/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.manager.legacy;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.blueprint.module.AddProjectModule;
import com.atlassian.jira.blueprint.module.PTAddProjectModule;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.projecttemplates.ProjectCreateHook;
import com.atlassian.jira.projecttemplates.manager.ProjectTemplateManager;
import com.atlassian.jira.projecttemplates.manager.ProjectTemplateSource;
import com.atlassian.jira.projecttemplates.manager.legacy.ProjectCreateHookAdapter;
import com.atlassian.jira.projecttemplates.manager.legacy.ProjectCreateHookModuleDescriptor;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateBuilder;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateBuilderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyTemplateSource
implements ProjectTemplateSource {
    private static final Logger log = LoggerFactory.getLogger(ProjectTemplateManager.class);
    private static final String PT_WEB_SECTION = "jira.project.templates";
    private static final String PT_PARAM_KEY = "templateKey";
    private static final String PT_LONG_DESCRIPTION = "longDescription";
    private static final String CONTEXT_KEY_USER = "user";
    private static final String CONTEXT_KEY_HELPER = "helper";
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final WebInterfaceManager webInterfaceManager;
    private final I18nResolver i18nResolver;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectTemplateBuilderFactory builderFactory;

    public LegacyTemplateSource(PluginAccessor pluginAccessor, PluginController pluginController, WebInterfaceManager webInterfaceManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, JiraAuthenticationContext authenticationContext, ProjectTemplateBuilderFactory builderFactory) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.webInterfaceManager = webInterfaceManager;
        this.i18nResolver = i18nResolver;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.authenticationContext = authenticationContext;
        this.builderFactory = builderFactory;
    }

    @Override
    @Nonnull
    public List<ProjectTemplate> findAll() {
        return this.toProjectTemplates(this.getAllItems());
    }

    @Override
    @Nonnull
    public List<ProjectTemplate> findAllVisible() {
        return this.toProjectTemplates(this.getDisplayableItems());
    }

    @Override
    @Nullable
    public ProjectTemplate findByKey(@Nonnull String key) {
        List<WebItemModuleDescriptor> webItems = this.getAllItems();
        for (WebItemModuleDescriptor webItem : webItems) {
            if (!webItem.getCompleteKey().equals(key)) continue;
            return this.toProjectTemplate(webItem);
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectTemplate findByKeyVisible(@Nonnull String itemKey, @Nonnull String moduleKey) {
        List<WebItemModuleDescriptor> displayableWebItems = this.getDisplayableItems();
        for (WebItemModuleDescriptor webItem : displayableWebItems) {
            if (webItem.getCompleteKey().equals(itemKey)) {
                return this.toProjectTemplate(webItem);
            }
            ProjectCreateHookModuleDescriptor projectTemplateMD = this.getProjectTemplateDescriptor(webItem);
            if (projectTemplateMD == null || !projectTemplateMD.getCompleteKey().equals(moduleKey)) continue;
            return this.toProjectTemplate(webItem);
        }
        return null;
    }

    private List<WebItemModuleDescriptor> getAllItems() {
        return this.filterValidWebItems(this.webInterfaceManager.getItems(PT_WEB_SECTION));
    }

    private List<WebItemModuleDescriptor> getDisplayableItems() {
        User user = this.authenticationContext.getLoggedInUser();
        return this.filterValidWebItems(this.webInterfaceManager.getDisplayableItems(PT_WEB_SECTION, this.makeContext(user, new JiraHelper(ExecutingHttpRequest.get()))));
    }

    private List<WebItemModuleDescriptor> filterValidWebItems(List<WebItemModuleDescriptor> allItems) {
        ArrayList validWebItems = Lists.newArrayList();
        for (WebItemModuleDescriptor webItem : allItems) {
            if (!this.isWebItemDescriptionValid(webItem)) continue;
            validWebItems.add(webItem);
        }
        return validWebItems;
    }

    private List<ProjectTemplate> toProjectTemplates(Iterable<WebItemModuleDescriptor> webItems) {
        return Lists.newArrayList((Iterable)Iterables.transform(webItems, (Function)new Function<WebItemModuleDescriptor, ProjectTemplate>(){

            public ProjectTemplate apply(@Nullable WebItemModuleDescriptor webItemMD) {
                return LegacyTemplateSource.this.toProjectTemplate(webItemMD);
            }
        }));
    }

    private ProjectTemplate toProjectTemplate(WebItemModuleDescriptor webItemMD) {
        ProjectCreateHookModuleDescriptor projectTemplateMD = this.getProjectTemplateDescriptor(webItemMD);
        Map<String, Object> projectTemplateContext = this.getProjectTemplateContext();
        ProjectTemplateBuilder builder = this.builderFactory.newBuilder().weight(webItemMD.getWeight()).name(this.getName(webItemMD, projectTemplateContext)).description(webItemMD.getDescription()).longDescriptionContent(this.getLongDescription(webItemMD)).iconUrl(this.defaultResourceUrl(webItemMD, "icon")).backgroundIconUrl(this.defaultResourceUrl(webItemMD, "backgroundIcon")).itemModuleCompleteKey(webItemMD.getCompleteKey());
        if (projectTemplateMD != null) {
            builder.projectTemplateModuleCompleteKey(projectTemplateMD.getCompleteKey()).addProjectModule(this.convertProjectCreateHookToAddProjectModule(projectTemplateMD.getProjectCreateHook()));
        }
        return builder.build();
    }

    private AddProjectModule convertProjectCreateHookToAddProjectModule(ProjectCreateHook projectCreateHook) {
        ProjectCreateHookAdapter addProjectHook = new ProjectCreateHookAdapter(projectCreateHook);
        return new PTAddProjectModule(addProjectHook);
    }

    private Map<String, Object> getProjectTemplateContext() {
        return Collections.emptyMap();
    }

    private ProjectCreateHookModuleDescriptor getProjectTemplateDescriptor(WebItemModuleDescriptor webItemMD) {
        Map params = webItemMD.getParams();
        String projectTemplateKey = (String)params.get(PT_PARAM_KEY);
        if (StringUtils.isBlank((String)projectTemplateKey)) {
            log.debug("No param with key '{}' specified in module descriptor with key '{}'.", (Object)PT_PARAM_KEY, (Object)webItemMD.getCompleteKey());
            return null;
        }
        String projectTemplateCompleteModuleKey = webItemMD.getPluginKey() + ":" + projectTemplateKey;
        ProjectCreateHookModuleDescriptor projectCreateHookModuleDescriptor = this.getProjectTemplateModuleDescriptorByKey(projectTemplateCompleteModuleKey);
        if (projectCreateHookModuleDescriptor == null) {
            log.debug("{} is not a <project-template>.", (Object)projectTemplateCompleteModuleKey);
            return null;
        }
        return projectCreateHookModuleDescriptor;
    }

    private ProjectCreateHookModuleDescriptor getProjectTemplateModuleDescriptorByKey(String projectTemplateCompleteModuleKey) {
        ModuleDescriptor projectTemplateModuleDescriptor = this.pluginAccessor.getEnabledPluginModule(projectTemplateCompleteModuleKey);
        if (!(projectTemplateModuleDescriptor instanceof ProjectCreateHookModuleDescriptor)) {
            log.debug("{} is not a <project-template>.", (Object)projectTemplateCompleteModuleKey);
            return null;
        }
        return (ProjectCreateHookModuleDescriptor)projectTemplateModuleDescriptor;
    }

    private boolean isWebItemDescriptionValid(WebItemModuleDescriptor webItemModuleDescriptor) {
        if (webItemModuleDescriptor == null) {
            return false;
        }
        int length = StringUtils.defaultString((String)webItemModuleDescriptor.getDescription()).length();
        if (length == 0) {
            this.pluginController.disablePluginModule(webItemModuleDescriptor.getCompleteKey());
            log.debug("Project Template Web Item {} has been disabled because there was no description specified.", (Object)webItemModuleDescriptor.getCompleteKey());
            return false;
        }
        return true;
    }

    private String getName(WebItemModuleDescriptor webItemMD, Map<String, Object> context) {
        WebLabel webLabel = webItemMD.getWebLabel();
        if (webLabel != null) {
            return webLabel.getDisplayableLabel(ExecutingHttpRequest.get(), context);
        }
        return "";
    }

    private String getLongDescription(WebItemModuleDescriptor webItemMD) {
        return this.i18nResolver.getText((String)webItemMD.getParams().get(PT_LONG_DESCRIPTION));
    }

    private Map<String, Object> makeContext(User remoteUser, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        params.put(CONTEXT_KEY_USER, remoteUser);
        params.put(CONTEXT_KEY_HELPER, jiraHelper);
        return params;
    }

    private String defaultResourceUrl(WebItemModuleDescriptor webItemMD, String resourceName) {
        ResourceLocation resourceLocation = webItemMD.getResourceLocation("download", resourceName);
        if (resourceLocation == null) {
            return "";
        }
        String iconFileName = resourceLocation.getName();
        if (StringUtils.isBlank((String)iconFileName)) {
            return "";
        }
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(webItemMD.getCompleteKey(), iconFileName, UrlMode.ABSOLUTE);
    }
}

