/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.manager.blueprint;

import com.atlassian.jira.blueprint.descriptor.ProjectBlueprintModuleDescriptor;
import com.atlassian.jira.blueprint.module.ProjectBlueprintModule;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.projecttemplates.manager.ProjectTemplateSource;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateBuilder;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateBuilderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BlueprintSource
implements ProjectTemplateSource {
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nResolver i18nResolver;
    private final ProjectTemplateBuilderFactory builderFactory;

    public BlueprintSource(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, I18nResolver i18nResolver, ProjectTemplateBuilderFactory builderFactory) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.i18nResolver = i18nResolver;
        this.builderFactory = builderFactory;
    }

    @Override
    @Nonnull
    public List<ProjectTemplate> findAll() {
        ArrayList allProjectTemplates = Lists.newArrayList();
        for (ProjectBlueprintModuleDescriptor blueprint : this.findAllBlueprintModules()) {
            allProjectTemplates.add(this.toProjectTemplate(blueprint));
        }
        return allProjectTemplates;
    }

    @Override
    @Nonnull
    public List<ProjectTemplate> findAllVisible() {
        ArrayList visibleProjectTemplates = Lists.newArrayList();
        for (ProjectBlueprintModuleDescriptor moduleDescriptor : this.findAllBlueprintModules()) {
            if (!this.isDisplayable(moduleDescriptor)) continue;
            visibleProjectTemplates.add(this.toProjectTemplate(moduleDescriptor));
        }
        return visibleProjectTemplates;
    }

    @Override
    @Nullable
    public ProjectTemplate findByKey(@Nonnull String key) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module instanceof ProjectBlueprintModuleDescriptor) {
            return this.toProjectTemplate((ProjectBlueprintModuleDescriptor)module);
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectTemplate findByKeyVisible(@Nonnull String itemKey, @Nonnull String moduleKey) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(itemKey);
        if (module == null) {
            module = this.pluginAccessor.getEnabledPluginModule(moduleKey);
        }
        if (module instanceof ProjectBlueprintModuleDescriptor) {
            ProjectBlueprintModuleDescriptor blueprint = (ProjectBlueprintModuleDescriptor)module;
            return this.isDisplayable(blueprint) ? this.toProjectTemplate(blueprint) : null;
        }
        return null;
    }

    private List<ProjectBlueprintModuleDescriptor> findAllBlueprintModules() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectBlueprintModuleDescriptor.class);
    }

    private boolean isDisplayable(ProjectBlueprintModuleDescriptor moduleDescriptor) {
        return moduleDescriptor.getCondition().shouldDisplay((Map)ImmutableMap.of((Object)"helper", (Object)new JiraHelper(ExecutingHttpRequest.get()), (Object)"user", (Object)this.authenticationContext.getLoggedInUser()));
    }

    private ProjectTemplate toProjectTemplate(ProjectBlueprintModuleDescriptor blueprintsMD) {
        ProjectBlueprintModule blueprint = blueprintsMD.getModule();
        ProjectTemplateBuilder builder = this.builderFactory.newBuilder().weight(blueprint.weight()).name(this.i18nResolver.getText(blueprint.labelKey())).description(this.i18nResolver.getText(blueprint.descriptionKey())).longDescriptionContent(this.i18nResolver.getText(blueprint.longDescriptionKey())).iconUrl(blueprint.icon().url()).backgroundIconUrl(blueprint.backgroundIcon().url()).itemModuleCompleteKey(StringUtils.isBlank((String)blueprint.key()) ? "" : blueprint.key()).infoSoyPath(blueprint.getInfoSoyPath());
        if (blueprint.hasAddProjectModule()) {
            builder.projectTemplateModuleCompleteKey(StringUtils.isBlank((String)blueprint.key()) ? "" : blueprint.key()).addProjectModule(blueprint.addProjectModule());
        }
        return builder.build();
    }
}

