/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.manager;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.projecttemplates.manager.ProjectTemplateManager;
import com.atlassian.jira.projecttemplates.manager.blueprint.BlueprintSource;
import com.atlassian.jira.projecttemplates.manager.legacy.LegacyTemplateSource;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProjectTemplateManagerImpl
implements ProjectTemplateManager {
    private final BlueprintSource blueprintSource;
    private final LegacyTemplateSource legacySource;

    public ProjectTemplateManagerImpl(BlueprintSource blueprintSource, LegacyTemplateSource legacySource) {
        this.blueprintSource = blueprintSource;
        this.legacySource = legacySource;
    }

    @Override
    public List<ProjectTemplate> getProjectTemplates(User user) {
        ArrayList projectTemplates = Lists.newArrayList(this.legacySource.findAllVisible());
        projectTemplates.addAll(this.blueprintSource.findAllVisible());
        Collections.sort(projectTemplates);
        return projectTemplates;
    }

    @Override
    public ProjectTemplate getProjectTemplate(String itemKey, String moduleKey) {
        ProjectTemplate blueprint = this.blueprintSource.findByKeyVisible(itemKey, moduleKey);
        if (blueprint != null) {
            return blueprint;
        }
        return this.legacySource.findByKeyVisible(itemKey, moduleKey);
    }
}

