/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.template;

import com.atlassian.jira.blueprint.template.IssueTypeSchemeTemplate;
import com.atlassian.jira.blueprint.template.IssueTypeTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class IssueTypeSchemeTemplateImpl
implements IssueTypeSchemeTemplate {
    private final String name;
    private final String description;
    private final List<IssueTypeTemplate> issueTypeTemplateList;

    public IssueTypeSchemeTemplateImpl(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="issue-types") List<? extends IssueTypeTemplate> issueTypeTemplateList) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        Preconditions.checkNotNull(issueTypeTemplateList, (Object)"issueTypeTemplates");
        this.issueTypeTemplateList = Lists.newArrayList(issueTypeTemplateList);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<IssueTypeTemplate> issueTypeTemplates() {
        return Collections.unmodifiableList(this.issueTypeTemplateList);
    }
}

