/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public class ResourceDescriptorFactory {
    public ResourceDescriptor createResource(Plugin plugin, String resourceName, String location) throws FileNotFoundException {
        InputStream inputStream = plugin.getResourceAsStream(location);
        if (inputStream == null) {
            throw new FileNotFoundException(location);
        }
        try {
            inputStream = new BufferedInputStream(inputStream);
            Element resource = new DOMElement("resource").addAttribute("name", resourceName).addAttribute("type", "download").addAttribute("location", location);
            String contentType = URLConnection.guessContentTypeFromStream(inputStream);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                resource.addElement("param").addAttribute("name", "content-type").addAttribute("value", contentType + "; charset=binary");
            }
            ResourceDescriptor resourceDescriptor = new ResourceDescriptor(resource);
            return resourceDescriptor;
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to determine content type of " + inputStream, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

