/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.descriptor;

import com.atlassian.fugue.Option;
import com.atlassian.jira.blueprint.descriptor.DefaultPluginParseHelper;
import com.atlassian.jira.blueprint.descriptor.PluginParseHelper;
import com.atlassian.jira.blueprint.descriptor.ResourceDescriptorFactory;
import com.atlassian.jira.blueprint.module.AddProjectModule;
import com.atlassian.jira.blueprint.module.AddProjectModuleBuilder;
import com.atlassian.jira.blueprint.module.Icon;
import com.atlassian.jira.blueprint.module.ProjectBlueprintModule;
import com.atlassian.jira.blueprint.module.ProjectBlueprintModuleBuilder;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ProjectBlueprintModuleDescriptor
extends AbstractModuleDescriptor<ProjectBlueprintModule>
implements ConditionalDescriptor {
    private final WebResourceUrlProvider urlProvider;
    private final ResourceDescriptorFactory resourceDescriptorFactory;
    private final WebInterfaceManager webInterfaceManager;
    private final ConditionElementParser conditionElementParser;
    private Element element;
    private ProjectBlueprintModule module;
    private Condition condition;

    public ProjectBlueprintModuleDescriptor(ModuleFactory moduleFactory, WebResourceUrlProvider urlProvider, ResourceDescriptorFactory resourceDescriptorFactory, WebInterfaceManager webInterfaceManager) {
        this(moduleFactory, urlProvider, resourceDescriptorFactory, webInterfaceManager, null);
    }

    @VisibleForTesting
    public ProjectBlueprintModuleDescriptor(ModuleFactory moduleFactory, WebResourceUrlProvider urlProvider, ResourceDescriptorFactory resourceDescriptorFactory, WebInterfaceManager webInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory) {
        super(moduleFactory);
        this.urlProvider = urlProvider;
        this.resourceDescriptorFactory = resourceDescriptorFactory;
        this.webInterfaceManager = webInterfaceManager;
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)(conditionFactory != null ? conditionFactory : new BlueprintConditionFactory()));
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.module = this.createModuleFromXml(element);
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
    }

    public ProjectBlueprintModule getModule() {
        return this.module;
    }

    @Nonnull
    public Condition getCondition() {
        return this.condition != null ? this.condition : new AlwaysDisplayCondition();
    }

    public String addIconResource(String iconPath, String iconName) {
        try {
            ResourceDescriptor resource = this.resourceDescriptorFactory.createResource(this.plugin, iconName, iconPath);
            this.addToResources(resource);
            return this.urlProvider.getResourceUrl(this.getCompleteKey(), resource.getName());
        }
        catch (FileNotFoundException e) {
            throw new PluginException(String.format("Icon file for '%s' does not exist at location: %s", iconName, iconPath));
        }
    }

    private ProjectBlueprintModule createModuleFromXml(Element element) {
        DefaultPluginParseHelper blueprint = new DefaultPluginParseHelper(element, "//project-blueprint[@key='" + element.attribute("key").getValue() + "']");
        ProjectBlueprintModuleBuilder builder = new ProjectBlueprintModuleBuilder();
        String weight = blueprint.optAttribute("weight");
        return builder.key(this.getPluginKey() + ":" + blueprint.attribute("key")).weight(weight != null ? Integer.valueOf(weight) : 100).labelKey(blueprint.element("label").attribute("key")).descriptionKey(blueprint.element("description").attribute("key")).longDescriptionKey(blueprint.element("longDescription").attribute("key")).icon(this.createIconFor(blueprint, "icon")).backgroundIcon(this.createIconFor(blueprint, "backgroundIcon")).infoSoyPath(((PluginParseHelper)blueprint.optElement("infoPage").getOrElse((Object)PluginParseHelper.NULL_PARSE_HELPER)).attribute("soy-template")).addProjectModule(this.createAddProjectModuleForBlueprintElement(blueprint)).build();
    }

    private AddProjectModule createAddProjectModuleForBlueprintElement(PluginParseHelper blueprint) {
        Option<PluginParseHelper> addProjectElement = blueprint.optElement("add-project");
        AddProjectModule addProjectModule = null;
        if (addProjectElement.isDefined()) {
            AddProjectModuleBuilder addProjectModuleBuilder = this.getProjectBlueprintModuleBuilder();
            addProjectModule = addProjectModuleBuilder.addProjectHookClassName(this.checkClassExists(((PluginParseHelper)((PluginParseHelper)addProjectElement.get()).optElement("hook").getOrElse((Object)PluginParseHelper.NULL_PARSE_HELPER)).attribute("class"))).templateConfigurationFileUrl(this.getFileUrl(((PluginParseHelper)((PluginParseHelper)addProjectElement.get()).optElement("descriptor").getOrElse((Object)PluginParseHelper.NULL_PARSE_HELPER)).attribute("file"))).build();
        }
        return addProjectModule;
    }

    private Icon createIconFor(PluginParseHelper blueprint, String elementName) {
        Option<PluginParseHelper> iconElement = blueprint.optElement(elementName);
        String location = ((PluginParseHelper)iconElement.getOrElse((Object)PluginParseHelper.NULL_PARSE_HELPER)).attribute("location");
        if (StringUtils.isBlank((CharSequence)location)) {
            return new Icon();
        }
        String resourceName = elementName + this.getFileExtension(location);
        try {
            ResourceDescriptor resource = this.resourceDescriptorFactory.createResource(this.plugin, resourceName, location);
            this.addToResources(resource);
            return new Icon(this.urlProvider, location, this.getCompleteKey(), resource.getName());
        }
        catch (FileNotFoundException e) {
            throw new PluginException(String.format("Icon file for '%s' does not exist at location: %s", elementName, location));
        }
    }

    private String getFileExtension(String path) {
        int indexOfDot;
        int n = indexOfDot = path != null ? path.lastIndexOf(46) : -1;
        if (indexOfDot != -1) {
            return path.substring(indexOfDot);
        }
        return "";
    }

    private void addToResources(ResourceDescriptor resource) {
        ImmutableList build = ImmutableList.builder().addAll((Iterable)this.resources.getResourceDescriptors()).add((Object)resource).build();
        this.resources = new Resources((Iterable)build);
    }

    private String checkClassExists(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            this.getPlugin().loadClass(className, ((Object)((Object)this)).getClass());
            return className;
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Class '" + className + "' not found.", (Throwable)e);
        }
    }

    private URL getFileUrl(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        URL fileUrl = this.getPlugin().getResource(fileName);
        if (fileUrl == null) {
            throw new PluginException("Project Template Configuration file not found on specified location: " + fileName);
        }
        return fileUrl;
    }

    protected AddProjectModuleBuilder getProjectBlueprintModuleBuilder() {
        return new AddProjectModuleBuilder(this.moduleFactory, this);
    }

    private class BlueprintConditionFactory
    implements ConditionElementParser.ConditionFactory {
        private BlueprintConditionFactory() {
        }

        public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
            return ProjectBlueprintModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
        }
    }
}

