/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

@PublicApi
public final class ValidateResponse {
    private final Map<String, String> errors = Maps.newHashMap();
    private final List<String> errorMessages = Lists.newArrayList();

    public static ValidateResponse create() {
        return new ValidateResponse();
    }

    private ValidateResponse() {
    }

    public ValidateResponse addError(String field, String error) {
        this.errors.put(field, error);
        return this;
    }

    public ValidateResponse addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
        return this;
    }

    ErrorCollection toErrorCollection() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrors(this.errors);
        errorCollection.addErrorMessages(this.errorMessages);
        return errorCollection;
    }
}

