SET LOCK_MODE 3;               
;              
CREATE USER IF NOT EXISTS SA SALT '909b55bdbf2ddf6a' HASH '1e296c77f6497e42a1bcaf096a5bd6f810947c78ad2e4e928c63005fa03473e9' ADMIN;            
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_514CD571_0C1B_4B9C_B130_46C0C4488345 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_71364CD0_649F_40BA_ACBC_5421EA520DC9 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_280B08B1_47DF_4846_9BAF_FD4F4F5B3966 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_7DA5B452_15BD_4827_9727_43CF2130CA95 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_2CB614E7_E955_454C_AEA3_B0AAB6B90C7D START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C51AB612_8DCD_42F2_95D6_6A9700B748BF START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C4076D78_F594_4F46_8FAE_11BD543B24A7 START WITH 33 BELONGS_TO_TABLE;    
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_7FD857EE_A34F_4E43_A575_CB7C4A256CA6 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_53BEEB73_7D42_4E3D_8A5C_EAB7C7D31D2D START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_03F2BD5E_69B1_478B_BDDE_2C0025A5F259 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_917D969A_F052_476A_91CC_564EAD9EFF13 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_8825EF89_E12C_4885_8DE2_CA355602D2C3 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_8E2B9C7B_2CD0_4BC9_BDD2_9BAE8A8C49D8 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_1B8935BA_8E04_4BC1_BD2B_4F26E043FB20 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_2B41D5E8_78E9_46DA_8CCB_6AF459E3F61E START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_66334F7F_7F5F_4D03_9F93_9E24C3A9FE64 START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_DC3A0EF9_C9AF_483A_A350_F4091A9CD54A START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_05D66401_F262_4794_98D5_BB29BD835E6C START WITH 1 BELONGS_TO_TABLE;     
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C4990A13_0F53_4F71_B947_BBB4EFB6D6B9 START WITH 1 BELONGS_TO_TABLE;     
CREATE CACHED TABLE PUBLIC.JIRAACTION(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    AUTHOR VARCHAR,
    ACTIONTYPE VARCHAR,
    ACTIONLEVEL VARCHAR,
    ROLELEVEL BIGINT,
    ACTIONBODY VARCHAR,
    CREATED TIMESTAMP,
    UPDATEAUTHOR VARCHAR,
    UPDATED TIMESTAMP,
    ACTIONNUM BIGINT
);          
ALTER TABLE PUBLIC.JIRAACTION ADD CONSTRAINT PUBLIC.PK_JIRAACTION PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JIRAACTION;               
CREATE INDEX PUBLIC.ACTION_AUTHOR_CREATED ON PUBLIC.JIRAACTION(AUTHOR, CREATED);               
CREATE INDEX PUBLIC.ACTION_ISSUE ON PUBLIC.JIRAACTION(ISSUEID);
CREATE CACHED TABLE PUBLIC.CWD_APPLICATION(
    ID BIGINT NOT NULL,
    APPLICATION_NAME VARCHAR,
    LOWER_APPLICATION_NAME VARCHAR,
    CREATED_DATE TIMESTAMP,
    UPDATED_DATE TIMESTAMP,
    ACTIVE INTEGER,
    DESCRIPTION VARCHAR,
    APPLICATION_TYPE VARCHAR,
    CREDENTIAL VARCHAR
);             
ALTER TABLE PUBLIC.CWD_APPLICATION ADD CONSTRAINT PUBLIC.PK_CWD_APPLICATION PRIMARY KEY(ID);   
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.CWD_APPLICATION;          
INSERT INTO PUBLIC.CWD_APPLICATION(ID, APPLICATION_NAME, LOWER_APPLICATION_NAME, CREATED_DATE, UPDATED_DATE, ACTIVE, DESCRIPTION, APPLICATION_TYPE, CREDENTIAL) VALUES
(1, 'crowd-embedded', 'crowd-embedded', TIMESTAMP '2013-02-28 11:57:51.302', TIMESTAMP '2013-02-28 11:57:51.302', 1, '', 'CROWD', 'X'); 
CREATE UNIQUE INDEX PUBLIC.UK_APPLICATION_NAME ON PUBLIC.CWD_APPLICATION(LOWER_APPLICATION_NAME);              
CREATE CACHED TABLE PUBLIC.APP_USER(
    ID BIGINT NOT NULL,
    USER_KEY VARCHAR,
    LOWER_USER_NAME VARCHAR
);              
ALTER TABLE PUBLIC.APP_USER ADD CONSTRAINT PUBLIC.PK_APP_USER PRIMARY KEY(ID); 
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.APP_USER; 
INSERT INTO PUBLIC.APP_USER(ID, USER_KEY, LOWER_USER_NAME) VALUES
(10000, 'admin', 'admin');   
CREATE UNIQUE INDEX PUBLIC.UK_USER_KEY ON PUBLIC.APP_USER(USER_KEY);           
CREATE UNIQUE INDEX PUBLIC.UK_LOWER_USER_NAME ON PUBLIC.APP_USER(LOWER_USER_NAME);             
CREATE CACHED TABLE PUBLIC.AUDIT_CHANGED_VALUE(
    ID BIGINT NOT NULL,
    LOG_ID BIGINT,
    NAME VARCHAR,
    DELTA_FROM VARCHAR,
    DELTA_TO VARCHAR
);   
ALTER TABLE PUBLIC.AUDIT_CHANGED_VALUE ADD CONSTRAINT PUBLIC.PK_AUDIT_CHANGED_VALUE PRIMARY KEY(ID);           
-- 36 +/- SELECT COUNT(*) FROM PUBLIC.AUDIT_CHANGED_VALUE;     
INSERT INTO PUBLIC.AUDIT_CHANGED_VALUE(ID, LOG_ID, NAME, DELTA_FROM, DELTA_TO) VALUES
(10000, 10001, 'Permission', '', 'Create Shared Objects'),
(10001, 10001, 'Group', '', 'jira-servicedesk-users'),
(10002, 10002, 'Permission', '', 'Bulk Change'),
(10003, 10002, 'Group', '', 'jira-servicedesk-users'),
(10004, 10003, 'Permission', '', 'Manage Group Filter Subscriptions'),
(10005, 10003, 'Group', '', 'jira-servicedesk-users'),
(10006, 10004, 'Permission', '', 'Browse Users'),
(10007, 10004, 'Group', '', 'jira-servicedesk-users'),
(10008, 10006, 'Permission', '', 'Create Shared Objects'),
(10009, 10006, 'Group', '', 'jira-software-users'),
(10010, 10007, 'Permission', '', 'Bulk Change'),
(10011, 10007, 'Group', '', 'jira-software-users'),
(10012, 10008, 'Permission', '', 'Manage Group Filter Subscriptions'),
(10013, 10008, 'Group', '', 'jira-software-users'),
(10014, 10009, 'Permission', '', 'Browse Users'),
(10015, 10009, 'Group', '', 'jira-software-users'),
(10016, 10010, 'Organisation', NULL, 'Example Company'),
(10017, 10010, 'Date Purchased', NULL, '05/Nov/15'),
(10018, 10010, 'License Type', NULL, 'Test license for plugin developers'),
(10019, 10010, 'Server ID', NULL, 'BE7E-4DZ2-6OJ7-G398'),
(10020, 10010, 'Support Entitlement Number (SEN)', NULL, 'SEN-500'),
(10021, 10010, 'User Limit', NULL, 'Unlimited'),
(10022, 10010, 'jira-servicedesk', NULL, '-1'),
(10023, 10010, 'jira-software', NULL, '-1'),
(10024, 10011, 'Username', NULL, 'admin'),
(10025, 10011, 'Full name', NULL, 'admin'),
(10026, 10011, 'Email', NULL, 'admin@admin.com'),
(10027, 10011, 'Active / Inactive', NULL, 'Active'),
(10028, 10013, 'Permission', '', 'Manage Group Filter Subscriptions'),
(10029, 10013, 'Group', '', 'jira-administrators'),
(10030, 10014, 'Permission', '', 'Browse Users'),
(10031, 10014, 'Group', '', 'jira-administrators'),
(10032, 10015, 'Permission', '', 'Bulk Change'),
(10033, 10015, 'Group', '', 'jira-administrators'),
(10034, 10016, 'Permission', '', 'Create Shared Objects'),
(10035, 10016, 'Group', '', 'jira-administrators');          
CREATE INDEX PUBLIC.IDX_CHANGED_VALUE_LOG_ID ON PUBLIC.AUDIT_CHANGED_VALUE(LOG_ID);            
CREATE CACHED TABLE PUBLIC.AUDIT_ITEM(
    ID BIGINT NOT NULL,
    LOG_ID BIGINT,
    OBJECT_TYPE VARCHAR,
    OBJECT_ID VARCHAR,
    OBJECT_NAME VARCHAR,
    OBJECT_PARENT_ID VARCHAR,
    OBJECT_PARENT_NAME VARCHAR
);     
ALTER TABLE PUBLIC.AUDIT_ITEM ADD CONSTRAINT PUBLIC.PK_AUDIT_ITEM PRIMARY KEY(ID);             
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.AUDIT_ITEM;               
INSERT INTO PUBLIC.AUDIT_ITEM(ID, LOG_ID, OBJECT_TYPE, OBJECT_ID, OBJECT_NAME, OBJECT_PARENT_ID, OBJECT_PARENT_NAME) VALUES
(10000, 10012, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory'),
(10001, 10017, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory'),
(10002, 10018, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory');      
CREATE INDEX PUBLIC.IDX_AUDIT_ITEM_LOG_ID2 ON PUBLIC.AUDIT_ITEM(LOG_ID);       
CREATE CACHED TABLE PUBLIC.AUDIT_LOG(
    ID BIGINT NOT NULL,
    REMOTE_ADDRESS VARCHAR,
    CREATED TIMESTAMP,
    AUTHOR_KEY VARCHAR,
    SUMMARY VARCHAR,
    CATEGORY VARCHAR,
    OBJECT_TYPE VARCHAR,
    OBJECT_ID VARCHAR,
    OBJECT_NAME VARCHAR,
    OBJECT_PARENT_ID VARCHAR,
    OBJECT_PARENT_NAME VARCHAR,
    AUTHOR_TYPE INTEGER,
    EVENT_SOURCE_NAME VARCHAR,
    DESCRIPTION VARCHAR,
    LONG_DESCRIPTION VARCHAR,
    SEARCH_FIELD VARCHAR
);          
ALTER TABLE PUBLIC.AUDIT_LOG ADD CONSTRAINT PUBLIC.PK_AUDIT_LOG PRIMARY KEY(ID);               
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.AUDIT_LOG;               
INSERT INTO PUBLIC.AUDIT_LOG(ID, REMOTE_ADDRESS, CREATED, AUTHOR_KEY, SUMMARY, CATEGORY, OBJECT_TYPE, OBJECT_ID, OBJECT_NAME, OBJECT_PARENT_ID, OBJECT_PARENT_NAME, AUTHOR_TYPE, EVENT_SOURCE_NAME, DESCRIPTION, LONG_DESCRIPTION, SEARCH_FIELD) VALUES
(10000, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.131', NULL, 'Group created', 'group management', 'GROUP', NULL, 'jira-servicedesk-users', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 group created management jira-servicedesk-users jira internal directory'),
(10001, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.169', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions create shared objects jira-servicedesk-users'),
(10002, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.171', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions bulk change jira-servicedesk-users'),
(10003, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.173', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions manage group filter subscriptions jira-servicedesk-users'),
(10004, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.174', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions browse users jira-servicedesk-users'),
(10005, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.181', NULL, 'Group created', 'group management', 'GROUP', NULL, 'jira-software-users', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 group created management jira-software-users jira internal directory'),
(10006, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.186', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions create shared objects jira-software-users'),
(10007, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.188', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions bulk change jira-software-users'),
(10008, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.189', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions manage group filter subscriptions jira-software-users'),
(10009, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.191', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions browse users jira-software-users'),
(10010, '127.0.0.1', TIMESTAMP '2015-11-07 02:06:52.215', NULL, 'New license added', 'system', 'LICENSE', '0', 'SEN-500', '0', 'License SEN', 0, '', NULL, '', '127.0.0.1 new license added system sen-500 sen example company 05/nov/15 test for plugin developers be7e-4dz2-6oj7-g398 unlimited -1'),
(10011, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.381', NULL, 'User created', 'user management', 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 user created management admin jira internal directory admin@admin.com active'),
(10012, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.408', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-administrators', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 user added to group management jira-administrators jira internal directory admin'),
(10013, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.42', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions manage group filter subscriptions jira-administrators'),
(10014, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.421', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions browse users jira-administrators');      
INSERT INTO PUBLIC.AUDIT_LOG(ID, REMOTE_ADDRESS, CREATED, AUTHOR_KEY, SUMMARY, CATEGORY, OBJECT_TYPE, OBJECT_ID, OBJECT_NAME, OBJECT_PARENT_ID, OBJECT_PARENT_NAME, AUTHOR_TYPE, EVENT_SOURCE_NAME, DESCRIPTION, LONG_DESCRIPTION, SEARCH_FIELD) VALUES
(10015, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.423', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions bulk change jira-administrators'),
(10016, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.424', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', NULL, '', '127.0.0.1 global permission added permissions create shared objects jira-administrators'),
(10017, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.427', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-servicedesk-users', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 user added to group management jira-servicedesk-users jira internal directory admin'),
(10018, '127.0.0.1', TIMESTAMP '2015-11-07 02:07:50.429', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-software-users', '1', 'JIRA Internal Directory', 0, '', NULL, '', '127.0.0.1 user added to group management jira-software-users jira internal directory admin');              
CREATE INDEX PUBLIC.IDX_AUDIT_LOG_CREATED ON PUBLIC.AUDIT_LOG(CREATED);        
CREATE CACHED TABLE PUBLIC.AVATAR(
    ID BIGINT NOT NULL,
    FILENAME VARCHAR,
    CONTENTTYPE VARCHAR,
    AVATARTYPE VARCHAR,
    OWNER VARCHAR,
    SYSTEMAVATAR INTEGER
);               
ALTER TABLE PUBLIC.AVATAR ADD CONSTRAINT PUBLIC.PK_AVATAR PRIMARY KEY(ID);     
-- 96 +/- SELECT COUNT(*) FROM PUBLIC.AVATAR;  
INSERT INTO PUBLIC.AVATAR(ID, FILENAME, CONTENTTYPE, AVATARTYPE, OWNER, SYSTEMAVATAR) VALUES
(10000, 'codegeist.png', 'image/png', 'project', NULL, 1),
(10001, 'bird.svg', 'image/svg+xml', 'project', NULL, 1),
(10002, 'jm_black.png', 'image/png', 'project', NULL, 1),
(10003, 'jm_brown.png', 'image/png', 'project', NULL, 1),
(10004, 'jm_orange.png', 'image/png', 'project', NULL, 1),
(10005, 'jm_red.png', 'image/png', 'project', NULL, 1),
(10006, 'jm_white.png', 'image/png', 'project', NULL, 1),
(10007, 'jm_yellow.png', 'image/png', 'project', NULL, 1),
(10008, 'monster.png', 'image/png', 'project', NULL, 1),
(10009, 'nature.svg', 'image/svg+xml', 'project', NULL, 1),
(10010, 'koala.svg', 'image/svg+xml', 'project', NULL, 1),
(10011, 'rocket.svg', 'image/svg+xml', 'project', NULL, 1),
(10100, 'Avatar-1.png', 'image/png', 'user', NULL, 1),
(10101, 'Avatar-2.png', 'image/png', 'user', NULL, 1),
(10102, 'Avatar-3.png', 'image/png', 'user', NULL, 1),
(10103, 'Avatar-4.png', 'image/png', 'user', NULL, 1),
(10104, 'Avatar-5.png', 'image/png', 'user', NULL, 1),
(10105, 'Avatar-6.png', 'image/png', 'user', NULL, 1),
(10106, 'Avatar-7.png', 'image/png', 'user', NULL, 1),
(10107, 'Avatar-8.png', 'image/png', 'user', NULL, 1),
(10108, 'Avatar-9.png', 'image/png', 'user', NULL, 1),
(10109, 'Avatar-10.png', 'image/png', 'user', NULL, 1),
(10110, 'Avatar-11.png', 'image/png', 'user', NULL, 1),
(10111, 'Avatar-12.png', 'image/png', 'user', NULL, 1),
(10112, 'Avatar-13.png', 'image/png', 'user', NULL, 1),
(10113, 'Avatar-14.png', 'image/png', 'user', NULL, 1),
(10114, 'Avatar-15.png', 'image/png', 'user', NULL, 1),
(10115, 'Avatar-16.png', 'image/png', 'user', NULL, 1),
(10116, 'Avatar-17.png', 'image/png', 'user', NULL, 1),
(10117, 'Avatar-18.png', 'image/png', 'user', NULL, 1),
(10118, 'Avatar-19.png', 'image/png', 'user', NULL, 1),
(10119, 'Avatar-20.png', 'image/png', 'user', NULL, 1),
(10120, 'Avatar-21.png', 'image/png', 'user', NULL, 1),
(10121, 'Avatar-22.png', 'image/png', 'user', NULL, 1),
(10122, 'Avatar-default.svg', 'image/svg+xml', 'user', NULL, 1),
(10123, 'Avatar-unknown.png', 'image/png', 'user', NULL, 1),
(10200, 'cloud.svg', 'image/svg+xml', 'project', NULL, 1),
(10201, 'spanner.svg', 'image/svg+xml', 'project', NULL, 1),
(10202, 'cd.svg', 'image/svg+xml', 'project', NULL, 1),
(10203, 'money.svg', 'image/svg+xml', 'project', NULL, 1),
(10204, 'mouse-hand.svg', 'image/svg+xml', 'project', NULL, 1),
(10205, 'yeti.svg', 'image/svg+xml', 'project', NULL, 1),
(10206, 'power.svg', 'image/svg+xml', 'project', NULL, 1),
(10207, 'refresh.svg', 'image/svg+xml', 'project', NULL, 1),
(10208, 'phone.svg', 'image/svg+xml', 'project', NULL, 1),
(10209, 'settings.svg', 'image/svg+xml', 'project', NULL, 1),
(10210, 'storm.svg', 'image/svg+xml', 'project', NULL, 1),
(10211, 'plane.svg', 'image/svg+xml', 'project', NULL, 1),
(10300, 'genericissue.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10303, 'bug.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10304, 'defect.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10306, 'documentation.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10307, 'epic.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10308, 'exclamation.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10309, 'design_task.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10310, 'improvement.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10311, 'newfeature.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10312, 'remove_feature.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10313, 'requirement.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10314, 'sales.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10315, 'story.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10316, 'subtask.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10318, 'task.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10320, 'question.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10321, 'development_task.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10322, 'feedback.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10323, 'request_access.svg', 'image/svg+xml', 'issuetype', NULL, 1),
(10324, 'default.svg', 'image/svg+xml', 'project', NULL, 1);   
INSERT INTO PUBLIC.AVATAR(ID, FILENAME, CONTENTTYPE, AVATARTYPE, OWNER, SYSTEMAVATAR) VALUES
(10325, 'code.svg', 'image/svg+xml', 'project', NULL, 1),
(10326, 'coffee.svg', 'image/svg+xml', 'project', NULL, 1),
(10327, 'design.svg', 'image/svg+xml', 'project', NULL, 1),
(10328, 'drill.svg', 'image/svg+xml', 'project', NULL, 1),
(10329, 'food.svg', 'image/svg+xml', 'project', NULL, 1),
(10330, 'notes.svg', 'image/svg+xml', 'project', NULL, 1),
(10331, 'red-flag.svg', 'image/svg+xml', 'project', NULL, 1),
(10332, 'science.svg', 'image/svg+xml', 'project', NULL, 1),
(10333, 'support.svg', 'image/svg+xml', 'project', NULL, 1),
(10334, 'bull.svg', 'image/svg+xml', 'user', NULL, 1),
(10335, 'cat.svg', 'image/svg+xml', 'user', NULL, 1),
(10336, 'dog.svg', 'image/svg+xml', 'user', NULL, 1),
(10337, 'female_1.svg', 'image/svg+xml', 'user', NULL, 1),
(10338, 'female_2.svg', 'image/svg+xml', 'user', NULL, 1),
(10339, 'female_3.svg', 'image/svg+xml', 'user', NULL, 1),
(10340, 'female_4.svg', 'image/svg+xml', 'user', NULL, 1),
(10341, 'ghost.svg', 'image/svg+xml', 'user', NULL, 1),
(10342, 'male_1.svg', 'image/svg+xml', 'user', NULL, 1),
(10343, 'male_2.svg', 'image/svg+xml', 'user', NULL, 1),
(10344, 'male_3.svg', 'image/svg+xml', 'user', NULL, 1),
(10345, 'male_4.svg', 'image/svg+xml', 'user', NULL, 1),
(10346, 'male_5.svg', 'image/svg+xml', 'user', NULL, 1),
(10347, 'male_6.svg', 'image/svg+xml', 'user', NULL, 1),
(10348, 'male_8.svg', 'image/svg+xml', 'user', NULL, 1),
(10349, 'owl.svg', 'image/svg+xml', 'user', NULL, 1),
(10350, 'pirate.svg', 'image/svg+xml', 'user', NULL, 1),
(10351, 'robot.svg', 'image/svg+xml', 'user', NULL, 1),
(10352, 'vampire.svg', 'image/svg+xml', 'user', NULL, 1);  
CREATE INDEX PUBLIC.AVATAR_INDEX ON PUBLIC.AVATAR(AVATARTYPE, OWNER);          
CREATE CACHED TABLE PUBLIC.BOARD(
    ID BIGINT NOT NULL,
    JQL VARCHAR
);   
ALTER TABLE PUBLIC.BOARD ADD CONSTRAINT PUBLIC.PK_BOARD PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.BOARD;    
CREATE CACHED TABLE PUBLIC.BOARDPROJECT(
    BOARD_ID BIGINT NOT NULL,
    PROJECT_ID BIGINT NOT NULL
);       
ALTER TABLE PUBLIC.BOARDPROJECT ADD CONSTRAINT PUBLIC.PK_BOARDPROJECT PRIMARY KEY(BOARD_ID, PROJECT_ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.BOARDPROJECT;             
CREATE INDEX PUBLIC.IDX_BOARD_PROJECT_IDS ON PUBLIC.BOARDPROJECT(PROJECT_ID);  
CREATE INDEX PUBLIC.IDX_BOARD_BOARD_IDS ON PUBLIC.BOARDPROJECT(BOARD_ID);      
CREATE CACHED TABLE PUBLIC.CHANGEGROUP(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    AUTHOR VARCHAR,
    CREATED TIMESTAMP
);               
ALTER TABLE PUBLIC.CHANGEGROUP ADD CONSTRAINT PUBLIC.PK_CHANGEGROUP PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CHANGEGROUP;              
CREATE INDEX PUBLIC.CHGGROUP_ISSUE ON PUBLIC.CHANGEGROUP(ISSUEID);             
CREATE INDEX PUBLIC.CHGGROUP_AUTHOR_CREATED ON PUBLIC.CHANGEGROUP(AUTHOR, CREATED);            
CREATE CACHED TABLE PUBLIC.CHANGEITEM(
    ID BIGINT NOT NULL,
    GROUPID BIGINT,
    FIELDTYPE VARCHAR,
    FIELD VARCHAR,
    OLDVALUE VARCHAR,
    OLDSTRING VARCHAR,
    NEWVALUE VARCHAR,
    NEWSTRING VARCHAR
);       
ALTER TABLE PUBLIC.CHANGEITEM ADD CONSTRAINT PUBLIC.PK_CHANGEITEM PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CHANGEITEM;               
CREATE INDEX PUBLIC.CHGITEM_CHGGRP ON PUBLIC.CHANGEITEM(GROUPID);              
CREATE INDEX PUBLIC.CHGITEM_FIELD ON PUBLIC.CHANGEITEM(FIELD); 
CREATE CACHED TABLE PUBLIC.CLUSTERLOCKSTATUS(
    ID BIGINT NOT NULL,
    LOCK_NAME VARCHAR,
    LOCKED_BY_NODE VARCHAR,
    UPDATE_TIME BIGINT
);             
ALTER TABLE PUBLIC.CLUSTERLOCKSTATUS ADD CONSTRAINT PUBLIC.PK_CLUSTERLOCKSTATUS PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CLUSTERLOCKSTATUS;        
CREATE UNIQUE INDEX PUBLIC.CLUSTER_LOCK_NAME_IDX ON PUBLIC.CLUSTERLOCKSTATUS(LOCK_NAME);       
CREATE CACHED TABLE PUBLIC.CLUSTERMESSAGE(
    ID BIGINT NOT NULL,
    SOURCE_NODE VARCHAR,
    DESTINATION_NODE VARCHAR,
    CLAIMED_BY_NODE VARCHAR,
    MESSAGE VARCHAR,
    MESSAGE_TIME TIMESTAMP
);      
ALTER TABLE PUBLIC.CLUSTERMESSAGE ADD CONSTRAINT PUBLIC.PK_CLUSTERMESSAGE PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CLUSTERMESSAGE;           
CREATE INDEX PUBLIC.SOURCE_DESTINATION_NODE_IDX ON PUBLIC.CLUSTERMESSAGE(SOURCE_NODE, DESTINATION_NODE);       
CREATE CACHED TABLE PUBLIC.CLUSTERNODE(
    NODE_ID VARCHAR NOT NULL,
    NODE_STATE VARCHAR,
    TIMESTAMP BIGINT,
    IP VARCHAR,
    CACHE_LISTENER_PORT BIGINT
);          
ALTER TABLE PUBLIC.CLUSTERNODE ADD CONSTRAINT PUBLIC.PK_CLUSTERNODE PRIMARY KEY(NODE_ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CLUSTERNODE;              
CREATE CACHED TABLE PUBLIC.CLUSTERNODEHEARTBEAT(
    NODE_ID VARCHAR NOT NULL,
    HEARTBEAT_TIME BIGINT,
    DATABASE_TIME BIGINT
);          
ALTER TABLE PUBLIC.CLUSTERNODEHEARTBEAT ADD CONSTRAINT PUBLIC.PK_CLUSTERNODEHEARTBEAT PRIMARY KEY(NODE_ID);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CLUSTERNODEHEARTBEAT;     
CREATE CACHED TABLE PUBLIC.CLUSTEREDJOB(
    ID BIGINT NOT NULL,
    JOB_ID VARCHAR,
    JOB_RUNNER_KEY VARCHAR,
    SCHED_TYPE CHAR(1),
    INTERVAL_MILLIS BIGINT,
    FIRST_RUN BIGINT,
    CRON_EXPRESSION VARCHAR,
    TIME_ZONE VARCHAR,
    NEXT_RUN BIGINT,
    VERSION BIGINT,
    PARAMETERS BLOB
); 
ALTER TABLE PUBLIC.CLUSTEREDJOB ADD CONSTRAINT PUBLIC.PK_CLUSTEREDJOB PRIMARY KEY(ID);         
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.CLUSTEREDJOB;             
INSERT INTO PUBLIC.CLUSTEREDJOB(ID, JOB_ID, JOB_RUNNER_KEY, SCHED_TYPE, INTERVAL_MILLIS, FIRST_RUN, CRON_EXPRESSION, TIME_ZONE, NEXT_RUN, VERSION, PARAMETERS) VALUES
(10001, 'com.atlassian.jira.service.JiraService:10002', 'com.atlassian.jira.service.DefaultServiceManager', 'C', NULL, NULL, '0 0 10 * * ?', NULL, 1446850800000, 1, X'aced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b02000078700000000000002712'),
(10101, 'com.atlassian.jira.service.JiraService:10001', 'com.atlassian.jira.service.DefaultServiceManager', 'C', NULL, NULL, '0 5 2/12 * * ?', NULL, 1446865500000, 1, X'aced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b02000078700000000000002711'),
(10103, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.LocalPluginLicenseNotificationJob-job-handler', 'I', 86400000, 1446822480352, NULL, NULL, 1446908880354, 2, NULL),
(10104, 'CompatibilityPluginScheduler.JobId.RemotePluginLicenseNotificationJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.RemotePluginLicenseNotificationJob-job-handler', 'I', 86400000, 1446870159903, NULL, NULL, 1446870159903, 1, NULL),
(10105, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.PluginRequestCheckJob-job-handler', 'I', 3600000, 1446822480356, NULL, NULL, 1446826080357, 2, NULL),
(10106, 'CompatibilityPluginScheduler.JobId.PluginUpdateCheckJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.PluginUpdateCheckJob-job-handler', 'I', 86400000, 1446904998348, NULL, NULL, 1446904998348, 1, NULL),
(10107, 'CompatibilityPluginScheduler.JobId.InstanceTopologyJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.InstanceTopologyJob-job-handler', 'I', 86400000, 1446868445880, NULL, NULL, 1446868445880, 1, NULL),
(10108, 'CompatibilityPluginScheduler.JobId.Service Provider Session Remover', 'CompatibilityPluginScheduler.JobRunnerKey.Service Provider Session Remover', 'I', 28800000, 1446851280811, NULL, NULL, 1446851280811, 1, NULL); 
CREATE INDEX PUBLIC.CLUSTEREDJOB_JOBID_IDX ON PUBLIC.CLUSTEREDJOB(JOB_ID);     
CREATE INDEX PUBLIC.CLUSTEREDJOB_JRK_IDX ON PUBLIC.CLUSTEREDJOB(JOB_RUNNER_KEY);               
CREATE INDEX PUBLIC.CLUSTEREDJOB_NEXTRUN_IDX ON PUBLIC.CLUSTEREDJOB(NEXT_RUN); 
CREATE CACHED TABLE PUBLIC.COLUMNLAYOUT(
    ID BIGINT NOT NULL,
    USERNAME VARCHAR,
    SEARCHREQUEST BIGINT
);             
ALTER TABLE PUBLIC.COLUMNLAYOUT ADD CONSTRAINT PUBLIC.PK_COLUMNLAYOUT PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COLUMNLAYOUT;             
CREATE INDEX PUBLIC.CL_SEARCHREQUEST ON PUBLIC.COLUMNLAYOUT(SEARCHREQUEST);    
CREATE INDEX PUBLIC.CL_USERNAME ON PUBLIC.COLUMNLAYOUT(USERNAME);              
CREATE CACHED TABLE PUBLIC.COLUMNLAYOUTITEM(
    ID BIGINT NOT NULL,
    COLUMNLAYOUT BIGINT,
    FIELDIDENTIFIER VARCHAR,
    HORIZONTALPOSITION BIGINT
);    
ALTER TABLE PUBLIC.COLUMNLAYOUTITEM ADD CONSTRAINT PUBLIC.PK_COLUMNLAYOUTITEM PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COLUMNLAYOUTITEM;         
CREATE INDEX PUBLIC.IDX_CLI_FIELDIDENTIFIER ON PUBLIC.COLUMNLAYOUTITEM(FIELDIDENTIFIER);       
CREATE CACHED TABLE PUBLIC.COMPONENT(
    ID BIGINT NOT NULL,
    PROJECT BIGINT,
    CNAME VARCHAR,
    DESCRIPTION VARCHAR,
    URL VARCHAR,
    LEAD VARCHAR,
    ASSIGNEETYPE BIGINT
);    
ALTER TABLE PUBLIC.COMPONENT ADD CONSTRAINT PUBLIC.PK_COMPONENT PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COMPONENT;
CREATE INDEX PUBLIC.IDX_COMPONENT_PROJECT ON PUBLIC.COMPONENT(PROJECT);        
CREATE INDEX PUBLIC.IDX_COMPONENT_NAME ON PUBLIC.COMPONENT(CNAME);             
CREATE CACHED TABLE PUBLIC.CONFIGURATIONCONTEXT(
    ID BIGINT NOT NULL,
    PROJECTCATEGORY BIGINT,
    PROJECT BIGINT,
    CUSTOMFIELD VARCHAR,
    FIELDCONFIGSCHEME BIGINT
);              
ALTER TABLE PUBLIC.CONFIGURATIONCONTEXT ADD CONSTRAINT PUBLIC.PK_CONFIGURATIONCONTEXT PRIMARY KEY(ID);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.CONFIGURATIONCONTEXT;     
INSERT INTO PUBLIC.CONFIGURATIONCONTEXT(ID, PROJECTCATEGORY, PROJECT, CUSTOMFIELD, FIELDCONFIGSCHEME) VALUES
(10000, NULL, NULL, 'issuetype', 10000);          
CREATE INDEX PUBLIC.CONFCONTEXT ON PUBLIC.CONFIGURATIONCONTEXT(PROJECTCATEGORY, PROJECT, CUSTOMFIELD);         
CREATE INDEX PUBLIC.CONFCONTEXTPROJECTKEY ON PUBLIC.CONFIGURATIONCONTEXT(PROJECT, CUSTOMFIELD);
CREATE INDEX PUBLIC.CONFCONTEXTFIELDCONFIGSCHEME ON PUBLIC.CONFIGURATIONCONTEXT(FIELDCONFIGSCHEME);            
CREATE CACHED TABLE PUBLIC.CUSTOMFIELD(
    ID BIGINT NOT NULL,
    CUSTOMFIELDTYPEKEY VARCHAR,
    CUSTOMFIELDSEARCHERKEY VARCHAR,
    CFNAME VARCHAR,
    DESCRIPTION VARCHAR,
    DEFAULTVALUE VARCHAR,
    FIELDTYPE BIGINT,
    PROJECT BIGINT,
    ISSUETYPE VARCHAR
);  
ALTER TABLE PUBLIC.CUSTOMFIELD ADD CONSTRAINT PUBLIC.PK_CUSTOMFIELD PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CUSTOMFIELD;              
CREATE CACHED TABLE PUBLIC.CUSTOMFIELDOPTION(
    ID BIGINT NOT NULL,
    CUSTOMFIELD BIGINT,
    CUSTOMFIELDCONFIG BIGINT,
    PARENTOPTIONID BIGINT,
    SEQUENCE BIGINT,
    CUSTOMVALUE VARCHAR,
    OPTIONTYPE VARCHAR,
    DISABLED VARCHAR
);           
ALTER TABLE PUBLIC.CUSTOMFIELDOPTION ADD CONSTRAINT PUBLIC.PK_CUSTOMFIELDOPTION PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CUSTOMFIELDOPTION;        
CREATE INDEX PUBLIC.CF_CFOPTION ON PUBLIC.CUSTOMFIELDOPTION(CUSTOMFIELD);      
CREATE CACHED TABLE PUBLIC.CUSTOMFIELDVALUE(
    ID BIGINT NOT NULL,
    ISSUE BIGINT,
    CUSTOMFIELD BIGINT,
    PARENTKEY VARCHAR,
    STRINGVALUE VARCHAR,
    NUMBERVALUE DOUBLE,
    TEXTVALUE VARCHAR,
    DATEVALUE TIMESTAMP,
    VALUETYPE VARCHAR
);
ALTER TABLE PUBLIC.CUSTOMFIELDVALUE ADD CONSTRAINT PUBLIC.PK_CUSTOMFIELDVALUE PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CUSTOMFIELDVALUE;         
CREATE INDEX PUBLIC.CFVALUE_ISSUE ON PUBLIC.CUSTOMFIELDVALUE(ISSUE, CUSTOMFIELD);              
CREATE CACHED TABLE PUBLIC.DEADLETTER(
    ID BIGINT NOT NULL,
    MESSAGE_ID VARCHAR,
    LAST_SEEN BIGINT,
    MAIL_SERVER_ID BIGINT,
    FOLDER_NAME VARCHAR
);             
ALTER TABLE PUBLIC.DEADLETTER ADD CONSTRAINT PUBLIC.PK_DEADLETTER PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DEADLETTER;               
CREATE INDEX PUBLIC.DEADLETTER_MSG_SERVER_FOLDER ON PUBLIC.DEADLETTER(MESSAGE_ID, MAIL_SERVER_ID, FOLDER_NAME);
CREATE INDEX PUBLIC.DEADLETTER_LASTSEEN ON PUBLIC.DEADLETTER(LAST_SEEN);       
CREATE CACHED TABLE PUBLIC.CWD_DIRECTORY(
    ID BIGINT NOT NULL,
    DIRECTORY_NAME VARCHAR,
    LOWER_DIRECTORY_NAME VARCHAR,
    CREATED_DATE TIMESTAMP,
    UPDATED_DATE TIMESTAMP,
    ACTIVE INTEGER,
    DESCRIPTION VARCHAR,
    IMPL_CLASS VARCHAR,
    LOWER_IMPL_CLASS VARCHAR,
    DIRECTORY_TYPE VARCHAR,
    DIRECTORY_POSITION BIGINT
);        
ALTER TABLE PUBLIC.CWD_DIRECTORY ADD CONSTRAINT PUBLIC.PK_CWD_DIRECTORY PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.CWD_DIRECTORY;            
INSERT INTO PUBLIC.CWD_DIRECTORY(ID, DIRECTORY_NAME, LOWER_DIRECTORY_NAME, CREATED_DATE, UPDATED_DATE, ACTIVE, DESCRIPTION, IMPL_CLASS, LOWER_IMPL_CLASS, DIRECTORY_TYPE, DIRECTORY_POSITION) VALUES
(1, 'JIRA Internal Directory', 'jira internal directory', TIMESTAMP '2013-02-28 11:57:51.308', TIMESTAMP '2013-02-28 11:57:51.308', 1, 'JIRA default internal directory', 'com.atlassian.crowd.directory.InternalDirectory', 'com.atlassian.crowd.directory.internaldirectory', 'INTERNAL', 0);           
CREATE INDEX PUBLIC.UK_DIRECTORY_NAME ON PUBLIC.CWD_DIRECTORY(LOWER_DIRECTORY_NAME);           
CREATE INDEX PUBLIC.IDX_DIRECTORY_ACTIVE ON PUBLIC.CWD_DIRECTORY(ACTIVE);      
CREATE INDEX PUBLIC.IDX_DIRECTORY_IMPL ON PUBLIC.CWD_DIRECTORY(LOWER_IMPL_CLASS);              
CREATE INDEX PUBLIC.IDX_DIRECTORY_TYPE ON PUBLIC.CWD_DIRECTORY(DIRECTORY_TYPE);
CREATE CACHED TABLE PUBLIC.CWD_DIRECTORY_ATTRIBUTE(
    DIRECTORY_ID BIGINT NOT NULL,
    ATTRIBUTE_NAME VARCHAR NOT NULL,
    ATTRIBUTE_VALUE VARCHAR
);      
ALTER TABLE PUBLIC.CWD_DIRECTORY_ATTRIBUTE ADD CONSTRAINT PUBLIC.PK_CWD_DIRECTORY_ATTRIBUTE PRIMARY KEY(DIRECTORY_ID, ATTRIBUTE_NAME);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.CWD_DIRECTORY_ATTRIBUTE;  
INSERT INTO PUBLIC.CWD_DIRECTORY_ATTRIBUTE(DIRECTORY_ID, ATTRIBUTE_NAME, ATTRIBUTE_VALUE) VALUES
(1, 'user_encryption_method', 'atlassian-security');          
CREATE CACHED TABLE PUBLIC.CWD_DIRECTORY_OPERATION(
    DIRECTORY_ID BIGINT NOT NULL,
    OPERATION_TYPE VARCHAR NOT NULL
);   
ALTER TABLE PUBLIC.CWD_DIRECTORY_OPERATION ADD CONSTRAINT PUBLIC.PK_CWD_DIRECTORY_OPERATION PRIMARY KEY(DIRECTORY_ID, OPERATION_TYPE);         
-- 12 +/- SELECT COUNT(*) FROM PUBLIC.CWD_DIRECTORY_OPERATION; 
INSERT INTO PUBLIC.CWD_DIRECTORY_OPERATION(DIRECTORY_ID, OPERATION_TYPE) VALUES
(1, 'CREATE_GROUP'),
(1, 'CREATE_ROLE'),
(1, 'CREATE_USER'),
(1, 'DELETE_GROUP'),
(1, 'DELETE_ROLE'),
(1, 'DELETE_USER'),
(1, 'UPDATE_GROUP'),
(1, 'UPDATE_GROUP_ATTRIBUTE'),
(1, 'UPDATE_ROLE'),
(1, 'UPDATE_ROLE_ATTRIBUTE'),
(1, 'UPDATE_USER'),
(1, 'UPDATE_USER_ATTRIBUTE');              
CREATE CACHED TABLE PUBLIC.JIRADRAFTWORKFLOWS(
    ID BIGINT NOT NULL,
    PARENTNAME VARCHAR,
    DESCRIPTOR VARCHAR
);       
ALTER TABLE PUBLIC.JIRADRAFTWORKFLOWS ADD CONSTRAINT PUBLIC.PK_JIRADRAFTWORKFLOWS PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JIRADRAFTWORKFLOWS;       
CREATE CACHED TABLE PUBLIC.DRAFTWORKFLOWSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    WORKFLOW_SCHEME_ID BIGINT,
    LAST_MODIFIED_DATE TIMESTAMP,
    LAST_MODIFIED_USER VARCHAR
);          
ALTER TABLE PUBLIC.DRAFTWORKFLOWSCHEME ADD CONSTRAINT PUBLIC.PK_DRAFTWORKFLOWSCHEME PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DRAFTWORKFLOWSCHEME;      
CREATE UNIQUE INDEX PUBLIC.DRAFT_WORKFLOW_SCHEME_PARENT ON PUBLIC.DRAFTWORKFLOWSCHEME(WORKFLOW_SCHEME_ID);     
CREATE CACHED TABLE PUBLIC.DRAFTWORKFLOWSCHEMEENTITY(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    WORKFLOW VARCHAR,
    ISSUETYPE VARCHAR
);
ALTER TABLE PUBLIC.DRAFTWORKFLOWSCHEMEENTITY ADD CONSTRAINT PUBLIC.PK_DRAFTWORKFLOWSCHEMEENTITY PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DRAFTWORKFLOWSCHEMEENTITY;
CREATE INDEX PUBLIC.DRAFT_WORKFLOW_SCHEME ON PUBLIC.DRAFTWORKFLOWSCHEMEENTITY(SCHEME);         
CREATE CACHED TABLE PUBLIC.ENTITY_PROPERTY(
    ID BIGINT NOT NULL,
    ENTITY_NAME VARCHAR,
    ENTITY_ID BIGINT,
    PROPERTY_KEY VARCHAR,
    CREATED TIMESTAMP,
    UPDATED TIMESTAMP,
    JSON_VALUE VARCHAR
);           
ALTER TABLE PUBLIC.ENTITY_PROPERTY ADD CONSTRAINT PUBLIC.PK_ENTITY_PROPERTY PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ENTITY_PROPERTY;          
CREATE INDEX PUBLIC.ENTITYPROPERTY_ENTITY ON PUBLIC.ENTITY_PROPERTY(ENTITY_NAME, ENTITY_ID);   
CREATE INDEX PUBLIC.ENTITYPROPERTY_KEY ON PUBLIC.ENTITY_PROPERTY(PROPERTY_KEY);
CREATE CACHED TABLE PUBLIC.ENTITY_PROPERTY_INDEX_DOCUMENT(
    ID BIGINT NOT NULL,
    PLUGIN_KEY VARCHAR,
    MODULE_KEY VARCHAR,
    ENTITY_KEY VARCHAR,
    UPDATED TIMESTAMP,
    DOCUMENT VARCHAR
);      
ALTER TABLE PUBLIC.ENTITY_PROPERTY_INDEX_DOCUMENT ADD CONSTRAINT PUBLIC.PK_ENTITY_PROPERTY_INDEX_DOCUM PRIMARY KEY(ID);        
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ENTITY_PROPERTY_INDEX_DOCUMENT;           
INSERT INTO PUBLIC.ENTITY_PROPERTY_INDEX_DOCUMENT(ID, PLUGIN_KEY, MODULE_KEY, ENTITY_KEY, UPDATED, DOCUMENT) VALUES
(10000, 'com.atlassian.jira.dev.func-test-plugin', 'index-doc-conf', 'IssueProperty', TIMESTAMP '2015-11-07 02:06:09.808', STRINGDECODE('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<index-document-configuration entity-key=\"IssueProperty\"><key property-key=\"func.test.prop\"><extract path=\"func\" type=\"STRING\"/></key></index-document-configuration>'));     
CREATE UNIQUE INDEX PUBLIC.ENTPROPINDEXDOC_MODULE ON PUBLIC.ENTITY_PROPERTY_INDEX_DOCUMENT(PLUGIN_KEY, MODULE_KEY);            
CREATE CACHED TABLE PUBLIC.JIRAEVENTTYPE(
    ID BIGINT NOT NULL,
    TEMPLATE_ID BIGINT,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    EVENT_TYPE VARCHAR
); 
ALTER TABLE PUBLIC.JIRAEVENTTYPE ADD CONSTRAINT PUBLIC.PK_JIRAEVENTTYPE PRIMARY KEY(ID);       
-- 17 +/- SELECT COUNT(*) FROM PUBLIC.JIRAEVENTTYPE;           
INSERT INTO PUBLIC.JIRAEVENTTYPE(ID, TEMPLATE_ID, NAME, DESCRIPTION, EVENT_TYPE) VALUES
(1, NULL, 'Issue Created', 'This is the ''issue created'' event.', 'jira.system.event.type'),
(2, NULL, 'Issue Updated', 'This is the ''issue updated'' event.', 'jira.system.event.type'),
(3, NULL, 'Issue Assigned', 'This is the ''issue assigned'' event.', 'jira.system.event.type'),
(4, NULL, 'Issue Resolved', 'This is the ''issue resolved'' event.', 'jira.system.event.type'),
(5, NULL, 'Issue Closed', 'This is the ''issue closed'' event.', 'jira.system.event.type'),
(6, NULL, 'Issue Commented', 'This is the ''issue commented'' event.', 'jira.system.event.type'),
(7, NULL, 'Issue Reopened', 'This is the ''issue reopened'' event.', 'jira.system.event.type'),
(8, NULL, 'Issue Deleted', 'This is the ''issue deleted'' event.', 'jira.system.event.type'),
(9, NULL, 'Issue Moved', 'This is the ''issue moved'' event.', 'jira.system.event.type'),
(10, NULL, 'Work Logged On Issue', 'This is the ''work logged on issue'' event.', 'jira.system.event.type'),
(11, NULL, 'Work Started On Issue', 'This is the ''work started on issue'' event.', 'jira.system.event.type'),
(12, NULL, 'Work Stopped On Issue', 'This is the ''work stopped on issue'' event.', 'jira.system.event.type'),
(13, NULL, 'Generic Event', 'This is the ''generic event'' event.', 'jira.system.event.type'),
(14, NULL, 'Issue Comment Edited', 'This is the ''issue comment edited'' event.', 'jira.system.event.type'),
(15, NULL, 'Issue Worklog Updated', 'This is the ''issue worklog updated'' event.', 'jira.system.event.type'),
(16, NULL, 'Issue Worklog Deleted', 'This is the ''issue worklog deleted'' event.', 'jira.system.event.type'),
(17, NULL, 'Issue Comment Deleted', 'This is the ''issue comment deleted'' event.', 'jira.system.event.type');  
CREATE CACHED TABLE PUBLIC.EXTERNAL_ENTITIES(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    ENTITYTYPE VARCHAR
);              
ALTER TABLE PUBLIC.EXTERNAL_ENTITIES ADD CONSTRAINT PUBLIC.PK_EXTERNAL_ENTITIES PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNAL_ENTITIES;        
CREATE INDEX PUBLIC.EXT_ENTITY_NAME ON PUBLIC.EXTERNAL_ENTITIES(NAME);         
CREATE CACHED TABLE PUBLIC.EXTERNALGADGET(
    ID BIGINT NOT NULL,
    GADGET_XML VARCHAR
);   
ALTER TABLE PUBLIC.EXTERNALGADGET ADD CONSTRAINT PUBLIC.PK_EXTERNALGADGET PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALGADGET;           
CREATE CACHED TABLE PUBLIC.FAVOURITEASSOCIATIONS(
    ID BIGINT NOT NULL,
    USERNAME VARCHAR,
    ENTITYTYPE VARCHAR,
    ENTITYID BIGINT,
    SEQUENCE BIGINT
);            
ALTER TABLE PUBLIC.FAVOURITEASSOCIATIONS ADD CONSTRAINT PUBLIC.PK_FAVOURITEASSOCIATIONS PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FAVOURITEASSOCIATIONS;    
CREATE UNIQUE INDEX PUBLIC.FAVOURITE_INDEX ON PUBLIC.FAVOURITEASSOCIATIONS(USERNAME, ENTITYTYPE, ENTITYID);    
CREATE CACHED TABLE PUBLIC.FEATURE(
    ID BIGINT NOT NULL,
    FEATURE_NAME VARCHAR,
    FEATURE_TYPE VARCHAR,
    USER_KEY VARCHAR
);        
ALTER TABLE PUBLIC.FEATURE ADD CONSTRAINT PUBLIC.PK_FEATURE PRIMARY KEY(ID);   
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.FEATURE;  
INSERT INTO PUBLIC.FEATURE(ID, FEATURE_NAME, FEATURE_TYPE, USER_KEY) VALUES
(10000, 'com.atlassian.jira.projects.ProjectCentricNavigation.Switch', 'site', ''),
(10001, 'com.atlassian.jira.projects.issuenavigator', 'site', '');             
CREATE INDEX PUBLIC.FEATURE_ID_USERKEY ON PUBLIC.FEATURE(ID, USER_KEY);        
CREATE CACHED TABLE PUBLIC.FIELDCONFIGSCHEME(
    ID BIGINT NOT NULL,
    CONFIGNAME VARCHAR,
    DESCRIPTION VARCHAR,
    FIELDID VARCHAR,
    CUSTOMFIELD BIGINT
);          
ALTER TABLE PUBLIC.FIELDCONFIGSCHEME ADD CONSTRAINT PUBLIC.PK_FIELDCONFIGSCHEME PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDCONFIGSCHEME;        
INSERT INTO PUBLIC.FIELDCONFIGSCHEME(ID, CONFIGNAME, DESCRIPTION, FIELDID, CUSTOMFIELD) VALUES
(10000, 'Default Issue Type Scheme', 'Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.', 'issuetype', NULL);              
CREATE INDEX PUBLIC.FCS_FIELDID ON PUBLIC.FIELDCONFIGSCHEME(FIELDID);          
CREATE CACHED TABLE PUBLIC.FIELDCONFIGSCHEMEISSUETYPE(
    ID BIGINT NOT NULL,
    ISSUETYPE VARCHAR,
    FIELDCONFIGSCHEME BIGINT,
    FIELDCONFIGURATION BIGINT
);           
ALTER TABLE PUBLIC.FIELDCONFIGSCHEMEISSUETYPE ADD CONSTRAINT PUBLIC.PK_FIELDCONFIGSCHEMEISSUETYPE PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDCONFIGSCHEMEISSUETYPE;               
INSERT INTO PUBLIC.FIELDCONFIGSCHEMEISSUETYPE(ID, ISSUETYPE, FIELDCONFIGSCHEME, FIELDCONFIGURATION) VALUES
(10100, NULL, 10000, 10000);        
CREATE INDEX PUBLIC.FCS_ISSUETYPE ON PUBLIC.FIELDCONFIGSCHEMEISSUETYPE(ISSUETYPE);             
CREATE INDEX PUBLIC.FCS_SCHEME ON PUBLIC.FIELDCONFIGSCHEMEISSUETYPE(FIELDCONFIGSCHEME);        
CREATE CACHED TABLE PUBLIC.FIELDCONFIGURATION(
    ID BIGINT NOT NULL,
    CONFIGNAME VARCHAR,
    DESCRIPTION VARCHAR,
    FIELDID VARCHAR,
    CUSTOMFIELD BIGINT
);         
ALTER TABLE PUBLIC.FIELDCONFIGURATION ADD CONSTRAINT PUBLIC.PK_FIELDCONFIGURATION PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDCONFIGURATION;       
INSERT INTO PUBLIC.FIELDCONFIGURATION(ID, CONFIGNAME, DESCRIPTION, FIELDID, CUSTOMFIELD) VALUES
(10000, 'Default Configuration for Issue Type', 'Default configuration generated by JIRA', 'issuetype', NULL); 
CREATE INDEX PUBLIC.FC_FIELDID ON PUBLIC.FIELDCONFIGURATION(FIELDID);          
CREATE CACHED TABLE PUBLIC.FIELDLAYOUT(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    LAYOUT_TYPE VARCHAR,
    LAYOUTSCHEME BIGINT
); 
ALTER TABLE PUBLIC.FIELDLAYOUT ADD CONSTRAINT PUBLIC.PK_FIELDLAYOUT PRIMARY KEY(ID);           
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDLAYOUT;              
INSERT INTO PUBLIC.FIELDLAYOUT(ID, NAME, DESCRIPTION, LAYOUT_TYPE, LAYOUTSCHEME) VALUES
(10000, 'Default Field Configuration', 'The default field configuration', 'default', NULL);            
CREATE CACHED TABLE PUBLIC.FIELDLAYOUTITEM(
    ID BIGINT NOT NULL,
    FIELDLAYOUT BIGINT,
    FIELDIDENTIFIER VARCHAR,
    DESCRIPTION VARCHAR,
    VERTICALPOSITION BIGINT,
    ISHIDDEN VARCHAR,
    ISREQUIRED VARCHAR,
    RENDERERTYPE VARCHAR
);       
ALTER TABLE PUBLIC.FIELDLAYOUTITEM ADD CONSTRAINT PUBLIC.PK_FIELDLAYOUTITEM PRIMARY KEY(ID);   
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.FIELDLAYOUTITEM;         
INSERT INTO PUBLIC.FIELDLAYOUTITEM(ID, FIELDLAYOUT, FIELDIDENTIFIER, DESCRIPTION, VERTICALPOSITION, ISHIDDEN, ISREQUIRED, RENDERERTYPE) VALUES
(10100, 10000, 'summary', NULL, NULL, 'false', 'true', 'jira-text-renderer'),
(10101, 10000, 'issuetype', NULL, NULL, 'false', 'true', 'jira-text-renderer'),
(10102, 10000, 'security', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10103, 10000, 'priority', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10104, 10000, 'duedate', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10105, 10000, 'components', NULL, NULL, 'false', 'false', 'frother-control-renderer'),
(10106, 10000, 'versions', NULL, NULL, 'false', 'false', 'frother-control-renderer'),
(10107, 10000, 'fixVersions', NULL, NULL, 'false', 'false', 'frother-control-renderer'),
(10108, 10000, 'assignee', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10109, 10000, 'reporter', NULL, NULL, 'false', 'true', 'jira-text-renderer'),
(10110, 10000, 'environment', 'For example operating system, software platform and/or hardware specifications (include as appropriate for the issue).', NULL, 'false', 'false', 'atlassian-wiki-renderer'),
(10111, 10000, 'description', NULL, NULL, 'false', 'false', 'atlassian-wiki-renderer'),
(10112, 10000, 'timetracking', 'An estimate of how much work remains until this issue will be resolved. The format of this is '' *w *d *h *m '' (representing weeks, days, hours and minutes - where * can be any number). Examples: 4d, 5h 30m, 60m and 3w.', NULL, 'false', 'false', 'jira-text-renderer'),
(10113, 10000, 'resolution', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10114, 10000, 'attachment', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10115, 10000, 'comment', NULL, NULL, 'false', 'false', 'atlassian-wiki-renderer'),
(10116, 10000, 'labels', NULL, NULL, 'false', 'false', 'jira-text-renderer'),
(10117, 10000, 'worklog', 'Allows work to be logged whilst creating, editing or transitioning issues.', NULL, 'false', 'false', 'atlassian-wiki-renderer'),
(10118, 10000, 'issuelinks', NULL, NULL, 'false', 'false', 'jira-text-renderer');               
CREATE INDEX PUBLIC.IDX_FLI_FIELDIDENTIFIER ON PUBLIC.FIELDLAYOUTITEM(FIELDIDENTIFIER);        
CREATE CACHED TABLE PUBLIC.FIELDLAYOUTSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);             
ALTER TABLE PUBLIC.FIELDLAYOUTSCHEME ADD CONSTRAINT PUBLIC.PK_FIELDLAYOUTSCHEME PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FIELDLAYOUTSCHEME;        
CREATE CACHED TABLE PUBLIC.FIELDLAYOUTSCHEMEASSOCIATION(
    ID BIGINT NOT NULL,
    ISSUETYPE VARCHAR,
    PROJECT BIGINT,
    FIELDLAYOUTSCHEME BIGINT
);    
ALTER TABLE PUBLIC.FIELDLAYOUTSCHEMEASSOCIATION ADD CONSTRAINT PUBLIC.PK_FIELDLAYOUTSCHEMEASSOCIATIO PRIMARY KEY(ID);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FIELDLAYOUTSCHEMEASSOCIATION;             
CREATE INDEX PUBLIC.FL_SCHEME_ASSOC ON PUBLIC.FIELDLAYOUTSCHEMEASSOCIATION(PROJECT, ISSUETYPE);
CREATE CACHED TABLE PUBLIC.FIELDLAYOUTSCHEMEENTITY(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    ISSUETYPE VARCHAR,
    FIELDLAYOUT BIGINT
);
ALTER TABLE PUBLIC.FIELDLAYOUTSCHEMEENTITY ADD CONSTRAINT PUBLIC.PK_FIELDLAYOUTSCHEMEENTITY PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FIELDLAYOUTSCHEMEENTITY;  
CREATE INDEX PUBLIC.FIELDLAYOUT_SCHEME ON PUBLIC.FIELDLAYOUTSCHEMEENTITY(SCHEME);              
CREATE INDEX PUBLIC.FIELDLAYOUT_LAYOUT ON PUBLIC.FIELDLAYOUTSCHEMEENTITY(FIELDLAYOUT);         
CREATE CACHED TABLE PUBLIC.FIELDSCREEN(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);   
ALTER TABLE PUBLIC.FIELDSCREEN ADD CONSTRAINT PUBLIC.PK_FIELDSCREEN PRIMARY KEY(ID);           
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.FIELDSCREEN;              
INSERT INTO PUBLIC.FIELDSCREEN(ID, NAME, DESCRIPTION) VALUES
(1, 'Default Screen', 'Allows to update all system fields.'),
(2, 'Workflow Screen', 'This screen is used in the workflow and enables you to assign issues'),
(3, 'Resolve Issue Screen', 'Allows to set resolution, change fix versions and assign an issue.');  
CREATE CACHED TABLE PUBLIC.FIELDSCREENLAYOUTITEM(
    ID BIGINT NOT NULL,
    FIELDIDENTIFIER VARCHAR,
    SEQUENCE BIGINT,
    FIELDSCREENTAB BIGINT
);       
ALTER TABLE PUBLIC.FIELDSCREENLAYOUTITEM ADD CONSTRAINT PUBLIC.PK_FIELDSCREENLAYOUTITEM PRIMARY KEY(ID);       
-- 20 +/- SELECT COUNT(*) FROM PUBLIC.FIELDSCREENLAYOUTITEM;   
INSERT INTO PUBLIC.FIELDSCREENLAYOUTITEM(ID, FIELDIDENTIFIER, SEQUENCE, FIELDSCREENTAB) VALUES
(10000, 'summary', 0, 10000),
(10001, 'issuetype', 1, 10000),
(10002, 'security', 2, 10000),
(10003, 'priority', 3, 10000),
(10004, 'duedate', 4, 10000),
(10005, 'components', 5, 10000),
(10006, 'versions', 6, 10000),
(10007, 'fixVersions', 7, 10000),
(10008, 'assignee', 8, 10000),
(10009, 'reporter', 9, 10000),
(10010, 'environment', 10, 10000),
(10011, 'description', 11, 10000),
(10012, 'timetracking', 12, 10000),
(10013, 'attachment', 13, 10000),
(10014, 'assignee', 0, 10001),
(10015, 'resolution', 0, 10002),
(10016, 'fixVersions', 1, 10002),
(10017, 'assignee', 2, 10002),
(10018, 'worklog', 3, 10002),
(10100, 'labels', 14, 10000);              
CREATE INDEX PUBLIC.FIELDSCITEM_TAB ON PUBLIC.FIELDSCREENLAYOUTITEM(FIELDSCREENTAB);           
CREATE INDEX PUBLIC.FIELDSCREEN_FIELD ON PUBLIC.FIELDSCREENLAYOUTITEM(FIELDIDENTIFIER);        
CREATE CACHED TABLE PUBLIC.FIELDSCREENSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);             
ALTER TABLE PUBLIC.FIELDSCREENSCHEME ADD CONSTRAINT PUBLIC.PK_FIELDSCREENSCHEME PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDSCREENSCHEME;        
INSERT INTO PUBLIC.FIELDSCREENSCHEME(ID, NAME, DESCRIPTION) VALUES
(1, 'Default Screen Scheme', 'Default Screen Scheme');      
CREATE CACHED TABLE PUBLIC.FIELDSCREENSCHEMEITEM(
    ID BIGINT NOT NULL,
    OPERATION BIGINT,
    FIELDSCREEN BIGINT,
    FIELDSCREENSCHEME BIGINT
);        
ALTER TABLE PUBLIC.FIELDSCREENSCHEMEITEM ADD CONSTRAINT PUBLIC.PK_FIELDSCREENSCHEMEITEM PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.FIELDSCREENSCHEMEITEM;    
INSERT INTO PUBLIC.FIELDSCREENSCHEMEITEM(ID, OPERATION, FIELDSCREEN, FIELDSCREENSCHEME) VALUES
(10000, NULL, 1, 1);            
CREATE INDEX PUBLIC.SCREENITEM_SCHEME ON PUBLIC.FIELDSCREENSCHEMEITEM(FIELDSCREENSCHEME);      
CREATE CACHED TABLE PUBLIC.FIELDSCREENTAB(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    SEQUENCE BIGINT,
    FIELDSCREEN BIGINT
);   
ALTER TABLE PUBLIC.FIELDSCREENTAB ADD CONSTRAINT PUBLIC.PK_FIELDSCREENTAB PRIMARY KEY(ID);     
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.FIELDSCREENTAB;           
INSERT INTO PUBLIC.FIELDSCREENTAB(ID, NAME, DESCRIPTION, SEQUENCE, FIELDSCREEN) VALUES
(10000, 'Field Tab', NULL, 0, 1),
(10001, 'Field Tab', NULL, 0, 2),
(10002, 'Field Tab', NULL, 0, 3);   
CREATE INDEX PUBLIC.FIELDSCREEN_TAB ON PUBLIC.FIELDSCREENTAB(FIELDSCREEN);     
CREATE CACHED TABLE PUBLIC.FILEATTACHMENT(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    MIMETYPE VARCHAR,
    FILENAME VARCHAR,
    CREATED TIMESTAMP,
    FILESIZE BIGINT,
    AUTHOR VARCHAR,
    ZIP INTEGER,
    THUMBNAILABLE INTEGER
);               
ALTER TABLE PUBLIC.FILEATTACHMENT ADD CONSTRAINT PUBLIC.PK_FILEATTACHMENT PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FILEATTACHMENT;           
CREATE INDEX PUBLIC.ATTACH_ISSUE ON PUBLIC.FILEATTACHMENT(ISSUEID);            
CREATE CACHED TABLE PUBLIC.FILTERSUBSCRIPTION(
    ID BIGINT NOT NULL,
    FILTER_I_D BIGINT,
    USERNAME VARCHAR,
    GROUPNAME VARCHAR,
    LAST_RUN TIMESTAMP,
    EMAIL_ON_EMPTY VARCHAR
);               
ALTER TABLE PUBLIC.FILTERSUBSCRIPTION ADD CONSTRAINT PUBLIC.PK_FILTERSUBSCRIPTION PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.FILTERSUBSCRIPTION;       
CREATE INDEX PUBLIC.SUBSCRPT_USER ON PUBLIC.FILTERSUBSCRIPTION(FILTER_I_D, USERNAME);          
CREATE INDEX PUBLIC.SUBSCRPTN_GROUP ON PUBLIC.FILTERSUBSCRIPTION(FILTER_I_D, GROUPNAME);       
CREATE CACHED TABLE PUBLIC.GADGETUSERPREFERENCE(
    ID BIGINT NOT NULL,
    PORTLETCONFIGURATION BIGINT,
    USERPREFKEY VARCHAR,
    USERPREFVALUE VARCHAR
);
ALTER TABLE PUBLIC.GADGETUSERPREFERENCE ADD CONSTRAINT PUBLIC.PK_GADGETUSERPREFERENCE PRIMARY KEY(ID);         
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.GADGETUSERPREFERENCE;     
INSERT INTO PUBLIC.GADGETUSERPREFERENCE(ID, PORTLETCONFIGURATION, USERPREFKEY, USERPREFVALUE) VALUES
(10000, 10002, 'isConfigured', 'true'),
(10001, 10003, 'keys', '__all_projects__'),
(10002, 10003, 'isConfigured', 'true'),
(10003, 10003, 'title', 'Your Company JIRA'),
(10004, 10003, 'numofentries', '5');            
CREATE INDEX PUBLIC.USERPREF_PORTLETCONFIGURATION ON PUBLIC.GADGETUSERPREFERENCE(PORTLETCONFIGURATION);        
CREATE CACHED TABLE PUBLIC.GENERICCONFIGURATION(
    ID BIGINT NOT NULL,
    DATATYPE VARCHAR,
    DATAKEY VARCHAR,
    XMLVALUE VARCHAR
);    
ALTER TABLE PUBLIC.GENERICCONFIGURATION ADD CONSTRAINT PUBLIC.PK_GENERICCONFIGURATION PRIMARY KEY(ID);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.GENERICCONFIGURATION;     
INSERT INTO PUBLIC.GENERICCONFIGURATION(ID, DATATYPE, DATAKEY, XMLVALUE) VALUES
(10000, 'DefaultValue', '10000', '<string>1</string>');        
CREATE UNIQUE INDEX PUBLIC.TYPE_KEY ON PUBLIC.GENERICCONFIGURATION(DATATYPE, DATAKEY);         
CREATE CACHED TABLE PUBLIC.GLOBALPERMISSIONENTRY(
    ID BIGINT NOT NULL,
    PERMISSION VARCHAR,
    GROUP_ID VARCHAR
);      
ALTER TABLE PUBLIC.GLOBALPERMISSIONENTRY ADD CONSTRAINT PUBLIC.PK_GLOBALPERMISSIONENTRY PRIMARY KEY(ID);       
-- 14 +/- SELECT COUNT(*) FROM PUBLIC.GLOBALPERMISSIONENTRY;   
INSERT INTO PUBLIC.GLOBALPERMISSIONENTRY(ID, PERMISSION, GROUP_ID) VALUES
(10000, 'ADMINISTER', 'jira-administrators'),
(10006, 'SYSTEM_ADMIN', 'jira-administrators'),
(10100, 'CREATE_SHARED_OBJECTS', 'jira-servicedesk-users'),
(10101, 'BULK_CHANGE', 'jira-servicedesk-users'),
(10102, 'MANAGE_GROUP_FILTER_SUBSCRIPTIONS', 'jira-servicedesk-users'),
(10103, 'USER_PICKER', 'jira-servicedesk-users'),
(10104, 'CREATE_SHARED_OBJECTS', 'jira-software-users'),
(10105, 'BULK_CHANGE', 'jira-software-users'),
(10106, 'MANAGE_GROUP_FILTER_SUBSCRIPTIONS', 'jira-software-users'),
(10107, 'USER_PICKER', 'jira-software-users'),
(10108, 'MANAGE_GROUP_FILTER_SUBSCRIPTIONS', 'jira-administrators'),
(10109, 'USER_PICKER', 'jira-administrators'),
(10110, 'BULK_CHANGE', 'jira-administrators'),
(10111, 'CREATE_SHARED_OBJECTS', 'jira-administrators');        
CREATE CACHED TABLE PUBLIC.CWD_GROUP(
    ID BIGINT NOT NULL,
    GROUP_NAME VARCHAR,
    LOWER_GROUP_NAME VARCHAR,
    ACTIVE INTEGER,
    LOCAL INTEGER,
    CREATED_DATE TIMESTAMP,
    UPDATED_DATE TIMESTAMP,
    DESCRIPTION VARCHAR,
    LOWER_DESCRIPTION VARCHAR,
    GROUP_TYPE VARCHAR,
    DIRECTORY_ID BIGINT
);  
ALTER TABLE PUBLIC.CWD_GROUP ADD CONSTRAINT PUBLIC.PK_CWD_GROUP PRIMARY KEY(ID);               
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.CWD_GROUP;
INSERT INTO PUBLIC.CWD_GROUP(ID, GROUP_NAME, LOWER_GROUP_NAME, ACTIVE, LOCAL, CREATED_DATE, UPDATED_DATE, DESCRIPTION, LOWER_DESCRIPTION, GROUP_TYPE, DIRECTORY_ID) VALUES
(10000, 'jira-administrators', 'jira-administrators', 1, 0, TIMESTAMP '2013-02-28 11:57:51.326', TIMESTAMP '2013-02-28 11:57:51.326', '', NULL, 'GROUP', 1),
(10010, 'jira-servicedesk-users', 'jira-servicedesk-users', 1, 0, TIMESTAMP '2015-11-07 02:06:52.118', TIMESTAMP '2015-11-07 02:06:52.118', NULL, NULL, 'GROUP', 1),
(10011, 'jira-software-users', 'jira-software-users', 1, 0, TIMESTAMP '2015-11-07 02:06:52.181', TIMESTAMP '2015-11-07 02:06:52.181', NULL, NULL, 'GROUP', 1);    
CREATE UNIQUE INDEX PUBLIC.UK_GROUP_NAME_DIR_ID ON PUBLIC.CWD_GROUP(LOWER_GROUP_NAME, DIRECTORY_ID);           
CREATE INDEX PUBLIC.IDX_GROUP_ACTIVE ON PUBLIC.CWD_GROUP(LOWER_GROUP_NAME, ACTIVE);            
CREATE INDEX PUBLIC.IDX_GROUP_DIR_ID ON PUBLIC.CWD_GROUP(DIRECTORY_ID);        
CREATE CACHED TABLE PUBLIC.CWD_GROUP_ATTRIBUTES(
    ID BIGINT NOT NULL,
    GROUP_ID BIGINT,
    DIRECTORY_ID BIGINT,
    ATTRIBUTE_NAME VARCHAR,
    ATTRIBUTE_VALUE VARCHAR,
    LOWER_ATTRIBUTE_VALUE VARCHAR
);           
ALTER TABLE PUBLIC.CWD_GROUP_ATTRIBUTES ADD CONSTRAINT PUBLIC.PK_CWD_GROUP_ATTRIBUTES PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CWD_GROUP_ATTRIBUTES;     
CREATE INDEX PUBLIC.IDX_GROUP_ATTR_DIR_NAME_LVAL ON PUBLIC.CWD_GROUP_ATTRIBUTES(DIRECTORY_ID, ATTRIBUTE_NAME, LOWER_ATTRIBUTE_VALUE);          
CREATE UNIQUE INDEX PUBLIC.UK_GROUP_ATTR_NAME_LVAL ON PUBLIC.CWD_GROUP_ATTRIBUTES(GROUP_ID, ATTRIBUTE_NAME, LOWER_ATTRIBUTE_VALUE);            
CREATE CACHED TABLE PUBLIC.JIRAISSUE(
    ID BIGINT NOT NULL,
    PKEY VARCHAR,
    ISSUENUM BIGINT,
    PROJECT BIGINT,
    REPORTER VARCHAR,
    ASSIGNEE VARCHAR,
    CREATOR VARCHAR,
    ISSUETYPE VARCHAR,
    SUMMARY VARCHAR,
    DESCRIPTION VARCHAR,
    ENVIRONMENT VARCHAR,
    PRIORITY VARCHAR,
    RESOLUTION VARCHAR,
    ISSUESTATUS VARCHAR,
    CREATED TIMESTAMP,
    UPDATED TIMESTAMP,
    DUEDATE TIMESTAMP,
    RESOLUTIONDATE TIMESTAMP,
    VOTES BIGINT,
    WATCHES BIGINT,
    TIMEORIGINALESTIMATE BIGINT,
    TIMEESTIMATE BIGINT,
    TIMESPENT BIGINT,
    WORKFLOW_ID BIGINT,
    SECURITY BIGINT,
    FIXFOR BIGINT,
    COMPONENT BIGINT
);
ALTER TABLE PUBLIC.JIRAISSUE ADD CONSTRAINT PUBLIC.PK_JIRAISSUE PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JIRAISSUE;
CREATE INDEX PUBLIC.ISSUE_PROJ_NUM ON PUBLIC.JIRAISSUE(ISSUENUM, PROJECT);     
CREATE INDEX PUBLIC.ISSUE_PROJ_STATUS ON PUBLIC.JIRAISSUE(PROJECT, ISSUESTATUS);               
CREATE INDEX PUBLIC.ISSUE_UPDATED ON PUBLIC.JIRAISSUE(UPDATED);
CREATE INDEX PUBLIC.ISSUE_ASSIGNEE ON PUBLIC.JIRAISSUE(ASSIGNEE);              
CREATE INDEX PUBLIC.ISSUE_REPORTER ON PUBLIC.JIRAISSUE(REPORTER);              
CREATE INDEX PUBLIC.ISSUE_WORKFLOW ON PUBLIC.JIRAISSUE(WORKFLOW_ID);           
CREATE CACHED TABLE PUBLIC.ISSUELINK(
    ID BIGINT NOT NULL,
    LINKTYPE BIGINT,
    SOURCE BIGINT,
    DESTINATION BIGINT,
    SEQUENCE BIGINT
);           
ALTER TABLE PUBLIC.ISSUELINK ADD CONSTRAINT PUBLIC.PK_ISSUELINK PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ISSUELINK;
CREATE INDEX PUBLIC.ISSUELINK_SRC ON PUBLIC.ISSUELINK(SOURCE); 
CREATE INDEX PUBLIC.ISSUELINK_DEST ON PUBLIC.ISSUELINK(DESTINATION);           
CREATE INDEX PUBLIC.ISSUELINK_TYPE ON PUBLIC.ISSUELINK(LINKTYPE);              
CREATE CACHED TABLE PUBLIC.ISSUELINKTYPE(
    ID BIGINT NOT NULL,
    LINKNAME VARCHAR,
    INWARD VARCHAR,
    OUTWARD VARCHAR,
    PSTYLE VARCHAR
);         
ALTER TABLE PUBLIC.ISSUELINKTYPE ADD CONSTRAINT PUBLIC.PK_ISSUELINKTYPE PRIMARY KEY(ID);       
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ISSUELINKTYPE;            
INSERT INTO PUBLIC.ISSUELINKTYPE(ID, LINKNAME, INWARD, OUTWARD, PSTYLE) VALUES
(10000, 'Blocks', 'is blocked by', 'blocks', NULL),
(10001, 'Cloners', 'is cloned by', 'clones', NULL),
(10002, 'Duplicate', 'is duplicated by', 'duplicates', NULL),
(10003, 'Relates', 'relates to', 'relates to', NULL),
(10100, 'jira_subtask_link', 'jira_subtask_inward', 'jira_subtask_outward', 'jira_subtask');        
CREATE INDEX PUBLIC.LINKTYPENAME ON PUBLIC.ISSUELINKTYPE(LINKNAME);            
CREATE INDEX PUBLIC.LINKTYPESTYLE ON PUBLIC.ISSUELINKTYPE(PSTYLE);             
CREATE CACHED TABLE PUBLIC.ISSUESECURITYSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    DEFAULTLEVEL BIGINT
);  
ALTER TABLE PUBLIC.ISSUESECURITYSCHEME ADD CONSTRAINT PUBLIC.PK_ISSUESECURITYSCHEME PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ISSUESECURITYSCHEME;      
CREATE CACHED TABLE PUBLIC.ISSUETYPE(
    ID VARCHAR NOT NULL,
    SEQUENCE BIGINT,
    PNAME VARCHAR,
    PSTYLE VARCHAR,
    DESCRIPTION VARCHAR,
    ICONURL VARCHAR,
    AVATAR BIGINT
);  
ALTER TABLE PUBLIC.ISSUETYPE ADD CONSTRAINT PUBLIC.PK_ISSUETYPE PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ISSUETYPE;
CREATE CACHED TABLE PUBLIC.ISSUETYPESCREENSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);         
ALTER TABLE PUBLIC.ISSUETYPESCREENSCHEME ADD CONSTRAINT PUBLIC.PK_ISSUETYPESCREENSCHEME PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ISSUETYPESCREENSCHEME;    
INSERT INTO PUBLIC.ISSUETYPESCREENSCHEME(ID, NAME, DESCRIPTION) VALUES
(1, 'Default Issue Type Screen Scheme', 'The default issue type screen scheme');        
CREATE CACHED TABLE PUBLIC.ISSUETYPESCREENSCHEMEENTITY(
    ID BIGINT NOT NULL,
    ISSUETYPE VARCHAR,
    SCHEME BIGINT,
    FIELDSCREENSCHEME BIGINT
);      
ALTER TABLE PUBLIC.ISSUETYPESCREENSCHEMEENTITY ADD CONSTRAINT PUBLIC.PK_ISSUETYPESCREENSCHEMEENTITY PRIMARY KEY(ID);           
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ISSUETYPESCREENSCHEMEENTITY;              
INSERT INTO PUBLIC.ISSUETYPESCREENSCHEMEENTITY(ID, ISSUETYPE, SCHEME, FIELDSCREENSCHEME) VALUES
(10000, NULL, 1, 1);           
CREATE INDEX PUBLIC.FIELDSCREEN_SCHEME ON PUBLIC.ISSUETYPESCREENSCHEMEENTITY(FIELDSCREENSCHEME);               
CREATE CACHED TABLE PUBLIC.JQUARTZ_BLOB_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    BLOB_DATA BLOB
);          
ALTER TABLE PUBLIC.JQUARTZ_BLOB_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_BLOB_TRIGGERS PRIMARY KEY(TRIGGER_NAME, TRIGGER_GROUP);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_BLOB_TRIGGERS;    
CREATE CACHED TABLE PUBLIC.JQUARTZ_CALENDARS(
    SCHED_NAME VARCHAR(120),
    CALENDAR_NAME VARCHAR(200) NOT NULL,
    CALENDAR BLOB
);       
ALTER TABLE PUBLIC.JQUARTZ_CALENDARS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_CALENDARS PRIMARY KEY(CALENDAR_NAME);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_CALENDARS;        
CREATE CACHED TABLE PUBLIC.JQUARTZ_CRON_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    CRON_EXPRESSION VARCHAR(120),
    TIME_ZONE_ID VARCHAR(80)
);              
ALTER TABLE PUBLIC.JQUARTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_CRON_TRIGGERS PRIMARY KEY(TRIGGER_NAME, TRIGGER_GROUP);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_CRON_TRIGGERS;    
CREATE CACHED TABLE PUBLIC.JQUARTZ_FIRED_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(200),
    TRIGGER_GROUP VARCHAR(200),
    IS_VOLATILE BOOLEAN,
    INSTANCE_NAME VARCHAR(200),
    FIRED_TIME BIGINT,
    SCHED_TIME BIGINT,
    PRIORITY BIGINT,
    STATE VARCHAR(16),
    JOB_NAME VARCHAR(200),
    JOB_GROUP VARCHAR(200),
    IS_STATEFUL BOOLEAN,
    IS_NONCONCURRENT BOOLEAN,
    IS_UPDATE_DATA BOOLEAN,
    REQUESTS_RECOVERY BOOLEAN
);
ALTER TABLE PUBLIC.JQUARTZ_FIRED_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_FIRED_TRIGGERS PRIMARY KEY(ENTRY_ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_FIRED_TRIGGERS;   
CREATE INDEX PUBLIC.IDX_QRTZ_FT_TRIG_INST_NAME ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, INSTANCE_NAME);    
CREATE INDEX PUBLIC.IDX_QRTZ_FT_INST_JOB_REQ_RCVRY ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, INSTANCE_NAME, REQUESTS_RECOVERY);             
CREATE INDEX PUBLIC.IDX_QRTZ_FT_J_G ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, JOB_NAME, JOB_GROUP);         
CREATE INDEX PUBLIC.IDX_QRTZ_FT_JG ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, JOB_GROUP);    
CREATE INDEX PUBLIC.IDX_QRTZ_FT_T_G ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP); 
CREATE INDEX PUBLIC.IDX_QRTZ_FT_TG ON PUBLIC.JQUARTZ_FIRED_TRIGGERS(SCHED_NAME, TRIGGER_GROUP);
CREATE CACHED TABLE PUBLIC.JQUARTZ_JOB_DETAILS(
    SCHED_NAME VARCHAR(120),
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250),
    JOB_CLASS_NAME VARCHAR(250),
    IS_DURABLE BOOLEAN,
    IS_VOLATILE BOOLEAN,
    IS_STATEFUL BOOLEAN,
    IS_NONCONCURRENT BOOLEAN,
    IS_UPDATE_DATA BOOLEAN,
    REQUESTS_RECOVERY BOOLEAN,
    JOB_DATA BLOB
);   
ALTER TABLE PUBLIC.JQUARTZ_JOB_DETAILS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_JOB_DETAILS PRIMARY KEY(JOB_NAME, JOB_GROUP);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_JOB_DETAILS;      
CREATE INDEX PUBLIC.IDX_QRTZ_J_REQ_RECOVERY ON PUBLIC.JQUARTZ_JOB_DETAILS(SCHED_NAME, REQUESTS_RECOVERY);      
CREATE INDEX PUBLIC.IDX_QRTZ_J_GRP ON PUBLIC.JQUARTZ_JOB_DETAILS(SCHED_NAME, JOB_GROUP);       
CREATE CACHED TABLE PUBLIC.JQUARTZ_JOB_LISTENERS(
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    JOB_LISTENER VARCHAR(200) NOT NULL
);           
ALTER TABLE PUBLIC.JQUARTZ_JOB_LISTENERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_JOB_LISTENERS PRIMARY KEY(JOB_NAME, JOB_GROUP, JOB_LISTENER);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_JOB_LISTENERS;    
CREATE CACHED TABLE PUBLIC.JQUARTZ_LOCKS(
    SCHED_NAME VARCHAR(120),
    LOCK_NAME VARCHAR(40) NOT NULL
);   
ALTER TABLE PUBLIC.JQUARTZ_LOCKS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_LOCKS PRIMARY KEY(LOCK_NAME);
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_LOCKS;            
INSERT INTO PUBLIC.JQUARTZ_LOCKS(SCHED_NAME, LOCK_NAME) VALUES
(NULL, 'TRIGGER_ACCESS'),
(NULL, 'JOB_ACCESS'),
(NULL, 'CALENDAR_ACCESS'),
(NULL, 'STATE_ACCESS'),
(NULL, 'MISFIRE_ACCESS');    
CREATE CACHED TABLE PUBLIC.JQUARTZ_PAUSED_TRIGGER_GRPS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_GROUP VARCHAR(200) NOT NULL
);
ALTER TABLE PUBLIC.JQUARTZ_PAUSED_TRIGGER_GRPS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY(TRIGGER_GROUP);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_PAUSED_TRIGGER_GRPS;              
CREATE CACHED TABLE PUBLIC.JQUARTZ_SCHEDULER_STATE(
    SCHED_NAME VARCHAR(120),
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    LAST_CHECKIN_TIME BIGINT,
    CHECKIN_INTERVAL BIGINT
);         
ALTER TABLE PUBLIC.JQUARTZ_SCHEDULER_STATE ADD CONSTRAINT PUBLIC.PK_JQUARTZ_SCHEDULER_STATE PRIMARY KEY(INSTANCE_NAME);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_SCHEDULER_STATE;  
CREATE CACHED TABLE PUBLIC.JQUARTZ_SIMPROP_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512),
    STR_PROP_2 VARCHAR(512),
    STR_PROP_3 VARCHAR(512),
    INT_PROP_1 BIGINT,
    INT_PROP_2 BIGINT,
    LONG_PROP_1 BIGINT,
    LONG_PROP_2 BIGINT,
    DEC_PROP_1 BIGINT,
    DEC_PROP_2 BIGINT,
    BOOL_PROP_1 BOOLEAN,
    BOOL_PROP_2 BOOLEAN
);      
ALTER TABLE PUBLIC.JQUARTZ_SIMPROP_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_SIMPROP_TRIGGERS PRIMARY KEY(TRIGGER_NAME, TRIGGER_GROUP);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_SIMPROP_TRIGGERS; 
CREATE CACHED TABLE PUBLIC.JQUARTZ_SIMPLE_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    REPEAT_COUNT BIGINT,
    REPEAT_INTERVAL BIGINT,
    TIMES_TRIGGERED BIGINT
);           
ALTER TABLE PUBLIC.JQUARTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_SIMPLE_TRIGGERS PRIMARY KEY(TRIGGER_NAME, TRIGGER_GROUP);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_SIMPLE_TRIGGERS;  
CREATE CACHED TABLE PUBLIC.JQUARTZ_TRIGGER_LISTENERS(
    TRIGGER_NAME VARCHAR(200),
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    TRIGGER_LISTENER VARCHAR(200) NOT NULL
);    
ALTER TABLE PUBLIC.JQUARTZ_TRIGGER_LISTENERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_TRIGGER_LISTENERS PRIMARY KEY(TRIGGER_GROUP, TRIGGER_LISTENER);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_TRIGGER_LISTENERS;
CREATE CACHED TABLE PUBLIC.JQUARTZ_TRIGGERS(
    SCHED_NAME VARCHAR(120),
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    JOB_NAME VARCHAR(200),
    JOB_GROUP VARCHAR(200),
    IS_VOLATILE BOOLEAN,
    DESCRIPTION VARCHAR(250),
    NEXT_FIRE_TIME BIGINT,
    PREV_FIRE_TIME BIGINT,
    PRIORITY BIGINT,
    TRIGGER_STATE VARCHAR(16),
    TRIGGER_TYPE VARCHAR(8),
    START_TIME BIGINT,
    END_TIME BIGINT,
    CALENDAR_NAME VARCHAR(200),
    MISFIRE_INSTR INTEGER,
    JOB_DATA BLOB
);    
ALTER TABLE PUBLIC.JQUARTZ_TRIGGERS ADD CONSTRAINT PUBLIC.PK_JQUARTZ_TRIGGERS PRIMARY KEY(TRIGGER_NAME, TRIGGER_GROUP);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JQUARTZ_TRIGGERS;         
CREATE INDEX PUBLIC.IDX_QRTZ_T_J ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, JOB_NAME, JOB_GROUP);  
CREATE INDEX PUBLIC.IDX_QRTZ_T_JG ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, JOB_GROUP);           
CREATE INDEX PUBLIC.IDX_QRTZ_T_C ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, CALENDAR_NAME);        
CREATE INDEX PUBLIC.IDX_QRTZ_J_G ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, TRIGGER_GROUP);        
CREATE INDEX PUBLIC.IDX_QRTZ_J_STATE ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, TRIGGER_STATE);    
CREATE INDEX PUBLIC.IDX_QRTZ_T_N_STATE ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_STATE);     
CREATE INDEX PUBLIC.IDX_QRTZ_T_N_G_STATE ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, TRIGGER_GROUP, TRIGGER_STATE); 
CREATE INDEX PUBLIC.IDX_QRTZ_T_NEXT_FIRE_TIME ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, NEXT_FIRE_TIME);          
CREATE INDEX PUBLIC.IDX_QRTZ_T_NFT_ST ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, TRIGGER_STATE, NEXT_FIRE_TIME);   
CREATE INDEX PUBLIC.IDX_QRTZ_T_NFT_MISFIRE ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME);              
CREATE INDEX PUBLIC.IDX_QRTZ_T_NFT_ST_MISFIRE ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME, TRIGGER_STATE);            
CREATE INDEX PUBLIC.IDX_QRTZ_T_NFT_ST_MISFIRE_GRP ON PUBLIC.JQUARTZ_TRIGGERS(SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME, TRIGGER_GROUP, TRIGGER_STATE);         
CREATE CACHED TABLE PUBLIC.LABEL(
    ID BIGINT NOT NULL,
    FIELDID BIGINT,
    ISSUE BIGINT,
    LABEL VARCHAR
);           
ALTER TABLE PUBLIC.LABEL ADD CONSTRAINT PUBLIC.PK_LABEL PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.LABEL;    
CREATE INDEX PUBLIC.LABEL_FIELDISSUE ON PUBLIC.LABEL(ISSUE, FIELDID);          
CREATE INDEX PUBLIC.LABEL_FIELDISSUELABEL ON PUBLIC.LABEL(ISSUE, FIELDID, LABEL);              
CREATE INDEX PUBLIC.LABEL_LABEL ON PUBLIC.LABEL(LABEL);        
CREATE INDEX PUBLIC.LABEL_ISSUE ON PUBLIC.LABEL(ISSUE);        
CREATE CACHED TABLE PUBLIC.LICENSEROLESDEFAULT(
    ID BIGINT NOT NULL,
    LICENSE_ROLE_NAME VARCHAR
);       
ALTER TABLE PUBLIC.LICENSEROLESDEFAULT ADD CONSTRAINT PUBLIC.PK_LICENSEROLESDEFAULT PRIMARY KEY(ID);           
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.LICENSEROLESDEFAULT;      
INSERT INTO PUBLIC.LICENSEROLESDEFAULT(ID, LICENSE_ROLE_NAME) VALUES
(10000, 'jira-servicedesk'),
(10001, 'jira-software');    
CREATE UNIQUE INDEX PUBLIC.LICENSEROLEDEFAULT_INDEX ON PUBLIC.LICENSEROLESDEFAULT(LICENSE_ROLE_NAME);          
CREATE CACHED TABLE PUBLIC.LICENSEROLESGROUP(
    ID BIGINT NOT NULL,
    LICENSE_ROLE_NAME VARCHAR,
    GROUP_ID VARCHAR,
    PRIMARY_GROUP CHAR(1)
);        
ALTER TABLE PUBLIC.LICENSEROLESGROUP ADD CONSTRAINT PUBLIC.PK_LICENSEROLESGROUP PRIMARY KEY(ID);               
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.LICENSEROLESGROUP;        
INSERT INTO PUBLIC.LICENSEROLESGROUP(ID, LICENSE_ROLE_NAME, GROUP_ID, PRIMARY_GROUP) VALUES
(10000, 'jira-servicedesk', 'jira-servicedesk-users', 'Y'),
(10001, 'jira-software', 'jira-software-users', 'Y'),
(10002, 'jira-servicedesk', 'jira-administrators', 'N'),
(10003, 'jira-software', 'jira-administrators', 'N');   
CREATE UNIQUE INDEX PUBLIC.LICENSEROLEGROUP_INDEX ON PUBLIC.LICENSEROLESGROUP(LICENSE_ROLE_NAME, GROUP_ID);    
CREATE CACHED TABLE PUBLIC.LISTENERCONFIG(
    ID BIGINT NOT NULL,
    CLAZZ VARCHAR,
    LISTENERNAME VARCHAR
);              
ALTER TABLE PUBLIC.LISTENERCONFIG ADD CONSTRAINT PUBLIC.PK_LISTENERCONFIG PRIMARY KEY(ID);     
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.LISTENERCONFIG;           
INSERT INTO PUBLIC.LISTENERCONFIG(ID, CLAZZ, LISTENERNAME) VALUES
(10000, 'com.atlassian.jira.event.listeners.mail.MailListener', 'Mail Listener'),
(10001, 'com.atlassian.jira.event.listeners.history.IssueAssignHistoryListener', 'Issue Assignment Listener'),
(10002, 'com.atlassian.jira.event.listeners.search.IssueIndexListener', 'Issue Index Listener'),
(10200, 'com.atlassian.jira.event.listeners.search.IssueIndexListener', 'Issue Index Listener');           
CREATE CACHED TABLE PUBLIC.MAILSERVER(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    MAILFROM VARCHAR,
    PREFIX VARCHAR,
    SMTP_PORT VARCHAR,
    PROTOCOL VARCHAR,
    SERVER_TYPE VARCHAR,
    SERVERNAME VARCHAR,
    JNDILOCATION VARCHAR,
    MAILUSERNAME VARCHAR,
    MAILPASSWORD VARCHAR,
    ISTLSREQUIRED VARCHAR,
    TIMEOUT BIGINT,
    SOCKS_PORT VARCHAR,
    SOCKS_HOST VARCHAR
);               
ALTER TABLE PUBLIC.MAILSERVER ADD CONSTRAINT PUBLIC.PK_MAILSERVER PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MAILSERVER;               
CREATE CACHED TABLE PUBLIC.MANAGEDCONFIGURATIONITEM(
    ID BIGINT NOT NULL,
    ITEM_ID VARCHAR,
    ITEM_TYPE VARCHAR,
    MANAGED VARCHAR,
    ACCESS_LEVEL VARCHAR,
    SOURCE VARCHAR,
    DESCRIPTION_KEY VARCHAR
);     
ALTER TABLE PUBLIC.MANAGEDCONFIGURATIONITEM ADD CONSTRAINT PUBLIC.PK_MANAGEDCONFIGURATIONITEM PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MANAGEDCONFIGURATIONITEM; 
CREATE INDEX PUBLIC.MANAGEDCONFIGITEM_ID_TYPE_IDX ON PUBLIC.MANAGEDCONFIGURATIONITEM(ITEM_ID, ITEM_TYPE);      
CREATE CACHED TABLE PUBLIC.CWD_MEMBERSHIP(
    ID BIGINT NOT NULL,
    PARENT_ID BIGINT,
    CHILD_ID BIGINT,
    MEMBERSHIP_TYPE VARCHAR,
    GROUP_TYPE VARCHAR,
    PARENT_NAME VARCHAR,
    LOWER_PARENT_NAME VARCHAR,
    CHILD_NAME VARCHAR,
    LOWER_CHILD_NAME VARCHAR,
    DIRECTORY_ID BIGINT
);    
ALTER TABLE PUBLIC.CWD_MEMBERSHIP ADD CONSTRAINT PUBLIC.PK_CWD_MEMBERSHIP PRIMARY KEY(ID);     
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.CWD_MEMBERSHIP;           
INSERT INTO PUBLIC.CWD_MEMBERSHIP(ID, PARENT_ID, CHILD_ID, MEMBERSHIP_TYPE, GROUP_TYPE, PARENT_NAME, LOWER_PARENT_NAME, CHILD_NAME, LOWER_CHILD_NAME, DIRECTORY_ID) VALUES
(10000, 10000, 10000, 'GROUP_USER', NULL, 'jira-administrators', 'jira-administrators', 'admin', 'admin', 1),
(10001, 10010, 10000, 'GROUP_USER', NULL, 'jira-servicedesk-users', 'jira-servicedesk-users', 'admin', 'admin', 1),
(10002, 10011, 10000, 'GROUP_USER', NULL, 'jira-software-users', 'jira-software-users', 'admin', 'admin', 1);     
CREATE UNIQUE INDEX PUBLIC.UK_MEM_PARENT_CHILD_TYPE ON PUBLIC.CWD_MEMBERSHIP(PARENT_ID, CHILD_ID, MEMBERSHIP_TYPE);            
CREATE INDEX PUBLIC.IDX_MEM_DIR_PARENT_CHILD ON PUBLIC.CWD_MEMBERSHIP(LOWER_PARENT_NAME, LOWER_CHILD_NAME, MEMBERSHIP_TYPE, DIRECTORY_ID);     
CREATE INDEX PUBLIC.IDX_MEM_DIR_PARENT ON PUBLIC.CWD_MEMBERSHIP(LOWER_PARENT_NAME, MEMBERSHIP_TYPE, DIRECTORY_ID);             
CREATE INDEX PUBLIC.IDX_MEM_DIR_CHILD ON PUBLIC.CWD_MEMBERSHIP(LOWER_CHILD_NAME, MEMBERSHIP_TYPE, DIRECTORY_ID);               
CREATE CACHED TABLE PUBLIC.MOVED_ISSUE_KEY(
    ID BIGINT NOT NULL,
    OLD_ISSUE_KEY VARCHAR,
    ISSUE_ID BIGINT
);          
ALTER TABLE PUBLIC.MOVED_ISSUE_KEY ADD CONSTRAINT PUBLIC.PK_MOVED_ISSUE_KEY PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MOVED_ISSUE_KEY;          
CREATE UNIQUE INDEX PUBLIC.IDX_OLD_ISSUE_KEY ON PUBLIC.MOVED_ISSUE_KEY(OLD_ISSUE_KEY);         
CREATE CACHED TABLE PUBLIC.NODEASSOCIATION(
    SOURCE_NODE_ID BIGINT NOT NULL,
    SOURCE_NODE_ENTITY VARCHAR NOT NULL,
    SINK_NODE_ID BIGINT NOT NULL,
    SINK_NODE_ENTITY VARCHAR NOT NULL,
    ASSOCIATION_TYPE VARCHAR NOT NULL,
    SEQUENCE INTEGER
);               
ALTER TABLE PUBLIC.NODEASSOCIATION ADD CONSTRAINT PUBLIC.PK_NODEASSOCIATION PRIMARY KEY(SOURCE_NODE_ID, SOURCE_NODE_ENTITY, SINK_NODE_ID, SINK_NODE_ENTITY, ASSOCIATION_TYPE); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NODEASSOCIATION;          
CREATE INDEX PUBLIC.NODE_SOURCE ON PUBLIC.NODEASSOCIATION(SOURCE_NODE_ID, SOURCE_NODE_ENTITY); 
CREATE INDEX PUBLIC.NODE_SINK ON PUBLIC.NODEASSOCIATION(SINK_NODE_ID, SINK_NODE_ENTITY);       
CREATE CACHED TABLE PUBLIC.NODEINDEXCOUNTER(
    ID BIGINT NOT NULL,
    NODE_ID VARCHAR,
    SENDING_NODE_ID VARCHAR,
    INDEX_OPERATION_ID BIGINT
);        
ALTER TABLE PUBLIC.NODEINDEXCOUNTER ADD CONSTRAINT PUBLIC.PK_NODEINDEXCOUNTER PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NODEINDEXCOUNTER;         
CREATE UNIQUE INDEX PUBLIC.NODE_ID_IDX ON PUBLIC.NODEINDEXCOUNTER(NODE_ID, SENDING_NODE_ID);   
CREATE CACHED TABLE PUBLIC.NOTIFICATION(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    EVENT VARCHAR,
    EVENT_TYPE_ID BIGINT,
    TEMPLATE_ID BIGINT,
    NOTIF_TYPE VARCHAR,
    NOTIF_PARAMETER VARCHAR
);
ALTER TABLE PUBLIC.NOTIFICATION ADD CONSTRAINT PUBLIC.PK_NOTIFICATION PRIMARY KEY(ID);         
-- 48 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION;            
INSERT INTO PUBLIC.NOTIFICATION(ID, SCHEME, EVENT, EVENT_TYPE_ID, TEMPLATE_ID, NOTIF_TYPE, NOTIF_PARAMETER) VALUES
(10000, 10000, NULL, 1, NULL, 'Current_Assignee', NULL),
(10001, 10000, NULL, 1, NULL, 'Current_Reporter', NULL),
(10002, 10000, NULL, 1, NULL, 'All_Watchers', NULL),
(10003, 10000, NULL, 2, NULL, 'Current_Assignee', NULL),
(10004, 10000, NULL, 2, NULL, 'Current_Reporter', NULL),
(10005, 10000, NULL, 2, NULL, 'All_Watchers', NULL),
(10006, 10000, NULL, 3, NULL, 'Current_Assignee', NULL),
(10007, 10000, NULL, 3, NULL, 'Current_Reporter', NULL),
(10008, 10000, NULL, 3, NULL, 'All_Watchers', NULL),
(10009, 10000, NULL, 4, NULL, 'Current_Assignee', NULL),
(10010, 10000, NULL, 4, NULL, 'Current_Reporter', NULL),
(10011, 10000, NULL, 4, NULL, 'All_Watchers', NULL),
(10012, 10000, NULL, 5, NULL, 'Current_Assignee', NULL),
(10013, 10000, NULL, 5, NULL, 'Current_Reporter', NULL),
(10014, 10000, NULL, 5, NULL, 'All_Watchers', NULL),
(10015, 10000, NULL, 6, NULL, 'Current_Assignee', NULL),
(10016, 10000, NULL, 6, NULL, 'Current_Reporter', NULL),
(10017, 10000, NULL, 6, NULL, 'All_Watchers', NULL),
(10018, 10000, NULL, 7, NULL, 'Current_Assignee', NULL),
(10019, 10000, NULL, 7, NULL, 'Current_Reporter', NULL),
(10020, 10000, NULL, 7, NULL, 'All_Watchers', NULL),
(10021, 10000, NULL, 8, NULL, 'Current_Assignee', NULL),
(10022, 10000, NULL, 8, NULL, 'Current_Reporter', NULL),
(10023, 10000, NULL, 8, NULL, 'All_Watchers', NULL),
(10024, 10000, NULL, 9, NULL, 'Current_Assignee', NULL),
(10025, 10000, NULL, 9, NULL, 'Current_Reporter', NULL),
(10026, 10000, NULL, 9, NULL, 'All_Watchers', NULL),
(10027, 10000, NULL, 10, NULL, 'Current_Assignee', NULL),
(10028, 10000, NULL, 10, NULL, 'Current_Reporter', NULL),
(10029, 10000, NULL, 10, NULL, 'All_Watchers', NULL),
(10030, 10000, NULL, 11, NULL, 'Current_Assignee', NULL),
(10031, 10000, NULL, 11, NULL, 'Current_Reporter', NULL),
(10032, 10000, NULL, 11, NULL, 'All_Watchers', NULL),
(10033, 10000, NULL, 12, NULL, 'Current_Assignee', NULL),
(10034, 10000, NULL, 12, NULL, 'Current_Reporter', NULL),
(10035, 10000, NULL, 12, NULL, 'All_Watchers', NULL),
(10036, 10000, NULL, 13, NULL, 'Current_Assignee', NULL),
(10037, 10000, NULL, 13, NULL, 'Current_Reporter', NULL),
(10038, 10000, NULL, 13, NULL, 'All_Watchers', NULL),
(10100, 10000, NULL, 14, NULL, 'Current_Assignee', NULL),
(10101, 10000, NULL, 14, NULL, 'Current_Reporter', NULL),
(10102, 10000, NULL, 14, NULL, 'All_Watchers', NULL),
(10103, 10000, NULL, 15, NULL, 'Current_Assignee', NULL),
(10104, 10000, NULL, 15, NULL, 'Current_Reporter', NULL),
(10105, 10000, NULL, 15, NULL, 'All_Watchers', NULL),
(10106, 10000, NULL, 16, NULL, 'Current_Assignee', NULL),
(10107, 10000, NULL, 16, NULL, 'Current_Reporter', NULL),
(10108, 10000, NULL, 16, NULL, 'All_Watchers', NULL);        
CREATE INDEX PUBLIC.NTFCTN_SCHEME ON PUBLIC.NOTIFICATION(SCHEME);              
CREATE CACHED TABLE PUBLIC.NOTIFICATIONINSTANCE(
    ID BIGINT NOT NULL,
    NOTIFICATIONTYPE VARCHAR,
    SOURCE BIGINT,
    EMAILADDRESS VARCHAR,
    MESSAGEID VARCHAR
);   
ALTER TABLE PUBLIC.NOTIFICATIONINSTANCE ADD CONSTRAINT PUBLIC.PK_NOTIFICATIONINSTANCE PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATIONINSTANCE;     
CREATE INDEX PUBLIC.NOTIF_SOURCE ON PUBLIC.NOTIFICATIONINSTANCE(SOURCE);       
CREATE INDEX PUBLIC.NOTIF_MESSAGEID ON PUBLIC.NOTIFICATIONINSTANCE(MESSAGEID); 
CREATE CACHED TABLE PUBLIC.NOTIFICATIONSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);            
ALTER TABLE PUBLIC.NOTIFICATIONSCHEME ADD CONSTRAINT PUBLIC.PK_NOTIFICATIONSCHEME PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATIONSCHEME;       
INSERT INTO PUBLIC.NOTIFICATIONSCHEME(ID, NAME, DESCRIPTION) VALUES
(10000, 'Default Notification Scheme', NULL);              
CREATE CACHED TABLE PUBLIC.OAUTHCONSUMER(
    ID BIGINT NOT NULL,
    CREATED TIMESTAMP,
    CONSUMERNAME VARCHAR,
    CONSUMER_KEY VARCHAR,
    CONSUMERSERVICE VARCHAR,
    PUBLIC_KEY VARCHAR,
    PRIVATE_KEY VARCHAR,
    DESCRIPTION VARCHAR,
    CALLBACK VARCHAR,
    SIGNATURE_METHOD VARCHAR,
    SHARED_SECRET VARCHAR
);           
ALTER TABLE PUBLIC.OAUTHCONSUMER ADD CONSTRAINT PUBLIC.PK_OAUTHCONSUMER PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OAUTHCONSUMER;            
CREATE UNIQUE INDEX PUBLIC.OAUTH_CONSUMER_INDEX ON PUBLIC.OAUTHCONSUMER(CONSUMER_KEY);         
CREATE UNIQUE INDEX PUBLIC.OAUTH_CONSUMER_SERVICE_INDEX ON PUBLIC.OAUTHCONSUMER(CONSUMERSERVICE);              
CREATE CACHED TABLE PUBLIC.OAUTHCONSUMERTOKEN(
    ID BIGINT NOT NULL,
    CREATED TIMESTAMP,
    TOKEN_KEY VARCHAR,
    TOKEN VARCHAR,
    TOKEN_SECRET VARCHAR,
    TOKEN_TYPE VARCHAR,
    CONSUMER_KEY VARCHAR
);          
ALTER TABLE PUBLIC.OAUTHCONSUMERTOKEN ADD CONSTRAINT PUBLIC.PK_OAUTHCONSUMERTOKEN PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OAUTHCONSUMERTOKEN;       
CREATE UNIQUE INDEX PUBLIC.OAUTH_CONSUMER_TOKEN_KEY_INDEX ON PUBLIC.OAUTHCONSUMERTOKEN(TOKEN_KEY);             
CREATE INDEX PUBLIC.OAUTH_CONSUMER_TOKEN_INDEX ON PUBLIC.OAUTHCONSUMERTOKEN(TOKEN);            
CREATE CACHED TABLE PUBLIC.OAUTHSPCONSUMER(
    ID BIGINT NOT NULL,
    CREATED TIMESTAMP,
    CONSUMER_KEY VARCHAR,
    CONSUMERNAME VARCHAR,
    PUBLIC_KEY VARCHAR,
    DESCRIPTION VARCHAR,
    CALLBACK VARCHAR,
    TWO_L_O_ALLOWED VARCHAR,
    EXECUTING_TWO_L_O_USER VARCHAR,
    TWO_L_O_IMPERSONATION_ALLOWED VARCHAR,
    THREE_L_O_ALLOWED VARCHAR
);             
ALTER TABLE PUBLIC.OAUTHSPCONSUMER ADD CONSTRAINT PUBLIC.PK_OAUTHSPCONSUMER PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OAUTHSPCONSUMER;          
CREATE UNIQUE INDEX PUBLIC.OAUTH_SP_CONSUMER_INDEX ON PUBLIC.OAUTHSPCONSUMER(CONSUMER_KEY);    
CREATE CACHED TABLE PUBLIC.OAUTHSPTOKEN(
    ID BIGINT NOT NULL,
    CREATED TIMESTAMP,
    TOKEN VARCHAR,
    TOKEN_SECRET VARCHAR,
    TOKEN_TYPE VARCHAR,
    CONSUMER_KEY VARCHAR,
    USERNAME VARCHAR,
    TTL BIGINT,
    SPAUTH VARCHAR,
    CALLBACK VARCHAR,
    SPVERIFIER VARCHAR,
    SPVERSION VARCHAR,
    SESSION_HANDLE VARCHAR,
    SESSION_CREATION_TIME TIMESTAMP,
    SESSION_LAST_RENEWAL_TIME TIMESTAMP,
    SESSION_TIME_TO_LIVE TIMESTAMP
);          
ALTER TABLE PUBLIC.OAUTHSPTOKEN ADD CONSTRAINT PUBLIC.PK_OAUTHSPTOKEN PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OAUTHSPTOKEN;             
CREATE UNIQUE INDEX PUBLIC.OAUTH_SP_TOKEN_INDEX ON PUBLIC.OAUTHSPTOKEN(TOKEN); 
CREATE INDEX PUBLIC.OAUTH_SP_CONSUMER_KEY_INDEX ON PUBLIC.OAUTHSPTOKEN(CONSUMER_KEY);          
CREATE CACHED TABLE PUBLIC.OS_CURRENTSTEP(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR,
    START_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    STATUS VARCHAR,
    CALLER VARCHAR
);  
ALTER TABLE PUBLIC.OS_CURRENTSTEP ADD CONSTRAINT PUBLIC.PK_OS_CURRENTSTEP PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OS_CURRENTSTEP;           
CREATE INDEX PUBLIC.WF_ENTRYID ON PUBLIC.OS_CURRENTSTEP(ENTRY_ID);             
CREATE CACHED TABLE PUBLIC.OS_CURRENTSTEP_PREV(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL
);     
ALTER TABLE PUBLIC.OS_CURRENTSTEP_PREV ADD CONSTRAINT PUBLIC.PK_OS_CURRENTSTEP_PREV PRIMARY KEY(ID, PREVIOUS_ID);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OS_CURRENTSTEP_PREV;      
CREATE CACHED TABLE PUBLIC.GROUPBASE(
    ID BIGINT NOT NULL,
    GROUPNAME VARCHAR
);         
ALTER TABLE PUBLIC.GROUPBASE ADD CONSTRAINT PUBLIC.PK_GROUPBASE PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.GROUPBASE;
CREATE INDEX PUBLIC.OSGROUP_NAME ON PUBLIC.GROUPBASE(GROUPNAME);               
CREATE CACHED TABLE PUBLIC.OS_HISTORYSTEP(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR,
    START_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    STATUS VARCHAR,
    CALLER VARCHAR
);  
ALTER TABLE PUBLIC.OS_HISTORYSTEP ADD CONSTRAINT PUBLIC.PK_OS_HISTORYSTEP PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OS_HISTORYSTEP;           
CREATE INDEX PUBLIC.HISTORYSTEP_ENTRYID ON PUBLIC.OS_HISTORYSTEP(ENTRY_ID);    
CREATE CACHED TABLE PUBLIC.OS_HISTORYSTEP_PREV(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL
);     
ALTER TABLE PUBLIC.OS_HISTORYSTEP_PREV ADD CONSTRAINT PUBLIC.PK_OS_HISTORYSTEP_PREV PRIMARY KEY(ID, PREVIOUS_ID);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OS_HISTORYSTEP_PREV;      
CREATE CACHED TABLE PUBLIC.MEMBERSHIPBASE(
    ID BIGINT NOT NULL,
    USER_NAME VARCHAR,
    GROUP_NAME VARCHAR
);            
ALTER TABLE PUBLIC.MEMBERSHIPBASE ADD CONSTRAINT PUBLIC.PK_MEMBERSHIPBASE PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MEMBERSHIPBASE;           
CREATE INDEX PUBLIC.MSHIPBASE_USER ON PUBLIC.MEMBERSHIPBASE(USER_NAME);        
CREATE INDEX PUBLIC.MSHIPBASE_GROUP ON PUBLIC.MEMBERSHIPBASE(GROUP_NAME);      
CREATE CACHED TABLE PUBLIC.PROPERTYDATA(
    ID BIGINT NOT NULL,
    PROPERTYVALUE BLOB
);     
ALTER TABLE PUBLIC.PROPERTYDATA ADD CONSTRAINT PUBLIC.PK_PROPERTYDATA PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYDATA;             
CREATE CACHED TABLE PUBLIC.PROPERTYDATE(
    ID BIGINT NOT NULL,
    PROPERTYVALUE TIMESTAMP
);
ALTER TABLE PUBLIC.PROPERTYDATE ADD CONSTRAINT PUBLIC.PK_PROPERTYDATE PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYDATE;             
CREATE CACHED TABLE PUBLIC.PROPERTYDECIMAL(
    ID BIGINT NOT NULL,
    PROPERTYVALUE DOUBLE
);
ALTER TABLE PUBLIC.PROPERTYDECIMAL ADD CONSTRAINT PUBLIC.PK_PROPERTYDECIMAL PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYDECIMAL;          
CREATE CACHED TABLE PUBLIC.PROPERTYENTRY(
    ID BIGINT NOT NULL,
    ENTITY_NAME VARCHAR,
    ENTITY_ID BIGINT,
    PROPERTY_KEY VARCHAR,
    PROPERTYTYPE INTEGER
);         
ALTER TABLE PUBLIC.PROPERTYENTRY ADD CONSTRAINT PUBLIC.PK_PROPERTYENTRY PRIMARY KEY(ID);       
-- 91 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYENTRY;           
INSERT INTO PUBLIC.PROPERTYENTRY(ID, ENTITY_NAME, ENTITY_ID, PROPERTY_KEY, PROPERTYTYPE) VALUES
(1, 'jira.properties', 1, 'jira.version.patched', 5),
(2, 'jira.properties', 1, 'jira.avatar.issuetype.subtask.default.id', 5),
(3, 'jira.properties', 1, 'jira.avatar.default.id', 5),
(4, 'jira.properties', 1, 'jira.avatar.issuetype.default.id', 5),
(5, 'jira.properties', 1, 'jira.avatar.user.default.id', 5),
(6, 'jira.properties', 1, 'jira.avatar.user.anonymous.id', 5),
(7, 'jira.properties', 1, 'jira.scheme.default.issue.type', 5),
(9, 'jira.properties', 1, 'jira.whitelist.disabled', 1),
(10, 'jira.properties', 1, 'jira.whitelist.rules', 6),
(11, 'jira.properties', 1, 'jira.option.timetracking', 1),
(12, 'jira.properties', 1, 'jira.timetracking.estimates.legacy.behaviour', 1),
(13, 'jira.properties', 1, 'jira.version', 5),
(14, 'jira.properties', 1, 'jira.downgrade.minimum.version', 5),
(15, 'jira.properties', 1, 'jira.option.allowunassigned', 1),
(16, 'jira.properties', 1, 'jira.path.index.use.default.directory', 1),
(21, 'com.atlassian.jira.plugins.jira-workflow-designer', 1, 'jira.workflow.layout:8a6044147cf2c19c02d099279cfbfd47', 6),
(22, 'jira.properties', 1, 'jira.onboarding.app_user.id.threshold', 5),
(23, 'jira.properties', 1, 'post.migration.page.displayed', 1),
(10100, 'jira.properties', 1, 'AO_550953_#', 5),
(10101, 'jira.properties', 1, 'AO_4AEACD_#', 5),
(10102, 'jira.properties', 1, 'jira.webresource.superbatch.flushcounter', 5),
(10103, 'jira.properties', 1, 'jira.i18n.language.index', 5),
(10104, 'jira.properties', 1, 'jira.sid.key', 5),
(10200, 'jira.properties', 1, 'jira.webresource.flushcounter', 5),
(10201, 'jira.properties', 1, 'webwork.i18n.encoding', 5),
(10202, 'jira.properties', 1, 'jira.title', 5),
(10203, 'jira.properties', 1, 'jira.baseurl', 5),
(10204, 'jira.properties', 1, 'jira.mode', 5),
(10205, 'jira.properties', 1, 'jira.path.attachments', 5),
(10206, 'jira.properties', 1, 'jira.path.attachments.use.default.directory', 1),
(10207, 'jira.properties', 1, 'jira.option.allowattachments', 1),
(10208, 'ServiceConfig', 10001, 'USE_DEFAULT_DIRECTORY', 5),
(10209, 'jira.properties', 1, 'jira.path.backup', 5),
(10210, 'jira.properties', 1, 'org.apache.shindig.common.crypto.BlobCrypter:key', 5),
(10211, 'jira.properties', 1, 'com.atlassian.jira.util.index.IndexingCounterManagerImpl.counterValue', 3),
(10212, 'jira.properties', 1, 'jira.setup', 5),
(10213, 'jira.properties', 1, 'jira.option.user.externalmanagement', 1),
(10214, 'jira.properties', 1, 'jira.option.voting', 1),
(10215, 'jira.properties', 1, 'jira.option.watching', 1),
(10216, 'jira.properties', 1, 'jira.option.issuelinking', 1),
(10217, 'jira.properties', 1, 'jira.option.emailvisible', 5),
(10218, 'jira.properties', 1, 'jira.option.allowsubtasks', 1),
(10219, 'jira.properties', 1, 'com.atlassian.streams.InlineActivityStream:loaded.from.jira.projects', 5),
(10220, 'jira.properties', 1, 'com.atlassian.analytics.client.configuration..policy_acknowledged', 5),
(10221, 'jira.properties', 1, 'com.atlassian.analytics.client.configuration..analytics_enabled', 5),
(10223, 'jira.properties', 1, 'com.atlassian.sal.jira:build', 5),
(10225, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-whitelist-api-plugin:whitelist.enabled', 5),
(10226, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-whitelist-api-plugin:build', 5),
(10227, 'jira.properties', 1, 'com.atlassian.jira.gadgets:build', 5),
(10228, 'jira.properties', 1, 'com.atlassian.refapp.ctk:build', 5),
(10230, 'jira.properties', 1, 'com.atlassian.crowd.embedded.admin:build', 5),
(10231, 'jira.properties', 1, 'com.atlassian.labs.hipchat.hipchat-for-jira-plugin:build', 5),
(10233, 'jira.properties', 1, 'com.atlassian.jira.jira-mail-plugin:build', 5),
(10234, 'jira.properties', 1, 'com.atlassian.jira.plugins.jira-workflow-designer:build', 5),
(10235, 'jira.properties', 1, 'com.atlassian.plugins.custom_apps.hasCustomOrder', 5),
(10236, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-nav-links-plugin:build', 5),
(10239, 'jira.properties', 1, 'com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin:build', 5);     
INSERT INTO PUBLIC.PROPERTYENTRY(ID, ENTITY_NAME, ENTITY_ID, PROPERTY_KEY, PROPERTYTYPE) VALUES
(10240, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:isDefaultFavicon', 5),
(10241, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:usingCustomFavicon', 5),
(10242, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:customDefaultFaviconURL', 5),
(10243, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:customDefaultFaviconHiresURL', 5),
(10244, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:faviconWidth', 5),
(10245, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:faviconHeight', 5),
(10246, 'jira.properties', 1, 'jira.lf.favicon.url', 5),
(10247, 'jira.properties', 1, 'jira.lf.favicon.hires.url', 5),
(10248, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:build', 5),
(10252, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-plugin.request', 5),
(10254, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-evaluation.expired', 5),
(10256, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-edition.mismatch', 5),
(10257, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-maintenance.expired', 5),
(10259, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-new.licenses', 5),
(10260, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-updated.licenses', 5),
(10261, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-auto.updated.plugin', 5),
(10262, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-auto.updated.upm', 5),
(10263, 'jira.properties', 1, 'com.atlassian.upm.request.PluginSettingsPluginRequestStore:requests:requests_v2', 5),
(10267, 'jira.properties', 1, 'com.atlassian.upm.atlassian-universal-plugin-manager-plugin:build', 5),
(10268, 'jira.properties', 1, 'com.atlassian.jirawallboard.atlassian-wallboard-plugin:build', 5),
(10269, 'jira.properties', 1, 'com.atlassian.support.stp:build', 5),
(10270, 'jira.properties', 1, 'com.atlassian.jira.project-templates-plugin:build', 5),
(10271, 'jira.properties', 1, 'jira-header-plugin.studio-tab-migration-complete', 5),
(10272, 'jira.properties', 1, 'com.atlassian.upm.log.PluginSettingsAuditLogService:log:upm_audit_log_v3', 5),
(10273, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-edition.mismatch', 5),
(10274, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-plugin.request', 5),
(10275, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-evaluation.expired', 5),
(10276, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-evaluation.nearlyexpired', 5),
(10277, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-maintenance.expired', 5),
(10278, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-maintenance.nearlyexpired', 5),
(10279, 'ApplicationUser', 10000, 'jira.onboarding.first.use.flow.started', 5),
(10280, 'jira.properties', 1, 'com.atlassian.jira.onboarding.postsetup.AppPropertiesPostSetupAnnouncementStore.all', 6),
(10281, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-update', 5),
(10282, 'jira.properties', 1, 'com.atlassian.analytics.client.configuration..logged_base_analytics_data', 5);            
CREATE INDEX PUBLIC.OSPROPERTY_ALL ON PUBLIC.PROPERTYENTRY(ENTITY_ID);         
CREATE INDEX PUBLIC.OSPROPERTY_ENTITYNAME ON PUBLIC.PROPERTYENTRY(ENTITY_NAME);
CREATE INDEX PUBLIC.OSPROPERTY_PROPERTYKEY ON PUBLIC.PROPERTYENTRY(PROPERTY_KEY);              
CREATE CACHED TABLE PUBLIC.PROPERTYNUMBER(
    ID BIGINT NOT NULL,
    PROPERTYVALUE BIGINT
); 
ALTER TABLE PUBLIC.PROPERTYNUMBER ADD CONSTRAINT PUBLIC.PK_PROPERTYNUMBER PRIMARY KEY(ID);     
-- 14 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYNUMBER;          
INSERT INTO PUBLIC.PROPERTYNUMBER(ID, PROPERTYVALUE) VALUES
(9, 0),
(11, 1),
(12, 0),
(15, 1),
(16, 1),
(23, 1),
(10206, 1),
(10207, 1),
(10211, 0),
(10213, 0),
(10214, 1),
(10215, 1),
(10216, 1),
(10218, 1);               
CREATE CACHED TABLE PUBLIC.PROPERTYSTRING(
    ID BIGINT NOT NULL,
    PROPERTYVALUE VARCHAR
);
ALTER TABLE PUBLIC.PROPERTYSTRING ADD CONSTRAINT PUBLIC.PK_PROPERTYSTRING PRIMARY KEY(ID);     
-- 74 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYSTRING;          
INSERT INTO PUBLIC.PROPERTYSTRING(ID, PROPERTYVALUE) VALUES
(1, '71001'),
(2, '10316'),
(3, '10011'),
(4, '10300'),
(5, '10122'),
(6, '10123'),
(7, '10000'),
(13, '7.1.0-SNAPSHOT'),
(14, '6.4.12'),
(22, '0'),
(10100, '1'),
(10101, '1'),
(10102, '2'),
(10103, 'english-moderate-stemming'),
(10104, 'BWP3-NZB2-6EDY-6C7K'),
(10200, 'b6b48b2829824b869586ac216d119363'),
(10201, 'UTF-8'),
(10202, 'Your Company JIRA'),
(10203, 'http://localhost:2990/jira'),
(10204, 'private'),
(10205, './data/attachments'),
(10208, 'true'),
(10209, './export'),
(10210, 'EuC5Y+UM6XLIMaKFld2td+DsYASYZlyIj3vFrJ/A5PQ='),
(10212, 'true'),
(10217, 'show'),
(10219, 'true'),
(10220, 'true'),
(10221, 'true'),
(10223, '2'),
(10225, 'true'),
(10226, '4'),
(10227, '1'),
(10228, '1'),
(10230, '3'),
(10231, '1'),
(10233, '2'),
(10234, '1'),
(10235, 'false'),
(10236, '1'),
(10239, '3'),
(10240, 'false'),
(10241, 'false'),
(10242, '/favicon.ico'),
(10243, '/images/64jira.png'),
(10244, '64'),
(10245, '64'),
(10246, '/favicon.ico'),
(10247, '/images/64jira.png'),
(10248, '1'),
(10252, STRINGDECODE('#java.util.List\n')),
(10254, STRINGDECODE('#java.util.List\n')),
(10256, STRINGDECODE('#java.util.List\n')),
(10257, STRINGDECODE('#java.util.List\n')),
(10259, STRINGDECODE('#java.util.List\n')),
(10260, STRINGDECODE('#java.util.List\n')),
(10261, STRINGDECODE('#java.util.List\n')),
(10262, STRINGDECODE('#java.util.List\n')),
(10263, STRINGDECODE('#java.util.List\n')),
(10267, '5'),
(10268, '6086'),
(10269, '1'),
(10270, '2001'),
(10271, 'migrated'),
(10272, STRINGDECODE('#java.util.List\n{\"userKey\":\"JIRA\",\"date\":1446822480312,\"i18nKey\":\"upm.auditLog.upm.startup\",\"entryType\":\"UPM_STARTUP\",\"params\":[]}')),
(10273, STRINGDECODE('#java.util.List\n')),
(10274, STRINGDECODE('#java.util.List\n')),
(10275, STRINGDECODE('#java.util.List\n')),
(10276, STRINGDECODE('#java.util.List\n')),
(10277, STRINGDECODE('#java.util.List\n')),
(10278, STRINGDECODE('#java.util.List\n')),
(10279, 'jiraFirstUseFlow'),
(10281, STRINGDECODE('#java.util.List\ncom.atlassian.jira.plugins.jira-healthcheck-plugin')),
(10282, 'true');          
CREATE CACHED TABLE PUBLIC.PROPERTYTEXT(
    ID BIGINT NOT NULL,
    PROPERTYVALUE VARCHAR
);  
ALTER TABLE PUBLIC.PROPERTYTEXT ADD CONSTRAINT PUBLIC.PK_PROPERTYTEXT PRIMARY KEY(ID);         
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.PROPERTYTEXT;             
INSERT INTO PUBLIC.PROPERTYTEXT(ID, PROPERTYVALUE) VALUES
(10, STRINGDECODE('http://www.atlassian.com/*\n')),
(21, STRINGDECODE('{\n    \"edgeMap\": {\n        \"1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA\": {\n            \"actionId\": 5,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1806.5,\n                    \"y\": 434.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1801.0,\n                    \"y\": 115.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1801.0,\n                \"y\": 115.0\n            },\n            \"endStepId\": 4,\n            \"id\": \"1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA\",\n            \"label\": \"Resolve Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1776.85,\n                \"y\": 355.25\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1806.5,\n                \"y\": 434.0\n            },\n            \"startStepId\": 5\n        },\n        \"3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230\": {\n            \"actionId\": 2,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1469.5,\n                    \"y\": 113.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1614.0,\n                    \"y\": 226.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1614.0,\n                \"y\": 226.0\n            },\n            \"endStepId\": 6,\n            \"id\": \"3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230\",\n            \"label\": \"Close Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1492.25,\n                \"y\": 154.25\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1469.5,\n                \"y\": 113.0\n            },\n            \"startStepId\": 1\n        },\n        \"483797F1-1BF4-5E0F-86C6-4D19CE6023A2\": {\n            \"actionId\": 5,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1469.5,\n                    \"y\": 113.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1763.0,\n                    \"y\": 113.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1763.0,\n                \"y\": 113.0\n            },\n            \"endStepId\": 4,\n            \"id\": \"483797F1-1BF4-5E0F-86C6-4D19CE6023A2\",\n            \"label\": \"Resolve Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1551.0,\n                \"y\": 104.0\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1469.5,\n                \"y\": 113.0\n            },\n            \"startStepId\": 1\n        },\n        \"517D7F32-20FB-309E-8639-4D19CE2ACB54\": {\n            \"actionId\": 5,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1434.0,\n                    \"y\": 435.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1435.0,\n                    \"y\": 490.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1947.0,\n                    \"y\": 494.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1950.0,\n                    \"y\": 118.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1763.0,\n                    \"y\": 113.0\n                }\n            ],\n            \"controlPoints\": [\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1435.0,\n                    \"y\": 490.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1947.0,\n                    \"y\": 494.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1950.0,\n                    \"y\": 118.0\n                }\n            ],\n            \"endNodeId\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1763.0,\n                \"y\": 113.0\n            },\n            \"endStepId\": 4,\n            \"id\": \"517D7F32-20FB-309E-8639-4D19CE2ACB54\",\n            \"label\": \"Resolve Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1631.25,\n                \"y\": 479.5\n            },\n            \"lineType\": \"poly\",\n            \"startNodeId\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1434.0,\n                \"y\": 435.0\n            },\n            \"startStepId\": 3\n        },\n        \"58BD4605-5FB9-84EA-6952-4D19CE7B454B\": {\n            \"actionId\": 1,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1470.0,\n                    \"y\": 16.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1469.5,\n                    \"y\": 113.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1469.5,\n                \"y\": 113.0\n            },\n            \"endStepId\": 1,\n            \"id\": \"58BD4605-5FB9-84EA-6952-4D19CE7B454B\",\n            \"label\": \"Create Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1475.5,\n                \"y\": 48.5\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"15174530-AE75-04E0-1D9D-4D19CD200835\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1470.0,\n                \"y\": 16.0\n            },\n            \"startStepId\": 1\n        },\n        \"92D3DEFD-13AC-06A7-E5D8-4D19CE537791\": {\n            \"actionId\": 4,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1439.5,\n                    \"y\": 116.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1393.0,\n                    \"y\": 116.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1390.0,\n                    \"y\": 434.0\n                }\n            ],\n            \"controlPoints\": [\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1393.0,\n                    \"y\": 116.0\n                }\n            ],\n            \"endNodeId\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1390.0,\n                \"y\": 434.0\n            },\n            \"endStepId\": 3,\n            \"id\": \"92D3DEFD-13AC-06A7-E5D8-4D19CE537791\",\n            \"label\": \"Start Progress\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1323.65,\n                \"y\": 193.75\n            },\n            \"lineType\": \"poly\",\n            \"startNodeId\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1439.5,\n                \"y\": 116.0\n            },\n            \"startStepId\": 1\n        },\n        \"C049EE11-C5BB-F93B-36C3-4D19CDF12B8F\": {\n            \"actionId\": 3,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1677.0,\n                    \"y\": 227.0\n                },\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1767.05,\n                    \"y\": 230.05\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1773.5,\n                    \"y\": 425.0\n                }\n            ],\n            \"controlPoints\": [\n                {\n                    \"positiveController\": {\n                        \"positiveController\": null,\n                        \"x\": 0.0,\n                        \"y\": 0.0\n                    },\n                    \"x\": 1767.05,\n                    \"y\": 230.05\n                }\n            ],\n            \"endNodeId\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1773.5,\n                \"y\": 425.0\n            },\n            \"endStepId\": 5,\n            \"id\": \"C049EE11-C5BB-F93B-36C3-4D19CDF12B8F\",\n            \"label\": \"Reopen Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1703.85,\n                \"y\": 218.5\n            },\n            \"lineType\": \"poly\",\n            \"startNodeId\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1677.0,\n                \"y\": 227.0\n            },\n            \"startStepId\": 6\n        },\n        \"C9EA1792-2332-8B56-A04D-4D19CD725367\": {\n            \"actionId\": 301,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1465.0,\n                    \"y\": 436.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1469.5,\n                    \"y\": 113.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1469.5,\n                \"y\": 113.0\n            },\n            \"endStepId\": 1,\n            \"id\": \"C9EA1792-2332-8B56-A04D-4D19CD725367\",\n            \"label\": \"Stop Progress\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1407.8,\n                \"y\": 308.5\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1465.0,\n                \"y\": 436.0\n            },\n            \"startStepId\": 3\n        },\n        \"CAF37138-6321-E03A-8E41-4D19CDD7DC78\": {\n            \"actionId\": 2,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1764.5,\n                    \"y\": 430.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1614.0,\n                    \"y\": 226.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1614.0,\n                \"y\": 226.0\n            },\n            \"endStepId\": 6,\n            \"id\": \"CAF37138-6321-E03A-8E41-4D19CDD7DC78\",\n            \"label\": \"Close Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1677.65,\n                \"y\": 365.0\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1764.5,\n                \"y\": 430.0\n            },\n            \"startStepId\": 5\n        },\n        \"E1F8462A-8B0A-87EA-4F70-4D19CE423C83\": {\n            \"actionId\": 2,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1488.0,\n                    \"y\": 430.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1614.0,\n                    \"y\": 226.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1614.0,\n                \"y\": 226.0\n            },\n            \"endStepId\": 6,\n            \"id\": \"E1F8462A-8B0A-87EA-4F70-4D19CE423C83\",\n            \"label\": \"Close Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1492.0,\n                \"y\": 345.0\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1488.0,\n                \"y\": 430.0\n            },\n            \"startStepId\": 3\n        },\n        \"E27D8EB8-8E49-430B-8FCB-4D19CE127171\": {\n            \"actionId\": 3,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1840.0,\n                    \"y\": 130.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1846.5,\n                    \"y\": 428.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1846.5,\n                \"y\": 428.0\n            },\n            \"endStepId\": 5,\n            \"id\": \"E27D8EB8-8E49-430B-8FCB-4D19CE127171\",\n            \"label\": \"Reopen Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1814.05,\n                \"y\": 169.5\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1840.0,\n                \"y\": 130.0\n            },\n            \"startStepId\": 4\n        },\n        \"F79E742D-A9E4-0124-D7D4-4D19CDE48C9C\": {\n            \"actionId\": 4,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1806.5,\n                    \"y\": 434.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1434.0,\n                    \"y\": 435.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1434.0,\n                \"y\": 435.0\n            },\n            \"endStepId\": 3,\n            \"id\": \"F79E742D-A9E4-0124-D7D4-4D19CDE48C9C\",\n            \"label\": \"Start Progress\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1607.25,\n                \"y\": 423.5\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1806.5,\n                \"y\": 434.0\n            },\n            \"startStepId\": 5\n        },\n        \"FD6BA267-475B-70B3-8AA4-4D19CE00BCD1\": {\n            \"actionId\": 701,\n            \"allPoints\": [\n                {\n                    \"positiveController\": null,\n                    \"x\": 1763.0,\n                    \"y\": 113.0\n                },\n                {\n                    \"positiveController\": null,\n                    \"x\": 1614.0,\n                    \"y\": 226.0\n                }\n            ],\n            \"controlPoints\": [],\n            \"endNodeId\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"endPoint\": {\n                \"positiveController\": null,\n                \"x\": 1614.0,\n                \"y\": 226.0\n            },\n            \"endStepId\": 6,\n            \"id\": \"FD6BA267-475B-70B3-8AA4-4D19CE00BCD1\",\n            \"label\": \"Close Issue\",\n            \"labelPoint\": {\n                \"positiveController\": null,\n                \"x\": 1635.75,\n                \"y\": 152.25\n            },\n            \"lineType\": \"straight\",\n            \"startNodeId\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"startPoint\": {\n                \"positiveController\": null,\n                \"x\": 1763.0,\n                \"y\": 113.0\n            },\n            \"startStepId\": 4\n        }\n    },\n    \"nodeMap\": {\n        \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\": {\n            \"id\": \"0740FFFA-2AA1-C90A-38ED-4D19CD61899B\",\n            \"inLinkIds\": [\n                \"F79E742D-A9E4-0124-D7D4-4D19CDE48C9C\",\n                \"92D3DEFD-13AC-06A7-E5D8-4D19CE537791\"\n            ],\n            \"isInitialAction\": false,\n            \"label\": \"In Progress\",\n            \"outLinkIds\": [\n                \"C9EA1792-2332-8B56-A04D-4D19CD725367\",\n                \"517D7F32-20FB-309E-8639-4D19CE2ACB54\",\n                \"E1F8462A-8B0A-87EA-4F70-4D19CE423C83\"\n            ],\n            \"rect\": {\n                \"height\": 45.0,\n                \"positiveController\": null,\n                \"width\": 146.0,\n                \"x\": 1373.0,\n                \"y\": 419.0\n            },\n            \"stepId\": 3\n        },\n        \"15174530-AE75-04E0-1D9D-4D19CD200835\": {\n            \"id\": \"15174530-AE75-04E0-1D9D-4D19CD200835\",\n            \"inLinkIds\": [],\n            \"isInitialAction\": true,\n            \"label\": \"Create Issue\",\n            \"outLinkIds\": [\n                \"58BD4605-5FB9-84EA-6952-4D19CE7B454B\"\n            ],\n            \"rect\": {\n                \"height\": 45.0,\n                \"positiveController\": null,\n                \"width\": 157.0,\n                \"x\": 1405.0,\n                \"y\": 0.0\n            },\n            \"stepId\": 1\n        },\n        \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\": {\n            \"id\": \"1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34\",\n            \"inLinkIds\": [\n                \"CAF37138-6321-E03A-8E41-4D19CDD7DC78\",\n                \"E1F8462A-8B0A-87EA-4F70-4D19CE423C83\",\n                \"FD6BA267-475B-70B3-8AA4-4D19CE00BCD1\",\n                \"3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230\"\n            ],\n            \"isInitialAction\": false,\n            \"label\": \"Closed\",\n            \"outLinkIds\": [\n                \"C049EE11-C5BB-F93B-36C3-4D19CDF12B8F\"\n            ],\n            \"rect\": {\n                \"height\": 45.0,\n                \"positiveController\": null,\n                \"width\": 120.0,\n                \"x\": 1569.0,\n                \"y\": 210.0\n            },\n            \"stepId\": 6\n        },\n        \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\": {\n            \"id\": \"6DA64EEB-08FE-2870-C90C-4D19CDA2F72D\",\n            \"inLinkIds\": [\n                \"517D7F32-20FB-309E-8639-4D19CE2ACB54\",\n                \"1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA\",\n                \"483797F1-1BF4-5E0F-86C6-4D19CE6023A2\"\n            ],\n            \"isInitialAction\": false,\n            \"label\": \"Resolved\",\n            \"outLinkIds\": [\n                \"FD6BA267-475B-70B3-8AA4-4D19CE00BCD1\",\n                \"E27D8EB8-8E49-430B-8FCB-4D19CE127171\"\n            ],\n            \"rect\": {\n                \"height\": 44.0,\n                \"positiveController\": null,\n                \"width\": 137.0,\n                \"x\": 1709.0,\n                \"y\": 97.0\n            },\n            \"stepId\": 4\n        },\n        \"778534F4-7595-88B6-45E1-4D19CD518712\": {\n            \"id\": \"778534F4-7595-88B6-45E1-4D19CD518712\",\n            \"inLinkIds\": [\n                \"C9EA1792-2332-8B56-A04D-4D19CD725367\",\n                \"58BD4605-5FB9-84EA-6952-4D19CE7B454B\"\n            ],\n            \"isInitialAction\": false,\n            \"label\": \"Open\",\n            \"outLinkIds\": [\n                \"92D3DEFD-13AC-06A7-E5D8-4D19CE537791\",\n                \"483797F1-1BF4-5E0F-86C6-4D19CE6023A2\",\n                \"3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230\"\n            ],\n            \"rect\": {\n                \"height\": 45.0,\n                \"positiveController\": null,\n                \"width\": 106.0,\n                \"x\": 1429.5,\n                \"y\": 97.0\n            },\n            \"stepId\": 1\n        },\n        \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\": {\n            \"id\": \"A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB\",\n            \"inLinkIds\": [\n                \"E27D8EB8-8E49-430B-8FCB-4D19CE127171\",\n                \"C049EE11-C5BB-F93B-36C3-4D19CDF12B8F\"\n            ],\n            \"isInitialAction\": false,\n            \"label\": \"Reopened\",\n            \"outLinkIds\": [\n                \"1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA\",\n                \"CAF37138-6321-E03A-8E41-4D19CDD7DC78\",\n                \"F79E742D-A9E4-0124-D7D4-4D19CDE48C9C\"\n            ],\n            \"rect\": {\n                \"height\": 45.0,\n                \"positiveController\": null,\n                \"width\": 142.0,\n                \"x\": 1749.5,\n                \"y\": 418.0\n            },\n            \"stepId\": 5\n        }\n    },\n    \"rootIds\": [\n        \"15174530-AE75-04E0-1D9D-4D19CD200835\"\n    ],\n    \"width\": 1136\n}\n'));  
INSERT INTO PUBLIC.PROPERTYTEXT(ID, PROPERTYVALUE) VALUES
(10280, 'database.setup=AWAITS;admin.account.setup=FULLFILLED;app.properties.setup=FULLFILLED;create.user.mail.properties.setup=AWAITS;mail.properties.setup=AWAITS');               
CREATE CACHED TABLE PUBLIC.USERBASE(
    ID BIGINT NOT NULL,
    USERNAME VARCHAR,
    PASSWORD_HASH VARCHAR
);
ALTER TABLE PUBLIC.USERBASE ADD CONSTRAINT PUBLIC.PK_USERBASE PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERBASE; 
CREATE INDEX PUBLIC.OSUSER_NAME ON PUBLIC.USERBASE(USERNAME);  
CREATE CACHED TABLE PUBLIC.OS_WFENTRY(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    INITIALIZED INTEGER,
    STATE INTEGER
); 
ALTER TABLE PUBLIC.OS_WFENTRY ADD CONSTRAINT PUBLIC.PK_OS_WFENTRY PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OS_WFENTRY;               
CREATE CACHED TABLE PUBLIC.OPTIONCONFIGURATION(
    ID BIGINT NOT NULL,
    FIELDID VARCHAR,
    OPTIONID VARCHAR,
    FIELDCONFIG BIGINT,
    SEQUENCE BIGINT
);              
ALTER TABLE PUBLIC.OPTIONCONFIGURATION ADD CONSTRAINT PUBLIC.PK_OPTIONCONFIGURATION PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OPTIONCONFIGURATION;      
CREATE INDEX PUBLIC.FIELDID_OPTIONID ON PUBLIC.OPTIONCONFIGURATION(FIELDID, OPTIONID);         
CREATE INDEX PUBLIC.FIELDID_FIELDCONF ON PUBLIC.OPTIONCONFIGURATION(FIELDID, FIELDCONFIG);     
CREATE CACHED TABLE PUBLIC.JIRAPERMS(
    ID BIGINT NOT NULL,
    PERMTYPE BIGINT,
    PROJECTID BIGINT,
    GROUPNAME VARCHAR
);              
ALTER TABLE PUBLIC.JIRAPERMS ADD CONSTRAINT PUBLIC.PK_JIRAPERMS PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.JIRAPERMS;
CREATE CACHED TABLE PUBLIC.PERMISSIONSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);              
ALTER TABLE PUBLIC.PERMISSIONSCHEME ADD CONSTRAINT PUBLIC.PK_PERMISSIONSCHEME PRIMARY KEY(ID); 
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PERMISSIONSCHEME;         
INSERT INTO PUBLIC.PERMISSIONSCHEME(ID, NAME, DESCRIPTION) VALUES
(0, 'Default Permission Scheme', 'This is the default Permission Scheme. Any new projects that are created will be assigned this scheme.');  
CREATE CACHED TABLE PUBLIC.PLUGINSTATE(
    PLUGINKEY VARCHAR NOT NULL,
    PLUGINENABLED VARCHAR
);           
ALTER TABLE PUBLIC.PLUGINSTATE ADD CONSTRAINT PUBLIC.PK_PLUGINSTATE PRIMARY KEY(PLUGINKEY);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PLUGINSTATE;              
CREATE CACHED TABLE PUBLIC.PLUGINVERSION(
    ID BIGINT NOT NULL,
    PLUGINNAME VARCHAR,
    PLUGINKEY VARCHAR,
    PLUGINVERSION VARCHAR,
    CREATED TIMESTAMP
);           
ALTER TABLE PUBLIC.PLUGINVERSION ADD CONSTRAINT PUBLIC.PK_PLUGINVERSION PRIMARY KEY(ID);       
-- 196 +/- SELECT COUNT(*) FROM PUBLIC.PLUGINVERSION;          
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10000, 'ActiveObjects Plugin - OSGi Bundle', 'com.atlassian.activeobjects.activeobjects-plugin', '1.1.1', TIMESTAMP '2015-11-07 02:07:25.923'),
(10001, 'Atlassian Template Renderer API', 'com.atlassian.templaterenderer.api', '2.0.0', TIMESTAMP '2015-11-07 02:07:25.927'),
(10002, 'Atlassian Template Renderer Velocity 1.6 Plugin', 'com.atlassian.templaterenderer.atlassian-template-renderer-velocity1.6-plugin', '2.0.0', TIMESTAMP '2015-11-07 02:07:25.93'),
(10003, 'Atlassian REST - Module Types', 'com.atlassian.plugins.rest.atlassian-rest-module', '3.0.8', TIMESTAMP '2015-11-07 02:07:25.932'),
(10004, 'Atlassian - Administration - Quick Search - JIRA', 'com.atlassian.administration.atlassian-admin-quicksearch-jira', '2.3.1', TIMESTAMP '2015-11-07 02:07:25.963'),
(10005, 'Analytics Client Plugin', 'com.atlassian.analytics.analytics-client', '5.0.3', TIMESTAMP '2015-11-07 02:07:25.992'),
(10006, 'Analytics Whitelist Plugin', 'com.atlassian.analytics.analytics-whitelist', '3.37', TIMESTAMP '2015-11-07 02:07:25.993'),
(10007, 'JSON Library', 'com.atlassian.bundles.json-20070829.0.0.1', '20070829.0.0.1', TIMESTAMP '2015-11-07 02:07:25.993'),
(10008, 'Atlassian OAuth Consumer SPI', 'com.atlassian.oauth.atlassian-oauth-consumer-spi', '2.0.2', TIMESTAMP '2015-11-07 02:07:25.994'),
(10009, 'Atlassian OAuth Service Provider SPI', 'com.atlassian.oauth.atlassian-oauth-service-provider-spi', '2.0.2', TIMESTAMP '2015-11-07 02:07:25.995'),
(10010, 'Applinks Product Plugin', 'com.atlassian.applinks.applinks-plugin', '5.0.3', TIMESTAMP '2015-11-07 02:07:26.092'),
(10011, 'Applinks Basic Auth Product Plugin', 'com.atlassian.applinks.applinks-basicauth-plugin', '5.0.3', TIMESTAMP '2015-11-07 02:07:26.097'),
(10012, 'Applinks CORS Product Plugin', 'com.atlassian.applinks.applinks-cors-plugin', '5.0.3', TIMESTAMP '2015-11-07 02:07:26.102'),
(10013, 'Atlassian JIRA - Plugins - OAuth Consumer SPI', 'com.atlassian.jira.oauth.consumer', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.103'),
(10014, 'Applinks OAuth Product Plugin', 'com.atlassian.applinks.applinks-oauth-plugin', '5.0.3', TIMESTAMP '2015-11-07 02:07:26.128'),
(10015, 'Applinks Trusted Apps Product Plugin', 'com.atlassian.applinks.applinks-trustedapps-plugin', '5.0.3', TIMESTAMP '2015-11-07 02:07:26.136'),
(10016, 'Functional Test Plugin', 'com.atlassian.functest.functest-plugin', '0.7.3', TIMESTAMP '2015-11-07 02:07:26.152'),
(10017, 'Atlassian Docco', 'com.atlassian.atl-docco', '0.11', TIMESTAMP '2015-11-07 02:07:26.154'),
(10018, 'atlassian-failure-cache-plugin', 'com.atlassian.atlassian-failure-cache-plugin', '0.15', TIMESTAMP '2015-11-07 02:07:26.155'),
(10019, 'Atlassian UI Plugin', 'com.atlassian.auiplugin', '5.7.31', TIMESTAMP '2015-11-07 02:07:26.159'),
(10020, 'ICU4J', 'com.atlassian.bundles.icu4j-3.8.0.1', '3.8.0.1', TIMESTAMP '2015-11-07 02:07:26.16'),
(10021, 'Neko HTML', 'com.atlassian.bundles.nekohtml-1.9.12.1', '1.9.12.1', TIMESTAMP '2015-11-07 02:07:26.16'),
(10022, 'Atlassian Embedded Crowd - Administration Plugin', 'com.atlassian.crowd.embedded.admin', '2.0.0-m4', TIMESTAMP '2015-11-07 02:07:26.184'),
(10023, 'Gadget Dashboard Plugin', 'com.atlassian.gadgets.dashboard', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.204'),
(10024, 'ROME, RSS and atOM utilitiEs for Java', 'rome.rome-1.0', '1.0', TIMESTAMP '2015-11-07 02:07:26.205'),
(10025, 'Gadget Directory Plugin', 'com.atlassian.gadgets.directory', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.22'),
(10026, 'Embedded Gadgets Plugin', 'com.atlassian.gadgets.embedded', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.221'),
(10027, 'Atlassian Gadgets OAuth Service Provider Plugin', 'com.atlassian.gadgets.oauth.serviceprovider', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.221'),
(10028, 'Opensocial Plugin', 'com.atlassian.gadgets.opensocial', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.229'),
(10029, 'Gadget Spec Publisher Plugin', 'com.atlassian.gadgets.publisher', '3.11.15', TIMESTAMP '2015-11-07 02:07:26.25'),
(10030, 'Atlassian HealthCheck Common Module', 'com.atlassian.healthcheck.atlassian-healthcheck', '3.0.1', TIMESTAMP '2015-11-07 02:07:26.262');               
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10031, 'Atlassian HTTP Client, Apache HTTP components impl', 'com.atlassian.httpclient.atlassian-httpclient-plugin', '0.22.3', TIMESTAMP '2015-11-07 02:07:26.263'),
(10032, 'Atlassian JIRA - Plugins - Pluggable Avatar Support', 'com.atlassian.jira.jira-pluggable-avatar-support', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.263'),
(10033, 'Atlassian JIRA - Plugins - REST Plugin', 'com.atlassian.jira.rest', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.366'),
(10034, 'JIRA Workflow Designer Plugin', 'com.atlassian.jira.plugins.jira-workflow-designer', '7.0.6', TIMESTAMP '2015-11-07 02:07:26.384'),
(10035, 'JIRA Workflow Sharing Plugin', 'com.atlassian.jira.plugins.workflow.sharing.jira-workflow-sharing-plugin', '2.0.2', TIMESTAMP '2015-11-07 02:07:26.408'),
(10036, 'Project Templates Plugin', 'com.atlassian.jira.project-templates-plugin', '6.0.4', TIMESTAMP '2015-11-07 02:07:26.432'),
(10037, 'Streams API', 'com.atlassian.streams.streams-api-6.0.7', '6.0.7', TIMESTAMP '2015-11-07 02:07:26.438'),
(10038, 'Streams SPI', 'com.atlassian.streams.streams-spi-6.0.7', '6.0.7', TIMESTAMP '2015-11-07 02:07:26.439'),
(10039, 'JIRA Projects Plugin', 'com.atlassian.jira.jira-projects-plugin', '4.0.4', TIMESTAMP '2015-11-07 02:07:26.571'),
(10040, 'jira-importers-plugin', 'com.atlassian.jira.plugins.jira-importers-plugin', '7.1.0', TIMESTAMP '2015-11-07 02:07:26.811'),
(10041, 'JIRA Core Project Templates Plugin', 'com.atlassian.jira-core-project-templates', '6.0.4', TIMESTAMP '2015-11-07 02:07:26.812'),
(10042, 'JIRA Issue Collector Plugin', 'com.atlassian.jira.collector.plugin.jira-issue-collector-plugin', '2.0.8', TIMESTAMP '2015-11-07 02:07:26.834'),
(10043, 'JIRA TestKit - Plugin', 'com.atlassian.jira.tests.jira-testkit-plugin', '7.0.101', TIMESTAMP '2015-11-07 02:07:26.858'),
(10044, 'Atlassian JIRA - Plugins - DevMode - Func Test Plugin', 'com.atlassian.jira.dev.func-test-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.899'),
(10045, 'JIRA iCalendar Plugin', 'com.atlassian.jira.extra.jira-ical-feed', '1.4.5', TIMESTAMP '2015-11-07 02:07:26.92'),
(10046, 'Atlassian Whitelist API Plugin', 'com.atlassian.plugins.atlassian-whitelist-api-plugin', '1.18', TIMESTAMP '2015-11-07 02:07:26.925'),
(10047, 'Atlassian JIRA - Plugins - Gadgets Plugin', 'com.atlassian.jira.gadgets', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.978'),
(10048, 'Atlassian JIRA - Plugins - ActiveObjects SPI', 'com.atlassian.jira.jira-activeobjects-spi-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.979'),
(10049, 'Atlassian JIRA - Plugins - Admin Navigation Component', 'com.atlassian.jira.jira-admin-navigation-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.98'),
(10050, 'Atlassian JIRA - Plugins - Analytics whitelist', 'com.atlassian.jira.jira-analytics-whitelist-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.98'),
(10051, 'Atlassian JIRA - Plugins - Application Properties', 'com.atlassian.jira.jira-application-properties-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.981'),
(10052, 'Atlassian JIRA - Plugins - Avatar Plugin', 'com.atlassian.jira.jira-avatar-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.981'),
(10053, 'JIRA Base URL Plugin', 'com.atlassian.jira.jira-baseurl-plugin', '2.0', TIMESTAMP '2015-11-07 02:07:26.982'),
(10054, 'Atlassian JIRA - Plugins - JIRA Board Plugin', 'com.atlassian.jira.jira-board-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:26.992'),
(10055, 'Atlassian Navigation Links Plugin', 'com.atlassian.plugins.atlassian-nav-links-plugin', '4.2.1', TIMESTAMP '2015-11-07 02:07:27.112'),
(10056, 'Atlassian JIRA - Plugins - Header Plugin', 'com.atlassian.jira.jira-header-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.161'),
(10057, 'Atlassian JIRA - Plugins - Invite User', 'com.atlassian.jira.jira-invite-user-plugin', '2.0.13', TIMESTAMP '2015-11-07 02:07:27.166'),
(10058, 'Atlassian JIRA - Plugins - Common AppLinks Based Issue Link Plugin', 'com.atlassian.jira.jira-issue-link-applinks-common-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.186');               
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10059, 'Atlassian JIRA - Plugins - View Issue Panels', 'com.atlassian.jira.jira-view-issue-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.235'),
(10060, 'Atlassian JIRA - Plugins - Confluence Link', 'com.atlassian.jira.jira-issue-link-confluence-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.259'),
(10061, 'Atlassian JIRA - Plugins - Remote JIRA Link', 'com.atlassian.jira.jira-issue-link-remote-jira-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.275'),
(10062, 'Atlassian JIRA - Plugins - Issue Web Link', 'com.atlassian.jira.jira-issue-link-web-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.276'),
(10063, 'jira-issue-nav-components', 'com.atlassian.jira.jira-issue-nav-components', '8.0.2', TIMESTAMP '2015-11-07 02:07:27.307'),
(10064, 'Atlassian JIRA - Plugins - Global Issue Navigator', 'com.atlassian.jira.jira-issue-nav-plugin', '8.0.2', TIMESTAMP '2015-11-07 02:07:27.327'),
(10065, 'English (Antarctica) Language Pack', 'com.atlassian.jira.jira-languages.en_AQ', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.328'),
(10066, 'English (Moon) Language Pack', 'com.atlassian.jira.jira-languages.en_MOON', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.328'),
(10067, 'English (United Kingdom) Language Pack', 'com.atlassian.jira.jira-languages.en_UK', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.328'),
(10068, 'English (United States) Language Pack', 'com.atlassian.jira.jira-languages.en_US', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.329'),
(10069, 'Atlassian LESS Transformer Plugin', 'com.atlassian.plugins.less-transformer-plugin', '3.0.1', TIMESTAMP '2015-11-07 02:07:27.332'),
(10070, 'Atlassian JIRA - Plugins - LESS integration', 'com.atlassian.jira.jira-less-integration', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.337'),
(10071, 'Atlassian JIRA - Plugins - Mail Plugin', 'com.atlassian.jira.jira-mail-plugin', '9.0.0', TIMESTAMP '2015-11-07 02:07:27.388'),
(10072, 'JIRA Monitoring Plugin', 'com.atlassian.jira.jira-monitoring-plugin', '05.7.0', TIMESTAMP '2015-11-07 02:07:27.419'),
(10073, 'Atlassian JIRA - Plugins - My JIRA Home', 'com.atlassian.jira.jira-my-home-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.421'),
(10074, 'Atlassian JIRA - Plugins - Onboarding', 'com.atlassian.jira.jira-onboarding-assets-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.464'),
(10075, 'Atlassian JIRA - Plugins - Post setup announcements plugin', 'com.atlassian.jira.jira-postsetup-announcements-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.485'),
(10076, 'JIRA Project Config Plugin', 'com.atlassian.jira.jira-project-config-plugin', '8.1.25', TIMESTAMP '2015-11-07 02:07:27.648'),
(10077, 'Atlassian JIRA - Plugins - Project Centric Issue Navigator', 'com.atlassian.jira.jira-projects-issue-navigator', '8.0.2', TIMESTAMP '2015-11-07 02:07:27.663'),
(10078, 'Atlassian JIRA - Plugins - Quick Edit Plugin', 'com.atlassian.jira.jira-quick-edit-plugin', '3.1.4', TIMESTAMP '2015-11-07 02:07:27.68'),
(10079, 'Atlassian JIRA - Plugins - Share Content Component', 'com.atlassian.jira.jira-share-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.7'),
(10080, 'Atlassian JIRA - Plugins - Closure Template Renderer', 'com.atlassian.jira.jira-soy-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.701'),
(10081, 'JIRA Time Zone Detection plugin', 'com.atlassian.jira.jira-tzdetect-plugin', '2.2', TIMESTAMP '2015-11-07 02:07:27.717'),
(10082, 'Atlassian JIRA - Plugins - User Profile Plugin', 'com.atlassian.jira.jira-user-profile-plugin', '3.0.5', TIMESTAMP '2015-11-07 02:07:27.735'),
(10083, 'Atlassian JIRA - Plugins - Look And Feel Logo Upload Plugin', 'com.atlassian.jira.lookandfeel', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.754'),
(10084, 'JIRA Mobile', 'com.atlassian.jira.mobile', '3.0.4', TIMESTAMP '2015-11-07 02:07:27.774'),
(10085, 'Atlassian JIRA - Plugins - OAuth Service Provider SPI', 'com.atlassian.jira.oauth.serviceprovider', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:27.774');               
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10086, 'Comment Panel Plugin', 'com.atlassian.jira.plugin.system.comment-panel', '1.0', TIMESTAMP '2015-11-07 02:07:27.775'),
(10087, 'Custom Field Types & Searchers', 'com.atlassian.jira.plugin.system.customfieldtypes', '1.0', TIMESTAMP '2015-11-07 02:07:27.777'),
(10088, 'Issue Operations Plugin', 'com.atlassian.jira.plugin.system.issueoperations', '1.0', TIMESTAMP '2015-11-07 02:07:27.78'),
(10089, 'Issue Tab Panels Plugin', 'com.atlassian.jira.plugin.system.issuetabpanels', '1.0', TIMESTAMP '2015-11-07 02:07:27.781'),
(10090, 'Renderer Plugin', 'com.atlassian.jira.plugin.system.jirarenderers', '1.0', TIMESTAMP '2015-11-07 02:07:27.781'),
(10091, 'Project Role Actors Plugin', 'com.atlassian.jira.plugin.system.projectroleactors', '1.0', TIMESTAMP '2015-11-07 02:07:27.782'),
(10092, 'Wiki Renderer Macros Plugin', 'com.atlassian.jira.plugin.system.renderers.wiki.macros', '1.0', TIMESTAMP '2015-11-07 02:07:27.834'),
(10093, 'Reports Plugin', 'com.atlassian.jira.plugin.system.reports', '1.0', TIMESTAMP '2015-11-07 02:07:27.835'),
(10094, 'Soy Function Plugin', 'com.atlassian.jira.plugin.system.soyfunction', '1.0', TIMESTAMP '2015-11-07 02:07:27.836'),
(10095, 'Workflow Plugin', 'com.atlassian.jira.plugin.system.workflow', '1.0', TIMESTAMP '2015-11-07 02:07:27.837'),
(10096, 'JIRA Workflow Transition Tabs', 'com.atlassian.jira.plugin.system.workfloweditor.transition.tabs', '1.0', TIMESTAMP '2015-11-07 02:07:27.838'),
(10097, 'Content Link Resolvers Plugin', 'com.atlassian.jira.plugin.wiki.contentlinkresolvers', '1.0', TIMESTAMP '2015-11-07 02:07:27.839'),
(10098, 'Renderer Component Factories Plugin', 'com.atlassian.jira.plugin.wiki.renderercomponentfactories', '1.0', TIMESTAMP '2015-11-07 02:07:27.84'),
(10099, 'scala-2.10-provider-plugin', 'com.atlassian.scala.plugins.scala-2.10-provider-plugin', '0.9', TIMESTAMP '2015-11-07 02:07:27.84'),
(10100, 'jackson-module-scala-2.10-provider', 'com.atlassian.scala.plugins.jackson-module-scala-2.10-provider-plugin', '0.5', TIMESTAMP '2015-11-07 02:07:27.841'),
(10101, 'jira-inline-issue-create-plugin', 'com.atlassian.jira.plugins.inline-create.jira-inline-issue-create-plugin', '1.2.5', TIMESTAMP '2015-11-07 02:07:27.867'),
(10102, 'Atlassian JIRA - Admin Helper Plugin', 'com.atlassian.jira.plugins.jira-admin-helper-plugin', '4.0.3', TIMESTAMP '2015-11-07 02:07:27.9'),
(10103, 'JIRA Auditing Plugin', 'com.atlassian.jira.plugins.jira-auditing-plugin', '1.7.1', TIMESTAMP '2015-11-07 02:07:27.918'),
(10104, 'JIRA browser metrics integration plugin', 'com.atlassian.jira.plugins.jira-browser-metrics', '1.3.0', TIMESTAMP '2015-11-07 02:07:27.919'),
(10105, 'Pocketknife Feature Flags Plugin', 'com.atlassian.pocketknife.featureflags-plugin', '0.5.4', TIMESTAMP '2015-11-07 02:07:27.924'),
(10106, 'JIRA Drag and Drop Attachment Plugin', 'com.atlassian.jira.plugins.jira-dnd-attachment-plugin', '4.2.6', TIMESTAMP '2015-11-07 02:07:27.951'),
(10107, 'Support Healthcheck Plugin', 'com.atlassian.support.healthcheck.support-healthcheck-plugin', '1.0.2', TIMESTAMP '2015-11-07 02:07:27.965'),
(10108, 'Atlassian JIRA - Plugins - Healthcheck Plugin', 'com.atlassian.jira.plugins.jira-healthcheck-plugin', '2.0.3', TIMESTAMP '2015-11-07 02:07:27.969'),
(10109, 'Asana Importers Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-asana-plugin', '1.0.3', TIMESTAMP '2015-11-07 02:07:27.97'),
(10110, 'Bitbucket Importer Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-bitbucket-plugin', '1.0.15', TIMESTAMP '2015-11-07 02:07:27.986'),
(10111, 'JIRA GitHub Issue Importer', 'com.atlassian.jira.plugins.jira-importers-github-plugin', '2.0.10', TIMESTAMP '2015-11-07 02:07:28.002'),
(10112, 'Redmine Importers Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-redmine-plugin', '2.1.5', TIMESTAMP '2015-11-07 02:07:28.003'),
(10113, 'jira-importers-trello-plugin', 'com.atlassian.jira.plugins.jira-importers-trello-plugin', '1.5.1', TIMESTAMP '2015-11-07 02:07:28.004'),
(10114, 'JIRA Password Policy Plugin', 'com.atlassian.jira.plugins.jira-password-policy-plugin', '2.0.2', TIMESTAMP '2015-11-07 02:07:28.007');  
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10115, 'wiki-editor', 'com.atlassian.jira.plugins.jira-wiki-editor', '1.9.4', TIMESTAMP '2015-11-07 02:07:28.008'),
(10116, 'Atlassian WebHooks Plugin', 'com.atlassian.webhooks.atlassian-webhooks-plugin', '3.1.3', TIMESTAMP '2015-11-07 02:07:28.025'),
(10117, 'Atlassian JIRA - Plugins - WebHooks Plugin', 'com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:28.084'),
(10118, 'Wallboard Plugin', 'com.atlassian.jirawallboard.atlassian-wallboard-plugin', '2.1.4', TIMESTAMP '2015-11-07 02:07:28.094'),
(10119, 'Atlassian Bot Session Killer', 'com.atlassian.labs.atlassian-bot-killer', '1.7.9', TIMESTAMP '2015-11-07 02:07:28.095'),
(10120, 'Atlassian Hipchat Integration Plugin Core', 'com.atlassian.plugins.base-hipchat-integration-plugin-api', '7.1.0', TIMESTAMP '2015-11-07 02:07:28.106'),
(10121, 'Atlassian Hipchat Integration Plugin', 'com.atlassian.plugins.base-hipchat-integration-plugin', '7.1.0', TIMESTAMP '2015-11-07 02:07:28.165'),
(10122, 'Project Creation Capability Product REST Plugin', 'com.atlassian.plugins.atlassian-project-creation-plugin', '2.0.4', TIMESTAMP '2015-11-07 02:07:28.197'),
(10123, 'HipChat for JIRA', 'com.atlassian.labs.hipchat.hipchat-for-jira-plugin', '7.1.0', TIMESTAMP '2015-11-07 02:07:28.268'),
(10124, 'Quick Reload - Stealing time back from Maven since 2013. Just press up arrow!', 'com.atlassian.labs.plugins.quickreload.reloader', '1.14', TIMESTAMP '2015-11-07 02:07:28.284'),
(10125, 'Workbox - Common Plugin', 'com.atlassian.mywork.mywork-common-plugin', '3.0.0-pluginsfour002', TIMESTAMP '2015-11-07 02:07:28.308'),
(10126, 'Workbox - JIRA Provider Plugin', 'com.atlassian.mywork.mywork-jira-provider-plugin', '3.0.0-pluginsfour002', TIMESTAMP '2015-11-07 02:07:28.31'),
(10127, 'Atlassian OAuth Admin Plugin', 'com.atlassian.oauth.admin', '2.0.2', TIMESTAMP '2015-11-07 02:07:28.31'),
(10128, 'Atlassian OAuth Consumer Plugin', 'com.atlassian.oauth.consumer', '2.0.2', TIMESTAMP '2015-11-07 02:07:28.311'),
(10129, 'Atlassian OAuth Service Provider Plugin', 'com.atlassian.oauth.serviceprovider', '2.0.2', TIMESTAMP '2015-11-07 02:07:28.317'),
(10130, 'Apache Commons FileUpload', 'org.apache.commons.fileupload-1.3.1', '1.3.1', TIMESTAMP '2015-11-07 02:07:28.317'),
(10131, 'Atlassian PDK Install Plugin', 'com.atlassian.pdkinstall', '0.7', TIMESTAMP '2015-11-07 02:07:28.319'),
(10132, 'Atlassian Plugins - JavaScript libraries', 'com.atlassian.plugin.jslibs', '0.5.0', TIMESTAMP '2015-11-07 02:07:28.32'),
(10133, 'Atlassian Awareness Capability', 'com.atlassian.plugins.atlassian-awareness-capability', '0.0.6', TIMESTAMP '2015-11-07 02:07:28.338'),
(10134, 'Atlassian Plugins - Web Resources - Implementation Plugin', 'com.atlassian.plugins.atlassian-plugins-webresource-plugin', '3.5-JIRA-CTCDN-1-d31498b', TIMESTAMP '2015-11-07 02:07:28.339'),
(10135, 'Atlassian Plugins - Web Resources REST', 'com.atlassian.plugins.atlassian-plugins-webresource-rest', '3.5-JIRA-CTCDN-1-d31498b', TIMESTAMP '2015-11-07 02:07:28.355'),
(10136, 'Atlassian Remote Event Common Plugin', 'com.atlassian.plugins.atlassian-remote-event-common-plugin', '1.0.5', TIMESTAMP '2015-11-07 02:07:28.37'),
(10137, 'Atlassian Remote Event Consumer Plugin', 'com.atlassian.plugins.atlassian-remote-event-consumer-plugin', '1.0.5', TIMESTAMP '2015-11-07 02:07:28.385'),
(10138, 'Atlassian Whitelist UI Plugin', 'com.atlassian.plugins.atlassian-whitelist-ui-plugin', '1.18', TIMESTAMP '2015-11-07 02:07:28.402'),
(10139, 'Atlassian Plugins - Avatar Plugin', 'com.atlassian.plugins.avatar', '1.3.2', TIMESTAMP '2015-11-07 02:07:28.403'),
(10140, 'Atlassian browser metrics plugin', 'com.atlassian.plugins.browser.metrics.browser-metrics-plugin', '1.64', TIMESTAMP '2015-11-07 02:07:28.404'),
(10141, 'jira-help-tips', 'com.atlassian.plugins.helptips.jira-help-tips', '1.0.4', TIMESTAMP '2015-11-07 02:07:28.42'),
(10142, 'Issue Status Plugin', 'com.atlassian.plugins.issue-status-plugin', '1.1.7', TIMESTAMP '2015-11-07 02:07:28.421');       
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10143, 'Attach Image for JIRA', 'com.atlassian.plugins.jira-html5-attach-images', '4.0.0', TIMESTAMP '2015-11-07 02:07:28.421'),
(10144, 'Project Creation Plugin SPI for JIRA', 'com.atlassian.plugins.jira-project-creation', '2.0.4', TIMESTAMP '2015-11-07 02:07:28.422'),
(10145, 'Remote Link Aggregator Plugin', 'com.atlassian.plugins.remote-link-aggregator-plugin', '2.0.14', TIMESTAMP '2015-11-07 02:07:28.436'),
(10146, 'JIRA Remote Link Aggregator Plugin', 'com.atlassian.plugins.jira-remote-link-aggregator-plugin', '2.0.14', TIMESTAMP '2015-11-07 02:07:28.437'),
(10147, 'jquery', 'com.atlassian.plugins.jquery', '1.7.2', TIMESTAMP '2015-11-07 02:07:28.438'),
(10148, 'Atlassian Pretty URLs Plugin', 'com.atlassian.prettyurls.atlassian-pretty-urls-plugin', '2.0.0', TIMESTAMP '2015-11-07 02:07:28.439'),
(10149, 'Atlassian QUnit Plugin', 'com.atlassian.qunit.atlassian-qunit-plugin', '1.0.3', TIMESTAMP '2015-11-07 02:07:28.441'),
(10150, 'Platform Compatibility Testing Kit Plugin', 'com.atlassian.refapp.ctk', '3.0.3', TIMESTAMP '2015-11-07 02:07:28.462'),
(10151, 'Atlassian JIRA - Plugins - SAL Plugin', 'com.atlassian.sal.jira', '7.1.0-SNAPSHOT', TIMESTAMP '2015-11-07 02:07:28.464'),
(10152, 'scala-2.11-provider-plugin', 'com.atlassian.scala.plugins.scala-2.11-provider-plugin', '0.10', TIMESTAMP '2015-11-07 02:07:28.465'),
(10153, 'Atlassian Soy - Plugin', 'com.atlassian.soy.soy-template-plugin', '4.1.3', TIMESTAMP '2015-11-07 02:07:28.47'),
(10154, 'Streams Plugin', 'com.atlassian.streams', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.498'),
(10155, 'Streams Inline Actions Plugin', 'com.atlassian.streams.actions', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.499'),
(10156, 'Streams Core Plugin', 'com.atlassian.streams.core', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.5'),
(10157, 'JIRA Streams Inline Actions Plugin', 'com.atlassian.streams.jira.inlineactions', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.501'),
(10158, 'JIRA Activity Stream Plugin', 'com.atlassian.streams.streams-jira-plugin', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.544'),
(10159, 'Streams Third Party Provider Plugin', 'com.atlassian.streams.streams-thirdparty-plugin', '6.0.7', TIMESTAMP '2015-11-07 02:07:28.562'),
(10160, 'Support Tools Plugin', 'com.atlassian.support.stp', '3.5.38', TIMESTAMP '2015-11-07 02:07:28.613'),
(10161, 'Universal Plugin Manager - Role-Based Licensing Implementation Plugin', 'com.atlassian.upm.role-based-licensing-plugin', '2.20.3', TIMESTAMP '2015-11-07 02:07:28.616'),
(10162, 'Atlassian Universal Plugin Manager Plugin', 'com.atlassian.upm.atlassian-universal-plugin-manager-plugin', '2.20.3', TIMESTAMP '2015-11-07 02:07:28.667'),
(10163, 'Atlassian Application Manager plugin', 'com.atlassian.upm.upm-application-plugin', '2.20.3', TIMESTAMP '2015-11-07 02:07:28.687'),
(10164, 'ROME: RSS/Atom syndication and publishing tools', 'com.springsource.com.sun.syndication-0.9.0', '0.9.0', TIMESTAMP '2015-11-07 02:07:28.687'),
(10165, 'JDOM DOM Processor', 'com.springsource.org.jdom-1.0.0', '1.0.0', TIMESTAMP '2015-11-07 02:07:28.688'),
(10166, 'Crowd REST API', 'crowd-rest-application-management', '1.0', TIMESTAMP '2015-11-07 02:07:28.725'),
(10167, 'Crowd REST API', 'crowd-rest-plugin', '1.0', TIMESTAMP '2015-11-07 02:07:28.747'),
(10168, 'Crowd System Password Encoders', 'crowd.system.passwordencoders', '1.0', TIMESTAMP '2015-11-07 02:07:28.749'),
(10169, 'JIRA Feature Keys', 'jira.feature.keys', '1.0', TIMESTAMP '2015-11-07 02:07:28.75'),
(10170, 'JIRA Footer', 'jira.footer', '1.0', TIMESTAMP '2015-11-07 02:07:28.75'),
(10171, 'Help Paths Plugin', 'jira.help.paths', '1.0', TIMESTAMP '2015-11-07 02:07:28.75'),
(10172, 'Issue Views Plugin', 'jira.issueviews', '1.0', TIMESTAMP '2015-11-07 02:07:28.751'),
(10173, 'JQL Functions', 'jira.jql.function', '1.0', TIMESTAMP '2015-11-07 02:07:28.753'),
(10174, 'Keyboard Shortcuts Plugin', 'jira.keyboard.shortcuts', '1.0', TIMESTAMP '2015-11-07 02:07:28.756'),
(10175, 'JIRA Attachment Archive File Processors', 'jira.system.attachment.processors', '1.0', TIMESTAMP '2015-11-07 02:07:28.757'); 
INSERT INTO PUBLIC.PLUGINVERSION(ID, PLUGINNAME, PLUGINKEY, PLUGINVERSION, CREATED) VALUES
(10176, 'JIRA Global Permissions', 'jira.system.global.permissions', '1.0', TIMESTAMP '2015-11-07 02:07:28.757'),
(10177, 'JIRA Project Permissions', 'jira.system.project.permissions', '1.0', TIMESTAMP '2015-11-07 02:07:28.758'),
(10178, 'Top Navigation Bar', 'jira.top.navigation.bar', '1.0', TIMESTAMP '2015-11-07 02:07:28.763'),
(10179, 'JIRA Usage Hints', 'jira.usage.hints', '1.0', TIMESTAMP '2015-11-07 02:07:28.764'),
(10180, 'User Format', 'jira.user.format', '1.0', TIMESTAMP '2015-11-07 02:07:28.773'),
(10181, 'User Profile Panels', 'jira.user.profile.panels', '1.0', TIMESTAMP '2015-11-07 02:07:28.775'),
(10182, 'Admin Menu Sections', 'jira.webfragments.admin', '1.0', TIMESTAMP '2015-11-07 02:07:28.794'),
(10183, 'Browse Project Operations Sections', 'jira.webfragments.browse.project.links', '1.0', TIMESTAMP '2015-11-07 02:07:28.795'),
(10184, 'Preset Filters Sections', 'jira.webfragments.preset.filters', '1.0', TIMESTAMP '2015-11-07 02:07:28.797'),
(10185, 'User Navigation Bar Sections', 'jira.webfragments.user.navigation.bar', '1.0', TIMESTAMP '2015-11-07 02:07:28.8'),
(10186, 'User Profile Links', 'jira.webfragments.user.profile.links', '1.0', TIMESTAMP '2015-11-07 02:07:28.801'),
(10187, 'View Project Operations Sections', 'jira.webfragments.view.project.operations', '1.0', TIMESTAMP '2015-11-07 02:07:28.802'),
(10188, 'Web Panel Plugin', 'jira.webpanels', '1.0', TIMESTAMP '2015-11-07 02:07:28.804'),
(10189, 'Web Resources Plugin', 'jira.webresources', '1.0', TIMESTAMP '2015-11-07 02:07:28.818'),
(10190, 'Apache HttpClient OSGi bundle', 'org.apache.httpcomponents.httpclient-4.2.5', '4.2.5', TIMESTAMP '2015-11-07 02:07:28.82'),
(10191, 'Apache HttpCore OSGi bundle', 'org.apache.httpcomponents.httpcore-4.2.4', '4.2.4', TIMESTAMP '2015-11-07 02:07:28.821'),
(10192, 'JIRA Core German (Germany) Language Pack', 'tac.jira core.languages.de_DE', '7.0.0-v2r18-2015-10-15', TIMESTAMP '2015-11-07 02:07:28.821'),
(10193, 'JIRA Core Spanish (Spain) Language Pack', 'tac.jira core.languages.es_ES', '7.0.0-v2r15-2015-10-28', TIMESTAMP '2015-11-07 02:07:28.822'),
(10194, 'JIRA Core French (France) Language Pack', 'tac.jira core.languages.fr_FR', '7.0.0-v2r38-2015-10-15', TIMESTAMP '2015-11-07 02:07:28.822'),
(10195, 'JIRA Core Japanese (Japan) Language Pack', 'tac.jira core.languages.ja_JP', '7.0.0-v2r11-2015-10-15', TIMESTAMP '2015-11-07 02:07:28.823'); 
CREATE CACHED TABLE PUBLIC.PORTALPAGE(
    ID BIGINT NOT NULL,
    USERNAME VARCHAR,
    PAGENAME VARCHAR,
    DESCRIPTION VARCHAR,
    SEQUENCE BIGINT,
    FAV_COUNT BIGINT,
    LAYOUT VARCHAR,
    PPVERSION BIGINT
);     
ALTER TABLE PUBLIC.PORTALPAGE ADD CONSTRAINT PUBLIC.PK_PORTALPAGE PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PORTALPAGE;               
INSERT INTO PUBLIC.PORTALPAGE(ID, USERNAME, PAGENAME, DESCRIPTION, SEQUENCE, FAV_COUNT, LAYOUT, PPVERSION) VALUES
(10000, NULL, 'System Dashboard', NULL, 0, 0, 'AA', 0);      
CREATE INDEX PUBLIC.PPAGE_USERNAME ON PUBLIC.PORTALPAGE(USERNAME);             
CREATE CACHED TABLE PUBLIC.PORTLETCONFIGURATION(
    ID BIGINT NOT NULL,
    PORTALPAGE BIGINT,
    PORTLET_ID VARCHAR,
    COLUMN_NUMBER INTEGER,
    POSITIONSEQ INTEGER,
    GADGET_XML VARCHAR,
    COLOR VARCHAR,
    DASHBOARD_MODULE_COMPLETE_KEY VARCHAR
);            
ALTER TABLE PUBLIC.PORTLETCONFIGURATION ADD CONSTRAINT PUBLIC.PK_PORTLETCONFIGURATION PRIMARY KEY(ID);         
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.PORTLETCONFIGURATION;     
INSERT INTO PUBLIC.PORTLETCONFIGURATION(ID, PORTALPAGE, PORTLET_ID, COLUMN_NUMBER, POSITIONSEQ, GADGET_XML, COLOR, DASHBOARD_MODULE_COMPLETE_KEY) VALUES
(10000, 10000, NULL, 0, 0, NULL, NULL, 'com.atlassian.jira.gadgets:introduction-dashboard-item'),
(10002, 10000, NULL, 1, 0, 'rest/gadgets/1.0/g/com.atlassian.jira.gadgets:assigned-to-me-gadget/gadgets/assigned-to-me-gadget.xml', NULL, NULL),
(10003, 10000, NULL, 1, 1, 'rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml', NULL, NULL);    
CREATE CACHED TABLE PUBLIC.PRIORITY(
    ID VARCHAR NOT NULL,
    SEQUENCE BIGINT,
    PNAME VARCHAR,
    DESCRIPTION VARCHAR,
    ICONURL VARCHAR,
    STATUS_COLOR VARCHAR
);
ALTER TABLE PUBLIC.PRIORITY ADD CONSTRAINT PUBLIC.PK_PRIORITY PRIMARY KEY(ID); 
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.PRIORITY; 
INSERT INTO PUBLIC.PRIORITY(ID, SEQUENCE, PNAME, DESCRIPTION, ICONURL, STATUS_COLOR) VALUES
('1', 1, 'Highest', 'This problem will block progress.', '/images/icons/priorities/highest.png', '#d04437'),
('2', 2, 'High', 'Serious problem that could block progress.', '/images/icons/priorities/high.png', '#f15C75'),
('3', 3, 'Medium', 'Has the potential to affect progress.', '/images/icons/priorities/medium.png', '#f79232'),
('4', 4, 'Low', 'Minor problem or easily worked around.', '/images/icons/priorities/low.png', '#707070'),
('5', 5, 'Lowest', 'Trivial problem with little or no impact on progress.', '/images/icons/priorities/lowest.png', '#999999');               
CREATE CACHED TABLE PUBLIC.PRODUCTLICENSE(
    ID BIGINT NOT NULL,
    LICENSE VARCHAR
);      
ALTER TABLE PUBLIC.PRODUCTLICENSE ADD CONSTRAINT PUBLIC.PK_PRODUCTLICENSE PRIMARY KEY(ID);     
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PRODUCTLICENSE;           
INSERT INTO PUBLIC.PRODUCTLICENSE(ID, LICENSE) VALUES
(10000, 'AAACdA0ODAoPeNqNVF1Po0AUfedXTLJvJiDQta0mJFthtHVtaSg06roPU7i2048ZMjOg+Ot3pBjrtnX3gYe53+ece/kWLwo0gRy5XWS3L1znouWi62GMXNttGRMQJYhB4F3iDja/Bw+u2Q5vOuZ167xr3NIUmIS4ymFENuAFeIpvwzGOjAkeefozz2zbmAsAtuB5DsI6ntF48EtORRUQBd7Yce2+saSCWLngWZEq6+1hplyARVJFS/CUKGAbsmsYFZsZiPApkSCkZzpGADIVNFeUM+9mEPVQBiWsuZ5IovW2MXriAimQirK50dim2v+W4hq4JOuC1Pl1hwOYcEZrPx7FOBpHgwk2hoQyBYywdB+XL6CuV5tc2zkzHde0XePk5MSPcC/GgXl5rx8emTNKsle6OkCF5E/qmWg69hCnfGMRtSZSUsIsbS31lBnI1RcSrKB6R+y0bbtjd1stx/A5U5pcrMGsPfpKGS8plD8+iutWx1TaG6uOO07Y56nfiy5BFyUiXdBSi2NlqcXZuvJmVa4DD7Gyg3Z3LRpV+0QuvKFv+1dXA+fl/nypHlhyJ9rzolf8jEUnylv+tLdIekvo3A39aWU/JNfOzX06I3ZfyqKfJ4NH7ys1dptqCUdhbF6FkTmOwiDx40E4MpMJftO2XgLI0KxCagGoIQZhlvIMBGqwo18LpfLHi9PTObc+8X7aQDJhm/HbQgFHjCuUUakEnRUKdGUqkeIoLaTiGy2E9dXsx9cjFHPCqCT/fUWTYvZxdntns0tS01T/ZhK2YvyZ/UPVw3t1NPw4pnGh14pI+PsK63raSHzQFyy2UzaXUJc4dgh/AHf43bgwLQIUZF/5iI54Fnrg4g9kWaCU+u6P6n8CFQCPfk1v9DFsq4TYuyAjyNYvEFo4ww==X02t9
');
CREATE CACHED TABLE PUBLIC.PROJECT(
    ID BIGINT NOT NULL,
    PNAME VARCHAR,
    URL VARCHAR,
    LEAD VARCHAR,
    DESCRIPTION VARCHAR,
    PKEY VARCHAR,
    PCOUNTER BIGINT,
    ASSIGNEETYPE BIGINT,
    AVATAR BIGINT,
    ORIGINALKEY VARCHAR,
    PROJECTTYPE VARCHAR
);              
ALTER TABLE PUBLIC.PROJECT ADD CONSTRAINT PUBLIC.PK_PROJECT PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROJECT;  
CREATE UNIQUE INDEX PUBLIC.IDX_PROJECT_KEY ON PUBLIC.PROJECT(PKEY);            
CREATE CACHED TABLE PUBLIC.PROJECTCATEGORY(
    ID BIGINT NOT NULL,
    CNAME VARCHAR,
    DESCRIPTION VARCHAR
);              
ALTER TABLE PUBLIC.PROJECTCATEGORY ADD CONSTRAINT PUBLIC.PK_PROJECTCATEGORY PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROJECTCATEGORY;          
CREATE INDEX PUBLIC.IDX_PROJECT_CATEGORY_NAME ON PUBLIC.PROJECTCATEGORY(CNAME);
CREATE CACHED TABLE PUBLIC.PROJECT_KEY(
    ID BIGINT NOT NULL,
    PROJECT_ID BIGINT,
    PROJECT_KEY VARCHAR
);              
ALTER TABLE PUBLIC.PROJECT_KEY ADD CONSTRAINT PUBLIC.PK_PROJECT_KEY PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROJECT_KEY;              
CREATE UNIQUE INDEX PUBLIC.IDX_ALL_PROJECT_KEYS ON PUBLIC.PROJECT_KEY(PROJECT_KEY);            
CREATE INDEX PUBLIC.IDX_ALL_PROJECT_IDS ON PUBLIC.PROJECT_KEY(PROJECT_ID);     
CREATE CACHED TABLE PUBLIC.PROJECTROLE(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);   
ALTER TABLE PUBLIC.PROJECTROLE ADD CONSTRAINT PUBLIC.PK_PROJECTROLE PRIMARY KEY(ID);           
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PROJECTROLE;              
INSERT INTO PUBLIC.PROJECTROLE(ID, NAME, DESCRIPTION) VALUES
(10002, 'Administrators', 'A project role that represents administrators in a project');          
CREATE CACHED TABLE PUBLIC.PROJECTROLEACTOR(
    ID BIGINT NOT NULL,
    PID BIGINT,
    PROJECTROLEID BIGINT,
    ROLETYPE VARCHAR,
    ROLETYPEPARAMETER VARCHAR
);          
ALTER TABLE PUBLIC.PROJECTROLEACTOR ADD CONSTRAINT PUBLIC.PK_PROJECTROLEACTOR PRIMARY KEY(ID); 
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PROJECTROLEACTOR;         
INSERT INTO PUBLIC.PROJECTROLEACTOR(ID, PID, PROJECTROLEID, ROLETYPE, ROLETYPEPARAMETER) VALUES
(10002, NULL, 10002, 'atlassian-group-role-actor', 'jira-administrators');     
CREATE INDEX PUBLIC.ROLE_PLAYER_IDX ON PUBLIC.PROJECTROLEACTOR(PROJECTROLEID, PID);            
CREATE CACHED TABLE PUBLIC.QRTZ_CALENDARS(
    ID BIGINT,
    CALENDAR_NAME VARCHAR NOT NULL,
    CALENDAR VARCHAR
);          
ALTER TABLE PUBLIC.QRTZ_CALENDARS ADD CONSTRAINT PUBLIC.PK_QRTZ_CALENDARS PRIMARY KEY(CALENDAR_NAME);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CALENDARS;           
CREATE CACHED TABLE PUBLIC.QRTZ_CRON_TRIGGERS(
    ID BIGINT NOT NULL,
    TRIGGER_ID BIGINT,
    CRONEXPERSSION VARCHAR
);    
ALTER TABLE PUBLIC.QRTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_CRON_TRIGGERS PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CRON_TRIGGERS;       
CREATE CACHED TABLE PUBLIC.QRTZ_FIRED_TRIGGERS(
    ID BIGINT,
    ENTRY_ID VARCHAR NOT NULL,
    TRIGGER_ID BIGINT,
    TRIGGER_LISTENER VARCHAR,
    FIRED_TIME TIMESTAMP,
    TRIGGER_STATE VARCHAR
);      
ALTER TABLE PUBLIC.QRTZ_FIRED_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY(ENTRY_ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_FIRED_TRIGGERS;      
CREATE CACHED TABLE PUBLIC.QRTZ_JOB_DETAILS(
    ID BIGINT NOT NULL,
    JOB_NAME VARCHAR,
    JOB_GROUP VARCHAR,
    CLASS_NAME VARCHAR,
    IS_DURABLE VARCHAR,
    IS_STATEFUL VARCHAR,
    REQUESTS_RECOVERY VARCHAR,
    JOB_DATA VARCHAR
);              
ALTER TABLE PUBLIC.QRTZ_JOB_DETAILS ADD CONSTRAINT PUBLIC.PK_QRTZ_JOB_DETAILS PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_JOB_DETAILS;         
CREATE CACHED TABLE PUBLIC.QRTZ_JOB_LISTENERS(
    ID BIGINT NOT NULL,
    JOB BIGINT,
    JOB_LISTENER VARCHAR
);             
ALTER TABLE PUBLIC.QRTZ_JOB_LISTENERS ADD CONSTRAINT PUBLIC.PK_QRTZ_JOB_LISTENERS PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_JOB_LISTENERS;       
CREATE CACHED TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS(
    ID BIGINT NOT NULL,
    TRIGGER_ID BIGINT,
    REPEAT_COUNT INTEGER,
    REPEAT_INTERVAL BIGINT,
    TIMES_TRIGGERED INTEGER
);           
ALTER TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPLE_TRIGGERS;     
CREATE CACHED TABLE PUBLIC.QRTZ_TRIGGER_LISTENERS(
    ID BIGINT NOT NULL,
    TRIGGER_ID BIGINT,
    TRIGGER_LISTENER VARCHAR
);              
ALTER TABLE PUBLIC.QRTZ_TRIGGER_LISTENERS ADD CONSTRAINT PUBLIC.PK_QRTZ_TRIGGER_LISTENERS PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_TRIGGER_LISTENERS;   
CREATE CACHED TABLE PUBLIC.QRTZ_TRIGGERS(
    ID BIGINT NOT NULL,
    TRIGGER_NAME VARCHAR,
    TRIGGER_GROUP VARCHAR,
    JOB BIGINT,
    NEXT_FIRE TIMESTAMP,
    TRIGGER_STATE VARCHAR,
    TRIGGER_TYPE VARCHAR,
    START_TIME TIMESTAMP,
    END_TIME TIMESTAMP,
    CALENDAR_NAME VARCHAR,
    MISFIRE_INSTR INTEGER
); 
ALTER TABLE PUBLIC.QRTZ_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_TRIGGERS PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_TRIGGERS;            
CREATE CACHED TABLE PUBLIC.REINDEX_COMPONENT(
    ID BIGINT NOT NULL,
    REQUEST_ID BIGINT,
    AFFECTED_INDEX VARCHAR,
    ENTITY_TYPE VARCHAR
);            
ALTER TABLE PUBLIC.REINDEX_COMPONENT ADD CONSTRAINT PUBLIC.PK_REINDEX_COMPONENT PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REINDEX_COMPONENT;        
CREATE INDEX PUBLIC.IDX_REINDEX_COMPONENT_REQ_ID ON PUBLIC.REINDEX_COMPONENT(REQUEST_ID);      
CREATE CACHED TABLE PUBLIC.REINDEX_REQUEST(
    ID BIGINT NOT NULL,
    TYPE VARCHAR,
    REQUEST_TIME TIMESTAMP,
    START_TIME TIMESTAMP,
    COMPLETION_TIME TIMESTAMP,
    STATUS VARCHAR,
    EXECUTION_NODE_ID VARCHAR
);
ALTER TABLE PUBLIC.REINDEX_REQUEST ADD CONSTRAINT PUBLIC.PK_REINDEX_REQUEST PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REINDEX_REQUEST;          
CREATE CACHED TABLE PUBLIC.REMEMBERMETOKEN(
    ID BIGINT NOT NULL,
    CREATED TIMESTAMP,
    TOKEN VARCHAR,
    USERNAME VARCHAR
);          
ALTER TABLE PUBLIC.REMEMBERMETOKEN ADD CONSTRAINT PUBLIC.PK_REMEMBERMETOKEN PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REMEMBERMETOKEN;          
CREATE INDEX PUBLIC.REMEMBERMETOKEN_USERNAME_INDEX ON PUBLIC.REMEMBERMETOKEN(USERNAME);        
CREATE CACHED TABLE PUBLIC.CWD_APPLICATION_ADDRESS(
    APPLICATION_ID BIGINT NOT NULL,
    REMOTE_ADDRESS VARCHAR NOT NULL,
    ENCODED_ADDRESS_BINARY VARCHAR,
    REMOTE_ADDRESS_MASK INTEGER
);            
ALTER TABLE PUBLIC.CWD_APPLICATION_ADDRESS ADD CONSTRAINT PUBLIC.PK_CWD_APPLICATION_ADDRESS PRIMARY KEY(APPLICATION_ID, REMOTE_ADDRESS);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CWD_APPLICATION_ADDRESS;  
CREATE CACHED TABLE PUBLIC.REMOTELINK(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    GLOBALID VARCHAR,
    TITLE VARCHAR,
    SUMMARY VARCHAR,
    URL VARCHAR,
    ICONURL VARCHAR,
    ICONTITLE VARCHAR,
    RELATIONSHIP VARCHAR,
    RESOLVED CHAR(1),
    STATUSNAME VARCHAR,
    STATUSDESCRIPTION VARCHAR,
    STATUSICONURL VARCHAR,
    STATUSICONTITLE VARCHAR,
    STATUSICONLINK VARCHAR,
    STATUSCATEGORYKEY VARCHAR,
    STATUSCATEGORYCOLORNAME VARCHAR,
    APPLICATIONTYPE VARCHAR,
    APPLICATIONNAME VARCHAR
);       
ALTER TABLE PUBLIC.REMOTELINK ADD CONSTRAINT PUBLIC.PK_REMOTELINK PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REMOTELINK;               
CREATE INDEX PUBLIC.REMOTELINK_ISSUEID ON PUBLIC.REMOTELINK(ISSUEID, GLOBALID);
CREATE INDEX PUBLIC.REMOTELINK_GLOBALID ON PUBLIC.REMOTELINK(GLOBALID);        
CREATE CACHED TABLE PUBLIC.REPLICATEDINDEXOPERATION(
    ID BIGINT NOT NULL,
    INDEX_TIME TIMESTAMP,
    NODE_ID VARCHAR,
    AFFECTED_INDEX VARCHAR,
    ENTITY_TYPE VARCHAR,
    AFFECTED_IDS VARCHAR,
    OPERATION VARCHAR,
    FILENAME VARCHAR
);      
ALTER TABLE PUBLIC.REPLICATEDINDEXOPERATION ADD CONSTRAINT PUBLIC.PK_REPLICATEDINDEXOPERATION PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REPLICATEDINDEXOPERATION; 
CREATE INDEX PUBLIC.NODE_OPERATION_IDX ON PUBLIC.REPLICATEDINDEXOPERATION(NODE_ID, AFFECTED_INDEX, OPERATION, INDEX_TIME);     
CREATE CACHED TABLE PUBLIC.RESOLUTION(
    ID VARCHAR NOT NULL,
    SEQUENCE BIGINT,
    PNAME VARCHAR,
    DESCRIPTION VARCHAR,
    ICONURL VARCHAR
);        
ALTER TABLE PUBLIC.RESOLUTION ADD CONSTRAINT PUBLIC.PK_RESOLUTION PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.RESOLUTION;               
CREATE CACHED TABLE PUBLIC.RUNDETAILS(
    ID BIGINT NOT NULL,
    JOB_ID VARCHAR,
    START_TIME TIMESTAMP,
    RUN_DURATION BIGINT,
    RUN_OUTCOME CHAR(1),
    INFO_MESSAGE VARCHAR
);     
ALTER TABLE PUBLIC.RUNDETAILS ADD CONSTRAINT PUBLIC.PK_RUNDETAILS PRIMARY KEY(ID);             
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.RUNDETAILS;               
INSERT INTO PUBLIC.RUNDETAILS(ID, JOB_ID, START_TIME, RUN_DURATION, RUN_OUTCOME, INFO_MESSAGE) VALUES
(10001, 'com.atlassian.jira.service.JiraService:10001', TIMESTAMP '2015-11-07 02:06:27.35', 384, 'S', ''),
(10002, 'com.atlassian.jira.user.UserHistoryDatabaseCompactor', TIMESTAMP '2015-11-07 02:07:29.18', 1, 'S', ''),
(10003, 'com.atlassian.jira.cache.monitor.CacheStatisticsMonitor', TIMESTAMP '2015-11-07 02:07:29.18', 6, 'S', ''),
(10005, 'CompatibilityPluginScheduler.JobId.BundledUpdateCheckJob-job', TIMESTAMP '2015-11-07 02:08:00.352', 4, 'S', ''),
(10006, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', TIMESTAMP '2015-11-07 02:08:00.357', 21, 'S', ''),
(10007, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', TIMESTAMP '2015-11-07 02:08:00.354', 37, 'S', ''),
(10008, 'JiraPluginScheduler:com.atlassian.analytics.client.upload.RemoteFilterRead:job', TIMESTAMP '2015-11-07 02:08:08.876', 2658, 'S', ''),
(10009, 'com.atlassian.jira.service.JiraService:10000', TIMESTAMP '2015-11-07 02:09:00.0', 0, 'S', '');       
CREATE INDEX PUBLIC.RUNDETAILS_JOBID_IDX ON PUBLIC.RUNDETAILS(JOB_ID);         
CREATE INDEX PUBLIC.RUNDETAILS_STARTTIME_IDX ON PUBLIC.RUNDETAILS(START_TIME); 
CREATE CACHED TABLE PUBLIC.SCHEMEISSUESECURITIES(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    SECURITY BIGINT,
    SEC_TYPE VARCHAR,
    SEC_PARAMETER VARCHAR
);           
ALTER TABLE PUBLIC.SCHEMEISSUESECURITIES ADD CONSTRAINT PUBLIC.PK_SCHEMEISSUESECURITIES PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SCHEMEISSUESECURITIES;    
CREATE INDEX PUBLIC.SEC_SCHEME ON PUBLIC.SCHEMEISSUESECURITIES(SCHEME);        
CREATE INDEX PUBLIC.SEC_SECURITY ON PUBLIC.SCHEMEISSUESECURITIES(SECURITY);    
CREATE CACHED TABLE PUBLIC.SCHEMEISSUESECURITYLEVELS(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR,
    SCHEME BIGINT
);  
ALTER TABLE PUBLIC.SCHEMEISSUESECURITYLEVELS ADD CONSTRAINT PUBLIC.PK_SCHEMEISSUESECURITYLEVELS PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SCHEMEISSUESECURITYLEVELS;
CREATE CACHED TABLE PUBLIC.SCHEMEPERMISSIONS(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    PERMISSION BIGINT,
    PERM_TYPE VARCHAR,
    PERM_PARAMETER VARCHAR,
    PERMISSION_KEY VARCHAR
);               
ALTER TABLE PUBLIC.SCHEMEPERMISSIONS ADD CONSTRAINT PUBLIC.PK_SCHEMEPERMISSIONS PRIMARY KEY(ID);               
-- 33 +/- SELECT COUNT(*) FROM PUBLIC.SCHEMEPERMISSIONS;       
INSERT INTO PUBLIC.SCHEMEPERMISSIONS(ID, SCHEME, PERMISSION, PERM_TYPE, PERM_PARAMETER, PERMISSION_KEY) VALUES
(10000, NULL, 0, 'group', 'jira-administrators', NULL),
(10004, 0, 23, 'projectrole', '10002', 'ADMINISTER_PROJECTS'),
(10005, 0, 10, 'applicationRole', '', 'BROWSE_PROJECTS'),
(10006, 0, 11, 'applicationRole', '', 'CREATE_ISSUES'),
(10007, 0, 15, 'applicationRole', '', 'ADD_COMMENTS'),
(10008, 0, 19, 'applicationRole', '', 'CREATE_ATTACHMENTS'),
(10009, 0, 13, 'applicationRole', '', 'ASSIGN_ISSUES'),
(10010, 0, 17, 'applicationRole', '', 'ASSIGNABLE_USER'),
(10011, 0, 14, 'applicationRole', '', 'RESOLVE_ISSUES'),
(10012, 0, 21, 'applicationRole', '', 'LINK_ISSUES'),
(10013, 0, 12, 'applicationRole', '', 'EDIT_ISSUES'),
(10014, 0, 16, 'projectrole', '10002', 'DELETE_ISSUES'),
(10015, 0, 18, 'applicationRole', '', 'CLOSE_ISSUES'),
(10016, 0, 25, 'applicationRole', '', 'MOVE_ISSUES'),
(10017, 0, 28, 'applicationRole', '', 'SCHEDULE_ISSUES'),
(10018, 0, 30, 'projectrole', '10002', 'MODIFY_REPORTER'),
(10019, 0, 20, 'applicationRole', '', 'WORK_ON_ISSUES'),
(10020, 0, 43, 'projectrole', '10002', 'DELETE_ALL_WORKLOGS'),
(10021, 0, 42, 'applicationRole', '', 'DELETE_OWN_WORKLOGS'),
(10022, 0, 41, 'projectrole', '10002', 'EDIT_ALL_WORKLOGS'),
(10023, 0, 40, 'applicationRole', '', 'EDIT_OWN_WORKLOGS'),
(10024, 0, 31, 'applicationRole', '', 'VIEW_VOTERS_AND_WATCHERS'),
(10025, 0, 32, 'projectrole', '10002', 'MANAGE_WATCHERS'),
(10026, 0, 34, 'projectrole', '10002', 'EDIT_ALL_COMMENTS'),
(10027, 0, 35, 'applicationRole', '', 'EDIT_OWN_COMMENTS'),
(10028, 0, 36, 'projectrole', '10002', 'DELETE_ALL_COMMENTS'),
(10029, 0, 37, 'applicationRole', '', 'DELETE_OWN_COMMENTS'),
(10030, 0, 38, 'projectrole', '10002', 'DELETE_ALL_ATTACHMENTS'),
(10031, 0, 39, 'applicationRole', '', 'DELETE_OWN_ATTACHMENTS'),
(10033, 0, 29, 'applicationRole', '', 'VIEW_DEV_TOOLS'),
(10101, NULL, 44, 'group', 'jira-administrators', NULL),
(10200, 0, 45, 'applicationRole', '', 'VIEW_READONLY_WORKFLOW'),
(10300, 0, 46, 'applicationRole', '', 'TRANSITION_ISSUES');             
CREATE INDEX PUBLIC.PRMSSN_SCHEME ON PUBLIC.SCHEMEPERMISSIONS(SCHEME);         
CREATE CACHED TABLE PUBLIC.SEARCHREQUEST(
    ID BIGINT NOT NULL,
    FILTERNAME VARCHAR,
    AUTHORNAME VARCHAR,
    DESCRIPTION VARCHAR,
    USERNAME VARCHAR,
    GROUPNAME VARCHAR,
    PROJECTID BIGINT,
    REQCONTENT VARCHAR,
    FAV_COUNT BIGINT,
    FILTERNAME_LOWER VARCHAR
);    
ALTER TABLE PUBLIC.SEARCHREQUEST ADD CONSTRAINT PUBLIC.PK_SEARCHREQUEST PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SEARCHREQUEST;            
CREATE INDEX PUBLIC.SR_AUTHOR ON PUBLIC.SEARCHREQUEST(AUTHORNAME);             
CREATE INDEX PUBLIC.SEARCHREQUEST_FILTERNAMELOWER ON PUBLIC.SEARCHREQUEST(FILTERNAME_LOWER);   
CREATE CACHED TABLE PUBLIC.SEQUENCE_VALUE_ITEM(
    SEQ_NAME VARCHAR NOT NULL,
    SEQ_ID BIGINT
);            
ALTER TABLE PUBLIC.SEQUENCE_VALUE_ITEM ADD CONSTRAINT PUBLIC.PK_SEQUENCE_VALUE_ITEM PRIMARY KEY(SEQ_NAME);     
-- 56 +/- SELECT COUNT(*) FROM PUBLIC.SEQUENCE_VALUE_ITEM;     
INSERT INTO PUBLIC.SEQUENCE_VALUE_ITEM(SEQ_NAME, SEQ_ID) VALUES
('Avatar', 10500),
('ConfigurationContext', 10100),
('EventType', 10000),
('Feature', 10100),
('FieldConfigScheme', 10100),
('FieldConfigSchemeIssueType', 10200),
('FieldConfiguration', 10100),
('FieldLayout', 10100),
('FieldScreen', 10000),
('FieldScreenLayoutItem', 10200),
('FieldScreenScheme', 10000),
('FieldScreenSchemeItem', 10100),
('FieldScreenTab', 10100),
('GadgetUserPreference', 10100),
('GenericConfiguration', 10100),
('IssueType', 10000),
('IssueLinkType', 10200),
('IssueTypeScreenSchemeEntity', 10100),
('Notification', 10200),
('NotificationScheme', 10100),
('OAuthConsumer', 10100),
('OptionConfiguration', 10200),
('PortalPage', 10100),
('PortletConfiguration', 10100),
('Priority', 10000),
('ProjectRole', 10100),
('ProjectRoleActor', 10100),
('Resolution', 10000),
('SchemePermissions', 10400),
('ServiceConfig', 10200),
('SharePermissions', 10100),
('Status', 10000),
('Workflow', 10100),
('WorkflowScheme', 10100),
('WorkflowSchemeEntity', 10100),
('UpgradeHistory', 10200),
('UpgradeVersionHistory', 10100),
('OSPropertyEntry', 10300),
('EntityPropertyIndexDocument', 10100),
('RunDetails', 10100),
('ListenerConfig', 10300),
('ClusteredJob', 10200),
('ProductLicense', 10100),
('Group', 10110),
('AuditLog', 10100),
('LicenseRoleGroup', 10100),
('GlobalPermissionEntry', 10200),
('AuditChangedValue', 10100),
('PluginVersion', 10200),
('ApplicationUser', 10100),
('User', 10100),
('UserAttribute', 10100),
('Membership', 10100),
('AuditItem', 10100),
('LicenseRoleDefault', 10100),
('FieldLayoutItem', 10200);               
CREATE CACHED TABLE PUBLIC.SERVICECONFIG(
    ID BIGINT NOT NULL,
    DELAYTIME BIGINT,
    CLAZZ VARCHAR,
    SERVICENAME VARCHAR,
    CRON_EXPRESSION VARCHAR
);             
ALTER TABLE PUBLIC.SERVICECONFIG ADD CONSTRAINT PUBLIC.PK_SERVICECONFIG PRIMARY KEY(ID);       
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.SERVICECONFIG;            
INSERT INTO PUBLIC.SERVICECONFIG(ID, DELAYTIME, CLAZZ, SERVICENAME, CRON_EXPRESSION) VALUES
(10000, 60000, 'com.atlassian.jira.service.services.mail.MailQueueService', 'Mail Queue Service', '0 * * * * ?'),
(10001, 43200000, 'com.atlassian.jira.service.services.export.ExportService', 'Backup Service', '0 5 2/12 * * ?'),
(10002, 86400000, 'com.atlassian.jira.service.services.auditing.AuditLogCleaningService', 'Audit log cleaning service', '0 0 10 * * ?');      
CREATE CACHED TABLE PUBLIC.SHAREPERMISSIONS(
    ID BIGINT NOT NULL,
    ENTITYID BIGINT,
    ENTITYTYPE VARCHAR,
    SHARETYPE VARCHAR,
    PARAM1 VARCHAR,
    PARAM2 VARCHAR
);             
ALTER TABLE PUBLIC.SHAREPERMISSIONS ADD CONSTRAINT PUBLIC.PK_SHAREPERMISSIONS PRIMARY KEY(ID); 
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SHAREPERMISSIONS;         
INSERT INTO PUBLIC.SHAREPERMISSIONS(ID, ENTITYID, ENTITYTYPE, SHARETYPE, PARAM1, PARAM2) VALUES
(10000, 10000, 'PortalPage', 'global', NULL, NULL);            
CREATE INDEX PUBLIC.SHARE_INDEX ON PUBLIC.SHAREPERMISSIONS(ENTITYID, ENTITYTYPE);              
CREATE CACHED TABLE PUBLIC.ISSUESTATUS(
    ID VARCHAR NOT NULL,
    SEQUENCE BIGINT,
    PNAME VARCHAR,
    DESCRIPTION VARCHAR,
    ICONURL VARCHAR,
    STATUSCATEGORY BIGINT
);            
ALTER TABLE PUBLIC.ISSUESTATUS ADD CONSTRAINT PUBLIC.PK_ISSUESTATUS PRIMARY KEY(ID);           
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ISSUESTATUS;              
INSERT INTO PUBLIC.ISSUESTATUS(ID, SEQUENCE, PNAME, DESCRIPTION, ICONURL, STATUSCATEGORY) VALUES
('1', 1, 'Open', 'The issue is open and ready for the assignee to start work on it.', '/images/icons/statuses/open.png', 2),
('3', 3, 'In Progress', 'This issue is being actively worked on at the moment by the assignee.', '/images/icons/statuses/inprogress.png', 4),
('4', 4, 'Reopened', 'This issue was once resolved, but the resolution was deemed incorrect. From here issues are either marked assigned or resolved.', '/images/icons/statuses/reopened.png', 2),
('5', 5, 'Resolved', 'A resolution has been taken, and it is awaiting verification by reporter. From here issues are either reopened, or are closed.', '/images/icons/statuses/resolved.png', 3),
('6', 6, 'Closed', 'The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.', '/images/icons/statuses/closed.png', 3);          
CREATE CACHED TABLE PUBLIC.TRACKBACK_PING(
    ID BIGINT NOT NULL,
    ISSUE BIGINT,
    URL VARCHAR,
    TITLE VARCHAR,
    BLOGNAME VARCHAR,
    EXCERPT VARCHAR,
    CREATED TIMESTAMP
);   
ALTER TABLE PUBLIC.TRACKBACK_PING ADD CONSTRAINT PUBLIC.PK_TRACKBACK_PING PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.TRACKBACK_PING;           
CREATE CACHED TABLE PUBLIC.TRUSTEDAPP(
    ID BIGINT NOT NULL,
    APPLICATION_ID VARCHAR,
    NAME VARCHAR,
    PUBLIC_KEY VARCHAR,
    IP_MATCH VARCHAR,
    URL_MATCH VARCHAR,
    TIMEOUT BIGINT,
    CREATED TIMESTAMP,
    CREATED_BY VARCHAR,
    UPDATED TIMESTAMP,
    UPDATED_BY VARCHAR
);          
ALTER TABLE PUBLIC.TRUSTEDAPP ADD CONSTRAINT PUBLIC.PK_TRUSTEDAPP PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.TRUSTEDAPP;               
CREATE UNIQUE INDEX PUBLIC.TRUSTEDAPP_ID ON PUBLIC.TRUSTEDAPP(APPLICATION_ID); 
CREATE CACHED TABLE PUBLIC.UPGRADEHISTORY(
    ID BIGINT,
    UPGRADECLASS VARCHAR NOT NULL,
    TARGETBUILD VARCHAR,
    STATUS VARCHAR,
    DOWNGRADETASKREQUIRED CHAR(1)
); 
ALTER TABLE PUBLIC.UPGRADEHISTORY ADD CONSTRAINT PUBLIC.PK_UPGRADEHISTORY PRIMARY KEY(UPGRADECLASS);           
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.UPGRADEHISTORY;           
INSERT INTO PUBLIC.UPGRADEHISTORY(ID, UPGRADECLASS, TARGETBUILD, STATUS, DOWNGRADETASKREQUIRED) VALUES
(10000, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70100', '70100', 'complete', 'Y'),
(10100, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70101', '70101', 'complete', 'N'),
(10101, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70102', '70102', 'complete', 'N'),
(10102, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70108', '70108', 'complete', 'N'),
(10103, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build71001', '71001', 'complete', 'N');   
CREATE CACHED TABLE PUBLIC.UPGRADEVERSIONHISTORY(
    ID BIGINT,
    TIMEPERFORMED TIMESTAMP,
    TARGETBUILD VARCHAR NOT NULL,
    TARGETVERSION VARCHAR
);   
ALTER TABLE PUBLIC.UPGRADEVERSIONHISTORY ADD CONSTRAINT PUBLIC.PK_UPGRADEVERSIONHISTORY PRIMARY KEY(TARGETBUILD);              
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.UPGRADEVERSIONHISTORY;    
INSERT INTO PUBLIC.UPGRADEVERSIONHISTORY(ID, TIMEPERFORMED, TARGETBUILD, TARGETVERSION) VALUES
(10000, TIMESTAMP '2015-11-07 02:06:09.778', '71001', '7.1.0-SNAPSHOT');        
CREATE CACHED TABLE PUBLIC.CWD_USER(
    ID BIGINT NOT NULL,
    DIRECTORY_ID BIGINT,
    USER_NAME VARCHAR,
    LOWER_USER_NAME VARCHAR,
    ACTIVE INTEGER,
    CREATED_DATE TIMESTAMP,
    UPDATED_DATE TIMESTAMP,
    FIRST_NAME VARCHAR,
    LOWER_FIRST_NAME VARCHAR,
    LAST_NAME VARCHAR,
    LOWER_LAST_NAME VARCHAR,
    DISPLAY_NAME VARCHAR,
    LOWER_DISPLAY_NAME VARCHAR,
    EMAIL_ADDRESS VARCHAR,
    LOWER_EMAIL_ADDRESS VARCHAR,
    CREDENTIAL VARCHAR,
    DELETED_EXTERNALLY INTEGER,
    EXTERNAL_ID VARCHAR
);       
ALTER TABLE PUBLIC.CWD_USER ADD CONSTRAINT PUBLIC.PK_CWD_USER PRIMARY KEY(ID); 
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.CWD_USER; 
INSERT INTO PUBLIC.CWD_USER(ID, DIRECTORY_ID, USER_NAME, LOWER_USER_NAME, ACTIVE, CREATED_DATE, UPDATED_DATE, FIRST_NAME, LOWER_FIRST_NAME, LAST_NAME, LOWER_LAST_NAME, DISPLAY_NAME, LOWER_DISPLAY_NAME, EMAIL_ADDRESS, LOWER_EMAIL_ADDRESS, CREDENTIAL, DELETED_EXTERNALLY, EXTERNAL_ID) VALUES
(10000, 1, 'admin', 'admin', 1, TIMESTAMP '2015-11-07 02:07:50.196', TIMESTAMP '2015-11-07 02:07:50.196', '', '', 'admin', 'admin', 'admin', 'admin', 'admin@admin.com', 'admin@admin.com', '{PKCS5S2}KDXvBerE1QSAoF/T2o4BoYJOTYDsX9eva5PShLGRj5nO7vflF778q7ekIb0lmRRS', NULL, '5b13caf0-9dc9-4909-8273-2fa44066c553');      
CREATE UNIQUE INDEX PUBLIC.UK_USER_NAME_DIR_ID ON PUBLIC.CWD_USER(LOWER_USER_NAME, DIRECTORY_ID);              
CREATE INDEX PUBLIC.UK_USER_EXTERNALID_DIR_ID ON PUBLIC.CWD_USER(EXTERNAL_ID, DIRECTORY_ID);   
CREATE INDEX PUBLIC.IDX_FIRST_NAME ON PUBLIC.CWD_USER(LOWER_FIRST_NAME);       
CREATE INDEX PUBLIC.IDX_LAST_NAME ON PUBLIC.CWD_USER(LOWER_LAST_NAME);         
CREATE INDEX PUBLIC.IDX_DISPLAY_NAME ON PUBLIC.CWD_USER(LOWER_DISPLAY_NAME);   
CREATE INDEX PUBLIC.IDX_EMAIL_ADDRESS ON PUBLIC.CWD_USER(LOWER_EMAIL_ADDRESS); 
CREATE CACHED TABLE PUBLIC.USERASSOCIATION(
    SOURCE_NAME VARCHAR NOT NULL,
    SINK_NODE_ID BIGINT NOT NULL,
    SINK_NODE_ENTITY VARCHAR NOT NULL,
    ASSOCIATION_TYPE VARCHAR NOT NULL,
    SEQUENCE INTEGER,
    CREATED TIMESTAMP
);   
ALTER TABLE PUBLIC.USERASSOCIATION ADD CONSTRAINT PUBLIC.PK_USERASSOCIATION PRIMARY KEY(SOURCE_NAME, SINK_NODE_ID, SINK_NODE_ENTITY, ASSOCIATION_TYPE);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERASSOCIATION;          
CREATE INDEX PUBLIC.USER_SOURCE ON PUBLIC.USERASSOCIATION(SOURCE_NAME);        
CREATE INDEX PUBLIC.USER_SINK ON PUBLIC.USERASSOCIATION(SINK_NODE_ID, SINK_NODE_ENTITY);       
CREATE CACHED TABLE PUBLIC.CWD_USER_ATTRIBUTES(
    ID BIGINT NOT NULL,
    USER_ID BIGINT,
    DIRECTORY_ID BIGINT,
    ATTRIBUTE_NAME VARCHAR,
    ATTRIBUTE_VALUE VARCHAR,
    LOWER_ATTRIBUTE_VALUE VARCHAR
);             
ALTER TABLE PUBLIC.CWD_USER_ATTRIBUTES ADD CONSTRAINT PUBLIC.PK_CWD_USER_ATTRIBUTES PRIMARY KEY(ID);           
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.CWD_USER_ATTRIBUTES;      
INSERT INTO PUBLIC.CWD_USER_ATTRIBUTES(ID, USER_ID, DIRECTORY_ID, ATTRIBUTE_NAME, ATTRIBUTE_VALUE, LOWER_ATTRIBUTE_VALUE) VALUES
(10000, 10000, 1, 'passwordLastChanged', '1446822470199', '1446822470199'),
(10001, 10000, 1, 'requiresPasswordChange', 'false', 'false'),
(10002, 10000, 1, 'invalidPasswordAttempts', '0', '0'),
(10003, 10000, 1, 'password.reset.request.expiry', '1446908870393', '1446908870393'),
(10004, 10000, 1, 'password.reset.request.token', 'c5e998106d19888c6b8d2c51f3764a12fa93fbe9', 'c5e998106d19888c6b8d2c51f3764a12fa93fbe9'),
(10005, 10000, 1, 'login.currentFailedCount', '0', '0'),
(10006, 10000, 1, 'login.lastLoginMillis', '1446822480884', '1446822480884'),
(10007, 10000, 1, 'login.count', '1', '1');        
CREATE INDEX PUBLIC.IDX_USER_ATTR_DIR_NAME_LVAL ON PUBLIC.CWD_USER_ATTRIBUTES(DIRECTORY_ID, ATTRIBUTE_NAME, LOWER_ATTRIBUTE_VALUE);            
CREATE INDEX PUBLIC.UK_USER_ATTR_NAME_LVAL ON PUBLIC.CWD_USER_ATTRIBUTES(USER_ID, ATTRIBUTE_NAME);             
CREATE CACHED TABLE PUBLIC.USERHISTORYITEM(
    ID BIGINT NOT NULL,
    ENTITYTYPE VARCHAR,
    ENTITYID VARCHAR,
    USERNAME VARCHAR,
    LASTVIEWED BIGINT,
    DATA VARCHAR
);             
ALTER TABLE PUBLIC.USERHISTORYITEM ADD CONSTRAINT PUBLIC.PK_USERHISTORYITEM PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERHISTORYITEM;          
CREATE UNIQUE INDEX PUBLIC.UH_TYPE_USER_ENTITY ON PUBLIC.USERHISTORYITEM(ENTITYTYPE, USERNAME, ENTITYID);      
CREATE CACHED TABLE PUBLIC.USERPICKERFILTER(
    ID BIGINT NOT NULL,
    CUSTOMFIELD BIGINT,
    CUSTOMFIELDCONFIG BIGINT,
    ENABLED VARCHAR
);              
ALTER TABLE PUBLIC.USERPICKERFILTER ADD CONSTRAINT PUBLIC.PK_USERPICKERFILTER PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERPICKERFILTER;         
CREATE INDEX PUBLIC.UPF_CUSTOMFIELD ON PUBLIC.USERPICKERFILTER(CUSTOMFIELD);   
CREATE INDEX PUBLIC.UPF_FIELDCONFIGID ON PUBLIC.USERPICKERFILTER(CUSTOMFIELDCONFIG);           
CREATE CACHED TABLE PUBLIC.USERPICKERFILTERGROUP(
    ID BIGINT NOT NULL,
    USERPICKERFILTER BIGINT,
    GROUPNAME VARCHAR
);
ALTER TABLE PUBLIC.USERPICKERFILTERGROUP ADD CONSTRAINT PUBLIC.PK_USERPICKERFILTERGROUP PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERPICKERFILTERGROUP;    
CREATE INDEX PUBLIC.CF_USERPICKERFILTERGROUP ON PUBLIC.USERPICKERFILTERGROUP(USERPICKERFILTER);
CREATE CACHED TABLE PUBLIC.USERPICKERFILTERROLE(
    ID BIGINT NOT NULL,
    USERPICKERFILTER BIGINT,
    PROJECTROLEID BIGINT
);              
ALTER TABLE PUBLIC.USERPICKERFILTERROLE ADD CONSTRAINT PUBLIC.PK_USERPICKERFILTERROLE PRIMARY KEY(ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.USERPICKERFILTERROLE;     
CREATE INDEX PUBLIC.CF_USERPICKERFILTERROLE ON PUBLIC.USERPICKERFILTERROLE(USERPICKERFILTER);  
CREATE CACHED TABLE PUBLIC.PROJECTVERSION(
    ID BIGINT NOT NULL,
    PROJECT BIGINT,
    VNAME VARCHAR,
    DESCRIPTION VARCHAR,
    SEQUENCE BIGINT,
    RELEASED VARCHAR,
    ARCHIVED VARCHAR,
    URL VARCHAR,
    STARTDATE TIMESTAMP,
    RELEASEDATE TIMESTAMP
);     
ALTER TABLE PUBLIC.PROJECTVERSION ADD CONSTRAINT PUBLIC.PK_PROJECTVERSION PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PROJECTVERSION;           
CREATE INDEX PUBLIC.IDX_VERSION_PROJECT ON PUBLIC.PROJECTVERSION(PROJECT);     
CREATE INDEX PUBLIC.IDX_VERSION_SEQUENCE ON PUBLIC.PROJECTVERSION(SEQUENCE);   
CREATE CACHED TABLE PUBLIC.VERSIONCONTROL(
    ID BIGINT NOT NULL,
    VCSNAME VARCHAR,
    VCSDESCRIPTION VARCHAR,
    VCSTYPE VARCHAR
);     
ALTER TABLE PUBLIC.VERSIONCONTROL ADD CONSTRAINT PUBLIC.PK_VERSIONCONTROL PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.VERSIONCONTROL;           
CREATE CACHED TABLE PUBLIC.VOTEHISTORY(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    VOTES BIGINT,
    TIMESTAMP TIMESTAMP
);               
ALTER TABLE PUBLIC.VOTEHISTORY ADD CONSTRAINT PUBLIC.PK_VOTEHISTORY PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.VOTEHISTORY;              
CREATE INDEX PUBLIC.VOTEHISTORY_ISSUE_INDEX ON PUBLIC.VOTEHISTORY(ISSUEID);    
CREATE CACHED TABLE PUBLIC.JIRAWORKFLOWS(
    ID BIGINT NOT NULL,
    WORKFLOWNAME VARCHAR,
    CREATORNAME VARCHAR,
    DESCRIPTOR VARCHAR,
    ISLOCKED VARCHAR
);           
ALTER TABLE PUBLIC.JIRAWORKFLOWS ADD CONSTRAINT PUBLIC.PK_JIRAWORKFLOWS PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.JIRAWORKFLOWS;            
INSERT INTO PUBLIC.JIRAWORKFLOWS(ID, WORKFLOWNAME, CREATORNAME, DESCRIPTOR, ISLOCKED) VALUES
(10000, 'classic default workflow', NULL, STRINGDECODE('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">\n<workflow>\n  <meta name=\"jira.description\">The classic JIRA default workflow</meta>\n  <initial-actions>\n    <action id=\"1\" name=\"Create Issue\">\n      <meta name=\"opsbar-sequence\">0</meta>\n      <meta name=\"jira.i18n.title\">common.forms.create</meta>\n      <validators>\n        <validator name=\"\" type=\"class\">\n          <arg name=\"class.name\">com.atlassian.jira.workflow.validator.PermissionValidator</arg>\n          <arg name=\"permission\">Create Issue</arg>\n        </validator>\n      </validators>\n      <results>\n        <unconditional-result old-status=\"Finished\" status=\"Open\" step=\"1\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueCreateFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">1</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n  </initial-actions>\n  <common-actions>\n    <action id=\"2\" name=\"Close Issue\" view=\"resolveissue\">\n      <meta name=\"opsbar-sequence\">60</meta>\n      <meta name=\"jira.i18n.submit\">closeissue.close</meta>\n      <meta name=\"jira.i18n.description\">closeissue.desc</meta>\n      <meta name=\"jira.i18n.title\">closeissue.title</meta>\n      <restrict-to>\n        <conditions type=\"AND\">\n          <condition type=\"class\">\n            <arg name=\"class.name\">com.atlassian.jira.workflow.condition.PermissionCondition</arg>\n            <arg name=\"permission\">Resolve Issue</arg>\n          </condition>\n          <condition type=\"class\">\n            <arg name=\"class.name\">com.atlassian.jira.workflow.condition.PermissionCondition</arg>\n            <arg name=\"permission\">Close Issue</arg>\n          </condition>\n        </conditions>\n      </restrict-to>\n      <results>\n        <unconditional-result old-status=\"Finished\" status=\"Closed\" step=\"6\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">5</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n    <action id=\"3\" name=\"Reopen Issue\" view=\"commentassign\">\n      <meta name=\"opsbar-sequence\">80</meta>\n      <meta name=\"jira.i18n.submit\">issue.operations.reopen.issue</meta>\n      <meta name=\"jira.i18n.description\">issue.operations.reopen.description</meta>\n      <meta name=\"jira.i18n.title\">issue.operations.reopen.issue</meta>\n      <restrict-to>\n        <conditions>\n          <condition type=\"class\">\n            <arg name=\"class.name\">com.atlassian.jira.workflow.condition.PermissionCondition</arg>\n            <arg name=\"permission\">Resolve Issue</arg>\n          </condition>\n        </conditions>\n      </restrict-to>\n      <results>\n        <unconditional-result old-status=\"Finished\" status=\"Reopened\" step=\"5\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>\n              <arg name=\"field.value\"></arg>\n              <arg name=\"field.name\">resolution</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">7</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n    <action id=\"4\" name=\"Start Progress\">\n      <meta name=\"opsbar-sequence\">20</meta>\n      <meta name=\"jira.i18n.title\">startprogress.title</meta>\n      <restrict-to>\n        <conditions>\n          <condition type=\"class\">\n            <arg name=\"class.name\">com.atlassian.jira.workflow.condition.AllowOnlyAssignee</arg>\n          </condition>\n        </conditions>\n      </restrict-to>\n      <results>\n        <unconditional-result old-status=\"Finished\" status=\"Underway\" step=\"3\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>\n              <arg name=\"field.value\"></arg>\n              <arg name=\"field.name\">resolution</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">11</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n    <action id=\"5\" name=\"Resolve Issue\" view=\"resolveissue\">\n      <meta name=\"opsbar-sequence\">40</meta>\n      <meta name=\"jira.i18n.submit\">resolveissue.resolve</meta>\n      <meta name=\"jira.i18n.description\">resolveissue.desc.line1</meta>\n      <meta name=\"jira.i18n.title\">resolveissue.title</meta>\n      <restrict-to>\n        <conditions>\n          <condition type=\"class\">\n            <arg name=\"class.name\">com.atlassian.jira.workflow.condition.PermissionCondition</arg>\n            <arg name=\"permission\">Resolve Issue</arg>\n          </condition>\n        </conditions>\n      </restrict-to>\n      <results>\n        <unconditional-result old-status=\"Finished\" status=\"Resolved\" step=\"4\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">4</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n  </common-actions>\n  <steps>\n    <step id=\"1\" name=\"Open\">\n      <meta name=\"jira.status.id\">1</meta>\n      <actions>\n<common-action id=\"4\" />\n<common-action id=\"5\" />\n<common-action id=\"2\" />\n      </actions>\n    </step>\n    <step id=\"3\" name=\"In Progress\">\n      <meta name=\"jira.status.id\">3</meta>\n      <actions>\n<common-action id=\"5\" />\n<common-action id=\"2\" />\n        <action id=\"301\" name=\"Stop Progress\">\n          <meta name=\"opsbar-sequence\">20</meta>\n          <meta name=\"jira.i18n.title\">stopprogress.title</meta>\n          <restrict-to>\n            <conditions>\n              <condition type=\"class\">\n                <arg name=\"class.name\">com.atlassian.jira.workflow.condition.AllowOnlyAssignee</arg>\n              </condition>\n            </conditions>\n          </restrict-to>\n          <results>\n            <unconditional-result old-status=\"Finished\" status=\"Assigned\" step=\"1\">\n              <post-functions>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>\n                  <arg name=\"field.value\"></arg>\n                  <arg name=\"field.name\">resolution</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n                  <arg name=\"eventTypeId\">12</arg>\n                </function>\n              </post-functions>\n            </unconditional-result>\n          </results>\n        </action>\n      </actions>\n    </step>\n    <step id=\"4\" name=\"Resolved\">\n      <meta name=\"jira.status.id\">5</meta>\n      <actions>\n<common-action id=\"3\" />\n        <action id=\"701\" name=\"Close Issue\" view=\"commentassign\">\n          <meta name=\"opsbar-sequence\">60</meta>\n          <meta name=\"jira.i18n.submit\">closeissue.close</meta>\n          <meta name=\"jira.i18n.description\">closeissue.desc</meta>\n          <meta name=\"jira.i18n.title\">closeissue.title</meta>\n          <meta name=\"jira.description\">Closing an issue indicates there is no more work to be done on it, and it has been verified as complete.</meta>\n          <restrict-to>\n            <conditions>\n              <condition type=\"class\">\n                <arg name=\"class.name\">com.atlassian.jira.workflow.condition.PermissionCondition</arg>\n                <arg name=\"permission\">Close Issue</arg>\n              </condition>\n            </conditions>\n          </restrict-to>\n          <results>\n            <unconditional-result old-status=\"Finished\" status=\"Closed\" step=\"6\">\n              <post-functions>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n                </function>\n                <function type=\"class\">\n                  <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n                  <arg name=\"eventTypeId\">5</arg>\n                </function>\n              </post-functions>\n            </unconditional-result>\n          </results>\n        </action>\n      </actions>\n    </step>\n    <step id=\"5\" name=\"Reopened\">\n      <meta name=\"jira.status.id\">4</meta>\n      <actions>\n<common-action id=\"5\" />\n<common-action id=\"2\" />\n<common-action id=\"4\" />\n      </actions>\n    </step>\n    <step id=\"6\" name=\"Closed\">\n      <meta name=\"jira.status.id\">6</meta>\n      <meta name=\"jira.issue.editable\">false</meta>\n      <actions>\n<common-action id=\"3\" />\n      </actions>\n    </step>\n  </steps>\n</workflow>\n'), NULL);       
CREATE CACHED TABLE PUBLIC.WORKFLOWSCHEME(
    ID BIGINT NOT NULL,
    NAME VARCHAR,
    DESCRIPTION VARCHAR
);
ALTER TABLE PUBLIC.WORKFLOWSCHEME ADD CONSTRAINT PUBLIC.PK_WORKFLOWSCHEME PRIMARY KEY(ID);     
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.WORKFLOWSCHEME;           
INSERT INTO PUBLIC.WORKFLOWSCHEME(ID, NAME, DESCRIPTION) VALUES
(10000, 'classic', 'classic'); 
CREATE CACHED TABLE PUBLIC.WORKFLOWSCHEMEENTITY(
    ID BIGINT NOT NULL,
    SCHEME BIGINT,
    WORKFLOW VARCHAR,
    ISSUETYPE VARCHAR
);     
ALTER TABLE PUBLIC.WORKFLOWSCHEMEENTITY ADD CONSTRAINT PUBLIC.PK_WORKFLOWSCHEMEENTITY PRIMARY KEY(ID);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.WORKFLOWSCHEMEENTITY;     
INSERT INTO PUBLIC.WORKFLOWSCHEMEENTITY(ID, SCHEME, WORKFLOW, ISSUETYPE) VALUES
(10000, 10000, 'classic default workflow', '0');               
CREATE INDEX PUBLIC.WORKFLOW_SCHEME ON PUBLIC.WORKFLOWSCHEMEENTITY(SCHEME);    
CREATE CACHED TABLE PUBLIC.WORKLOG(
    ID BIGINT NOT NULL,
    ISSUEID BIGINT,
    AUTHOR VARCHAR,
    GROUPLEVEL VARCHAR,
    ROLELEVEL BIGINT,
    WORKLOGBODY VARCHAR,
    CREATED TIMESTAMP,
    UPDATEAUTHOR VARCHAR,
    UPDATED TIMESTAMP,
    STARTDATE TIMESTAMP,
    TIMEWORKED BIGINT
);           
ALTER TABLE PUBLIC.WORKLOG ADD CONSTRAINT PUBLIC.PK_WORKLOG PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.WORKLOG;  
CREATE INDEX PUBLIC.WORKLOG_ISSUE ON PUBLIC.WORKLOG(ISSUEID);  
CREATE INDEX PUBLIC.WORKLOG_AUTHOR ON PUBLIC.WORKLOG(AUTHOR);  
CREATE CACHED TABLE PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY(
    DURATION INT,
    HEIGHT INT,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_C4990A13_0F53_4F71_B947_BBB4EFB6D6B9) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C4990A13_0F53_4F71_B947_BBB4EFB6D6B9,
    URL VARCHAR(450),
    WIDTH INT
);
ALTER TABLE PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_2 PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY;              
CREATE CACHED TABLE PUBLIC.AO_563AEE_ACTOR_ENTITY(
    FULL_NAME VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_71364CD0_649F_40BA_ACBC_5421EA520DC9) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_71364CD0_649F_40BA_ACBC_5421EA520DC9,
    PROFILE_PAGE_URI VARCHAR(450),
    PROFILE_PICTURE_URI VARCHAR(450),
    USERNAME VARCHAR(255)
);            
ALTER TABLE PUBLIC.AO_563AEE_ACTOR_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_3 PRIMARY KEY(ID);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_563AEE_ACTOR_ENTITY;   
CREATE CACHED TABLE PUBLIC.AO_563AEE_TARGET_ENTITY(
    CONTENT VARCHAR(255),
    DISPLAY_NAME VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_280B08B1_47DF_4846_9BAF_FD4F4F5B3966) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_280B08B1_47DF_4846_9BAF_FD4F4F5B3966,
    IMAGE_ID INT,
    OBJECT_ID VARCHAR(450),
    OBJECT_TYPE VARCHAR(450),
    SUMMARY VARCHAR(255),
    URL VARCHAR(450)
);      
ALTER TABLE PUBLIC.AO_563AEE_TARGET_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_A PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_563AEE_TARGET_ENTITY;  
CREATE INDEX PUBLIC.INDEX_AO_563AEE_TAR521440921 ON PUBLIC.AO_563AEE_TARGET_ENTITY(IMAGE_ID);  
CREATE CACHED TABLE PUBLIC.AO_563AEE_OBJECT_ENTITY(
    CONTENT VARCHAR(255),
    DISPLAY_NAME VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_66334F7F_7F5F_4D03_9F93_9E24C3A9FE64) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_66334F7F_7F5F_4D03_9F93_9E24C3A9FE64,
    IMAGE_ID INT,
    OBJECT_ID VARCHAR(450),
    OBJECT_TYPE VARCHAR(450),
    SUMMARY VARCHAR(255),
    URL VARCHAR(450)
);      
ALTER TABLE PUBLIC.AO_563AEE_OBJECT_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_4 PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_563AEE_OBJECT_ENTITY;  
CREATE INDEX PUBLIC.INDEX_AO_563AEE_OBJ696886343 ON PUBLIC.AO_563AEE_OBJECT_ENTITY(IMAGE_ID);  
CREATE CACHED TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY(
    ACTIVITY_ID BIGINT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_DC3A0EF9_C9AF_483A_A350_F4091A9CD54A) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_DC3A0EF9_C9AF_483A_A350_F4091A9CD54A,
    ACTOR_ID INT,
    CONTENT CLOB,
    GENERATOR_DISPLAY_NAME VARCHAR(255),
    GENERATOR_ID VARCHAR(450),
    ICON_ID INT,
    ID VARCHAR(450),
    ISSUE_KEY VARCHAR(255),
    OBJECT_ID INT,
    POSTER VARCHAR(255),
    PROJECT_KEY VARCHAR(255),
    PUBLISHED TIMESTAMP,
    TARGET_ID INT,
    TITLE VARCHAR(255),
    URL VARCHAR(450),
    USERNAME VARCHAR(255),
    VERB VARCHAR(450)
);         
ALTER TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_1 PRIMARY KEY(ACTIVITY_ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_563AEE_ACTIVITY_ENTITY;
CREATE INDEX PUBLIC.INDEX_AO_563AEE_ACT1642652291 ON PUBLIC.AO_563AEE_ACTIVITY_ENTITY(OBJECT_ID);              
CREATE INDEX PUBLIC.INDEX_AO_563AEE_ACT1978295567 ON PUBLIC.AO_563AEE_ACTIVITY_ENTITY(TARGET_ID);              
CREATE INDEX PUBLIC.INDEX_AO_563AEE_ACT972488439 ON PUBLIC.AO_563AEE_ACTIVITY_ENTITY(ICON_ID); 
CREATE INDEX PUBLIC.INDEX_AO_563AEE_ACT995325379 ON PUBLIC.AO_563AEE_ACTIVITY_ENTITY(ACTOR_ID);
CREATE CACHED TABLE PUBLIC.AO_B9A0F0_APPLIED_TEMPLATE(
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_917D969A_F052_476A_91CC_564EAD9EFF13) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_917D969A_F052_476A_91CC_564EAD9EFF13,
    PROJECT_ID BIGINT DEFAULT 0,
    PROJECT_TEMPLATE_MODULE_KEY VARCHAR(255),
    PROJECT_TEMPLATE_WEB_ITEM_KEY VARCHAR(255)
);         
ALTER TABLE PUBLIC.AO_B9A0F0_APPLIED_TEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_5 PRIMARY KEY(ID);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_B9A0F0_APPLIED_TEMPLATE;               
CREATE CACHED TABLE PUBLIC.AO_A44657_HEALTH_CHECK_ENTITY(
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_05D66401_F262_4794_98D5_BB29BD835E6C) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_05D66401_F262_4794_98D5_BB29BD835E6C
);     
ALTER TABLE PUBLIC.AO_A44657_HEALTH_CHECK_ENTITY ADD CONSTRAINT PUBLIC.CONSTRAINT_9 PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_A44657_HEALTH_CHECK_ENTITY;            
CREATE CACHED TABLE PUBLIC.AO_5FB9D7_AOHIP_CHAT_LINK(
    ADDON_TOKEN_EXPIRY TIMESTAMP,
    API_URL VARCHAR(255),
    CONNECT_DESCRIPTOR CLOB,
    GROUP_ID INT DEFAULT 0,
    GROUP_NAME VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_8825EF89_E12C_4885_8DE2_CA355602D2C3) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_8825EF89_E12C_4885_8DE2_CA355602D2C3,
    OAUTH_ID VARCHAR(255),
    SECRET_KEY VARCHAR(255),
    SYSTEM_PASSWORD VARCHAR(255),
    SYSTEM_TOKEN_EXPIRY TIMESTAMP,
    "SYSTEM_USER" VARCHAR(255),
    SYSTEM_USER_TOKEN VARCHAR(255),
    TOKEN VARCHAR(255)
);
ALTER TABLE PUBLIC.AO_5FB9D7_AOHIP_CHAT_LINK ADD CONSTRAINT PUBLIC.CONSTRAINT_E PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_5FB9D7_AOHIP_CHAT_LINK;
CREATE CACHED TABLE PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER(
    HIP_CHAT_LINK_ID INT,
    HIP_CHAT_USER_ID VARCHAR(255),
    HIP_CHAT_USER_NAME VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_514CD571_0C1B_4B9C_B130_46C0C4488345) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_514CD571_0C1B_4B9C_B130_46C0C4488345,
    REFRESH_CODE VARCHAR(255),
    USER_KEY VARCHAR(255),
    USER_SCOPES VARCHAR(255),
    USER_TOKEN VARCHAR(255),
    USER_TOKEN_EXPIRY TIMESTAMP
); 
ALTER TABLE PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER ADD CONSTRAINT PUBLIC.CONSTRAINT_ED PRIMARY KEY(ID);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER;
CREATE INDEX PUBLIC.INDEX_AO_5FB9D7_AOH1981563178 ON PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER(USER_KEY);               
CREATE INDEX PUBLIC.INDEX_AO_5FB9D7_AOH49772492 ON PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER(HIP_CHAT_LINK_ID);         
CREATE CACHED TABLE PUBLIC.AO_21D670_WHITELIST_RULES(
    ALLOWINBOUND BOOLEAN,
    EXPRESSION CLOB NOT NULL,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_C4076D78_F594_4F46_8FAE_11BD543B24A7) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C4076D78_F594_4F46_8FAE_11BD543B24A7,
    TYPE VARCHAR(255) NOT NULL
); 
ALTER TABLE PUBLIC.AO_21D670_WHITELIST_RULES ADD CONSTRAINT PUBLIC.CONSTRAINT_B PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.AO_21D670_WHITELIST_RULES;
INSERT INTO PUBLIC.AO_21D670_WHITELIST_RULES(ALLOWINBOUND, EXPRESSION, ID, TYPE) VALUES
(FALSE, 'http://www.atlassian.com/*', 1, 'WILDCARD_EXPRESSION');       
CREATE CACHED TABLE PUBLIC.AO_3B1893_LOOP_DETECTION(
    COUNTER INT DEFAULT 0 NOT NULL,
    EXPIRES_AT BIGINT DEFAULT 0 NOT NULL,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_53BEEB73_7D42_4E3D_8A5C_EAB7C7D31D2D) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_53BEEB73_7D42_4E3D_8A5C_EAB7C7D31D2D,
    SENDER_EMAIL CLOB NOT NULL
);            
ALTER TABLE PUBLIC.AO_3B1893_LOOP_DETECTION ADD CONSTRAINT PUBLIC.CONSTRAINT_11 PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_3B1893_LOOP_DETECTION; 
CREATE CACHED TABLE PUBLIC.AO_550953_SHORTCUT(
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_7DA5B452_15BD_4827_9727_43CF2130CA95) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_7DA5B452_15BD_4827_9727_43CF2130CA95,
    NAME VARCHAR(255),
    PROJECT_ID BIGINT,
    SHORTCUT_URL CLOB,
    URL VARCHAR(255),
    ICON VARCHAR(255)
);              
ALTER TABLE PUBLIC.AO_550953_SHORTCUT ADD CONSTRAINT PUBLIC.CONSTRAINT_EC PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_550953_SHORTCUT;       
CREATE INDEX PUBLIC.INDEX_AO_550953_SHO1778115994 ON PUBLIC.AO_550953_SHORTCUT(PROJECT_ID);    
CREATE CACHED TABLE PUBLIC.AO_587B34_PROJECT_CONFIG(
    CONFIGURATION_GROUP_ID VARCHAR(255) NOT NULL,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_8E2B9C7B_2CD0_4BC9_BDD2_9BAE8A8C49D8) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_8E2B9C7B_2CD0_4BC9_BDD2_9BAE8A8C49D8,
    "NAME" VARCHAR(255),
    NAME_UNIQUE_CONSTRAINT VARCHAR(255) NOT NULL,
    PROJECT_ID BIGINT DEFAULT 0 NOT NULL,
    ROOM_ID BIGINT DEFAULT 0 NOT NULL,
    "VALUE" VARCHAR(255)
);      
ALTER TABLE PUBLIC.AO_587B34_PROJECT_CONFIG ADD CONSTRAINT PUBLIC.CONSTRAINT_6 PRIMARY KEY(ID);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_587B34_PROJECT_CONFIG; 
CREATE INDEX PUBLIC.INDEX_AO_587B34_PRO2115480362 ON PUBLIC.AO_587B34_PROJECT_CONFIG(NAME);    
CREATE INDEX PUBLIC.INDEX_AO_587B34_PRO2093917684 ON PUBLIC.AO_587B34_PROJECT_CONFIG(PROJECT_ID);              
CREATE INDEX PUBLIC.INDEX_AO_587B34_PRO193829489 ON PUBLIC.AO_587B34_PROJECT_CONFIG(CONFIGURATION_GROUP_ID);   
CREATE INDEX PUBLIC.INDEX_AO_587B34_PRO1732672724 ON PUBLIC.AO_587B34_PROJECT_CONFIG(ROOM_ID); 
CREATE CACHED TABLE PUBLIC.AO_DEB285_BLOG_AO(
    AUTHOR VARCHAR(255),
    ID BIGINT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_2CB614E7_E955_454C_AEA3_B0AAB6B90C7D) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_2CB614E7_E955_454C_AEA3_B0AAB6B90C7D,
    TEXT VARCHAR(255)
);              
ALTER TABLE PUBLIC.AO_DEB285_BLOG_AO ADD CONSTRAINT PUBLIC.CONSTRAINT_A0 PRIMARY KEY(ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_DEB285_BLOG_AO;        
CREATE CACHED TABLE PUBLIC.AO_DEB285_COMMENT_AO(
    AUTHOR VARCHAR(255),
    BLOG_ID BIGINT,
    COMMENT VARCHAR(255),
    DATE TIMESTAMP,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_1B8935BA_8E04_4BC1_BD2B_4F26E043FB20) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_1B8935BA_8E04_4BC1_BD2B_4F26E043FB20
);   
ALTER TABLE PUBLIC.AO_DEB285_COMMENT_AO ADD CONSTRAINT PUBLIC.CONSTRAINT_12 PRIMARY KEY(ID);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_DEB285_COMMENT_AO;     
CREATE INDEX PUBLIC.INDEX_AO_DEB285_COM782863884 ON PUBLIC.AO_DEB285_COMMENT_AO(BLOG_ID);      
CREATE CACHED TABLE PUBLIC.AO_97EDAB_USERINVITATION(
    APPLICATION_KEYS VARCHAR(255),
    EMAIL_ADDRESS VARCHAR(255),
    EXPIRY TIMESTAMP,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_03F2BD5E_69B1_478B_BDDE_2C0025A5F259) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_03F2BD5E_69B1_478B_BDDE_2C0025A5F259,
    REDEEMED BOOLEAN,
    SENDER_USERNAME VARCHAR(255),
    TOKEN VARCHAR(255)
); 
ALTER TABLE PUBLIC.AO_97EDAB_USERINVITATION ADD CONSTRAINT PUBLIC.CONSTRAINT_7 PRIMARY KEY(ID);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_97EDAB_USERINVITATION; 
CREATE CACHED TABLE PUBLIC.AO_38321B_CUSTOM_CONTENT_LINK(
    CONTENT_KEY VARCHAR(255),
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_C51AB612_8DCD_42F2_95D6_6A9700B748BF) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_C51AB612_8DCD_42F2_95D6_6A9700B748BF,
    LINK_LABEL VARCHAR(255),
    LINK_URL VARCHAR(255),
    SEQUENCE INT DEFAULT 0
);   
ALTER TABLE PUBLIC.AO_38321B_CUSTOM_CONTENT_LINK ADD CONSTRAINT PUBLIC.CONSTRAINT_2F PRIMARY KEY(ID);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_38321B_CUSTOM_CONTENT_LINK;            
CREATE INDEX PUBLIC.INDEX_AO_38321B_CUS1828044926 ON PUBLIC.AO_38321B_CUSTOM_CONTENT_LINK(CONTENT_KEY);        
CREATE CACHED TABLE PUBLIC.AO_4AEACD_WEBHOOK_DAO(
    ENABLED BOOLEAN,
    ENCODED_EVENTS CLOB,
    FILTER CLOB,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_7FD857EE_A34F_4E43_A575_CB7C4A256CA6) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_7FD857EE_A34F_4E43_A575_CB7C4A256CA6,
    JQL VARCHAR(255),
    LAST_UPDATED TIMESTAMP NOT NULL,
    LAST_UPDATED_USER VARCHAR(255) NOT NULL,
    NAME CLOB NOT NULL,
    REGISTRATION_METHOD VARCHAR(255) NOT NULL,
    URL CLOB NOT NULL,
    EXCLUDE_ISSUE_DETAILS BOOLEAN,
    PARAMETERS CLOB
);
ALTER TABLE PUBLIC.AO_4AEACD_WEBHOOK_DAO ADD CONSTRAINT PUBLIC.CONSTRAINT_19 PRIMARY KEY(ID);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_4AEACD_WEBHOOK_DAO;    
CREATE CACHED TABLE PUBLIC.AO_A0B856_WEB_HOOK_LISTENER_AO(
    DESCRIPTION CLOB,
    ENABLED BOOLEAN,
    EVENTS CLOB,
    EXCLUDE_BODY BOOLEAN,
    FILTERS CLOB,
    ID INT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_2B41D5E8_78E9_46DA_8CCB_6AF459E3F61E) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_2B41D5E8_78E9_46DA_8CCB_6AF459E3F61E,
    LAST_UPDATED TIMESTAMP NOT NULL,
    LAST_UPDATED_USER VARCHAR(255),
    NAME CLOB NOT NULL,
    PARAMETERS CLOB,
    REGISTRATION_METHOD VARCHAR(255) NOT NULL,
    URL CLOB NOT NULL
);
ALTER TABLE PUBLIC.AO_A0B856_WEB_HOOK_LISTENER_AO ADD CONSTRAINT PUBLIC.CONSTRAINT_F PRIMARY KEY(ID);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AO_A0B856_WEB_HOOK_LISTENER_AO;           
ALTER TABLE PUBLIC.AO_587B34_PROJECT_CONFIG ADD CONSTRAINT PUBLIC.U_AO_587B34_PROJECT2070954277 UNIQUE(NAME_UNIQUE_CONSTRAINT);
ALTER TABLE PUBLIC.AO_563AEE_OBJECT_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_OBJECT_ENTITY_IMAGE_ID FOREIGN KEY(IMAGE_ID) REFERENCES PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY(ID) NOCHECK;          
ALTER TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_ACTIVITY_ENTITY_ICON_ID FOREIGN KEY(ICON_ID) REFERENCES PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY(ID) NOCHECK;        
ALTER TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_ACTIVITY_ENTITY_ACTOR_ID FOREIGN KEY(ACTOR_ID) REFERENCES PUBLIC.AO_563AEE_ACTOR_ENTITY(ID) NOCHECK;           
ALTER TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_ACTIVITY_ENTITY_TARGET_ID FOREIGN KEY(TARGET_ID) REFERENCES PUBLIC.AO_563AEE_TARGET_ENTITY(ID) NOCHECK;        
ALTER TABLE PUBLIC.AO_DEB285_COMMENT_AO ADD CONSTRAINT PUBLIC.FK_AO_DEB285_COMMENT_AO_BLOG_ID FOREIGN KEY(BLOG_ID) REFERENCES PUBLIC.AO_DEB285_BLOG_AO(ID) NOCHECK;            
ALTER TABLE PUBLIC.AO_563AEE_TARGET_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_TARGET_ENTITY_IMAGE_ID FOREIGN KEY(IMAGE_ID) REFERENCES PUBLIC.AO_563AEE_MEDIA_LINK_ENTITY(ID) NOCHECK;          
ALTER TABLE PUBLIC.AO_563AEE_ACTIVITY_ENTITY ADD CONSTRAINT PUBLIC.FK_AO_563AEE_ACTIVITY_ENTITY_OBJECT_ID FOREIGN KEY(OBJECT_ID) REFERENCES PUBLIC.AO_563AEE_OBJECT_ENTITY(ID) NOCHECK;        
ALTER TABLE PUBLIC.AO_5FB9D7_AOHIP_CHAT_USER ADD CONSTRAINT PUBLIC.FK_AO_5FB9D7_AOHIP_CHAT_USER_HIP_CHAT_LINK_ID FOREIGN KEY(HIP_CHAT_LINK_ID) REFERENCES PUBLIC.AO_5FB9D7_AOHIP_CHAT_LINK(ID) NOCHECK;        
