/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.config;

import com.atlassian.jira.plugins.passwordpolicy.config.ConfigItem;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyMode;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.util.Properties;

public class PasswordPolicyConfiguration
implements Cloneable {
    static final String SETTINGS_KEY = "passwordpolicy.configuration";
    private int minimumLength;
    private int maximumLength;
    private int minimumLowercase;
    private int minimumUppercase;
    private int minimumDigits;
    private int minimumSpecial;
    private int minimumDistinctCharacterClasses;
    private boolean enablePassphraseExemption;
    private PasswordPolicyMode passwordPolicyMode;
    private SimilarityCheck similarityToUserInfo;
    private SimilarityCheck similarityToOldPassword;

    public PasswordPolicyConfiguration() {
        this.updateFrom(new Properties());
    }

    public PasswordPolicyConfiguration(Properties properties) {
        this.updateFrom(properties);
    }

    public PasswordPolicyConfiguration(PluginSettings settings) {
        this(PasswordPolicyConfiguration.toProperties(settings));
    }

    @VisibleForTesting
    public static Properties toProperties(PluginSettings settings) {
        Object value = settings.get(SETTINGS_KEY);
        if (value instanceof Properties) {
            return (Properties)value;
        }
        return new Properties();
    }

    void updateFrom(Properties properties) {
        Assertions.notNull((String)"properties", (Object)properties);
        this.minimumLength = ConfigItem.MINIMUM_LENGTH.load(properties);
        this.maximumLength = ConfigItem.MAXIMUM_LENGTH.load(properties);
        this.minimumLowercase = ConfigItem.MINIMUM_LOWERCASE.load(properties);
        this.minimumUppercase = ConfigItem.MINIMUM_UPPERCASE.load(properties);
        this.minimumDigits = ConfigItem.MINIMUM_DIGITS.load(properties);
        this.minimumSpecial = ConfigItem.MINIMUM_SPECIAL.load(properties);
        this.minimumDistinctCharacterClasses = ConfigItem.MINIMUM_CLASSES.load(properties);
        this.enablePassphraseExemption = ConfigItem.ENABLE_PASSPHRASE_EXEMPTION.load(properties);
        this.similarityToOldPassword = SimilarityCheck.from(ConfigItem.SIMILARITY_TO_OLD_PASSWORD.load(properties));
        this.similarityToUserInfo = SimilarityCheck.from(ConfigItem.SIMILARITY_TO_USER_INFO.load(properties));
        if (this.minimumLength > this.maximumLength) {
            this.minimumLength = ConfigItem.MINIMUM_LENGTH.defaultValue();
            this.maximumLength = ConfigItem.MAXIMUM_LENGTH.defaultValue();
        }
        this.maximumLength = Math.max(this.maximumLength, this.minimumLowercase + this.minimumUppercase + this.minimumDigits + this.minimumSpecial);
        this.passwordPolicyMode = PasswordPolicyMode.DISABLED;
        if (properties.containsKey(ConfigItem.PASSWORD_POLICY_MODE.key())) {
            PasswordPolicyMode.from(ConfigItem.PASSWORD_POLICY_MODE.load(properties)).applyTo(this);
        } else if ("true".equalsIgnoreCase(properties.getProperty("enablePasswordPolicy"))) {
            this.passwordPolicyMode = PasswordPolicyMode.CUSTOM;
        }
    }

    Properties toProperties() {
        Properties properties = new Properties();
        ConfigItem.PASSWORD_POLICY_MODE.store(properties, this.passwordPolicyMode.ordinal());
        ConfigItem.MINIMUM_LENGTH.store(properties, this.minimumLength);
        ConfigItem.MAXIMUM_LENGTH.store(properties, this.maximumLength);
        ConfigItem.MINIMUM_LOWERCASE.store(properties, this.minimumLowercase);
        ConfigItem.MINIMUM_UPPERCASE.store(properties, this.minimumUppercase);
        ConfigItem.MINIMUM_DIGITS.store(properties, this.minimumDigits);
        ConfigItem.MINIMUM_SPECIAL.store(properties, this.minimumSpecial);
        ConfigItem.MINIMUM_CLASSES.store(properties, this.minimumDistinctCharacterClasses);
        ConfigItem.ENABLE_PASSPHRASE_EXEMPTION.store(properties, this.enablePassphraseExemption);
        ConfigItem.SIMILARITY_TO_OLD_PASSWORD.store(properties, this.similarityToOldPassword.ordinal());
        ConfigItem.SIMILARITY_TO_USER_INFO.store(properties, this.similarityToUserInfo.ordinal());
        return properties;
    }

    void writeTo(PluginSettings settings) {
        settings.put(SETTINGS_KEY, (Object)this.toProperties());
    }

    private void setProperty(Properties properties, String key, int value) {
        properties.setProperty(key, Integer.toString(value));
    }

    private int getInt(Properties properties, String key, int minimum, int maximum, int defaultValue) {
        String setting = properties.getProperty(key);
        if (setting == null) {
            return defaultValue;
        }
        try {
            int value = Integer.valueOf(setting);
            if (value < minimum) {
                return minimum;
            }
            if (value > maximum) {
                return maximum;
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        String setting = properties.getProperty(key);
        return setting != null ? Boolean.valueOf(setting) : defaultValue;
    }

    public PasswordPolicyMode getPasswordPolicyMode() {
        return this.passwordPolicyMode;
    }

    public void setPasswordPolicyMode(PasswordPolicyMode passwordPolicyMode) {
        this.passwordPolicyMode = (PasswordPolicyMode)((Object)Assertions.notNull((String)"passwordPolicyMode", (Object)((Object)passwordPolicyMode)));
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    public int getMinimumLowercase() {
        return this.minimumLowercase;
    }

    public void setMinimumLowercase(int minimumLowercase) {
        this.minimumLowercase = minimumLowercase;
    }

    public int getMinimumUppercase() {
        return this.minimumUppercase;
    }

    public void setMinimumUppercase(int minimumUppercase) {
        this.minimumUppercase = minimumUppercase;
    }

    public int getMinimumDigits() {
        return this.minimumDigits;
    }

    public void setMinimumDigits(int minimumDigits) {
        this.minimumDigits = minimumDigits;
    }

    public int getMinimumSpecial() {
        return this.minimumSpecial;
    }

    public void setMinimumSpecial(int minimumSpecial) {
        this.minimumSpecial = minimumSpecial;
    }

    public int getMinimumDistinctCharacterClasses() {
        return this.minimumDistinctCharacterClasses;
    }

    public void setMinimumDistinctCharacterClasses(int minimumDistinctCharacterClasses) {
        this.minimumDistinctCharacterClasses = minimumDistinctCharacterClasses;
    }

    public boolean getEnablePassphraseExemption() {
        return this.enablePassphraseExemption;
    }

    public void setEnablePassphraseExemption(boolean enablePassphraseExemption) {
        this.enablePassphraseExemption = enablePassphraseExemption;
    }

    public SimilarityCheck getSimilarityToUserInfo() {
        return this.similarityToUserInfo;
    }

    public void setSimilarityToUserInfo(SimilarityCheck similarityToUserInfo) {
        this.similarityToUserInfo = similarityToUserInfo;
    }

    public SimilarityCheck getSimilarityToOldPassword() {
        return this.similarityToOldPassword;
    }

    public void setSimilarityToOldPassword(SimilarityCheck similarityToOldPassword) {
        this.similarityToOldPassword = similarityToOldPassword;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("passwordPolicyMode", (Object)this.passwordPolicyMode).add("minimumLength", (Object)this.minimumLength).add("maximumLength", (Object)this.maximumLength).add("minimumLowercase", (Object)this.minimumLowercase).add("minimumUppercase", (Object)this.minimumUppercase).add("minimumDigits", (Object)this.minimumDigits).add("minimumSpecial", (Object)this.minimumSpecial).add("minimumDistinctCharacterClasses", (Object)this.minimumDistinctCharacterClasses).add("enablePassphraseExemption", (Object)this.enablePassphraseExemption).add("similarityToOldPassword", (Object)this.similarityToOldPassword).add("similarityToUserInfo", (Object)this.similarityToUserInfo).toString();
    }
}

