/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.config;

import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyMode;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;
import java.util.Properties;

public class ConfigItem {
    public static final int PASSPHRASE_THRESHOLD = 16;
    public static final IntegerConfigItem PASSWORD_POLICY_MODE = new IntegerConfigItem("passwordPolicyMode", 0, PasswordPolicyMode.values().length, PasswordPolicyMode.DISABLED.ordinal());
    public static final IntegerConfigItem MINIMUM_LENGTH = new IntegerConfigItem("minimumLength", 0, 32, 8);
    public static final IntegerConfigItem MAXIMUM_LENGTH = new IntegerConfigItem("maximumLength", 8, 255, 64);
    public static final IntegerConfigItem MINIMUM_LOWERCASE = new IntegerConfigItem("minimumLowercase", 0, 8, 0);
    public static final IntegerConfigItem MINIMUM_UPPERCASE = new IntegerConfigItem("minimumUppercase", 0, 8, 0);
    public static final IntegerConfigItem MINIMUM_DIGITS = new IntegerConfigItem("minimumDigits", 0, 8, 0);
    public static final IntegerConfigItem MINIMUM_SPECIAL = new IntegerConfigItem("minimumSpecial", 0, 8, 0);
    public static final IntegerConfigItem MINIMUM_CLASSES = new IntegerConfigItem("minimumClasses", 0, 4, 3);
    public static final BooleanConfigItem ENABLE_PASSPHRASE_EXEMPTION = new BooleanConfigItem("enablePassphraseExemption", false);
    public static final IntegerConfigItem SIMILARITY_TO_OLD_PASSWORD = new IntegerConfigItem("similarityToOldPassword", 0, SimilarityCheck.values().length, SimilarityCheck.LENIENT.ordinal());
    public static final IntegerConfigItem SIMILARITY_TO_USER_INFO = new IntegerConfigItem("similarityToUserInfo", 0, SimilarityCheck.values().length, SimilarityCheck.LENIENT.ordinal());
    private final String key;

    ConfigItem(String key) {
        this.key = key;
    }

    public String key() {
        return this.key;
    }

    public static class BooleanConfigItem
    extends ConfigItem {
        private final boolean defaultValue;

        BooleanConfigItem(String key, boolean def) {
            super(key);
            this.defaultValue = def;
        }

        public boolean load(Properties properties) {
            return this.valueOf(properties.getProperty(this.key()));
        }

        public boolean valueOf(String value) {
            if (value == null) {
                return this.defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        public void store(Properties properties, boolean value) {
            properties.setProperty(this.key(), String.valueOf(value));
        }

        public boolean defaultValue() {
            return this.defaultValue;
        }
    }

    public static class IntegerConfigItem
    extends ConfigItem {
        private final int minimumValue;
        private final int maximumValue;
        private final int defaultValue;

        IntegerConfigItem(String key, int min, int max, int def) {
            super(key);
            this.minimumValue = min;
            this.maximumValue = max;
            this.defaultValue = def;
        }

        public boolean isBelowMinimum(int value) {
            return value < this.minimumValue;
        }

        public boolean isAboveMaximum(int value) {
            return value > this.maximumValue;
        }

        public boolean isOutOfRange(int value) {
            return this.isBelowMinimum(value) || this.isAboveMaximum(value);
        }

        public int load(Properties properties) {
            return this.valueOf(properties.getProperty(this.key()));
        }

        public int defaultValue() {
            return this.defaultValue;
        }

        public int minimumValue() {
            return this.minimumValue;
        }

        public int maximumValue() {
            return this.maximumValue;
        }

        public int valueOf(String value) {
            if (value == null) {
                return this.defaultValue;
            }
            try {
                int x = Integer.parseInt(value.trim());
                if (x < this.minimumValue) {
                    return this.minimumValue;
                }
                if (x > this.maximumValue) {
                    return this.maximumValue;
                }
                return x;
            }
            catch (NumberFormatException nfe) {
                return this.defaultValue;
            }
        }

        public void store(Properties properties, int value) {
            properties.setProperty(this.key(), String.valueOf(value));
        }
    }
}

