/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.analysis;

import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;

public class CharacterClassAnalysis {
    private int lower;
    private int upper;
    private int space;
    private int punct;
    private int nonAscii;
    private int surrogatePair;
    private int digit;
    private int control;
    private int invalid;

    private CharacterClassAnalysis(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isHighSurrogate(c)) {
                int code;
                if (i + 1 >= len || !Character.isLowSurrogate(s.charAt(i + 1))) {
                    ++this.invalid;
                    continue;
                }
                if (((code = s.codePointAt(i++)) & 0xFFFE) == 65534) {
                    ++this.invalid;
                    continue;
                }
                ++this.surrogatePair;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                ++this.invalid;
                continue;
            }
            this.tally(c);
        }
    }

    private void tally(char c) {
        if (c >= 'a' && c <= 'z') {
            ++this.lower;
        } else if (c >= 'A' && c <= 'Z') {
            ++this.upper;
        } else if (c >= '0' && c <= '9') {
            ++this.digit;
        } else if (c == ' ') {
            ++this.space;
        } else if (Character.isISOControl(c)) {
            ++this.control;
        } else if (c < '\u007f') {
            ++this.punct;
        } else if (c >= '\ufffd') {
            ++this.invalid;
        } else {
            ++this.nonAscii;
        }
    }

    public static CharacterClassAnalysis of(@Nonnull String text) {
        return new CharacterClassAnalysis((String)Assertions.notNull((String)"text", (Object)text));
    }

    public int getLowercaseLetterCount() {
        return this.lower;
    }

    public int getUppercaseLetterCount() {
        return this.upper;
    }

    public int getDigitCount() {
        return this.digit;
    }

    public int getPunctuationCount() {
        return this.punct;
    }

    public int getSpaceCount() {
        return this.space;
    }

    public int getNonAsciiCount() {
        return this.nonAscii;
    }

    public int getSurrogatePairCount() {
        return this.surrogatePair;
    }

    public int getInvalidCount() {
        return this.invalid;
    }

    public int getControlCount() {
        return this.control;
    }

    public int getSpecialCount() {
        return this.punct + this.nonAscii + this.surrogatePair;
    }

    public int getCharacterClassCount() {
        int count = 0;
        if (this.upper > 0) {
            ++count;
        }
        if (this.lower > 0) {
            ++count;
        }
        if (this.digit > 0) {
            ++count;
        }
        if (this.getSpecialCount() > 0) {
            ++count;
        }
        return count;
    }
}

