/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy;

import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.plugin.user.WebErrorMessageImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;

public enum Message {
    MINIMUM_LENGTH("password.policy.error.minimum.length"),
    MAXIMUM_LENGTH("password.policy.error.maximum.length"),
    LEADING_OR_TRAILING_SPACES("password.policy.error.no.leading.or.trailing.spaces"),
    MINIMUM_UPPER("password.policy.error.minimum.uppercase"),
    MINIMUM_LOWER("password.policy.error.minimum.lowercase"),
    MINIMUM_DIGITS("password.policy.error.minimum.digits"),
    MINIMUM_SPECIAL("password.policy.error.minimum.special"),
    MINIMUM_CLASSES("password.policy.error.minimum.classes"),
    SIMILAR_TO_USER_INFO("password.policy.error.too.similar.to.user.info"),
    SIMILAR_TO_OLD_PASSWORD("password.policy.error.too.similar.to.old.password"),
    INVALID_CHARS("password.policy.error.no.invalid.chars"),
    ADMIN_MINIMUM_LENGTH_RANGE("password.policy.admin.error.minimum.length.range"),
    ADMIN_MAXIMUM_LENGTH_RANGE("password.policy.admin.error.maximum.length.range"),
    ADMIN_MAXIMUM_LENGTH_VS_MINIMUM("password.policy.admin.error.maximum.length.vs.minimum"),
    ADMIN_MAXIMUM_LENGTH_VS_CLASSES("password.policy.admin.error.maximum.length.vs.classes"),
    ADMIN_MAXIMUM_LENGTH_VS_PASSPHRASE("password.policy.admin.error.maximum.length.vs.passphrase"),
    ADMIN_PER_CLASS_RANGE("password.policy.admin.error.characters.for.class.range"),
    ADMIN_TOTAL_CLASSES_RANGE("password.policy.admin.error.total.classes.range"),
    ADMIN_CHANGES_SAVED("password.policy.admin.saved"),
    ADMIN_CHANGES_REJECTED("password.policy.admin.error.rejected");

    private final String key;

    private Message(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public WebErrorMessage error(I18nResolver i18n) {
        return Message.wrap(this.snippet(i18n));
    }

    public WebErrorMessage error(I18nResolver i18n, int arg) {
        return Message.wrap(this.snippet(i18n, arg));
    }

    public WebErrorMessage error(I18nResolver i18n, int arg0, int arg1) {
        return Message.wrap(this.snippet(i18n, arg0, arg1));
    }

    public String snippet(I18nResolver i18n) {
        return i18n.getText(this.key);
    }

    public String snippet(I18nResolver i18n, int arg) {
        return i18n.getText(this.key, new Serializable[]{Integer.valueOf(arg)});
    }

    public String snippet(I18nResolver i18n, int arg0, int arg1) {
        return i18n.getText(this.key, new Serializable[]{Integer.valueOf(arg0), Integer.valueOf(arg1)});
    }

    public String snippet(I18nHelper i18n) {
        return i18n.getText(this.key);
    }

    public String snippet(I18nHelper i18n, int arg) {
        return i18n.getText(this.key, (Object)arg);
    }

    public String snippet(I18nHelper i18n, int arg0, int arg1) {
        return i18n.getText(this.key, (Object)new Object[]{arg0, arg1});
    }

    private static WebErrorMessage wrap(String message) {
        return new WebErrorMessageImpl(message, message, null);
    }
}

