/**
 * Renders the header section of the optimizer plugin.
 * If the model has category it means we are rendering recommendation page, else home page
 */
define('jira/optimizer-plugin/headerView', ['jira-optimizer-plugin/marionette-2.1.0', 'jira/util/data/meta'], function (Marionette, meta) {
    'use strict';

    return Marionette.ItemView.extend({
        initialize: function initialize() {
            this.render();
        },
        serializeData: function serializeData() {
            var data = this.model.toJSON();
            data.mainPageHelpUrl = meta.get("cfo-main-page-help-url");
            data.globalContextsHelpUrl = meta.get("cfo-global-contexts-help-url");
            return data;
        },
        getTemplate: function getTemplate() {
            if (this.model.get('category')) {
                return CustomfieldAnalyzer.Templates.RecommendationHeader;
            }
            return CustomfieldAnalyzer.Templates.HomePageHeader;
        }
    });
});