/**
 * Since we have to support older versions of Jira, which has this mixed up with entire resources for browse projects
 * sadly we are bundling this copy with the plugin #thisisthejiraway
 */
define('jira/optimizer-plugin/paginationview', ['jquery', 'underscore', 'jira-optimizer-plugin/marionette-2.1.0', 'jira/util/navigation'], function ($, _, Marionette) {
    'use strict';

    return Marionette.ItemView.extend({
        template: CustomfieldAnalyzer.Templates.pagination,
        ui: {
            page: "li a",
            previous: "li.aui-nav-previous a",
            next: "li.aui-nav-next a"
        },
        events: {
            "click @ui.page": "clickPage",
            "click @ui.previous": "clickPrevious",
            "click @ui.next": "clickNext"
        },
        collectionEvents: {
            reset: "render"
        },
        modelEvents: {
            change: "render"
        },
        serializeData: function serializeData() {
            var data = _.extend({
                url: '/secure/admin/CustomfieldsAnalyzer.jspa'
            }, this.collection.state);
            data.firstPage = Math.max(data.currentPage - 5, data.firstPage);
            data.totalPages = data.lastPage;
            data.lastPage = Math.min(data.currentPage + 5, data.lastPage);
            return data;
        },
        clickPage: function clickPage(e) {
            e.preventDefault();
            // this must be integer value
            var pageNumber = +$(e.target).attr("data-page");
            if (pageNumber) {
                this.collection.getPage(pageNumber).done(this.render);
            }
        },
        clickPrevious: function clickPrevious() {
            this.trigger("navigate-previous");
        },
        clickNext: function clickNext() {
            this.trigger("navigate-next");
        }
    });
});