/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.processor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.annotation.OnEventNotAccepted;
import org.springframework.statemachine.annotation.OnExtendedStateChanged;
import org.springframework.statemachine.annotation.OnStateChanged;
import org.springframework.statemachine.annotation.OnStateEntry;
import org.springframework.statemachine.annotation.OnStateExit;
import org.springframework.statemachine.annotation.OnStateMachineError;
import org.springframework.statemachine.annotation.OnStateMachineStart;
import org.springframework.statemachine.annotation.OnStateMachineStop;
import org.springframework.statemachine.annotation.OnTransition;
import org.springframework.statemachine.annotation.OnTransitionEnd;
import org.springframework.statemachine.annotation.OnTransitionStart;
import org.springframework.statemachine.annotation.WithStateMachine;
import org.springframework.statemachine.config.configuration.StateMachineHandlerApplicationListener;
import org.springframework.statemachine.processor.StateMachineHandler;
import org.springframework.statemachine.processor.StateMachineRuntime;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StateMachineHandlerCallHelper<S, E>
implements InitializingBean,
BeanFactoryAware {
    private final Log log = LogFactory.getLog(StateMachineHandlerCallHelper.class);
    private final Map<String, List<CacheEntry>> cache = new HashMap<String, List<CacheEntry>>();
    private ListableBeanFactory beanFactory;
    private StateMachineHandlerApplicationListener stateMachineHandlerApplicationListener;
    private long last = Long.MIN_VALUE;

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory == null) {
            return;
        }
        if (!(this.beanFactory instanceof ListableBeanFactory)) {
            this.log.info((Object)("Beanfactory is not instance of ListableBeanFactory, was " + this.beanFactory + " thus Disabling handlers."));
            return;
        }
        if (this.beanFactory.containsBean("stateMachineHandlerApplicationListener")) {
            this.stateMachineHandlerApplicationListener = (StateMachineHandlerApplicationListener)this.beanFactory.getBean("stateMachineHandlerApplicationListener", StateMachineHandlerApplicationListener.class);
        }
        for (StateMachineHandler handler : this.beanFactory.getBeansOfType(StateMachineHandler.class).values()) {
            Annotation annotation = handler.getAnnotation();
            Object metaAnnotation = handler.getMetaAnnotation();
            WithStateMachine withStateMachine = (WithStateMachine)AnnotationUtils.findAnnotation(handler.getBeanClass(), WithStateMachine.class);
            if (StringUtils.hasText((String)withStateMachine.id())) {
                this.updateCache(metaAnnotation.annotationType().getName() + withStateMachine.id(), new CacheEntry(handler, annotation, (Annotation)metaAnnotation));
                continue;
            }
            if (!StringUtils.hasText((String)withStateMachine.name())) continue;
            this.updateCache(metaAnnotation.annotationType().getName() + withStateMachine.name(), new CacheEntry(handler, annotation, (Annotation)metaAnnotation));
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            return;
        }
        Assert.state((boolean)(beanFactory instanceof ListableBeanFactory), (String)("Bean factory must be instance of ListableBeanFactory, was " + beanFactory));
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void callOnStateChanged(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateChanged.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getSource(), stateContext.getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnStateEntry(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateEntry.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getSource(), stateContext.getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnStateExit(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateExit.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getSource(), stateContext.getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnEventNotAccepted(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnEventNotAccepted.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            E event = stateContext.getEvent();
            if (event != null) {
                if (!this.annotationHandlerEventVariableMatch(entry.metaAnnotation, new String[]{event.toString()})) continue;
                handlersList.add(entry.handler);
                continue;
            }
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnTransitionStart(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnTransitionStart.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getTransition().getSource(), stateContext.getTransition().getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnTransition(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnTransition.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getTransition().getSource(), stateContext.getTransition().getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnTransitionEnd(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnTransitionEnd.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerSourceTargetMatch((String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"source"), (String[])AnnotationUtils.getValue((Annotation)entry.metaAnnotation, (String)"target"), entry.annotation, stateContext.getTransition().getSource(), stateContext.getTransition().getTarget())) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnStateMachineStart(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateMachineStart.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnStateMachineStop(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateMachineStop.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnStateMachineError(String stateMachineId, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnStateMachineError.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    public void callOnExtendedStateChanged(String stateMachineId, Object key, Object value, StateContext<S, E> stateContext) {
        if (!StringUtils.hasText((String)stateMachineId)) {
            return;
        }
        ArrayList handlersList = new ArrayList();
        String cacheKey = OnExtendedStateChanged.class.getName() + stateMachineId;
        List<CacheEntry> list = this.getCacheEntries(cacheKey);
        if (list == null) {
            return;
        }
        for (CacheEntry entry : list) {
            if (!this.annotationHandlerVariableMatch(entry.metaAnnotation, key)) continue;
            handlersList.add(entry.handler);
        }
        this.getStateMachineHandlerResults(handlersList, stateContext);
    }

    private void updateCache(String key, CacheEntry cacheEntry) {
        List<CacheEntry> list = this.cache.get(key);
        if (list == null) {
            list = new ArrayList<CacheEntry>();
            this.cache.put(key, list);
        }
        list.add(cacheEntry);
    }

    private synchronized List<CacheEntry> getCacheEntries(String cacheKey) {
        Long l;
        if (this.stateMachineHandlerApplicationListener != null && (l = this.stateMachineHandlerApplicationListener.getLastRefreshTime()) != null && l < System.currentTimeMillis() && this.last != l) {
            this.cache.clear();
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to update handler cache", (Throwable)e);
            }
            this.last = l;
        }
        return this.cache.get(cacheKey);
    }

    private boolean annotationHandlerVariableMatch(Annotation annotation, Object key) {
        boolean handle = false;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        Object object = annotationAttributes.get("key");
        Collection<String> scoll = StateMachineUtils.toStringCollection(object);
        if (!scoll.isEmpty()) {
            if (StateMachineUtils.containsAtleastOne(scoll, StateMachineUtils.toStringCollection(key))) {
                handle = true;
            }
        } else {
            handle = true;
        }
        return handle;
    }

    private boolean annotationHandlerEventVariableMatch(Annotation annotation, Object key) {
        boolean handle = false;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        Object object = annotationAttributes.get("event");
        Collection<String> scoll = StateMachineUtils.toStringCollection(object);
        if (!scoll.isEmpty()) {
            if (StateMachineUtils.containsAtleastOne(scoll, StateMachineUtils.toStringCollection(key))) {
                handle = true;
            }
        } else {
            handle = true;
        }
        return handle;
    }

    private boolean annotationHandlerSourceTargetMatch(String[] msources, String[] mtargets, Annotation methodAnnotation, State<S, E> sourceState, State<S, E> targetState) {
        Collection<String> tcoll;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)methodAnnotation);
        Object source = annotationAttributes.get("source");
        Object target = annotationAttributes.get("target");
        Collection<String> scoll = StateMachineUtils.toStringCollection(source);
        if (scoll.isEmpty() && msources != null) {
            scoll = Arrays.asList(msources);
        }
        if ((tcoll = StateMachineUtils.toStringCollection(target)).isEmpty() && mtargets != null) {
            tcoll = Arrays.asList(mtargets);
        }
        boolean handle = false;
        if (!scoll.isEmpty() && !tcoll.isEmpty()) {
            if (sourceState != null && targetState != null && StateMachineUtils.containsAtleastOne(scoll, StateMachineUtils.toStringCollection(sourceState.getIds())) && StateMachineUtils.containsAtleastOne(tcoll, StateMachineUtils.toStringCollection(targetState.getIds()))) {
                handle = true;
            }
        } else if (!scoll.isEmpty()) {
            if (sourceState != null && StateMachineUtils.containsAtleastOne(scoll, StateMachineUtils.toStringCollection(sourceState.getIds()))) {
                handle = true;
            }
        } else if (!tcoll.isEmpty()) {
            if (targetState != null && StateMachineUtils.containsAtleastOne(tcoll, StateMachineUtils.toStringCollection(targetState.getIds()))) {
                handle = true;
            }
        } else if (scoll.isEmpty() && tcoll.isEmpty()) {
            handle = true;
        }
        return handle;
    }

    private List<Object> getStateMachineHandlerResults(List<StateMachineHandler<? extends Annotation, S, E>> stateMachineHandlers, final StateContext<S, E> stateContext) {
        StateMachineRuntime runtime = new StateMachineRuntime<S, E>(){

            @Override
            public StateContext<S, E> getStateContext() {
                return stateContext;
            }
        };
        ArrayList<Object> results = new ArrayList<Object>();
        for (StateMachineHandler<Annotation, S, E> handler : stateMachineHandlers) {
            try {
                results.add(handler.handle(runtime));
            }
            catch (Throwable e) {
                this.log.error((Object)("Error processing handler " + handler), e);
            }
        }
        return results;
    }

    private class CacheEntry {
        final StateMachineHandler<? extends Annotation, S, E> handler;
        final Annotation annotation;
        final Annotation metaAnnotation;

        public CacheEntry(StateMachineHandler<? extends Annotation, S, E> handler, Annotation annotation, Annotation metaAnnotation) {
            this.handler = handler;
            this.annotation = annotation;
            this.metaAnnotation = metaAnnotation;
        }
    }
}

