/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.guard.Guard;

public class DefaultStateMachineComponentResolver<S, E>
implements StateMachineComponentResolver<S, E> {
    private BeanFactory beanFactory;
    private final Map<String, Action<S, E>> registeredActions;
    private final Map<String, Guard<S, E>> registeredGuards;

    public DefaultStateMachineComponentResolver() {
        this(null, null, null);
    }

    public DefaultStateMachineComponentResolver(Map<String, Action<S, E>> registeredActions, Map<String, Guard<S, E>> registeredGuards) {
        this(null, registeredActions, registeredGuards);
    }

    public DefaultStateMachineComponentResolver(BeanFactory beanFactory, Map<String, Action<S, E>> registeredActions, Map<String, Guard<S, E>> registeredGuards) {
        this.beanFactory = beanFactory;
        this.registeredActions = registeredActions != null ? registeredActions : new HashMap();
        this.registeredGuards = registeredGuards != null ? registeredGuards : new HashMap();
    }

    @Override
    public Action<S, E> resolveAction(String id) {
        Action a = null;
        a = this.registeredActions.get(id);
        if (a == null && this.beanFactory != null) {
            a = (Action)this.beanFactory.getBean(id, Action.class);
        }
        return a;
    }

    @Override
    public Guard<S, E> resolveGuard(String id) {
        Guard g = null;
        g = this.registeredGuards.get(id);
        if (g == null && this.beanFactory != null) {
            g = (Guard)this.beanFactory.getBean(id, Guard.class);
        }
        return g;
    }

    public void registerAction(String id, Action<S, E> action) {
        this.registeredActions.put(id, action);
    }

    public void registerGuard(String id, Guard<S, E> guard) {
        this.registeredGuards.put(id, guard);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

