/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config;

import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.config.ObjectStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfig;
import org.springframework.statemachine.config.builders.StateMachineConfigBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineConfigurer;
import org.springframework.statemachine.config.builders.StateMachineModelBuilder;
import org.springframework.statemachine.config.builders.StateMachineModelConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateBuilder;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.ObjectPostProcessor;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionsData;

public class StateMachineBuilder {
    public static <S, E> Builder<S, E> builder() {
        return new Builder();
    }

    private static class BuilderStateMachineConfigurerAdapter<S, E>
    implements StateMachineConfigurer<S, E> {
        private StateMachineModelBuilder<S, E> modelBuilder;
        private StateMachineTransitionBuilder<S, E> transitionBuilder;
        private StateMachineStateBuilder<S, E> stateBuilder;
        private StateMachineConfigurationBuilder<S, E> configurationBuilder;

        BuilderStateMachineConfigurerAdapter() {
            try {
                this.getStateMachineModelBuilder();
                this.getStateMachineTransitionBuilder();
                this.getStateMachineStateBuilder();
                this.getStateMachineConfigurationBuilder();
            }
            catch (Exception e) {
                throw new StateMachineException("Error instantiating builder adapter", e);
            }
        }

        @Override
        public void init(StateMachineConfigBuilder<S, E> config) throws Exception {
            config.setSharedObject(StateMachineModelBuilder.class, this.getStateMachineModelBuilder());
            config.setSharedObject(StateMachineTransitionBuilder.class, this.getStateMachineTransitionBuilder());
            config.setSharedObject(StateMachineStateBuilder.class, this.getStateMachineStateBuilder());
            config.setSharedObject(StateMachineConfigurationBuilder.class, this.getStateMachineConfigurationBuilder());
        }

        @Override
        public void configure(StateMachineConfigBuilder<S, E> builder) throws Exception {
        }

        @Override
        public boolean isAssignable(AnnotationBuilder<StateMachineConfig<S, E>> builder) {
            return false;
        }

        @Override
        public void configure(StateMachineModelConfigurer<S, E> model) throws Exception {
        }

        @Override
        public void configure(StateMachineConfigurationConfigurer<S, E> config) throws Exception {
        }

        @Override
        public void configure(StateMachineStateConfigurer<S, E> states) throws Exception {
        }

        @Override
        public void configure(StateMachineTransitionConfigurer<S, E> transitions) throws Exception {
        }

        protected final StateMachineModelBuilder<S, E> getStateMachineModelBuilder() throws Exception {
            if (this.modelBuilder != null) {
                return this.modelBuilder;
            }
            this.modelBuilder = new StateMachineModelBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
            this.configure(this.modelBuilder);
            return this.modelBuilder;
        }

        protected final StateMachineTransitionBuilder<S, E> getStateMachineTransitionBuilder() throws Exception {
            if (this.transitionBuilder != null) {
                return this.transitionBuilder;
            }
            this.transitionBuilder = new StateMachineTransitionBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
            return this.transitionBuilder;
        }

        protected final StateMachineStateBuilder<S, E> getStateMachineStateBuilder() throws Exception {
            if (this.stateBuilder != null) {
                return this.stateBuilder;
            }
            this.stateBuilder = new StateMachineStateBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
            return this.stateBuilder;
        }

        protected final StateMachineConfigurationBuilder<S, E> getStateMachineConfigurationBuilder() throws Exception {
            if (this.configurationBuilder != null) {
                return this.configurationBuilder;
            }
            this.configurationBuilder = new StateMachineConfigurationBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
            return this.configurationBuilder;
        }
    }

    public static class Builder<S, E> {
        private StateMachineConfigBuilder<S, E> builder;
        private BuilderStateMachineConfigurerAdapter<S, E> adapter = new BuilderStateMachineConfigurerAdapter();

        public Builder() {
            this.builder = new StateMachineConfigBuilder();
        }

        public StateMachineModelConfigurer<S, E> configureModel() {
            return ((BuilderStateMachineConfigurerAdapter)this.adapter).modelBuilder;
        }

        public StateMachineConfigurationConfigurer<S, E> configureConfiguration() {
            return ((BuilderStateMachineConfigurerAdapter)this.adapter).configurationBuilder;
        }

        public StateMachineStateConfigurer<S, E> configureStates() {
            return ((BuilderStateMachineConfigurerAdapter)this.adapter).stateBuilder;
        }

        public StateMachineTransitionConfigurer<S, E> configureTransitions() {
            return ((BuilderStateMachineConfigurerAdapter)this.adapter).transitionBuilder;
        }

        public StateMachine<S, E> build() {
            try {
                this.builder.apply(this.adapter);
                StateMachineConfig stateMachineConfig = (StateMachineConfig)this.builder.getOrBuild();
                TransitionsData stateMachineTransitions = stateMachineConfig.getTransitions();
                StatesData stateMachineStates = stateMachineConfig.getStates();
                ConfigurationData stateMachineConfigurationConfig = stateMachineConfig.getStateMachineConfigurationConfig();
                ObjectStateMachineFactory stateMachineFactory = null;
                stateMachineFactory = stateMachineConfig.getModel() != null && stateMachineConfig.getModel().getFactory() != null ? new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, null, null), stateMachineConfig.getModel().getFactory()) : new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, stateMachineStates, stateMachineTransitions), null);
                stateMachineFactory.setHandleAutostartup(stateMachineConfigurationConfig.isAutoStart());
                if (stateMachineConfigurationConfig.getBeanFactory() != null) {
                    stateMachineFactory.setBeanFactory(stateMachineConfigurationConfig.getBeanFactory());
                }
                if (stateMachineConfigurationConfig.getTaskExecutor() != null) {
                    stateMachineFactory.setTaskExecutor(stateMachineConfigurationConfig.getTaskExecutor());
                } else {
                    stateMachineFactory.setTaskExecutor((TaskExecutor)new SyncTaskExecutor());
                }
                if (stateMachineConfigurationConfig.getTaskScheduler() != null) {
                    stateMachineFactory.setTaskScheduler(stateMachineConfigurationConfig.getTaskScheduler());
                } else {
                    stateMachineFactory.setTaskScheduler((TaskScheduler)new ConcurrentTaskScheduler());
                }
                return stateMachineFactory.getStateMachine();
            }
            catch (Exception e) {
                throw new StateMachineException("Error building state machine", e);
            }
        }
    }
}

