/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.optimizer.ao.PropertiesDao;
import com.atlassian.jira.optimizer.api.OptimizerService;
import com.atlassian.jira.optimizer.api.RecommendationGenerationStatus;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.beans.RecommendationCategoryBean;
import com.atlassian.jira.optimizer.beans.RecommendationsInfoBean;
import com.atlassian.jira.optimizer.events.ScanFailedEvent;
import com.atlassian.jira.optimizer.events.ScanFinishedEvent;
import com.atlassian.jira.optimizer.events.ScanStartedEvent;
import com.atlassian.jira.optimizer.impl.RecommendationsManager;
import com.atlassian.jira.optimizer.impl.recommendations.CustomFieldsStatsProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.StateMachineBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;

@ExportAsService(value={OptimizerService.class})
@Named(value="optimizerService")
public class DefaultOptimizerService
implements OptimizerService {
    private static final Logger log = LoggerFactory.getLogger(DefaultOptimizerService.class);
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final CustomFieldsStatsProvider customFieldsStatsProvider;
    private final PropertiesDao propertiesDao;
    private final RecommendationsManager recommendationsManager;
    private final StateMachine<RecommendationGenerationStatus, Event> stateMachine;

    @Inject
    public DefaultOptimizerService(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport EventPublisher eventPublisher, RecommendationsManager recommendationsManager, CustomFieldsStatsProvider customFieldsStatsProvider, PropertiesDao propertiesDao) throws Exception {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.customFieldsStatsProvider = customFieldsStatsProvider;
        this.propertiesDao = propertiesDao;
        this.recommendationsManager = recommendationsManager;
        this.stateMachine = this.buildMachine();
        this.stateMachine.start();
        recommendationsManager.setFinishListener(() -> this.stateMachine.sendEvent(Event.COMPLETE));
        recommendationsManager.setFailListener(() -> this.stateMachine.sendEvent(Event.FAIL));
    }

    @Override
    public String getName() {
        if (this.applicationProperties != null) {
            return "optimizerService: " + this.applicationProperties.getDisplayName();
        }
        return "optimizerService";
    }

    @Override
    public List<RecommendationBean> getRecommendations(String category) {
        return this.recommendationsManager.getRecommendations().stream().filter(r -> category.equals(r.getCategory())).sorted().collect(Collectors.toList());
    }

    @Override
    public synchronized void refreshRecommendations() {
        this.stateMachine.sendEvent(Event.REFRESH);
    }

    @Override
    public RecommendationGenerationStatus getStatus() {
        return this.propertiesDao.getRecommendationGenerationStatus();
    }

    @Override
    public RecommendationsInfoBean getRecommendationsInfo() {
        Map<String, List<RecommendationBean>> recommendations = this.recommendationsManager.getRecommendations().stream().collect(Collectors.groupingBy(RecommendationBean::getCategory));
        RecommendationGenerationStatus recommendationGenerationStatus = this.propertiesDao.getRecommendationGenerationStatus();
        RecommendationsInfoBean recommendationsInfo = new RecommendationsInfoBean(recommendationGenerationStatus, this.propertiesDao.getLastScannedDate().toEpochMilli(), recommendations.entrySet().stream().map(entry -> new RecommendationCategoryBean((String)entry.getKey(), ((List)entry.getValue()).size())).collect(Collectors.toList()), this.getProgress(recommendationGenerationStatus));
        recommendationsInfo.setProgress(this.getProgress(recommendationsInfo.getStatus()));
        return recommendationsInfo;
    }

    private double getProgress(RecommendationGenerationStatus status) {
        switch (status) {
            case IN_PROGRESS: {
                return this.recommendationsManager.getProgress();
            }
            case NOT_STARTED: {
                return 0.0;
            }
        }
        return 1.0;
    }

    @Override
    public void stop() {
        this.stateMachine.sendEvent(Event.STOP);
    }

    private StateMachine<RecommendationGenerationStatus, Event> buildMachine() throws Exception {
        StateMachineBuilder.Builder builder = StateMachineBuilder.builder();
        builder.configureStates().withStates().initial(RecommendationGenerationStatus.NOT_STARTED).stateEntry(RecommendationGenerationStatus.IN_PROGRESS, item -> {
            this.eventPublisher.publish((Object)new ScanStartedEvent());
            this.propertiesDao.setStartScanDate(Instant.now());
            this.propertiesDao.setRecommendationGenerationStatus(RecommendationGenerationStatus.IN_PROGRESS);
            this.recommendationsManager.submitJobs();
        }).stateEntry(RecommendationGenerationStatus.STOPPED, item -> {
            this.recommendationsManager.stop();
            this.propertiesDao.setRecommendationGenerationStatus(RecommendationGenerationStatus.STOPPED);
        }).stateEntry(RecommendationGenerationStatus.FAILED, item -> {
            this.propertiesDao.setRecommendationGenerationStatus(RecommendationGenerationStatus.FAILED);
            this.eventPublisher.publish((Object)new ScanFailedEvent(Duration.between(this.propertiesDao.getStartScanDate(), Instant.now()).toMillis()));
        }).stateEntry(RecommendationGenerationStatus.DONE, item -> {
            this.propertiesDao.setLastScannedDate(Instant.now());
            this.propertiesDao.setRecommendationGenerationStatus(RecommendationGenerationStatus.DONE);
            Map<String, List<RecommendationBean>> recommendations = this.recommendationsManager.getRecommendations().stream().collect(Collectors.groupingBy(RecommendationBean::getCategory));
            Duration scanDuration = Duration.between(this.propertiesDao.getStartScanDate(), this.propertiesDao.getLastScannedDate());
            log.info("Finished generating recommendations in {}s", (Object)scanDuration.getSeconds());
            this.publishAnalytics(scanDuration, recommendations);
        }).states(EnumSet.allOf(RecommendationGenerationStatus.class));
        ((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)builder.configureTransitions().withExternal().source(RecommendationGenerationStatus.NOT_STARTED)).target(RecommendationGenerationStatus.IN_PROGRESS).event(Event.REFRESH)).and()).withExternal().source(RecommendationGenerationStatus.DONE)).target(RecommendationGenerationStatus.IN_PROGRESS).event(Event.REFRESH)).and()).withExternal().source(RecommendationGenerationStatus.FAILED)).target(RecommendationGenerationStatus.IN_PROGRESS).event(Event.REFRESH)).and()).withExternal().source(RecommendationGenerationStatus.STOPPED)).target(RecommendationGenerationStatus.IN_PROGRESS).event(Event.REFRESH)).and()).withExternal().source(RecommendationGenerationStatus.IN_PROGRESS)).target(RecommendationGenerationStatus.DONE).event(Event.COMPLETE)).and()).withExternal().source(RecommendationGenerationStatus.IN_PROGRESS)).target(RecommendationGenerationStatus.FAILED).event(Event.FAIL)).and()).withExternal().source(RecommendationGenerationStatus.IN_PROGRESS)).target(RecommendationGenerationStatus.STOPPED).event(Event.STOP);
        return builder.build();
    }

    private void publishAnalytics(Duration scanDuration, Map<String, List<RecommendationBean>> recommendations) {
        Map<String, Map<String, Long>> recommendationToImpactHistogram = recommendations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toHistogram((List)e.getValue())));
        Map<String, Integer> recommendationCount = recommendations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).size()));
        this.eventPublisher.publish((Object)new ScanFinishedEvent(scanDuration.toMillis(), this.customFieldsStatsProvider.getStats(), recommendationCount, recommendationToImpactHistogram));
    }

    private Map<String, Long> toHistogram(List<RecommendationBean> recommendationBeans) {
        return recommendationBeans.stream().collect(Collectors.groupingBy(l -> String.format("%.1f", l.getPerformanceImpact()), Collectors.counting()));
    }

    public static enum Event {
        REFRESH,
        STOP,
        FAIL,
        COMPLETE;

    }
}

