/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.optimizer.events.ArchivedProjectSearchFail;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ArchivedProjectSQLSearcher {
    private final EventPublisher eventPublisher;

    @Inject
    public ArchivedProjectSQLSearcher(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> getArchivedProjectsUsingCfUsingSQL(CustomField customField, Set<Long> archivedProjectsIds) {
        try (Connection conn = DefaultOfBizConnectionFactory.getInstance().getConnection();){
            String query = "SELECT DISTINCT issue.project FROM customfieldvalue cfv INNER JOIN jiraissue issue ON cfv.issue = issue.id WHERE customfield = " + customField.getIdAsLong() + " AND issue.project IN (" + archivedProjectsIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
            ArrayList<Long> foundProjects = new ArrayList<Long>();
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setQueryTimeout(60);
            ResultSet r = statement.executeQuery();
            while (r.next()) {
                foundProjects.add(r.getLong(1));
            }
            ArrayList<Long> arrayList = foundProjects;
            return arrayList;
        }
        catch (SQLException e) {
            this.eventPublisher.publish((Object)new ArchivedProjectSearchFail());
            return Collections.emptyList();
        }
    }
}

