/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.ao;

import com.atlassian.jira.optimizer.api.RecommendationGenerationStatus;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class PropertiesDao {
    private final PluginSettings pluginSettings;

    @Inject
    public PropertiesDao(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public Instant getLastScannedDate() {
        return this.stringToInstant((String)this.pluginSettings.get("lastCheckDate"));
    }

    public void setLastScannedDate(Instant lastScannedDate) {
        this.pluginSettings.put("lastCheckDate", (Object)this.instantToString(lastScannedDate));
    }

    public Instant getStartScanDate() {
        return this.stringToInstant((String)this.pluginSettings.get("startScanDate"));
    }

    public void setStartScanDate(Instant startScannedDate) {
        this.pluginSettings.put("startScanDate", (Object)this.instantToString(startScannedDate));
    }

    public RecommendationGenerationStatus getRecommendationGenerationStatus() {
        return Optional.ofNullable((String)this.pluginSettings.get("recommendationGenerationStatus")).map(RecommendationGenerationStatus::valueOf).orElse(RecommendationGenerationStatus.NOT_STARTED);
    }

    public void setRecommendationGenerationStatus(RecommendationGenerationStatus status) {
        this.pluginSettings.put("recommendationGenerationStatus", (Object)status.toString());
    }

    private String instantToString(Instant instant) {
        return Long.toString(instant.toEpochMilli());
    }

    private Instant stringToInstant(String string) {
        return Optional.ofNullable(string).map(Long::parseLong).map(Instant::ofEpochMilli).orElseGet(() -> Instant.ofEpochMilli(0L));
    }
}

