AJS.test.require(["com.atlassian.jira.plugins.jira-importers-github-plugin:webResources"], function () {
    module("lib/log", {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
        }
    });

    test("it is callable and takes a single string argument", function () {
        var sentinel = "(&H@…ouanfa~!@^#*!&(H(D!ª•";
        var log = this.context.require("jira-github-importer/lib/log");
        log(sentinel);
        expect(0);
    });

    test("it proxies to AJS.log", function () {
        var window = {AJS: {log: sinon.stub()}};
        var sentinel = "(&H@…ouanfa~!@^#*!&(H(D!ª•";

        var log = this.context
            .mock("jira-github-importer/lib/window", window)
            .require("jira-github-importer/lib/log");

        log(sentinel);
        deepEqual(window.AJS.log.args, [[sentinel]]);
    });
});
