/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.atlassian.jira.plugins.importer.github.importer.markup.AttachmentsConverter;
import com.atlassian.jira.plugins.importer.github.importer.markup.CodeFragmentConverter;
import com.atlassian.jira.plugins.importer.github.importer.markup.ConversionResult;
import com.atlassian.jira.plugins.importer.github.importer.markup.MentionConverter;
import com.atlassian.jira.plugins.importer.github.importer.markup.NoFormatFragmentConverter;
import com.atlassian.jira.plugins.importer.github.importer.markup.SimpleConverter;
import com.atlassian.jira.plugins.importer.github.importer.markup.SimpleSyntax;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.egit.github.core.Repository;

public class MarkupConverter {
    private final DataBean dataBean;
    private final ConfigBean configBean;

    public MarkupConverter(DataBean dataBean, ConfigBean configBean) {
        this.dataBean = dataBean;
        this.configBean = configBean;
    }

    public ConversionResult convert(Repository repository, String content) {
        String currentContent = content;
        List<NoFormatFragmentConverter> noFormatConverters = this.getNoFormatConverters();
        for (NoFormatFragmentConverter noFormatFragmentConverter : noFormatConverters) {
            currentContent = noFormatFragmentConverter.removeNoFormatFragments(currentContent);
        }
        ConversionResult afterAttachments = this.getAttachmentConverter().convert(repository, currentContent);
        currentContent = afterAttachments.getConvertedContent();
        for (SimpleConverter simpleConverter : this.getSimpleConverters()) {
            currentContent = simpleConverter.convertMarkdown(currentContent);
        }
        for (NoFormatFragmentConverter noFormatFragmentConverter : noFormatConverters) {
            currentContent = noFormatFragmentConverter.putBackNoFormatFragments(currentContent);
        }
        return new ConversionResult(afterAttachments.getAttachments(), currentContent);
    }

    private List<NoFormatFragmentConverter> getNoFormatConverters() {
        return ImmutableList.of((Object)new CodeFragmentConverter());
    }

    private List<SimpleConverter> getSimpleConverters() {
        return ImmutableList.of((Object)new SimpleSyntax(), (Object)new MentionConverter(this.dataBean));
    }

    private AttachmentsConverter getAttachmentConverter() {
        return new AttachmentsConverter(this.configBean);
    }
}

