/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.fetch.Project;
import com.atlassian.jira.plugins.importer.github.importer.GithubIssueConverter;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.User;

public class DataBean
extends AbstractDataBean<ConfigBean> {
    public static final String ISSUE_KEY_REGEX = "#([0-9]+)";
    private final ConfigBean configBean;
    private final GithubImportProcessBean importProcessBean;
    private final GithubIssueConverter converter;
    private Set<ExternalUser> allUserCache;

    public DataBean(ConfigBean configBean, GithubImportProcessBean importProcessBean, I18nHelper i18nHelper) {
        super((AbstractConfigBean2)configBean);
        this.configBean = configBean;
        this.importProcessBean = importProcessBean;
        this.converter = new GithubIssueConverter(configBean, ComponentAccessor.getConstantsManager(), ComponentAccessor.getWorkflowManager(), ComponentAccessor.getWorkflowSchemeManager(), this, i18nHelper);
    }

    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        if (this.allUserCache == null) {
            this.allUserCache = new HashSet<ExternalUser>();
            for (Issue issue : this.configBean.getGithubDataService().getAllIssues()) {
                this.allUserCache.add(this.convertUser(issue.getUser()));
                if (issue.getAssignee() != null) {
                    this.allUserCache.add(this.convertUser(issue.getAssignee()));
                }
                List<Comment> comments = this.configBean.getGithubDataService().getComments(issue);
                for (Comment comment : comments) {
                    this.allUserCache.add(this.convertUser(comment.getUser()));
                }
            }
        }
        return this.allUserCache;
    }

    public Set<ExternalUser> getAllUserCache() {
        return this.allUserCache;
    }

    private ExternalUser convertUser(User userWithNoDetails) {
        Optional<User> userWithDetails = this.configBean.getGithubDataService().getUserWithDetails(userWithNoDetails.getLogin());
        User user = userWithDetails.isPresent() ? (User)userWithDetails.get() : userWithNoDetails;
        ExternalUser externalUser = new ExternalUser();
        externalUser.setName(user.getLogin());
        externalUser.setFullname(user.getName());
        externalUser.setEmail(user.getEmail());
        return externalUser;
    }

    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet((Iterable)Iterables.transform(this.configBean.getGithubDataService().getProjects(), (Function)new Function<Project, ExternalProject>(){

            public ExternalProject apply(Project project) {
                ExternalProject externalProject = new ExternalProject();
                String externalName = project.getRepository().generateId();
                externalProject.setKey(DataBean.this.configBean.getProjectKey(externalName));
                externalProject.setName(DataBean.this.configBean.getProjectName(externalName));
                externalProject.setLead(DataBean.this.configBean.getProjectLead(externalName));
                externalProject.setId(project.getRepository().generateId());
                externalProject.setExternalName(externalName);
                externalProject.setDescription(project.getRepository().getDescription());
                externalProject.setUrl(project.getRepository().getHtmlUrl());
                externalProject.setWorkflowSchemeName(DataBean.this.configBean.getSchemeStatusMapping().getWorkflowSchemeName());
                return externalProject;
            }
        }));
    }

    public Iterator<ExternalIssue> getIssuesIterator(final ExternalProject externalProject, final ImportLogger importLogger) {
        final Project project = this.configBean.getGithubDataService().getProjectByName(externalProject.getExternalName());
        return new Iterator<ExternalIssue>(){
            Iterator<Issue> issueIterator;
            ExternalIssue next;
            {
                this.issueIterator = project.getIssues().iterator();
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                while (this.issueIterator.hasNext() && this.next == null) {
                    Issue githubIssue = this.issueIterator.next();
                    try {
                        this.next = DataBean.this.converter.convertIssue(project, githubIssue, importLogger, externalProject);
                    }
                    catch (Exception e) {
                        importLogger.fail((Throwable)e, "Failed convert issue #" + githubIssue.getNumber(), new Object[0]);
                    }
                }
                return this.next != null;
            }

            @Override
            public ExternalIssue next() {
                ExternalIssue externalIssue = this.next;
                this.next = null;
                return externalIssue;
            }

            @Override
            public void remove() {
                this.issueIterator.remove();
            }
        };
    }

    public Collection<ExternalLink> getLinks(ImportLogger log) {
        return Lists.newArrayList();
    }

    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        return this.configBean.getGithubDataService().getAllIssues().size();
    }

    public String getUnusedUsersGroup() {
        return "github_import_unused";
    }

    public void cleanUp() {
        this.importProcessBean.cleanup();
    }

    public String getIssueKeyRegex() {
        return ISSUE_KEY_REGEX;
    }

    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        Project project = this.configBean.getGithubDataService().getProjectByName(externalProject.getExternalName());
        ArrayList<ExternalVersion> externalVersions = new ArrayList<ExternalVersion>();
        for (Milestone milestone : project.getMilestones()) {
            ExternalVersion version = new ExternalVersion();
            Date dueOn = milestone.getDueOn();
            version.setName(milestone.getTitle());
            version.setDescription(milestone.getDescription());
            version.setReleaseDate(dueOn);
            version.setReleased("closed".equals(milestone.getState()));
            externalVersions.add(version);
        }
        return externalVersions;
    }

    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return Collections.emptyList();
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger importLogger) {
        return this.converter.downloadAttachmentsForIssue(externalIssue, importLogger);
    }
}

