/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;

public class GithubProjectMappingPage
extends ImporterProjectMappingsPage {
    protected final ProjectManager projectManager;
    protected final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final WorkflowSchemeManager workflowSchemeManager;

    public GithubProjectMappingPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport ProjectService projectService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport CreateProjectManager createProjectManager, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
        super(usageTrackingService, projectService, webInterfaceManager, pluginAccessor, projectManager, createProjectManager);
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        Collection<Project> existingDestinationProjects = this.getExistingDestinationProjects();
        if (this.isMoreThanOneIssueTypeScheme(existingDestinationProjects)) {
            this.addErrorMessage(this.getI18nHelper().getText("com.atlassian.jira.plugins.importer.github.step.projectmapping.issuetypescheme.error"));
        }
        if (this.isMoreThanOneWorkflowSchemes(existingDestinationProjects)) {
            this.addErrorMessage(this.getI18nHelper().getText("com.atlassian.jira.plugins.importer.github.step.projectmapping.workflowscheme.error"));
        }
    }

    protected boolean isMoreThanOneIssueTypeScheme(Iterable<Project> projects) {
        Iterable issueTypeSchemeIds = Iterables.transform(projects, (Function)new Function<Project, Long>(){

            public Long apply(Project input) {
                FieldConfigScheme configScheme = GithubProjectMappingPage.this.issueTypeSchemeManager.getConfigScheme(input);
                return configScheme != null ? configScheme.getId() : null;
            }
        });
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)issueTypeSchemeIds, (Predicate)Predicates.notNull())).size() > 1;
    }

    protected boolean isMoreThanOneWorkflowSchemes(Iterable<Project> projects) {
        Iterable workflowSchemesIds = Iterables.transform(projects, (Function)new Function<Project, Long>(){

            public Long apply(Project input) {
                AssignableWorkflowScheme workflowSchemeObj = GithubProjectMappingPage.this.workflowSchemeManager.getWorkflowSchemeObj(input);
                return workflowSchemeObj.getId() != null ? workflowSchemeObj.getId() : null;
            }
        });
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)workflowSchemesIds, (Predicate)Predicates.notNull())).size() > 1;
    }

    protected Collection<Project> getExistingDestinationProjects() {
        Iterable existingProjects = Iterables.transform(this.getConfigBean().getSelectedProjects(), (Function)new Function<String, Project>(){

            public Project apply(String input) {
                String projectKey = GithubProjectMappingPage.this.getConfigBean().getProjectKey(input);
                if (projectKey == null) {
                    return null;
                }
                return GithubProjectMappingPage.this.projectManager.getProjectObjByKey(projectKey);
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)existingProjects, (Predicate)Predicates.notNull()));
    }

    @Nullable
    protected GithubImportProcessBean getProcessBean() {
        ImporterController controller = this.getController();
        if (controller == null) {
            throw new RuntimeException("Unknown Controller");
        }
        ImportProcessBean processBean = controller.getImportProcessBeanFromSession();
        if (processBean == null || !(processBean instanceof GithubImportProcessBean)) {
            return null;
        }
        return (GithubImportProcessBean)controller.getImportProcessBeanFromSession();
    }

    public ConfigBean getConfigBean() {
        return this.getProcessBean() != null ? (ConfigBean)this.getProcessBean().getConfigBean() : null;
    }

    public String getFormTitle() {
        return this.getI18nHelper().getText("com.atlassian.jira.plugins.importer.github.step.projectmapping.form.title");
    }

    public String getFormDescription() {
        return this.getI18nHelper().getText("com.atlassian.jira.plugins.importer.github.step.projectmapping.description");
    }
}

