/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.fetch.auth;

import org.eclipse.egit.github.core.client.GitHubClient;

public interface GithubAuthenticator {
    public void setGithubEnterpriseUrl(String var1);

    public AuthorizationResponse authenticateGithub(String var1, String var2);

    public AuthorizationResponse authenticateAndValidateGithubToken(String var1);

    public AuthorizationResponse tryAuthenticateWith2FAToken(String var1) throws IllegalStateException;

    public boolean isTwoFactorAuthenticationEnabled();

    public void cleanUp();

    public GitHubClient buildAuthenticatedClient();

    public static enum AuthState {
        ERROR,
        OK,
        TWO_FACTOR_AUTH_REQUIRED_APP,
        TWO_FACTOR_AUTH_REQUIRED_SMS;

    }

    public static class AuthorizationResponse {
        private final String accessToken;
        private final AuthState state;
        private final String error;

        private AuthorizationResponse(String accessToken, AuthState state, String error) {
            this.accessToken = accessToken;
            this.state = state;
            this.error = error;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public AuthState getState() {
            return this.state;
        }

        public String getError() {
            return this.error;
        }

        public static AuthorizationResponse ok(String accessToken) {
            return new AuthorizationResponse(accessToken, AuthState.OK, null);
        }

        public static AuthorizationResponse error(String error) {
            return new AuthorizationResponse(null, AuthState.ERROR, error);
        }

        public static AuthorizationResponse actionRequired(AuthState authState) {
            return new AuthorizationResponse(null, authState, null);
        }
    }
}

