package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MentionConverter implements SimpleConverter {

	private static final Pattern ghMentionPattern = Pattern.compile("(^|\\s)@([a-zA-z]+)($|\\s)");

	private final DataBean dataBean;

	public MentionConverter(DataBean dataBean) {
		this.dataBean = dataBean;
	}

	@Override
	public String convertMarkdown(String content) {
		final Matcher matcher = ghMentionPattern.matcher(content);
		final StringBuffer buffer = new StringBuffer();
		while (matcher.find()) {
			if (doesUserExist(matcher.group(2))) {
				matcher.appendReplacement(buffer, "$1[~$2]$3");
			}
		}
		matcher.appendTail(buffer);
		return buffer.toString();
	}

	private boolean doesUserExist(final String username) {
		return Iterables.any(dataBean.getAllUserCache(), new Predicate<ExternalUser>() {
			@Override
			public boolean apply(ExternalUser input) {
				return input.getName().equals(username);
			}
		});
	}
}
