package com.atlassian.jira.plugins.importer.github.fetch.auth;

import org.eclipse.egit.github.core.client.GitHubClient;

public interface GithubAuthenticator {

	public void setGithubEnterpriseUrl(String url);

	public AuthorizationResponse authenticateGithub(String username, String password);

	public AuthorizationResponse authenticateAndValidateGithubToken(String token);

	public AuthorizationResponse tryAuthenticateWith2FAToken(String key) throws IllegalStateException;

	public boolean isTwoFactorAuthenticationEnabled();

	public void cleanUp();

	public GitHubClient buildAuthenticatedClient();

	public static class AuthorizationResponse {

		private final String accessToken;
		private final AuthState state;
		private final String error;

		private AuthorizationResponse(String accessToken, AuthState state, String error) {
			this.accessToken = accessToken;
			this.state = state;
			this.error = error;
		}

		public String getAccessToken() {
			return accessToken;
		}

		public AuthState getState() {
			return state;
		}

		public String getError() {
			return error;
		}

		public static AuthorizationResponse ok(String accessToken) {
			return new AuthorizationResponse(accessToken, AuthState.OK, null);
		}

		public static AuthorizationResponse error(String error) {
			return new AuthorizationResponse(null, AuthState.ERROR, error);
		}

		public static AuthorizationResponse actionRequired(AuthState authState) {
			return new AuthorizationResponse(null, authState, null);
		}

	}
	public static enum AuthState {
		ERROR,
		OK,
		TWO_FACTOR_AUTH_REQUIRED_APP,
		TWO_FACTOR_AUTH_REQUIRED_SMS,
	}
}
