package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

import javax.annotation.Nullable;
import java.util.List;

public abstract class GithubImportProcessSupport extends ImporterProcessSupport {

	protected final ProjectManager projectManager;
	protected final IssueTypeSchemeManager issueTypeSchemeManager;
	protected final WorkflowSchemeManager workflowSchemeManager;

	public GithubImportProcessSupport(@ComponentImport UsageTrackingService usageTrackingService,
									  @ComponentImport WebInterfaceManager webInterfaceManager,
									  @ComponentImport PluginAccessor pluginAccessor,
									  @ComponentImport ProjectManager projectManager,
									  @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager,
									  @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
		super(usageTrackingService, webInterfaceManager, pluginAccessor);
		this.projectManager = projectManager;
		this.issueTypeSchemeManager = issueTypeSchemeManager;
		this.workflowSchemeManager = workflowSchemeManager;
	}

	@Nullable
	protected GithubImportProcessBean getProcessBean() {
		final ImporterController controller = getController();

		if (controller == null) {
			throw new RuntimeException("Unknown Controller");
		}
		final ImportProcessBean processBean = controller.getImportProcessBeanFromSession();
		if (processBean == null || !(processBean instanceof GithubImportProcessBean)) {
			return null;
		}

		return (GithubImportProcessBean) controller.getImportProcessBeanFromSession();
	}

	public ConfigBean getConfigBean() {
		return getProcessBean() != null ? (ConfigBean) getProcessBean().getConfigBean() : null;
	}

	protected List<Project> getExistingDestinationProjects() {
		Iterable<Project> existingProjects = Iterables.transform(getConfigBean().getSelectedProjects(), new Function<String, Project>() {
			@Override
			public Project apply(String input) {
				final String projectKey = getConfigBean().getProjectKey(input);
				if (projectKey == null) {
					return null;
				}
				return projectManager.getProjectObjByKey(projectKey);
			}
		});
		return ImmutableList.copyOf(Iterables.filter(existingProjects, Predicates.notNull()));
	}
}
