package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.fetch.auth.GithubAuthenticator;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;

/**
 * GitHub importer authentication page.
 */
public class GithubAuthenticationPage extends GithubImportProcessSupport {

	private String authCode;

	public GithubAuthenticationPage(@ComponentImport UsageTrackingService usageTrackingService,
									@ComponentImport WebInterfaceManager webInterfaceManager,
									@ComponentImport PluginAccessor pluginAccessor,
									@ComponentImport ProjectManager projectManager,
									@ComponentImport IssueTypeSchemeManager issueTypeSchemeManager,
									@ComponentImport WorkflowSchemeManager workflowSchemeManager) {
		super(usageTrackingService, webInterfaceManager, pluginAccessor, projectManager, issueTypeSchemeManager, workflowSchemeManager);
	}

	public void setAuthCode(final String authCode) {
		this.authCode = authCode;
	}

	public boolean is2FARequired() {
		final GithubImportProcessBean processBean = getProcessBean();
		return processBean != null && processBean.getAuthenticator().isTwoFactorAuthenticationEnabled();
	}

	@Override
    public String doDefault() throws Exception {
        if (!isAdministrator()) {
            return "denied";
        }

        if (getController() == null || getController().getImportProcessBeanFromSession() == null) {
            return RESTART_NEEDED;
        }

        return INPUT;
    }

	@Override
	protected void doValidation() {
		super.doValidation();

		if(isPreviousClicked()) {
			return;
		}

		if(!isNextClicked()) {
			return;
		}

		final GithubImportProcessBean processBean = getProcessBean();
		if(processBean == null) {
			return;
		}

		final GithubAuthenticator authenticator = processBean.getAuthenticator();
		if(authenticator.isTwoFactorAuthenticationEnabled()) {
			final GithubAuthenticator.AuthorizationResponse authorizationResponse = authenticator.tryAuthenticateWith2FAToken(authCode);
			if(authorizationResponse.getState() != GithubAuthenticator.AuthState.OK) {
				addErrorMessage(getText("com.atlassian.jira.plugins.importer.github.error.invalid.auth.code"));
			} else {
				processBean.getGithubDataService().setGitHubClient(authenticator.buildAuthenticatedClient());
			}
		}
	}

	@Override
    public String getFormTitle() {
        return getText("com.atlassian.jira.plugins.importer.github.oauth.title");
    }
}
