package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.google.common.collect.Sets;

import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeFragmentConverter implements NoFormatFragmentConverter {

	private static final Pattern codePattern = Pattern.compile("```([a-zA-z]+)?(.*?)```", Pattern.DOTALL);

	private Set<Replacement> replacements = Sets.newHashSet();

	public String removeNoFormatFragments(String content) {
		final Matcher matcher = codePattern.matcher(content);
		final StringBuffer buffer = new StringBuffer();
		while (matcher.find()) {
			final String codeBlock;
			final String temporaryReplacement = UUID.randomUUID().toString();
			if(matcher.group(1) != null) {
				codeBlock = String.format("{code:%s}%s{code}", matcher.group(1), matcher.group(2));
			} else {
				codeBlock = String.format("{code}%s{code}", matcher.group(2));
			}
			matcher.appendReplacement(buffer, temporaryReplacement);
			replacements.add(new Replacement(temporaryReplacement, codeBlock));
		}
		matcher.appendTail(buffer);
		return buffer.toString();
	}

	public String putBackNoFormatFragments(String content) {
		for (Replacement replacement : replacements) {
			content = content.replace(replacement.tempReplacement, replacement.codeBlock);
		}
		return content;
	}

	private static class Replacement {
		private String tempReplacement;
		private String codeBlock;

		private Replacement(String tempReplacement, String codeBlock) {
			this.tempReplacement = tempReplacement;
			this.codeBlock = codeBlock;
		}
	}

}
