package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import org.apache.commons.lang.StringUtils;

import java.net.MalformedURLException;
import java.net.URL;

public class GithubSetupPage extends AbstractSetupPage {

	private String githubUsername = "";
	private String githubPassword = "";
	private String githubUrl = "";
	private String githubToken = "";
	private boolean githubClassic = true;

	public void setGithubUsername(String githubUsername) {
		this.githubUsername = githubUsername;
	}

	public void setGithubPassword(String githubPassword) {
		this.githubPassword = githubPassword;
	}

	public void setGithubUrl(String githubUrl) {
		this.githubUrl = githubUrl;
	}

	public void setGithubClassic(boolean githubClassic) {
		this.githubClassic = githubClassic;
	}

	public void setGithubToken(final String githubToken) {
		this.githubToken = githubToken;
	}

	public String getGithubUsername() {
		return githubUsername;
	}

	public String getGithubToken() {
		return githubToken;
	}

	public String getGithubPassword() {
		return githubPassword;
	}

	public String getGithubUrl() {
		return githubUrl;
	}

	public boolean isGithubClassic() {
		return githubClassic;
	}

	public GithubSetupPage(@ComponentImport UsageTrackingService usageTrackingService,
						   @ComponentImport WebInterfaceManager webInterfaceManager,
						   @ComponentImport PluginAccessor pluginAccessor,
						   @ComponentImport EventPublisher eventPublisher) {
		super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
	}

	@Override
	protected void doValidation() {
		if(!isPreviousClicked()) {
			if(!githubClassic && !isUrlValid())
			addErrorMessage(getText("com.atlassian.jira.plugins.importer.github.error.incorrect.url"));
		}

		super.doValidation();
	}

	public boolean isUrlValid() {
		try {
			final URL u = new URL(githubUrl);
			if (!"http".equals(u.getProtocol()) && !"https".equals(u.getProtocol())) {
				return false;
			}
			githubUrl = StringUtils.chomp(u.toString(), "/");
		} catch (MalformedURLException e) {
			return false;
		}
		return true;
	}


	@Override
	protected String doExecute() throws Exception {
		final ImporterController controller = getController();
		if (controller == null) {
			return RESTART_NEEDED;
		}

		if(hasAnyErrors()) {
			return INPUT;
		}

		if ( !isPreviousClicked() && !controller.createImportProcessBean(this)) {
			return INPUT;
		}

		return super.doExecute();
	}
}
