/* global require, sinon, ok, deepEqual, test, module */
AJS.test.require([
    'com.pyxis.greenhopper.jira:gh-test-common',
    'com.pyxis.greenhopper.jira:gh-rapid-config',
    'com.pyxis.greenhopper.jira:onboarding-create-project-component'
], function () {
    //Set up components
    var createProjectSequenceView = {
        render: sinon.spy(),
        once: function (name, handler) {
            this._events[name] = handler;
        },
        trigger: function (name, argument) {
            this._events[name](argument);
        },
        _events: {}
    };

    var CreateProjectSequenceViewFactory = function () {
        return createProjectSequenceView;
    };

    var $;
    var CreateProjectSequence;
    try {
        var context = AJS.test.mockableModuleContext();
        context.mock('jira-agile/onboarding/create-project-sequence-view', CreateProjectSequenceViewFactory);

        $ = context.require('jquery');
        CreateProjectSequence = context.require('jira-agile/onboarding/create-project-sequence');
    } catch (e) {
        AJS.log('Was not able to load the resource, likely testing on an old version of JIRA');
    }



    module('CreateProjectSequence tests', {
        setup: function () {
            if (CreateProjectSequence) {
                GH.Test.setUpFakeServer(this);

                this.$el = $('<div/>');

                this.analyticsSpy = sinon.spy();

                this.analytics = {
                    pushEvent: this.analyticsSpy
                };

                $('#qunit-fixture').append(this.$el);

                this.clock = sinon.useFakeTimers();
            }
        },

        teardown: function () {
            if (CreateProjectSequence) {
                this.clock.restore();
                GH.Test.restoreServer(this);
            }
        }
    });


//As these qunit tests cannot be put in dynamic module it must be included in all versions of JIRA, therefore,
//It will try and run it in versions of JIRA which are not possible. If it does, do not fail these tests.
    if (!CreateProjectSequence) {
        test('Make sure there is at least one test for JIRA versions < 6.4', sinon.test(function () {
            ok(true);
        }));
    } else {
        test('Rendered if has permission to create a project', sinon.test(function () {
            var createProjectSequence = new CreateProjectSequence({
                username: 'admin',
                canCompleteCreateProjectSequence: true
            });

            createProjectSequence.init(this.$el, this.analytics);

            ok(createProjectSequenceView.render.calledOnce);
        }));

        test('Test redirects to intro to agile if cannot create project', sinon.test(function () {
            var createProjectSequence = new CreateProjectSequence({
                username: 'admin',
                canCompleteCreateProjectSequence: false
            });

            var promise = createProjectSequence.init(this.$el, this.analytics);

            this.clock.tick(100);

            ok(promise.isRejected());
            equal(promise.reason(), CreateProjectSequence.EVENTS.NO_PERMISSION, 'Reason for rejection should be the user does not have permission');
        }));

        test('Test finishing the view redirects to the specified url', sinon.test(function () {
            var createProjectSequence = new CreateProjectSequence({
                username: 'admin',
                canCompleteCreateProjectSequence: true
            });

            var promise = createProjectSequence.init(this.$el, this.analytics);

            var returnUrl = '/test';

            var response = {
                returnUrl: returnUrl
            };

            createProjectSequenceView.trigger('done', {
                returnUrl: returnUrl
            });

            this.clock.tick(100);
            ok(promise.isFulfilled());
            deepEqual(promise.value(), response, 'Value being fulfilled should be the return url');


            ok(this.analyticsSpy.calledOnce, 'Analytics push event should have been called');
            ok(this.analyticsSpy.withArgs(CreateProjectSequence.EVENTS.CREATED).calledOnce, 'Should have created a createissues event');
        }));

        test('Test skipping the project creation redirects to intro to agile', sinon.test(function () {
            var createProjectSequence = new CreateProjectSequence({
                username: 'admin',
                canCompleteCreateProjectSequence: true
            });

            var promise = createProjectSequence.init(this.$el, this.analytics);

            createProjectSequenceView.trigger('skip');

            ok(promise.isRejected());
            equal(promise.reason(), CreateProjectSequence.EVENTS.SKIPPED, 'Reason for rejection should be the user skipped');

            ok(this.analyticsSpy.calledOnce, 'Analytics push event should have been called');
            ok(this.analyticsSpy.withArgs(CreateProjectSequence.EVENTS.SKIPPED).calledOnce, 'Should have created a createissues event');
        }));
    }

});
