window.GH = {};

AJS.test.require(["com.pyxis.greenhopper.jira:gh-flexible-boards"], function () {
    module("FlexibleBoardsDiscovery", {
        setup: function setup() {
            var $ = jQuery;
            this.target = $(window.GH);
            this.sandbox = sinon.sandbox.create();
            this.sandbox.spy = sinon.spy();
            this.target.on('flexible-boards-discovery-launch', this.sandbox.spy);

            var fixture = $('#qunit-fixture');
            this.contents = $('<div class="ghx-columns"></div>');
            this.columns = $('<div id="ghx-pool-column"></div>');
            fixture.append(this.contents);
            fixture.append(this.columns);
        },
        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    asyncTest("Feature discovery is shown when horizontal scroll appears", function () {
        var _this = this;

        expect(1);
        this.contents.width(400);
        this.columns.width(200);
        this.target.trigger('pool-column-updated');
        window.setTimeout(function () {
            sinon.assert.calledOnce(_this.sandbox.spy);
            start();
        }, 0);
    });

    asyncTest("Feature discovery isn't shown when content is no bigger than container", function () {
        var _this2 = this;

        expect(1);
        this.contents.width(200);
        this.columns.width(400);
        this.target.trigger('pool-column-updated');
        window.setTimeout(function () {
            sinon.assert.notCalled(_this2.sandbox.spy);
            start();
        }, 0);
    });
});