window.GH = {};

AJS.test.require(["com.pyxis.greenhopper.jira:gh-flexible-boards"], function () {
    module("FlexibleBoardsDiscovery", {
        setup: function () {
            const $ = jQuery;
            this.target = $(window.GH);
            this.sandbox = sinon.sandbox.create();
            this.sandbox.spy = sinon.spy();
            this.target.on('flexible-boards-discovery-launch', this.sandbox.spy);

            const fixture = $('#qunit-fixture');
            this.contents = $('<div class="ghx-columns"></div>');
            this.columns = $('<div id="ghx-pool-column"></div>');
            fixture.append(this.contents);
            fixture.append(this.columns);
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    asyncTest("Feature discovery is shown when horizontal scroll appears", function () {
        expect(1);
        this.contents.width(400);
        this.columns.width(200);
        this.target.trigger('pool-column-updated');
        window.setTimeout(() => {
            sinon.assert.calledOnce(this.sandbox.spy);
            start();
        }, 0);
    });

    asyncTest("Feature discovery isn't shown when content is no bigger than container", function () {
        expect(1);
        this.contents.width(200);
        this.columns.width(400);
        this.target.trigger('pool-column-updated');
        window.setTimeout(() => {
            sinon.assert.notCalled(this.sandbox.spy);
            start();
        }, 0);
    });
});
