AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-common", function () {

    var Features = require('jira-agile/gh-features');
    var JiraDarkFeatures = require('jira/ajs/dark-features');

    module("Features tests", {
        setup: function setup() {
            sinon.stub(AJS.DarkFeatures, "isEnabled");
        },

        teardown: function teardown() {
            AJS.DarkFeatures.isEnabled.restore();
        }
    });

    test("Feature jag.DISABLE_CREATE_PROJECT is detected as active", function () {
        JiraDarkFeatures.isEnabled.withArgs("jag.DISABLE_CREATE_PROJECT").returns(true);

        ok(Features.DISABLE_CREATE_PROJECT.isEnabled());
    });

    test("Feature jag.DISABLE_CREATE_PROJECT is detected as inactive", function () {
        JiraDarkFeatures.isEnabled.withArgs("jag.DISABLE_CREATE_PROJECT").returns(false);

        ok(!Features.DISABLE_CREATE_PROJECT.isEnabled());
    });
});