AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-test-dates"], function() {
    var BacklogController = require('jira-agile/rapid/ui/plan/BacklogController');
    var BacklogModel = require('jira-agile/rapid/ui/plan/BacklogModel');
    var BacklogSelectionController = require('jira-agile/rapid/ui/plan/BacklogSelectionController');

    // css classes used in tests
    var classForCreateLink = "js-add-sprint";
    var classForRemoveLink = "js-remove-sprint";
    var classForMarkerHeader = "js-sprint-container";

    // selectors used in tests
    var selectorForCreateLink = "." + classForCreateLink;
    var selectorForRemoveLink = "." + classForRemoveLink;

    var selectorForInlineEditField = ".js-editing-field";

    // marker data
    var backlogData = {
        "markers":
            [
                {"id":1, name:"Sprint 1", afterIssueKey:"ISS-1"},
                {"id":2, name:"Sprint 2", afterIssueKey:"ISS-2"}
            ]
    };

    var issueListStub = {
        getAllIssues: function() {
            return {};
        },
        getNumVisibleIssues: function() {
            return 0;
        },
        insertMarker: function() {},
        removeMarker: function() {},
        getOrder: function() {},
        getVisibleRankables: function() {}
    };

    module("SprintBacklogControllerAndView tests: Create and Remove Sprint marker", {
        setup: function() {
            BacklogController.rapidViewData = {};
            BacklogController.rapidViewData.id = 1;
            BacklogController.rapidViewConfig = {};
            BacklogController.rapidViewConfig.columns = [],
            GH.RapidBoard.State.data["rapidViewId"] = 1;
            BacklogModel.setData({ issues: [], sprints: []});
            BacklogSelectionController.init();
            GH.EpicController.init();
            GH.EpicController.setEpicData({});
            GH.Test.setUpFakeServer(this);
        },
        teardown: function () {
            GH.Test.clearEvents();
            GH.Test.restoreServer(this);
        }
    });

    test("clicking Create Sprint does nothing if the link is disabled", sinon.test(function() {

        // add a disabled button to the page
        QUnit.GhFixtures.addFixture("<a href='#' class='disabled " + classForCreateLink + "'>Create</a>");

        GH.SprintBacklogController.init();
        AJS.$(selectorForCreateLink).click();

        equal(this.server.requests.length, 0);
    }));

    test("clicking Create Sprint adds a sprint marker and redraws the backlog", sinon.test(function() {

        // add an enabled button to the page
        QUnit.GhFixtures.addFixture("<a href='#' class='" + classForCreateLink + "'>Create</a>");
        QUnit.GhFixtures.addFixture("<div id='ghx-backlog'><div class='ghx-sprint-group'></div></div>");

        // ensure success path is invoked for any Ajax requests - only match the correct one
        // new sprint ID is 3, name is (imaginitively) "Sprint"
        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/sprintquery/1"));
        this.server.respondWith("POST", url, [200, { "Content-Type": "application/json" }, JSON.stringify({ id: 3, name: "Sprint"})]);

        GH.SprintBacklogController.init();
        AJS.$(selectorForCreateLink).click();

        this.server.respond();

        // Should have drawn sprint on the page
        equal(AJS.$(".js-sprint-container").length, 1);
        equal(AJS.$(".js-sprint-container").attr("data-sprint-id"), "3");
        equal(AJS.$(".js-sprint-container .ghx-name").text(), "Sprint");

    }));

    test("clicking Remove Sprint does nothing if the link is disabled", function () {

        QUnit.GhFixtures.addFixture("<a href='#' class='disabled " + classForRemoveLink + "'>Remove</a>");

        GH.SprintBacklogController.init();
        AJS.$(selectorForRemoveLink).click();

        equal(this.server.requests.length, 0);
    });

    test("clicking Remove Sprint removes the marker from the backlog", sinon.test(function() {

        // add an enabled button to the page
        QUnit.GhFixtures.addFixture("<a href='#' class='" + classForCreateLink + "'>Create</a>");
        QUnit.GhFixtures.addFixture("<div id='ghx-backlog'>" +
                "<div class='ghx-sprint-group'>" +
                    "<div>Some Sprint</div>" +
                "</div>" +
            "</div>");

        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/sprintquery/3") + "(.*)");
        this.server.respondWith("DELETE", url, [200, { "Content-Type": "application/json" }, JSON.stringify({})]);

        equal(AJS.$(".js-sprint-container").length, 0);

    }));

    test("it does not attempt to update if the name is the same", function() {
        var html = "<div class='" + classForMarkerHeader + "' data-sprint-id='1'>";
        html+="<span class='js-edit-sprintName-trigger' data-fieldname='sprintName' data-fieldvalue='Sprint 2'>Sprint 2</span>";
        html+="</div>";
        QUnit.GhFixtures.addFixture(html);

        BacklogModel.setData({ issues: [], sprints: [ { id: 1, name: "Sprint 2" }]});

        GH.SprintController.init();

        AJS.$(GH.Test.selectorForInlineEditTrigger).click();
        AJS.$(selectorForInlineEditField).blur();

        // ensure we did not try to update the marker
        equal(this.server.requests.length, 0);
    });

    test("updates the name and fires an event", function() {
        var html = "<div class='" + classForMarkerHeader + "' data-sprint-id='1'>";
        html+="<span class='js-edit-sprintName-trigger' data-fieldname='sprintName' data-fieldvalue='Sprint 2'>Sprint 2</span>";
        html+="</div>";
        QUnit.GhFixtures.addFixture(html);

        // stub request
        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/sprint/1"));
        this.server.respondWith("PUT", url, [200, { "Content-Type": "application/json" }, JSON.stringify({ id: 3, name: "Sprint"})]);

        var eventTester = new GH.Test.EventTester(GH.Components.EVENT_SPRINT_UPDATED);

        BacklogModel.setData({ issues: [], sprints: [ { id: 1, name: "Sprint 2" }]});

        GH.SprintController.init();

        AJS.$(GH.Test.selectorForInlineEditTrigger).click();
        AJS.$(selectorForInlineEditField).val("Sprint 15");
        AJS.$(selectorForInlineEditField).blur();

        this.server.respond();

        ok(eventTester.eventWasFired());
        equal(AJS.$(GH.Test.selectorForInlineEditTrigger).text(), "Sprint 15");

    });
});