GH.Test = GH.Test || {};

GH.Test.EpicReport = {};

GH.Test.EpicReport.getChartSelector = function() {
    return AJS.$("#ghx-chart-selector");
};

GH.Test.EpicReport.getChartContent = function() {
    return AJS.$("#ghx-chart-content");
};

GH.Test.EpicReport.hasNoEpicsMessage = function() {
    var msg = GH.Test.EpicReport.getChartContent().find(".aui-message.aui-message-info");
    if (msg.length === 0) {
        return true;
    }

    return msg.text().indexOf("gh.report.epic.noepics") >= 0;
};

GH.Test.EpicReport.hasNoIssuesInEpicMessage = function() {
    var msg = GH.Test.EpicReport.getChartContent().find(".aui-message.aui-message-info");
    if (msg.length === 0) {
        return true;
    }

    return msg.text().indexOf("gh.rapid.charts.epic.empty") >= 0;
};

GH.Test.EpicReport.epicPickerTrigger = function() {
    return AJS.$("#ghx-items-trigger");
};

GH.Test.EpicReport.hasTriggerForEpicPicker = function() {
    return GH.Test.EpicReport.epicPickerTrigger().length == 1;
};

GH.Test.EpicReport.hasSingleEpicName = function(name) {
    return GH.Test.EpicReport.getChartSelector().find(".ghx-selector-single").text() == name;
};

GH.Test.EpicReport.selectedEpicIs = function(epic) {
    return GH.Test.EpicReport.epicPickerTrigger().text() == epic.epicLabel;
};

GH.Test.EpicReport.pickerChoicesInclude = function(epic) {
    var matchingChoice = _.find(AJS.$("#ghx-chart-picker").find("option"), function(option) {
        return AJS.$(option).text() == epic.epicLabel
            && AJS.$(option).val() == epic.key;
    });
    return matchingChoice;
};

/* Epic meta data display */
GH.Test.EpicReport.getMeta = function() {
    return AJS.$("#ghx-epic-meta");
};
GH.Test.EpicReport.displayingEpicMeta = function()
{
    return GH.Test.EpicReport.getMeta().length == 1;
};

GH.Test.EpicReport.hasEpicMetaFor = function(epic) {
    var meta = GH.Test.EpicReport.getMeta();
    if (meta.text().indexOf(epic.key + " " + epic.summary) === -1) {
        return false;
    }
    return meta.find("a").attr("href") == "/jira/browse/" + epic.key;
};

/* Epic Summary Data Display */

GH.Test.EpicReport.getSummary = function() {
    return AJS.$(".ghx-epic-summary");
};

GH.Test.EpicReport.hasSummary = function() {
    return GH.Test.EpicReport.getSummary().length == 1;
};

GH.Test.EpicReport.getSummaryBlocks = function() {
    return GH.Test.EpicReport.getSummary().find(".ghx-inline-blocks");
};

GH.Test.EpicReport.numberOfSummaryBlocks = function() {
    return GH.Test.EpicReport.getSummaryBlocks().length;
};

GH.Test.EpicReport.summaryTotalIs = function(issueCount) {
    return AJS.$(GH.Test.EpicReport.getSummaryBlocks()[0]).text() === "gh.classification.issues.total:" + issueCount;
};

GH.Test.EpicReport.summaryCompletedIs = function(issueCount) {
    return AJS.$(GH.Test.EpicReport.getSummaryBlocks()[1]).text() === "gh.classification.issues.completed:" + issueCount;
};

GH.Test.EpicReport.summaryUnestimatedIs = function(issueCount) {
    return AJS.$(GH.Test.EpicReport.getSummaryBlocks()[2]).text() === "gh.classification.issues.unestimated:" + issueCount;
};

GH.Test.EpicReport.summaryTotalStoryPointsIs = function(storyPoints) {
    return AJS.$(GH.Test.EpicReport.getSummaryBlocks()[3]).text() === "gh.classification.statistic.total:" + storyPoints;
};

GH.Test.EpicReport.summaryDoneStoryPointsIs = function(storyPoints) {
    return AJS.$(GH.Test.EpicReport.getSummaryBlocks()[4]).text() === "gh.classification.statistic.done:" + storyPoints;
};

GH.Test.EpicReport.estimationType = function() {
    return GH.Test.EpicReport.getSummary().find("#ghx-stat-name").text();
};

/* Report Table */
GH.Test.EpicReport.reportTable = function() {
    return AJS.$(".ghx-epic-report-table");
};

GH.Test.EpicReport.hasReportTable = function() {
    return GH.Test.EpicReport.reportTable().length === 1;
};

GH.Test.EpicReport.numberOfReportSections = function() {
    var sections = GH.Test.EpicReport.reportTable().find(".ghx-controls");
    return sections.length;
};

/* Graph */
GH.Test.EpicReport.leftYAxisLabel = function() {
    return AJS.$("#ghx-axis-y").find('.ghx-inner').text();
};

GH.Test.EpicReport.rightYAxisLabel = function() {
    return AJS.$("#ghx-axis-y-right").find('.ghx-inner').text();
};