AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-test-dates', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var $ = require('jquery');
    var _ = require('underscore');
    var ChartController = require('jira-agile/rapid/ui/chart/chart-controller');

    var startDate = new Date(2012, 10, 26).valueOf(); // Monday
    var endDate = new Date(2012, 11, 7).valueOf(); // Friday, 11 days later
    var startWeekend = new Date(2012, 11, 1).valueOf();
    var endWeekend = new Date(2012, 11, 3).valueOf();

    var workRates = {
        timezone: 'Australia/Sydney',
        rates: [
            { start: startDate, end: startWeekend, rate: 1 },
            { start: startWeekend, end: endWeekend, rate: 0 },
            { start: endWeekend, end: endDate, rate: 1 }
        ]
    };

    var chartData = {
        issues: [],
        workRateData: workRates
    };

    var config = {
        currentViewConfig: {
            id: 1,
            columns: [],
            quickFilters: [],
            swimlanes: []
        },
        globalConfig: { dateFormat: '%d.%m.%Y'}
    };

    function clearCachedElements() {
        delete GH.ChartView.chartContentElem;
        delete GH.ChartView.chartControls;
        delete GH.ChartView.chartStatus;
        delete GH.ChartView.chartGroup;
    }

    module('Render Burndown Chart', {
        setup: function() {
            var stubbedFlotChart = {
                hooks: {
                    draw: [],
                    drawSeries: []
                }
            };
            sinon.stub($, 'plot', function(placeholder, data, options) {
                options.xaxis.tickSize = 'day';
                // create a skeleton of the flot legend so that the non-working days checkbox can be added
                $('#ghx-chart-legend').html('<table><tbody></tbody></table>');
                return stubbedFlotChart;
            });
            if (_.isUndefined(GH.RapidViewConfig.currentData.data)) { GH.RapidViewConfig.currentData.data = {id: 1}; }

            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            $.plot.restore();
            GH.Test.restoreServer(this);
            // remove cached content element so tests don't affect each other
            clearCachedElements();
        }
    });

    test('Renders chart and cycle times for total elapsed time', sinon.test(function() {
        // force calculation with non-working days
        this.stub(GH.RapidBoard.State, 'getCycleTimeCalculationType').returns(GH.ControlChart.CYCLE_TIME_CALCULATION_TOTAL);

        GH.Test.respondToGetWith200(this, '/xboard/config.json', config);
        GH.Test.respondToGetWith200(this, '/rapid/charts/controlchart.json', chartData);

        QUnit.GhFixtures.addFixture('<section id="ghx-chart-content"></section>');

        GH.ControlChartController.rapidViewData = { id: 1 };
        GH.ControlChartController.show();

        this.server.respond();

        // check that we tried to draw a chart
        ok($.plot.called, 'should have plotted the chart');

        var chartArgs = $.plot.firstCall.args;

        // check we passed the correct selector
        equal(chartArgs[0].selector, '#ghx-chart-view', 'should have put the chart in the right element');

        // should contain markings
        var options = chartArgs[2];
        ok(options.grid.markings, 'should have added markings');

        // should have drawn the checkbox for non-working days
        equal($('#ghx-chart-include-non-working-days').length, 1, 'Should display the non-working days checkbox');

        // check we show the total cycle time and working days is hidden
        equal($('.ghx-cycle-total').length, 1, 'Should have element for the total cycle time');
        ok($('.ghx-cycle-total').is(':visible'), 'Should display the total cycle time');
        ok($('.ghx-cycle-working-days').is(':hidden'), 'Should hide the working days time');
    }));

    test('Render chart and cycle times for working days only', sinon.test(function() {

        GH.Test.respondToGetWith200(this, '/xboard/config.json', config);
        GH.Test.respondToGetWith200(this, '/rapid/charts/controlchart.json', chartData);

        QUnit.GhFixtures.addFixture('<section id="ghx-chart-content"></section>');

        // force calculation without non-working days
        this.stub(GH.RapidBoard.State, 'getCycleTimeCalculationType').returns('workingDays');

        GH.ControlChartController.rapidViewData = { id: 1 };
        GH.ControlChartController.show();

        this.server.respond();

        // check that we tried to draw a chart
        ok($.plot.called);

        var chartArgs = $.plot.firstCall.args;

        // check we passed the correct selector
        equal(chartArgs[0].selector, '#ghx-chart-view');

        // should contain markings
        var options = chartArgs[2];
        ok(options.grid.markings, 'should have added markings');

        // should have drawn the checkbox for non-working days
        equal($('#ghx-chart-include-non-working-days').length, 1, 'Should display the non-working days checkbox');

        // check we show the time in working days and total is hidden
        equal($('.ghx-cycle-working-days').length, 1, 'Should have element for the working days time');
        ok($('.ghx-cycle-working-days').is(':visible'), 'working days cycle time should be visible');
        ok($('.ghx-cycle-total').is(':hidden'), 'total cycle time should be hidden');
    }));

    module('view while loading chart', {
        teardown: function() {
            clearCachedElements();
        }
    });

    test('Spinner is displayed until chart is loaded', sinon.test(function() {
        QUnit.GhFixtures.addFixture('<div id="ghx-chart-controls"></div><section id="ghx-chart-content"></section>');

        // catch before we try to update the data - only interested in loading state
        this.stub(ChartController, 'loadRapidViewConfig');

        GH.ControlChartController.show();

        // check the blanket and spinner got created
        equal($('.ghx-chart-blanket').length, 1);
        equal($('.spinner').length, 1);
    }));
});