AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-common"], function () {
    module("AJS future: AJS.parseUri tests");

    test("it should correctly encode null values in query parameters", function () {

        var uri = AJS.parseUri('http://localhost:2990/jira');

        uri.queryKey = {
            key: null
        };

        equal(uri.toString(), 'http://localhost:2990/jira?key=null#');
    });

    test("it should correctly parse IPv6 address", function () {
        var address = 'https://[2600:1f18:674c:af04:f332:60dd:3863:8ceb]:8080/jira/secure/RapidBoard.jspa?projectKey=TEST&rapidView=1&view=planning.nodetail';

        var result = AJS.parseUri(address);

        equal(result.protocol, 'https');
        equal(result.host, '[2600:1f18:674c:af04:f332:60dd:3863:8ceb]');
        equal(result.port, '8080');
        equal(result.path, '/jira/secure/RapidBoard.jspa');
        equal(result.query, 'projectKey=TEST&rapidView=1&view=planning.nodetail');
        equal(result.queryKey.projectKey, 'TEST');
        equal(result.queryKey.rapidView, '1');
        equal(result.queryKey.view, 'planning.nodetail');
        equal(result.authority, '[2600:1f18:674c:af04:f332:60dd:3863:8ceb]:8080');
        equal(result.source, address);
    });

    test("it should correctly parse IPv6 address with a double colon", function () {
        var address = 'http://[fe80::2584:baa2:5d4d:c86d]:2990/secure/Dashboard.jspa';

        var result = AJS.parseUri(address);

        equal(result.protocol, 'http');
        equal(result.host, '[fe80::2584:baa2:5d4d:c86d]');
        equal(result.port, '2990');
        equal(result.path, '/secure/Dashboard.jspa');
        equal(result.query, '');
        equal(result.authority, '[fe80::2584:baa2:5d4d:c86d]:2990');
        equal(result.source, address);
    });

    test("it should correctly parse IPv6 local address", function () {
        var address = 'http://[::1]:8090/jira/secure/RapidBoard.jspa?rapidView=1&view=detail&selectedIssue=TEST-13';

        var result = AJS.parseUri(address);

        equal(result.protocol, 'http');
        equal(result.host, '[::1]');
        equal(result.port, '8090');
        equal(result.path, '/jira/secure/RapidBoard.jspa');
        equal(result.query, 'rapidView=1&view=detail&selectedIssue=TEST-13');
        equal(result.queryKey.rapidView, '1');
        equal(result.queryKey.view, 'detail');
        equal(result.queryKey.selectedIssue, 'TEST-13');
        equal(result.authority, '[::1]:8090');
        equal(result.source, address);
    });
});