define('jira-agile/ui-utils', ["jquery"], function ($) {
    /**
     * @module jira-agile/ui-utils
     */
    const UI = {};

    UI.isDisabled = function(elem) {
        var el = $(elem);
        return el.hasClass("disabled") || (el.attr("aria-disabled") == "true");
    };

    // included to allow code that uses it to be more readable
    UI.isEnabled = function(elem) {
        return !UI.isDisabled(elem);
    };

    UI.isVisibleY = function(pos) {
        var windowHeight = $(window).height();
        var scrollPosition = $(document).scrollTop();
        return pos > scrollPosition && pos < windowHeight + scrollPosition;
    };

    UI.isVisibleX = function(pos) {
        var windowWidth = $(window).width();
        var scrollPosition = $(document).scrollLeft();
        return pos > scrollPosition && pos < windowWidth + scrollPosition;
    };

    UI.ariaEnable = function(elem) {
        $(elem).removeAttr("aria-disabled");
    };

    UI.ariaDisable = function(elem) {
        $(elem).attr("aria-disabled", "true");
    };

    UI.Aria = Object.freeze({
        EXPANDED: 1,
        COLLAPSED: 2,
    });

    /**
     * Updates a11y attributes for a typical expander in Agile.
     * `$container` param must contain the expander button selectable by .ghx-expander class.
     * `$container` param should have .ghx-open class when it's expanded.
     *
     * If `$container`'s .ghx-open class should not be used to determine the expanded/collapse state,
     *  an optional `forceExpanderState` param must be set to either `UI.Aria.EXPANDED` or `UI.Aria.COLLAPSED`.
     *
     * @param {jQuery} $container
     * @param {(UI.Aria.EXPANDED|UI.Aria.COLLAPSED)=} forceExpanderState
     */
    UI.updateExpanderA11yAttrs = function($container, forceExpanderState) {
        if (!$container.length || !$container.jquery) {
            return;
        }

        const expanded = forceExpanderState ? forceExpanderState === UI.Aria.EXPANDED : $container.hasClass('ghx-open');
        $container.find('.ghx-expander').attr('aria-expanded', expanded);
    };

    return UI;
});

AJS.namespace('GH.Util.UI', null, require('jira-agile/ui-utils'));
