AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function() {
    const WorkView = require('jira-agile/rapid/ui/work/work-view');
    const FeatureFlagManager = require('jira/featureflags/feature-manager');

    const RAPID_BOARD_BANDS = "com.atlassian.jira.agile.darkfeature.rapid.boards.bands";

    module('WorkView', {
        renderIssue: function(id, key, summary) {
            var displayIssueKeys = {};
            displayIssueKeys[key] = key;
            return GH.tpl.rapid.swimlane.renderIssue({
                issue: {
                    id: id,
                    key: key,
                    summary: summary
                },
                displayIssueKeys: displayIssueKeys,
                selectedIssueKeys: {}
            });
        },

        renderThrobber: function renderThrobber() {
            var throbber = AJS.$('<div class="ghx-throbber"></div>');
            AJS.$('#qunit-fixture').append(throbber);
        },

        findSpinners: function findSpinners() {
            return AJS.$('.ghx-throbber').find('aui-spinner');
        }
    });

    test('showKanPlanAcknowledge: show KanPlan acknowledge when mode is Kanban', function() {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };

        this.stub(WorkView, "showKanPlanAcknowledge");

        WorkView.show();

        ok(WorkView.showKanPlanAcknowledge.called, "Show KanPlan acknowledge when mode is KanBan");
    });

    test('should show a spinner when showing pool', function shouldShowASpinnerWhenShowingPool() {
        this.renderThrobber();

        WorkView.hideLoadingPool();
        WorkView.showLoadingPool();

        ok(this.findSpinners().length === 1);
    });

    test('should not show a spinner when hiding pool', function shouldNotShowASpinnerWhenHidingPool() {
        this.renderThrobber();

        WorkView.showLoadingPool();
        WorkView.hideLoadingPool();

        ok(this.findSpinners().length === 0);
    });

    test('banding works with feature flag, in gadget', function() {
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(RAPID_BOARD_BANDS).returns(true);
        this.stub(WorkView, 'usesOldLayout').returns(true);
        this.stub(WorkView, 'getBand').returns(2);
        var pool = AJS.$('<div id="ghx-pool"></div>');
        AJS.$('#qunit-fixture').append(pool);

        WorkView.updateIssueCardLayout();

        ok(AJS.$('#ghx-pool').hasClass('ghx-band-2'));
    });

    test('banding doesn\'t work outside of gadgets', function() {
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(RAPID_BOARD_BANDS).returns(true);
        this.stub(WorkView, 'usesOldLayout').returns(false);
        this.stub(WorkView, 'getBand').returns(2);
        var pool = AJS.$('<div id="ghx-pool"></div>');
        AJS.$('#qunit-fixture').append(pool);

        WorkView.updateIssueCardLayout();

        ok(!AJS.$('#ghx-pool').hasClass('ghx-band-2'));
        ok(!AJS.$('#ghx-pool').hasClass('ghx-band-1'));
    });

    test('banding doesn\'t work without feature flag', function() {
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(RAPID_BOARD_BANDS).returns(false);
        this.stub(WorkView, 'usesOldLayout').returns(true);
        var pool = AJS.$('<div id="ghx-pool"></div>');
        AJS.$('#qunit-fixture').append(pool);

        WorkView.updateIssueCardLayout();

        ok(!AJS.$('#ghx-pool').hasClass('ghx-band-2'));
        ok(!AJS.$('#ghx-pool').hasClass('ghx-band-1'));
    });
});

