define('jira-agile/rapid/ui/work/swimlane-view-text', [
    "jira-agile/rapid/ui/work/grid-data-controller",
    "jira/util/formatter"
], function (GridDataController, formatter) {
    "use strict";

    return {
        getIssueCountLabel: function (swimlane, issueCount) {
            if (swimlane.parentKey) {
                return formatter.I18n.getText('gh.boards.subtasks2', issueCount);
            } else {
                return formatter.I18n.getText('gh.boards.issues2', issueCount);
            }
        },

        getSwimlaneTitle: function (swimlane, issueCount) {
            // issue count
            var title = this.getIssueCountLabel(swimlane, issueCount);

            // parent summary, description or query
            if (swimlane.parentKey) {
                var parentIssue = GridDataController.getModel().getIssueDataByKey(swimlane.parentKey);
                if (parentIssue && parentIssue.summary) {
                    title += ' - ' + parentIssue.summary;
                }
            }
            else if (swimlane.description) {
                title += ' - ' + swimlane.description;
            }
            else if (swimlane.query) {
                title += ' - ' + swimlane.query;
            }
            return title;
        }

    };
});
