AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    const SwimlaneView = require('jira-agile/rapid/ui/work/swimlane-view');
    const $ = require('jquery');

    module("SwimlaneView");

    test("renderActiveSprintEmptyMsg: SwimlaneView.activeSprintEmptyMsg should be defined", sinon.test(function() {

        this.stub(GH.UserData, "hasUser").returns(false);
        this.stub(GH.WorkControls, "hasSprints").returns(false);
        this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);

        SwimlaneView.renderActiveSprintEmptyMsg();

        ok(!_.isUndefined(GH.WorkController.activeSprintEmptyMsg), "Active sprint empty message should be defined");
    }));

    test("renderActiveSprintEmptyMsg: The second line of message should NOT has hidden class when canEdit is true", sinon.test(function() {

            this.stub(GH.UserData, "hasUser").returns(true);
            this.stub(GH.WorkControls, "hasSprints").returns(true);
            this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);
            var deferred = new AJS.$.Deferred();

            this.stub(GH.RapidViewConfig, "fetchConfiguration").returns(deferred.promise());

            SwimlaneView.renderActiveSprintEmptyMsg();

            deferred.resolve({canEdit: true});

            ok(!GH.WorkController.activeSprintEmptyMsg.secondLineView.hasClass("hidden"), "The link should be visible");
    }));

    test("renderActiveSprintEmptyMsg: The second line of message should has hidden class when canEdit is false", sinon.test(function() {

        this.stub(GH.UserData, "hasUser").returns(true);
        this.stub(GH.WorkControls, "hasSprints").returns(true);
        this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);
        var deferred = new AJS.$.Deferred();

        this.stub(GH.RapidViewConfig, "fetchConfiguration").returns(deferred.promise());

        SwimlaneView.renderActiveSprintEmptyMsg();

        deferred.resolve({canEdit: false});

        ok(GH.WorkController.activeSprintEmptyMsg.secondLineView.hasClass("hidden"), "The link should NOT be visible");
    }));

    test("test scrollIntoView when swimlane is collapsed", sinon.test(function() {

        const containerHeight = 500;
        const swimlaneHeight = 500;
        const columnHeaderHeight = 50;
        const swimlaneHeaderHeight = 50;

        $('#qunit-fixture').append(`
        <div id="ghx-work" class="ghx-work">
            <div id="ghx-pool-column">
                <div id="ghx-pool" class="ghx-has-swimlanes ghx-parent-child ghx-band-3" style="height: ${containerHeight}px; overflow-y: auto;">
                    <div id="ghx-column-header-group" class="ghx-column-header-group" style="height: ${columnHeaderHeight}px;"></div>
                    <div class="ghx-swimlane ghx-first" swimlane-id="1" style="height: ${swimlaneHeight}px;">
                        <div class="ghx-swimlane-header" style="height: ${swimlaneHeaderHeight}px;"></div>
                    </div>
                    <div class="ghx-swimlane" swimlane-id="2" style="height: ${swimlaneHeight}px;">
                        <div class="ghx-swimlane-header" style="height: ${swimlaneHeaderHeight}px;"></div>
                    </div>
                 </div>
             </div>
         </div>
        `);

        const container = $('#ghx-pool').get(0);
        container.scrollTop = container.scrollHeight - container.clientHeight; // scroll to bottom
        const oldScrollTop = container.scrollTop;
        SwimlaneView.setCollapsed($('.ghx-swimlane.ghx-first'), true, true);

        notEqual(oldScrollTop, container.scrollTop, "The swimlane should be scrolled into view");
    }));
});