define("jira-agile/rapid/ui/work/grid-data-model",["jira-agile/rapid/logger","underscore","jira-agile/rapid/ui/component/extra-fields/ExtraFieldsHelper","jira-agile/rapid/ui/work/issue-list-util"],function(e,t,n,i){"use strict";var s=function(e,t,n,i,s,r,a,o,u){var l=this.data={};l.columns=e,l.columnIssueMapping=t,l.swimlanes=n,l.swimlaneIssueMapping=i,l.issues=s,l.order=r,l.variables=a,l.swimlaneStrategy=o,l.cardColorStrategy=u,this.buildCache(),this.preprocessIssues()};return s.prototype.isModelDifferent=function(n){return t.isEqual(this.data.order,n.data.order)?t.isEqual(this.data.issues,n.data.issues)?t.isEqual(this.data.swimlaneIssueMapping,n.data.swimlaneIssueMapping)?t.isEqual(this.data.columnIssueMapping,n.data.columnIssueMapping)?(e.log("GridDataModel comparison: Everything is equal"),!1):(e.log("GridDataModel comparison: The columns differ"),!0):(e.log("GridDataModel comparison: The swimlanes differ"),!0):(e.log("GridDataModel comparison: The issues details differ"),!0):(e.log("GridDataModel comparison: The order differs"),!0)},s.prototype.buildCache=function(){var e=this,t=this.data,n=this.cache={};n.bySwimlaneThenColumn={};var i=this.createRankMap(t.order);t.swimlanes.forEach(function(s){n.bySwimlaneThenColumn[s.id]={};var r=e.toSet(t.swimlaneIssueMapping[s.id]);t.columns.forEach(function(a){var o=t.columnIssueMapping[a.id],u=e.filterBySwimlane(o,r);u=e.sortByRank(u,i),n.bySwimlaneThenColumn[s.id][a.id]=u})})},s.prototype.toSet=function(e){var t=new Set;return e.forEach(function(e){return t.add(e)}),t},s.prototype.createRankMap=function(e){var t={};return e.forEach(function(e,n){return t[e]=n}),t},s.prototype.filterBySwimlane=function(e,t){return e.filter(function(e){return t.has(e)})},s.prototype.sortByRank=function(e,t){return e.sort(function(e,n){return t[e]-t[n]})},s.prototype.preprocessIssues=function(){var e=this;t.each(this.data.issues,function(t){e.preprocessIssue(t)})},s.prototype.preprocessIssue=function(e){this.computeTimeInColumnForIssue(e),n.prepareExtraFields(e.extraFields)},s.prototype.computeTimeInColumnForIssue=function(e){var t=864e5;e.timeInColumn&&(e.timeInColumn.days=Math.floor((e.timeInColumn.durationPreviously+(new Date).getTime()-e.timeInColumn.enteredStatus)/t))},s.prototype.updateIssueData=function(e){this.preprocessIssue(e),this.data.issues[e.key]=e},s.prototype.updateOrder=function(e){this.data.order=e,this.buildCache()},s.prototype.getGroupData=function(){var e=[],n=this;t.each(n.data.swimlanes,function(i){t.each(n.data.columns,function(t){e.push(n.getIssuesDataForCell(i.id,t.id))})});var s=i.calculateGroupData(e);return s.drawFakeParents=!this.isParentChildStrategy(),s},s.prototype.getIssuesDataForCell=function(e,t){var n=this.cache.bySwimlaneThenColumn[e];if(!n)return!1;var i=n[t];return!!i&&this.getIssueDataByKeys(i)},s.prototype.getIssueDataByKeys=function(e){var n=[],i=this.data.issues;return t.each(e,function(e){var t=i[e];t&&n.push(t)}),n},s.prototype.getCells=function(){return this.cache.bySwimlaneThenColumn},s.prototype.getIssues=function(){return this.data.issues},s.prototype.getColumns=function(){return this.data.columns},s.prototype.getSwimlanes=function(){return this.data.swimlanes},s.prototype.getOrder=function(){return this.data.order},s.prototype.getSwimlaneById=function(e){return t.find(this.data.swimlanes,function(t){return t.id==e})},s.prototype.getColumnById=function(e){return t.find(this.data.columns,function(t){return t.id==e})},s.prototype.getFirstColumn=function(){return t.first(this.data.columns)},s.prototype.getSwimlaneIdByIssueKey=function(e){var n=!1;return t.each(this.data.swimlaneIssueMapping,function(i,s){t.indexOf(i,e)>-1&&(n=parseInt(s,10))}),n},s.prototype.getColumnIdByIssueKey=function(e){var n=!1;return t.each(this.data.columnIssueMapping,function(i,s){t.indexOf(i,e)>-1&&(n=parseInt(s,10))}),n},s.prototype.getIssueDataByKey=function(e){return this.data.issues[e]},s.prototype.getIssueData=s.prototype.getIssueDataByKey,s.prototype.getIssueDataById=function(e){return t.findWhere(this.data.issues,{id:e})},s.prototype.getIssueIdForKey=function(e){var t=this.getIssueDataByKey(e);return!!t&&t.id},s.prototype.isIssueValid=function(e){return!!this.data.issues[e]},s.prototype.hasSwimlanes=function(){var e=this,n=e.isParentChildStrategy();return t.any(e.getSwimlanes(),function(t){return(n||e.getSwimlaneIssueCount(t.id)>0)&&!t.defaultSwimlane})},s.prototype.getSwimlaneIssueCount=function(e){return this.data.swimlaneIssueMapping[e].length},s.prototype.getColumnIssueCount=function(e){return this.data.columnIssueMapping[e].length},s.prototype.isParentChildStrategy=function(){return"parentChild"==this.data.variables.swimlanesType},s.prototype.getParentSwimlaneByIssueKey=function(e){return!!this.isParentChildStrategy()&&(t.find(this.data.swimlanes,function(t){if(t.parentKey==e)return!0})||!1)},s.prototype._getIssuePositionAndDataByKey=function(e){var n=this.data.issues[e];if(!n)return!1;var i=!1;if(this.isParentChildStrategy()&&t.each(this.data.swimlanes,function(t){t.parentKey==e&&(i=t)}),i)return{isSwimlane:!0,swimlaneId:i.id,columnId:t.first(this.getColumns()).id,issueIndex:-1,issue:n};var s=this.getSwimlaneIdByIssueKey(e);if(!s)return!1;var r=this.getColumnIdByIssueKey(e);if(!r)return!1;var a=-1;if(s&&r){var o=this.cache.bySwimlaneThenColumn[s][r];a=t.indexOf(o,e)}return{swimlaneId:s,columnId:r,issueIndex:a,issue:n}},s.prototype.getIssueIndexByKey=function(e){var t=this._getIssuePositionAndDataByKey(e);return!!t&&t.issueIndex},s.prototype.getNextIssueKey=function(e,n){var i=this._getIssuePositionAndDataByKey(e);if(!i)return!1;n&&(i.columnId=n);var s=this,r=s.getCells(),a=!1,o=!1;return t.find(s.getSwimlanes(),function(e){var t;if(e.id==i.swimlaneId)a=!0,t=i.issueIndex+1;else{if(!a)return!1;if(e.parentKey)return o=e.parentKey,!0;t=0}var n=s.hasSwimlanes();return(!n||!GH.RapidBoard.State.isSwimlaneCollapsed(e.id))&&(o=r[e.id][i.columnId][t],!!o)}),o||!1},s.prototype.getPreviousIssueKey=function(e,n){var i=this._getIssuePositionAndDataByKey(e);if(!i)return!1;n&&(i.columnId=n);var s=this,r=s.getCells(),a=!1,o=!1,u=s.getSwimlanes().slice(0).reverse();return t.find(u,function(n){if(n.id!=i.swimlaneId&&!a)return!1;if(a=!0,n.id==i.swimlaneId)return n.parentKey!=e&&(0==i.issueIndex&&n.parentKey?(o=n.parentKey,!0):(o=r[n.id][i.columnId][i.issueIndex-1],!!o));var u=s.hasSwimlanes()&&GH.RapidBoard.State.isSwimlaneCollapsed(n.id);return!u&&r[n.id][i.columnId].length>0?(o=t.last(r[n.id][i.columnId]),!!o):!!n.parentKey&&(o=n.parentKey,!0)}),o||!1},s.prototype.getIssueKeyForColumnAtIndex=function(e,n,i){var s=this.cache.bySwimlaneThenColumn[e][n];return!t.isEmpty(s)&&(i<0?s[0]:i>=s.length?t.last(s):s[i])},s.prototype.getFirstIssueKey=function(){var e=this.getSwimlanes(),n=this.getColumns(),i=this.getCells(),s=this.hasSwimlanes(),r=!1;return t.find(n,function(n){return t.find(e,function(e){if(s&&GH.RapidBoard.State.isSwimlaneCollapsed(e.id))return!1;var a=i[e.id][n.id];return!t.isEmpty(a)&&(r=t.first(a),!0)}),r}),r},s.prototype.getLastIssueKey=function(){var e=this.getSwimlanes().slice().reverse(),n=this.getColumns(),i=this.getCells(),s=this.hasSwimlanes(),r=!1;return t.find(n,function(n){return t.find(e,function(e){if(s&&GH.RapidBoard.State.isSwimlaneCollapsed(e.id))return!1;var a=i[e.id][n.id];return!t.isEmpty(a)&&(r=t.last(a),!0)}),r}),r},s.prototype.getIssueKeyInPreviousColumn=function(e,t){var n=this._getIssuePositionAndDataByKey(e);if(!n)return!1;if(n.isSwimlane)return!1;for(var i=this._getPreviousColumn(n.columnId);i;){var s=this.getIssueKeyForColumnAtIndex(n.swimlaneId,i.id,t);if(s)return s;i=this._getPreviousColumn(i.id)}return!1},s.prototype._getPreviousColumn=function(e){for(var t=this.getColumns(),n=t.length-1;n>0;n--)if(t[n].id==e)return t[n-1];return!1},s.prototype.getIssueKeyInNextColumn=function(e,t){var n=this._getIssuePositionAndDataByKey(e);if(!n)return!1;if(n.isSwimlane)return!1;for(var i=this._getNextColumn(n.columnId);i;){var s=this.getIssueKeyForColumnAtIndex(n.swimlaneId,i.id,t);if(s)return s;i=this._getNextColumn(i.id)}return!1},s.prototype._getNextColumn=function(e){for(var t=this.getColumns(),n=0;n<t.length-1;n++)if(t[n].id==e)return t[n+1];return!1},s.prototype.getIssuePositionByKey=function(e){var t=this._getIssuePositionAndDataByKey(e);if(t)return{swimlaneId:t.swimlaneId,columnId:t.columnId,position:t.issueIndex}},s.prototype.getIssueKeyAtPosition=function(e){if(e&&void 0!==e.swimlaneId&&void 0!==e.columnId&&void 0!==e.position){for(var n,i,s,r,a=this.getSwimlanes(),o=0,u=a.length;o<u;o++)if(a[o].id==e.swimlaneId){n=a[o],o+1<u&&(r=a[o+1]);break}if(n&&(i=this.getColumnById(e.columnId))){var l=this.cache.bySwimlaneThenColumn[e.swimlaneId][e.columnId];return s=l[e.position],s?s:r?this.getIssueKeyAtPosition({swimlaneId:r.id,columnId:e.columnId,position:0}):t.last(l)}}},s.prototype.moveIssueToColumn=function(e,t,n){this.moveIssuesToColumn([e],t,n)},s.prototype.moveIssuesToColumn=function(e,n,i){var s=this.data.columnIssueMapping;return!(!s[n]||!s[i])&&(e.forEach(function(e){s[n]=t.without(s[n],e),s[i].push(e)}),void this.buildCache())},s.prototype.removeEpicFromIssues=function(e){var n=[],i=this.getIssueDataByKeys(e);return t.each(i,function(e){e.epic&&(delete e.epic,n.push(e))}),n},s.prototype.getSwimlaneStrategy=function(){return this.data.swimlaneStrategy},s.prototype.getCardColorStrategy=function(){return this.data.cardColorStrategy},s}),AJS.namespace("GH.GridDataModel",null,require("jira-agile/rapid/ui/work/grid-data-model"));