/**
 * globals
 * GH.WorkController, GH.GH.Ajax
 */

/**
 * Render the active sprint empty message
 * @module jira-agile/rapid/ui/work/EmptyFilterBoardView
 * @requires module:jquery
 */
define("jira-agile/rapid/ui/work/EmptyFilterBoardView", [
    "jquery"
], function ($) {
    "use strict";

    // private constants
    var CLASS_NAME = {
        HIDDEN: "hidden",
        DASHBOARD_MODE: "dashboard-mode",
        NO_MAPPED_COLUMNS_MODE: "no-mapped-columns-mode"
    };

    var handleNoActiveSprint = function(e) {
        e.preventDefault();
        GH.WorkController.trigger(GH.WorkController.EVENT_NAMES.ON_PLAN_MODE);
    };

    var clearAllFilter = function(e) {
        e.preventDefault();
        GH.WorkController.trigger(GH.WorkController.EVENT_NAMES.ON_ALL_FILTERS_CLEARING);
    };

    /**
     * @constructor
     * @param {boolean} noActiveSprints     Indicate if the board has active sprint or not
     * @param {boolean} activeQuickFilters  Indicate if the quick filters is active or not
     * @param {number}  rapidViewId         The id of the current board
     * @param {boolean} noMappedColumns     Indicate if all columns is mapped or not
     * @param {jQuery}  container           The container of the view
     */
    function EmptyFilterBoardView(rapidViewId, container) {

        var renderer = GH.tpl.rapid.emptyfilterboardview.emptyFilterBoard;

        this.view = $(renderer({
        }));

        GH.WorkController.on(GH.WorkController.EVENT_NAMES.ON_RELOAD_EMPTY_STATE_VIEW, this._reloadView, this);

        $(container).append(this.view);
    }

    /**
     * Update the view when it show in the dashboard
     */
    EmptyFilterBoardView.prototype.handleOnDashboardMode = function () {
        this.view.addClass(CLASS_NAME.DASHBOARD_MODE);
    };

    /**
     * Handler for the reload view event
     * @param {boolean} canEdit Indicate if the current user can edit the board or not
     */
    EmptyFilterBoardView.prototype._reloadView = function(canEdit) {
    };

    return EmptyFilterBoardView;
});