/**
 * globals
 * GH.WorkController, GH.GH.Ajax
 */

/**
 * Render the active sprint empty message
 * @module jira-agile/rapid/ui/work/EmptyFilterBacklogView
 * @requires module:jquery
 */
define("jira-agile/rapid/ui/work/EmptyFilterBacklogView", [
    "jquery"
], function ($) {
    "use strict";

    // private constants
    var CLASS_NAME = {
        HIDDEN: "hidden",
        DASHBOARD_MODE: "dashboard-mode",
        NO_MAPPED_COLUMNS_MODE: "no-mapped-columns-mode"
    };

    /**
     * @constructor
     * @param {boolean} noActiveSprints     Indicate if the board has active sprint or not
     * @param {boolean} activeQuickFilters  Indicate if the quick filters is active or not
     * @param {number}  rapidViewId         The id of the current board
     * @param {boolean} noMappedColumns     Indicate if all columns is mapped or not
     * @param {jQuery}  container           The container of the view
     */
    function EmptyFilterBacklogView(rapidViewId, container) {

        var renderer = GH.tpl.rapid.emptyfilterbacklogview.emptyFilterBacklog;

        this.view = $(renderer({
        }));

        $(container).append(this.view);
    }

    /**
     * Update the view when it show in the dashboard
     */
    EmptyFilterBacklogView.prototype.handleOnDashboardMode = function () {
        this.view.addClass(CLASS_NAME.DASHBOARD_MODE);
    };

    /**
     * Handler for the reload view event
     * @param {boolean} canEdit Indicate if the current user can edit the board or not
     */
    EmptyFilterBacklogView.prototype._reloadView = function(canEdit) {
    };

    return EmptyFilterBacklogView;
});