AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var $ = require('jquery');
    var SprintBacklogView = require('jira-agile/rapid/ui/plan/sprint-backlog-view');

    var BacklogModel2 = require('jira-agile/rapid/ui/plan/backlog-model2');
    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var IssueListModel = require('jira-agile/rapid/ui/plan/issue-list-model');
    var FeatureFlagManager = require('jira/featureflags/feature-manager');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var BacklogController = require('jira-agile/rapid/ui/plan/backlog-controller');

    const BACKLOG_END_ISSUES_COUNT = 10;
    const FEATURE_FLAG = 'com.atlassian.jira.agile.darkfeature.backlog.showmore';

    module('SprintBacklogView', {
        setup: function () {
            GlobalEvents.trigger('pre-initialization');
            GH.PlanController.setBacklogIssuesLimitConfig(undefined);

            const mockableModuleContext = require("ajs/test/mockableModuleContext");
            const mockEpicModel = new GH.EpicModel();
            mockEpicModel.epicsList = new IssueListModel('test', [], null);

            this.sandbox = sinon.sandbox.create();
            this.sprintModel = undefined;

            this.backlogModel= _.extend(BacklogModel, {
                getBacklogModel2 : () => this.sprintModel,
            });
            this.mockedContext = mockableModuleContext();
            this.mockedContext.mock('jira-agile/rapid/ui/plan/backlog-model', this.backlogModel);

            this.sandbox.stub(GH.EpicController, 'getEpicModel');
            this.sandbox.stub(BacklogController, 'calculateIssueRenderData');

            GH.EpicController.getEpicModel.returns(mockEpicModel);
        },

        teardown: function () {
            this.sandbox.restore();
        },

        stubShowMore(number) {
            GH.PlanController.setBacklogIssuesLimitConfig(number);
        }
    });

    test('SprintBacklogView module exists', function () {
        ok(SprintBacklogView);
        ok(GH.SprintBacklogView);
    });

    test('Epic label should appear on backlog issues', function() {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");

        var epicKey = 'TEST';
        var issues = GH.IssueTest.createArrayOfIssues(2);
        var issueKey1 = issues[0].key;
        var issueKey2 = issues[1].key;
        issues[0].epic = epicKey;
        var epics = [GH.IssueTest.createIssueObject({key: epicKey, epicLabel: 'TEST Epic'})];

        var mockEpicModel = new GH.EpicModel();
        mockEpicModel.epicsList = new IssueListModel('test', epics, null);
        GH.EpicController.getEpicModel.returns(mockEpicModel);

        this.sprintModel = new BacklogModel2(issues);

        var issueRenderData = {hiddenIssues: {}, selectedIssueKeys: {}};
        SprintBacklogView.renderBacklog(issueRenderData);

        ok($('.js-issue[data-issue-key=' + issueKey1 + ']').find('span[data-epickey=' + epicKey + ']').length > 0);
        ok($('.js-issue[data-issue-key=' + issueKey2 + ']').find('span[data-epickey=' + epicKey + ']').length === 0);
    });

    test('Show more doesn\'t appear on small boards', function() {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        prepareBacklogWithIssues.call(this, 50);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').length === 0);
    });

    test('Show more appears on big boards', function() {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        prepareBacklogWithIssues.call(this, 500);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').length === 1, "expected to show a show more container");
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').find('.js-show-all-link').length === 1, "expected to see a show all button");
    });

    test('Show more works with feature flag only', function() {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(false);
        prepareBacklogWithIssues.call(this, 500);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').length === 0, "expected show more container not to be present");
    });

    asyncTest('If vertical split is enabled, end of backlog is always constant ', function() {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        this.stubShowMore(50);
        prepareBacklogWithIssues.call(this, 500);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').nextAll('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === BACKLOG_END_ISSUES_COUNT);

        this.stubShowMore(60);
        SprintBacklogView.updateBacklog();
        setTimeout(() => {
            ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').nextAll('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === BACKLOG_END_ISSUES_COUNT);
            start();
        });
    });

    asyncTest('If vertical split is enabled, start of backlog changes accordingly to selected issues number ', function() {
        const issuesNum1 = 50;
        const issuesNum2 = 70;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        this.stubShowMore(issuesNum1);
        prepareBacklogWithIssues.call(this, 500);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').prevAll('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === issuesNum1 - BACKLOG_END_ISSUES_COUNT,
            "backlog should change accordingly to selected issues number");

        this.stubShowMore(issuesNum2);
        SprintBacklogView.updateBacklog();
        setTimeout(() => {
            ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').prevAll('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === issuesNum2 - BACKLOG_END_ISSUES_COUNT,
                "backlog should change accordingly to selected issues number");
            start();
        });
    });

    test('On click Show More should display all issues', function() {
        const issuesNum1 = 50;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        this.stubShowMore(issuesNum1);
        prepareBacklogWithIssues.call(this, 100);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === issuesNum1);

        let clock = sinon.useFakeTimers();
        SprintBacklogView.showIssues(-1, true);
        clock.tick(1);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.js-issue:not(.ghx-filtered):not(.ghx-filtered-showmore)').length === 100, 'should display all issues');
        clock.restore();
    });

    test('On click Show All triggers analytics', function() {
        const issuesNum1 = 100;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        this.stub(AJS, "trigger");
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        prepareBacklogWithIssues.call(this, issuesNum1);
        let clock = sinon.useFakeTimers();

        SprintBacklogView.showIssues(-1, true);
        clock.tick(1);
        ok(AJS.trigger.called, "Called success analytics");
        clock.restore();
    });

    test('On change issues to show not trigger analytics', function() {
        const issuesNum1 = 50;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        this.stub(AJS, "trigger");
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        prepareBacklogWithIssues.call(this, 100);
        let clock = sinon.useFakeTimers();

        SprintBacklogView.setIssueLimit(issuesNum1);
        SprintBacklogView.showIssues(issuesNum1);
        clock.tick(2);
        ok(!AJS.trigger.called, "Called analytics when doesn\'t have to");
        clock.restore();
    });

    asyncTest('Show more section displays correct amount of not shown issues', function() {
        const issuesNum1 = 50;
        const issuesNum2 = 70;
        const issueCount = 200;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        this.stub(AJS.I18n, 'getText').withArgs('gh.issue.show.all.issues').returns('Show all issues ({0})');
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        this.stubShowMore(issuesNum1);
        prepareBacklogWithIssues.call(this, issueCount);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').length === 1, "show more container not found");
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').find('.js-show-all-link').length === 1, "button not found");
        ok(getShowAllIssuesCount() === (issueCount - issuesNum1), "amount of items in 'show all' should change accordingly to selected issues number");

        this.stubShowMore(issuesNum2);
        SprintBacklogView.updateBacklog();
        setTimeout(() => {
            ok(getShowAllIssuesCount() === (issueCount - issuesNum2), "amount of items in 'show all' should change accordingly to selected issues number");
            start();
        });
    });

    asyncTest('If vertical split is enabled, hidden issues are not rendered', function() {
        const issuesNum1 = 50;

        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");
        this.stub(FeatureFlagManager, 'isFeatureEnabled').withArgs(FEATURE_FLAG).returns(true);
        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {}, selectedIssueKeys: {}});

        this.stubShowMore(issuesNum1);
        prepareBacklogWithIssues.call(this, 50);
        ok($('.ghx-backlog-group .ghx-backlog-container').find('.js-issue').length === issuesNum1, "should all be rendered");

        const backlogModel2 = BacklogModel.getBacklogModel2();
        const backlogIssueList = backlogModel2.getIssueList();
        const [issue1, issue2] = backlogIssueList.data.order;

        BacklogController.calculateIssueRenderData.returns({hiddenIssues: {[issue1]: true, [issue2]: true}, selectedIssueKeys: {}});
        SprintBacklogView.updateBacklog();
        setTimeout(() => {
            ok($('.ghx-backlog-group .ghx-backlog-container').find('.js-issue').length === issuesNum1 - 2, "should not render hidden issues");
            ok($('.ghx-backlog-group .ghx-backlog-container').find(`.js-issue[data-issue-key="${issue1}"]`).length === 0, "should not render hidden issues");
            ok($('.ghx-backlog-group .ghx-backlog-container').find(`.js-issue[data-issue-key="${issue2}"]`).length === 0, "should not render hidden issues");
            start();
        });
    });


    function getShowAllIssuesCount() {
        return $('.ghx-backlog-group .ghx-backlog-container').find('.ghx-issue-show-all-container').find('.js-show-all-link').data('issuesNotShown');
    }

    function prepareBacklogWithIssues(issueCount) {
        const issues = GH.IssueTest.createArrayOfIssues(issueCount);

        this.sprintModel = new BacklogModel2(issues);

        const issueRenderData = {hiddenIssues: {}, selectedIssueKeys: {}};
        SprintBacklogView.setShowAllClicked(false);
        SprintBacklogView.renderBacklog(issueRenderData);
    }
});