AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function () {

    var SprintBacklogUtil = require('jira-agile/rapid/ui/plan/sprint-backlog-util');

    module('SprintBacklogUtil', {
        /**
         * @param input
         * @param limit
         * @param expected
         */
        assertHeadResult: function assertHeadResult(input, limit, expected) {
            var actual = SprintBacklogUtil.getIssuesListHead(input, limit);

            deepEqual(actual, expected);
        },

        assertTailResult: function assertTailResult(input, limit, expected) {
            var actual = SprintBacklogUtil.getIssuesListTail(input, limit);

            deepEqual(actual, expected);
        },

        generateInput: function generateInput(start, end) {
            var result = [];
            for (var i = start; i < end; i++) {
                result.push({ key: '' + i });
            }
            return result;
        }
    });

    test('Limit = issues amount; Simple data for backlog head', function () {
        var input = this.generateInput(0, 20);

        this.assertHeadResult(input, 20, input);
    });

    test('Limit > issues amount; Simple data for backlog head', function () {
        var input = this.generateInput(0, 20);

        this.assertHeadResult(input, 30, input);
    });

    test('Limit < issues amount; Simple data for backlog head', function () {
        var input = this.generateInput(0, 30);
        var expected = input.slice(0, 20);

        this.assertHeadResult(input, 20, expected);
    });

    test('Limit < issues amount; Complex data for backlog head', function () {
        var input = this.generateInput(0, 30);
        input[1].subTasks = this.generateInput(0, 4);
        input[3].subTasks = this.generateInput(0, 17);

        var expected = input.slice(0, 4);
        expected[3] = { key: "3", subTasks: this.generateInput(0, 12) };

        this.assertHeadResult(input, 20, expected);
    });

    test('Limit < issues amount; Complex data for backlog head; Fake parent', function () {
        var input = this.generateInput(0, 30);
        input[1].subTasks = this.generateInput(0, 4);
        input[3].subTasks = this.generateInput(0, 17);
        input[3].fakeParent = true;

        var expected = input.slice(0, 4);
        expected[3] = { key: "3", subTasks: this.generateInput(0, 13), fakeParent: true };

        this.assertHeadResult(input, 20, expected);
    });

    test('Limit = issues amount; Simple data for backlog tail', function () {
        var input = this.generateInput(0, 20);

        this.assertTailResult(input, 20, input);
    });

    test('Limit > issues amount; Simple data for backlog tail', function () {
        var input = this.generateInput(0, 20);

        this.assertTailResult(input, 30, input);
    });

    test('Limit < issues amount; Simple data for backlog tail', function () {
        var input = this.generateInput(0, 30);
        var expected = input.slice(10);

        this.assertTailResult(input, 20, expected);
    });

    test('Limit < issues amount; Complex data for backlog tail', function () {
        var input = this.generateInput(0, 30);
        input[29].subTasks = this.generateInput(0, 4);
        input[28].subTasks = this.generateInput(0, 17);

        var expected = input.slice(28);
        expected[0] = { key: "28", subTasks: this.generateInput(2, 17), fakeParent: true };

        this.assertTailResult(input, 20, expected);
    });
});