var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Utility functions for backlog
 * @module jira-agile/rapid/ui/plan/sprint-backlog-util
 */
define('jira-agile/rapid/ui/plan/sprint-backlog-util', ['underscore'], function (_) {
    /**
     * Used for calculating correct amount of issues in backlog with vertical split.
     * Class is highly specialized to be shareable
     */
    var IssueAddingCounter = function () {
        function IssueAddingCounter() {
            _classCallCheck(this, IssueAddingCounter);
        }

        _createClass(IssueAddingCounter, [{
            key: 'currentIssue',
            set: function set(issue) {
                // In terms of specification of how vertical split should work for
                // kanplan, we can change parent issues if needed for visual effects,
                // but it should be able to reuse them originally in other operations.
                this.issue = issue || {};
            },
            get: function get() {
                return this.issue;
            }
        }, {
            key: 'parentLength',
            get: function get() {
                // Don't count as issue added if it is fake, because it is not usable
                // for any manipulations, and exists only like container
                return this.issue.fakeParent ? 0 : 1;
            }
        }, {
            key: 'subTasksCount',
            get: function get() {
                return this.issue.subTasks ? this.issue.subTasks.length : 0;
            }
        }, {
            key: 'goingToAdd',
            get: function get() {
                return this.parentLength + this.subTasksCount;
            }
        }]);

        return IssueAddingCounter;
    }();

    var SprintBacklogUtil = {};

    /**
     * Calculate first n issues with sub-tasks for vertical split
     * @param issues
     * @param limit of issues should be totally shown
     * @returns {Array}
     */
    SprintBacklogUtil.getIssuesListHead = function (issues) {
        var limit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

        var headIndex = 0;
        var totalInList = 0;
        var counter = new IssueAddingCounter();
        var result = [];

        counter.currentIssue = issues[headIndex];
        while (totalInList + counter.goingToAdd <= limit) {
            // This check helps to avoid situation with empty object created by counter
            if (!issues[headIndex]) {
                break;
            }

            totalInList += counter.goingToAdd;
            result.push(counter.currentIssue);

            counter.currentIssue = issues[++headIndex];
        }

        if (totalInList < limit && issues[headIndex]) {
            // For this moment we already have an issue in counter,
            // so we process it
            counter.currentIssue = _.extend({}, issues[headIndex]);
            counter.issue.subTasks = _.extend([], counter.issue.subTasks);
            counter.issue.subTasks.length = limit - totalInList - counter.parentLength;
            result.push(counter.currentIssue);
        }

        return result;
    };

    /**
     * Calculate last issues with sub-tasks for vertical split tail
     * @param issues
     * @param limit
     * @returns {Array}
     */
    SprintBacklogUtil.getIssuesListTail = function (issues) {
        var limit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

        var result = [];
        var counter = new IssueAddingCounter();
        var totalInList = 0;
        var tailIndex = issues.length - 1;

        counter.currentIssue = issues[tailIndex];
        while (totalInList + counter.goingToAdd <= limit) {
            // This check helps to avoid situation with empty object created by counter
            if (!issues[tailIndex]) {
                break;
            }

            totalInList += counter.goingToAdd;
            result.unshift(counter.currentIssue);

            counter.currentIssue = issues[--tailIndex];
        }

        if (totalInList < limit && issues[tailIndex]) {
            // Issue anyway is marked as a fake parent, because if not, then
            // it had been processed before this condition
            counter.currentIssue = _.extend({}, issues[tailIndex]);
            counter.issue.fakeParent = true;
            counter.issue.subTasks = _.extend([], counter.issue.subTasks);
            counter.issue.subTasks.splice(0, counter.subTasksCount - (limit - totalInList));
            result.unshift(counter.currentIssue);
        }

        return result;
    };

    return SprintBacklogUtil;
});