AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    var $ = require("jquery");

    module("PlanView.show", {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();

            this.$el = $('<div id="ghx-plan"></div>');
            $('#qunit-fixture').append(this.$el);

            this.KanplanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
            this.isEpicsAndVersionsEnabled = true;
            this.KanplanFeatureService.isEpicsAndVersionsEnabled = function () {
                return this.isEpicsAndVersionsEnabled;
            }.bind(this);

            this.shouldShowEpics = true;
            this.KanplanFeatureService.shouldShowEpicsPanel = function () {
                return this.shouldShowEpics;
            }.bind(this);

            this.sandbox.stub(GH.RapidBoard.State, "isScrumBoard");
            GH.RapidBoard.State.isScrumBoard.returns(true);

            this.PlanView = require('jira-agile/rapid/ui/plan/plan-view');

            var GlobalEvents = require('jira-agile/rapid/global-events');
            GlobalEvents.trigger('pre-initialization');
        },

        assertVersionToggle: function assertVersionToggle(shouldExist) {
            var $elem = this.$el.find('.js-release-toggle.ghx-release-toggle');
            if (shouldExist) {
                ok($elem.is("*"), "Version toggle should exist");
            } else {
                ok(!$elem.is("*"), "Version toggle should not exist");
            }
        },

        assertEpicToggle: function assertEpicToggle(shouldExist) {
            var $elem = this.$el.find('.js-epic-toggle.ghx-epic-toggle');
            if (shouldExist) {
                ok($elem.is("*"), "Epic toggle should exist");
            } else {
                ok(!$elem.is("*"), "Epic toggle should not exist");
            }
        },

        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test('Scrum board: epics and versions are visible', function () {
        this.PlanView.show();

        this.assertEpicToggle(true);
        this.assertVersionToggle(true);
    });

    test('Scrum board: epics and versions are visible even if dark feature is disabled', function () {
        this.isEpicsAndVersionsEnabled = false;
        this.PlanView.show();

        this.assertEpicToggle(true);
        this.assertVersionToggle(true);
    });

    test('Kanban board: epics and versions are visible if dark feature is enabled', function () {
        GH.RapidBoard.State.isScrumBoard.returns(false);
        this.PlanView.show();
        this.assertEpicToggle(true);
        this.assertVersionToggle(true);
    });

    test('Kanban board: epics and versions are not visible if dark feature is disabled', function () {
        GH.RapidBoard.State.isScrumBoard.returns(false);
        this.isEpicsAndVersionsEnabled = false;
        this.shouldShowEpics = false;
        this.PlanView.show();
        this.assertEpicToggle(false);
        this.assertVersionToggle(false);
    });
});